/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class UnknownObjectConvertor
extends AbstractConvertor {
    @Override
    protected Object stringToObject(String value) throws WfException {
        if (RelevantDataType.isNULL(value)) {
            return null;
        }
        byte[] fieldValueByteArray = null;
        try {
            fieldValueByteArray = StringUtils.hexFromString((String)value);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        catch (InvalidClassException e) {
            String message = e.getMessage();
            if (message.contains("local class incompatible")) {
                String[] parts = message.split("=|,");
                long l1 = Long.parseLong(parts[1].trim());
                long l2 = Long.parseLong(parts[3].trim());
                try {
                    byte[] src = UnknownObjectConvertor.replaceByteAll(fieldValueByteArray, UnknownObjectConvertor.longToBytes(l1), UnknownObjectConvertor.longToBytes(l2));
                    ByteArrayInputStream bis = new ByteArrayInputStream(src);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    Object o = ois.readObject();
                    return o;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new WfException("ClassNotFoundException", e);
        }
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            oos.close();
            byte[] valueByteArray = baos.toByteArray();
            String result = StringUtils.byteArrayToString((byte[])valueByteArray);
            return result;
        }
        catch (IOException e) {
            throw new WfException("IOException", e);
        }
    }

    public UnknownObjectConvertor(RelevantData dstRelevantData) {
        super(dstRelevantData);
    }

    private static byte[] longToBytes(long l) {
        byte[] lb = new byte[]{(byte)((byte)(l >> 56) & 0xFF), (byte)((byte)(l >> 48) & 0xFF), (byte)((byte)(l >> 40) & 0xFF), (byte)((byte)(l >> 32) & 0xFF), (byte)((byte)(l >> 24) & 0xFF), (byte)((byte)(l >> 16) & 0xFF), (byte)(l >> 8), (byte)((byte)(l << 0) & 0xFF)};
        return lb;
    }

    private static byte[] replaceByteAll(byte[] src, byte[] b1, byte[] b2) {
        byte[] dest;
        while ((dest = UnknownObjectConvertor.replaceByte(src, b1, b2)) != src) {
            src = dest;
        }
        return src;
    }

    private static byte[] replaceByte(byte[] src, byte[] b1, byte[] b2) {
        int pos = 0;
        boolean found = false;
        for (int i = 0; i < src.length - b1.length; ++i) {
            int index = i;
            for (int j = 0; j < b1.length && src[index++] == b1[j]; ++j) {
                if (j != b1.length - 1) continue;
                found = true;
                pos = i;
            }
            if (found) break;
        }
        if (found) {
            byte[] dest = new byte[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            System.arraycopy(b2, 0, dest, pos, b2.length);
            return dest;
        }
        return src;
    }
}

