/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.LRUCapacityMap;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ApplicationUtil {
    private static final Logger logger = Logger.getLogger(ApplicationUtil.class);
    private static LRUCapacityMap processDefMap = new LRUCapacityMap(ApplicationUtil.getProcessDefMapCount());
    private static long randomParamFlag = 0L;

    private ApplicationUtil() {
    }

    public static Locale[] getContextLocales(Context ctx) {
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null) {
            LanguageCollection langs = solu.getLanguages();
            if (langs != null) {
                locales = new Locale[langs.size()];
                for (int i = 0; i < langs.size(); ++i) {
                    locales[i] = langs.get(i).getLocale();
                }
            }
            if (locales.length == 3 && locales[1] != null && locales[1].toString().equalsIgnoreCase("l2")) {
                Locale L2 = locales[1];
                locales[1] = locales[0];
                locales[0] = L2;
            }
        }
        return locales;
    }

    public static Locale getDefaultLocale(Context ctx) {
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null) {
            return solu.getDefaultLocale();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDbType(Context ctx) {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        try {
            cn = WfDbUtil.getConnection(ctx);
            int dbType = KSqlUtil.getDbType((Connection)cn);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ApplicationUtil.getDbType() cost:" + lowTimer.msValue()));
            }
            int n = dbType;
            return n;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            int n = -1;
            return n;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static ProcessDef getProcessDefByDefHashValue(String procDefHashValue) throws BOSException {
        logger.debug((Object)("The process define hash value :" + procDefHashValue));
        ProcessDef processDef = null;
        if (processDefMap.containsKey(procDefHashValue)) {
            processDef = (ProcessDef)processDefMap.get(procDefHashValue);
        } else {
            IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
            processDef = service.getRuntimeProcessDef(procDefHashValue);
            if (processDef != null) {
                processDefMap.put(procDefHashValue, processDef);
            }
        }
        return processDef;
    }

    public static int getProcessDefMapCount() {
        try {
            int count;
            String max;
            Configuration config = Configuration.getInstance();
            ConfigurationItem configurationItem = config.getConfigItem("clientProcessDefMaxCount");
            if (configurationItem != null && !StringUtils.isEmpty((String)(max = configurationItem.getProperty("max"))) && (count = Integer.parseInt(max)) > 0) {
                return count;
            }
        }
        catch (Exception e) {
            logger.error((Object)"there is a error to get the max count client process define !", (Throwable)e);
        }
        return 10;
    }

    public static String getRandomParamFlag() {
        if (randomParamFlag == 0L) {
            randomParamFlag = System.currentTimeMillis();
        }
        return "_=" + randomParamFlag;
    }

    public static void updateRandomParamFlag() {
        randomParamFlag = System.currentTimeMillis();
    }
}

