/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ClientConfig {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.ClientConfig");
    private static boolean inBOS = false;
    private static boolean congfig = false;
    private static Method getBOSProperty = null;
    private static Element element = null;
    private static String clientFactory = null;
    private static String queryFactory = null;
    private static Hashtable clientEnv = null;
    private static Hashtable queryEnv = null;

    public static String getClientFactory() {
        return clientFactory;
    }

    public static String getQueryFactory() {
        return queryFactory;
    }

    public static String getClientProperty(String name) {
        return (String)clientEnv.get(name);
    }

    public static String getQueryProperty(String name) {
        return (String)queryEnv.get(name);
    }

    static void load() {
        try {
            Class<?> bosConfigClass = Class.forName("com.kingdee.util.Configuration", true, ClientConfig.class.getClassLoader());
            Class[] para = new Class[]{String.class};
            getBOSProperty = bosConfigClass.getMethod("getProperty", para);
            Object[] p = new Object[]{"wf_client_config"};
            Method bos_config_load = bosConfigClass.getMethod("load", null);
            if (bos_config_load != null) {
                bos_config_load.invoke(null, null);
            }
            if (getBOSProperty.invoke(null, p) != null) {
                inBOS = true;
            }
        }
        catch (Exception e) {
            log.debug((Object)"not in bos", (Throwable)e);
        }
        if (inBOS) {
            String xml = ClientConfig.getPropertyInBos("wf_client_config");
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            try {
                Document document = builder.build(new File(xml));
                element = document.getRootElement().getChild("workflow-client");
                congfig = true;
            }
            catch (Exception e1) {
                log.error((Object)"workflow client config error!", (Throwable)e1);
            }
        }
        if (congfig) {
            ClientConfig.loadXMLConfig();
        }
    }

    static void loadXMLConfig() {
        String value;
        String name;
        Element el;
        int i;
        List els;
        if (element == null) {
            log.error((Object)" no workflow config find!");
            return;
        }
        if (element.getChild("client") != null) {
            clientFactory = element.getChild("client").getChildText("factory");
            clientEnv = new Hashtable();
            els = element.getChild("client").getChildren("attribute");
            for (i = 0; i < els.size(); ++i) {
                el = (Element)els.get(i);
                name = el.getAttributeValue("name");
                value = el.getAttributeValue("value");
                if (name == null || value == null) continue;
                clientEnv.put(name, value);
            }
        }
        if (element.getChild("query") != null) {
            queryFactory = element.getChild("query").getChildText("factory");
            queryEnv = new Hashtable();
            els = element.getChild("query").getChildren("attribute");
            for (i = 0; i < els.size(); ++i) {
                el = (Element)els.get(i);
                name = el.getAttributeValue("name");
                value = el.getAttributeValue("value");
                if (name == null || value == null) continue;
                queryEnv.put(name, value);
            }
        }
    }

    static String getPropertyInBos(String name) {
        try {
            String pr = getBOSProperty.invoke(null, name).toString();
            return pr;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    static {
        ClientConfig.load();
    }
}

