/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.util.ICollectionBase;
import com.kingdee.util.SortedStringObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CollectionBase
implements ICollectionBase,
Cloneable {
    private static final long serialVersionUID = -5140759420334841506L;
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.CollectionBase");
    protected Map indexes = new SortedStringObjectMap();
    protected List list = new ArrayList();

    public CollectionBase() {
    }

    public CollectionBase(Class itemType) {
        this();
    }

    public CollectionBase(int size) {
        this();
        this.list = new ArrayList(size);
    }

    public CollectionBase(Class itemType, int size) {
        this(size);
    }

    protected final void checkClass(Object obj) throws IllegalArgumentException {
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public final boolean containsObject(Object obj) {
        this.checkClass(obj);
        return this.list.contains(obj);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.indexes.containsKey(key);
    }

    @Override
    public final Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public final Object removeObject(int index) {
        Object objVal = this.list.remove(index);
        this.removeIndex(index);
        return objVal;
    }

    @Override
    public final boolean removeObject(Object obj) {
        this.checkClass(obj);
        this.removeIndex(this.list.indexOf(obj));
        return this.list.remove(obj);
    }

    @Override
    public final Object removeObjectByKey(Object key) {
        Object obj = this.indexes.get(key);
        if (obj == null) {
            return null;
        }
        int index = (Integer)obj;
        this.removeIndex(index);
        return this.list.remove(index);
    }

    @Override
    public final int indexOfObject(Object obj) {
        return this.list.indexOf(obj);
    }

    @Override
    public final int lastIndexOfObject(Object obj) {
        return this.list.lastIndexOf(obj);
    }

    @Override
    public final void clear() {
        this.list.clear();
        this.indexes.clear();
    }

    @Override
    public final boolean equalsObject(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof CollectionBase)) {
            return false;
        }
        if (!this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        return this.list.equals(((CollectionBase)that).list);
    }

    @Override
    public final Object getObject(int index) {
        return this.list.get(index);
    }

    @Override
    public final Object getObject(Object key) {
        Integer integer = (Integer)this.indexes.get(key);
        if (integer == null) {
            return null;
        }
        int i = integer;
        return this.getObject(i);
    }

    @Override
    public final Object setObject(int index, Object obj) {
        this.checkClass(obj);
        return this.list.set(index, obj);
    }

    @Override
    public final Object setObject(String key, Object obj) {
        if (!this.containsKey(key)) {
            this.addObject(key, obj);
            return obj;
        }
        Object object = this.indexes.get(key);
        if (object == null) {
            return null;
        }
        return this.list.set((Integer)object, obj);
    }

    @Override
    public final void addObject(int index, Object obj) {
        this.list.add(index, obj);
        this.addIndex(index, Integer.toString(obj.hashCode()));
    }

    @Override
    public final boolean addObject(Object obj) {
        this.checkClass(obj);
        boolean isAdd = this.list.add(obj);
        this.addIndex(this.list.indexOf(obj), Integer.toString(obj.hashCode()));
        return isAdd;
    }

    @Override
    public final boolean addObject(String key, Object obj) {
        this.checkClass(obj);
        boolean isAdd = false;
        Object object = this.indexes.get(key);
        if (object == null || obj instanceof FormalParameterDef) {
            isAdd = this.list.add(obj);
            this.addIndex(this.list.indexOf(obj), key);
        } else {
            isAdd = true;
            this.list.set((Integer)object, obj);
        }
        return isAdd;
    }

    @Override
    public final void changeIndex(int oldIndex, int newIndex) {
    }

    private final void addIndex(int index, String key) {
        assert (key != null);
        this.indexes.put(key, new Integer(index));
    }

    private final Object removeIndex(int index) {
        int tempIndex;
        Iterator it = ((SortedStringObjectMap)this.indexes).keySet().iterator();
        Object key = null;
        Object removeKey = null;
        ArrayList tempKeys = new ArrayList();
        while (it.hasNext()) {
            key = it.next();
            tempIndex = (Integer)this.indexes.get(key);
            if (index == tempIndex) {
                removeKey = key;
            }
            if (index >= tempIndex) continue;
            tempKeys.add(key);
        }
        this.indexes.remove(removeKey);
        for (int i = 0; i < tempKeys.size(); ++i) {
            tempIndex = (Integer)this.indexes.get(tempKeys.get(i));
            this.indexes.put(tempKeys.get(i), new Integer(tempIndex - 1));
        }
        return null;
    }

    @Override
    public final int indexOfKey(Object key) {
        return (Integer)this.indexes.get(key);
    }

    public final List toList() {
        return this.list;
    }

    public Object clone() {
        try {
            CollectionBase destCollection = (CollectionBase)super.clone();
            destCollection.indexes = (SortedStringObjectMap)((SortedStringObjectMap)this.indexes).clone();
            ArrayList tempList = new ArrayList();
            for (int i = 0; i < this.list.size(); ++i) {
                tempList.add(this.list.get(i));
            }
            destCollection.list = tempList;
            return destCollection;
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"CollectionBase.clone error", (Throwable)e);
            throw new InternalError();
        }
    }

    @Override
    public void trimToSize() {
        assert (this.list instanceof ArrayList);
        ((ArrayList)this.list).trimToSize();
        assert (this.indexes instanceof SortedStringObjectMap);
        ((SortedStringObjectMap)this.indexes).trimToSize();
    }
}

