/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.wfdesigner.WorkFlowDesignerMessages;
import java.util.Locale;

public class DataTypeUtil {
    private static final String[] javaNameArray = new String[]{"int", "float", "boolean", "java.lang.string", "java.util.date"};
    private static final String[] nameArray = new String[]{WorkFlowDesignerMessages.FlowVarTab_1Int, WorkFlowDesignerMessages.FlowVarTab_1Float, WorkFlowDesignerMessages.FlowVarTab_1Fool, WorkFlowDesignerMessages.FlowVarTab_1String, WorkFlowDesignerMessages.FlowVarTab_1Date, WorkFlowDesignerMessages.FlowVarTab_1Object, "\u5185\u7801(BOID)", "\u4e3b\u952e(PK)", "\u503c\u5bf9\u8c61(ObjectValue)", "\u5355\u636e\u5bf9\u8c61", "\u679a\u4e3e", "\u5916\u90e8\u6570\u636e\u7c7b\u578b", "\u5ba1\u6279\u7ed3\u679c\u5bf9\u8c61"};
    public static final DataType[] dataTypeArray = new DataType[]{BasicType.INTEGER, BasicType.FLOAT, BasicType.BOOLEAN, BasicType.STRING, BasicType.DATETIME, BasicType.PERFORMER, BasicType.BOID, BasicType.PK, BasicType.OBJECTVALUE, BasicType.BIZOBJ, ExternalType.ENUM, ExternalType.OBJECT, BasicType.APPROVERESULT};

    public static String[] getNames() {
        return nameArray;
    }

    public static String getName(DataType value) {
        if (value == null) {
            return "";
        }
        return nameArray[DataTypeUtil.getIndex(value)];
    }

    public static int getIndex(DataType value) {
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (!dataTypeArray[i].equals(value)) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static int getIndex(String value) {
        for (int i = 0; i < nameArray.length; ++i) {
            if (!nameArray[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static DataType getcDataType(int index) {
        return dataTypeArray[index];
    }

    public static int getDataTypeCount() {
        return dataTypeArray.length;
    }

    public static DataType getDataType(String name) {
        for (int i = 0; i < nameArray.length; ++i) {
            if (!name.equals(nameArray[i])) continue;
            return DataTypeUtil.getcDataType(i);
        }
        throw new IllegalArgumentException();
    }

    public static DataType getDataTypeByClassName(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < javaNameArray.length; ++i) {
            if (name.equals(javaNameArray[i])) {
                return DataTypeUtil.getcDataType(i);
            }
            if (!name.equals(javaNameArray[i] + "[]")) continue;
            return DataTypeUtil.getcDataType(i);
        }
        return ExternalType.OBJECT;
    }
}

