/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionCache {
    private static HashMap cache = new HashMap();

    public static synchronized Connection getConnection(Context ctx) throws SQLException {
        Connection conn;
        String ais = ctx.getAIS();
        if (cache.containsKey(ais) && !(conn = (Connection)cache.get(ais)).isClosed()) {
            return conn;
        }
        conn = EJBFactory.getConnection((Context)ctx);
        cache.put(ais, conn);
        return conn;
    }

    public static synchronized void putConnection(Context ctx, Connection conn) throws SQLException {
        if (!conn.isClosed()) {
            String ais = ctx.getAIS();
            cache.put(ais, conn);
        }
    }

    public static synchronized void removeConnection(Context ctx) {
        String ais = ctx.getAIS();
        Connection conn = (Connection)cache.remove(ais);
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
                conn = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static synchronized void cleanup() {
        for (Map.Entry entry : cache.entrySet()) {
            Connection conn = (Connection)entry.getValue();
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        cache.clear();
        cache = null;
    }
}

