/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenSchemeFactory;
import com.kingdee.eas.base.permission.AuthenSchemeInfo;
import com.kingdee.eas.base.permission.AuthenSchemeOrgUserFactory;
import com.kingdee.eas.base.permission.AuthenSchemeRuleFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractAuthenSchemeAsscreditUI;
import com.kingdee.eas.base.permission.client.f7.NewOrgAuthenF7PromptDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AuthenSchemeAsscreditUI
extends AbstractAuthenSchemeAsscreditUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenSchemeAsscreditUI.class);
    private String authenSchemeId = null;
    private String orgId = null;
    private boolean isRule = false;
    protected static final String PERM_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private SelectorItemCollection userSelector = null;

    public void onLoad() throws Exception {
        this.initParm();
        super.onLoad();
        this.initComponent();
        this.initAuthenSchemeF7();
        this.initOrgF7();
        this.initCheckBox();
    }

    private void initCheckBox() {
        this.fillCheckBox();
        this.ckRule.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (!KDCheckBox.class.isInstance(event.getSource())) {
                    return;
                }
                KDCheckBox ruleCheckBox = (KDCheckBox)event.getSource();
                AuthenSchemeAsscreditUI.this.isRule = ruleCheckBox.isSelected();
            }
        });
    }

    private void fillCheckBox() {
        try {
            HashSet<String> orgIdSet = new HashSet<String>();
            orgIdSet.add(this.orgId);
            Map orgRuleMap = AuthenSchemeRuleFactory.getRemoteInstance().getRule(this.authenSchemeId, orgIdSet);
            Boolean isRuleObj = (Boolean)orgRuleMap.get(this.orgId);
            this.isRule = isRuleObj == null ? false : isRuleObj;
            this.ckRule.setSelected(this.isRule);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"FILL_SELECT_FAIL"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
            SysUtil.abort();
        }
    }

    private void initOrgF7() throws Exception {
        NewOrgAuthenF7PromptDialog newOrgF7 = new NewOrgAuthenF7PromptDialog();
        newOrgF7.setMultiSelect(false);
        newOrgF7.setNeedAddOrgRange(false);
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            if (orgTypeInfo.getOrgViewType() == null || OrgViewType.UNIONDEBT == orgTypeInfo.getOrgViewType() || OrgViewType.CTRLUNIT == orgTypeInfo.getOrgViewType()) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        orgViewTypeList.add(0, OrgViewType.CTRLUNIT);
        OrgViewType[] orgViewTypeArray = new OrgViewType[orgViewTypeList.size()];
        orgViewTypeList.toArray(orgViewTypeArray);
        this.orgBizPromptBox.setSelector((KDPromptSelector)newOrgF7);
        FullOrgUnitInfo defaultOrgInfo = null;
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            if (userInfo != null) {
                defaultOrgInfo = userInfo.getDefOrgUnit();
            }
            if (defaultOrgInfo == null) {
                String rootCUPK = "00000000-0000-0000-0000-000000000000CCE7AED4";
                BOSUuid rootCUUuid = BOSUuid.read((String)rootCUPK);
                ObjectUuidPK parentPK = new ObjectUuidPK(rootCUUuid);
                defaultOrgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)parentPK);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        this.orgId = defaultOrgInfo.getId().toString();
        this.orgBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                CoreBaseInfo oldOrg = (CoreBaseInfo)event.getOldValue();
                CoreBaseInfo newOrg = (CoreBaseInfo)event.getNewValue();
                if (newOrg.equals((Object)oldOrg)) {
                    return;
                }
                AuthenSchemeAsscreditUI.this.orgId = newOrg.getId().toString();
                AuthenSchemeAsscreditUI.this.setMainQuery();
                AuthenSchemeAsscreditUI.this.tblMain.removeRows(true);
                AuthenSchemeAsscreditUI.this.fillCheckBox();
            }
        });
        this.orgBizPromptBox.setData((Object)defaultOrgInfo);
    }

    private void initAuthenSchemeF7() throws Exception {
        try {
            AuthenSchemeInfo authenSchemeInfo = null;
            ObjectUuidPK authenSchemePK = new ObjectUuidPK(this.authenSchemeId);
            authenSchemeInfo = AuthenSchemeFactory.getRemoteInstance().getAuthenSchemeInfo((IObjectPK)authenSchemePK);
            this.authenSchemeBizPromptBox.setData((Object)authenSchemeInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        this.authenSchemeBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                AuthenSchemeInfo oldScheme = (AuthenSchemeInfo)event.getOldValue();
                AuthenSchemeInfo newScheme = (AuthenSchemeInfo)event.getNewValue();
                if (oldScheme.getId().equals((Object)newScheme.getId())) {
                    return;
                }
                AuthenSchemeAsscreditUI.this.authenSchemeId = newScheme.getId().toString();
                AuthenSchemeAsscreditUI.this.setMainQuery();
                AuthenSchemeAsscreditUI.this.tblMain.removeRows(true);
                AuthenSchemeAsscreditUI.this.fillCheckBox();
            }
        });
    }

    private void initComponent() {
        this.tblMain.setEditable(false);
        this.btnAssign.setEnabled(true);
        this.btnCancelAssign.setEnabled(true);
        this.btnSetRule.setEnabled(true);
    }

    private void initParm() {
        Object authenSchemeIdObj = this.getUIContext().get("authenSchemeId");
        if (authenSchemeIdObj == null) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"CERTI_SOLUTIONID_NOT_EMPTY"), (String)ThrowableHelper.toString((Exception)((Object)new BOSException(EASResource.getString((String)PERM_RESOURCE, (String)"CERTI_SOLUTIONID_NOT_EMPTY")))), (int)0);
            SysUtil.abort();
        }
        this.authenSchemeId = (String)authenSchemeIdObj;
        this.getUIContext().remove("authenShemeId");
    }

    private void setMainQuery() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCol = filter.getFilterItems();
        filterItemCol.add(new FilterItemInfo("authenScheme.id", (Object)this.authenSchemeId, CompareType.EQUALS));
        filterItemCol.add(new FilterItemInfo("org.id", (Object)this.orgId, CompareType.EQUALS));
        this.mainQuery.setFilter(filter);
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        KDCommonPromptDialog userF7 = new KDCommonPromptDialog();
        userF7.setEnabledMultiSelection(true);
        userF7.setSelectorCollection(this.getUserSelector());
        userF7.setEntityViewInfo(this.getUserFilter());
        userF7.setQueryInfo(MetaDataPK.create((String)"com.kingdee.eas.base.permission.app.UserListQuery"));
        userF7.show();
        if (userF7.isCanceled()) {
            return;
        }
        Object[] selectedUsers = (Object[])userF7.getData();
        if (selectedUsers == null || selectedUsers.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_USER"));
            return;
        }
        final HashSet<String> userIdSet = new HashSet<String>();
        UserInfo userInfo = null;
        for (Object userInfoObj : selectedUsers) {
            userInfo = (UserInfo)userInfoObj;
            userIdSet.add(userInfo.getId().toString());
        }
        final HashSet<String> orgIdSet = new HashSet<String>();
        orgIdSet.add(this.orgId);
        final HashMap<String, Boolean> orgRuleMap = new HashMap<String, Boolean>();
        orgRuleMap.put(this.orgId, this.isRule);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"EXECUTE_UPDATEING"), (String)EASResource.getString((String)PERM_RESOURCE, (String)"WAITING"));
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    AuthenSchemeOrgUserFactory.getRemoteInstance().assignAuthenScheme(AuthenSchemeAsscreditUI.this.authenSchemeId, orgIdSet, userIdSet, false);
                    List resultList = AuthenSchemeRuleFactory.getRemoteInstance().checkAndSetRule(AuthenSchemeAsscreditUI.this.authenSchemeId, orgRuleMap);
                    return resultList;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeAsscreditUI.this), (String)EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"EXECUTE_FAIL"), (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if (!List.class.isInstance(result)) {
                    return;
                }
                List resultList = (List)result;
                if ("success".equals(resultList.get(0))) {
                    AuthenSchemeAsscreditUI.this.tblMain.removeRows(true);
                    MsgBox.showInfo((String)EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"SET_SUCCEED"));
                } else if ("fail".equals(resultList.get(0))) {
                    StringBuffer message = new StringBuffer();
                    message.append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"SET_RULE_AND_VIEW_CONFLIT") + "\n").append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"SET_DISABLE") + "\n").append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"CERTI_RULE") + "\uff1a").append(resultList.get(1)).append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"ORG_1") + "\uff1a").append(resultList.get(2));
                    MsgBox.showInfo((String)message.toString());
                    AuthenSchemeAsscreditUI.this.tblMain.removeRows(true);
                }
            }
        });
        dialog.show();
    }

    private EntityViewInfo getUserFilter() {
        StringBuffer innerSql = new StringBuffer();
        innerSql.append("select asou.fuserid ").append("from t_pm_authenschemeorguser as asou ").append("where asou.fauthenschemeid = '").append(this.authenSchemeId).append("' ").append("and asou.forgid = '").append(this.orgId).append("'");
        StringBuffer orgRangeSql = new StringBuffer();
        orgRangeSql.append("select orgrange.fuserid ").append("from t_pm_orgrange orgrange ").append("where orgrange.forgid = '").append(this.orgId).append("' ").append("and orgrange.ftype = ").append(10);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql.toString(), CompareType.NOTINNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgRangeSql.toString(), CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)20, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)60, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isRegister", (Object)1, CompareType.EQUALS));
        filterInfo.setMaskString("( #0 and ( ( #1 and #2 ) or #3 ) and #4)");
        return view;
    }

    private SelectorItemCollection getUserSelector() {
        if (this.userSelector != null) {
            return this.userSelector;
        }
        this.userSelector = new SelectorItemCollection();
        this.userSelector.add(new SelectorItemInfo("id"));
        this.userSelector.add(new SelectorItemInfo("number"));
        this.userSelector.add(new SelectorItemInfo("type"));
        this.userSelector.add(new SelectorItemInfo("name"));
        this.userSelector.add(new SelectorItemInfo("cu.name"));
        this.userSelector.add(new SelectorItemInfo("effectiveDate"));
        this.userSelector.add(new SelectorItemInfo("invalidationDate"));
        return this.userSelector;
    }

    @Override
    public void actionSetRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetRule_actionPerformed(e);
        final HashMap<String, Boolean> orgRuleMap = new HashMap<String, Boolean>();
        orgRuleMap.put(this.orgId, this.isRule);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"EXECUTE_UPDATEING"), (String)EASResource.getString((String)PERM_RESOURCE, (String)"WAITING"));
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    List resultList = AuthenSchemeRuleFactory.getRemoteInstance().checkAndSetRule(AuthenSchemeAsscreditUI.this.authenSchemeId, orgRuleMap);
                    return resultList;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeAsscreditUI.this), (String)EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"EXECUTE_FAIL"), (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if (!List.class.isInstance(result)) {
                    return;
                }
                List resultList = (List)result;
                if ("success".equals(resultList.get(0))) {
                    MsgBox.showInfo((String)EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"SET_SUCCEED"));
                } else if ("fail".equals(resultList.get(0))) {
                    StringBuffer message = new StringBuffer();
                    message.append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"SET_RULE_AND_VIEW_CONFLIT") + "\n").append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"SET_DISABLE") + "\n").append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"CERTI_RULE") + "\uff1a").append(resultList.get(1)).append(EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"ORG_1") + "\uff1a").append(resultList.get(2));
                    MsgBox.showInfo((String)message.toString());
                }
            }
        });
        dialog.show();
    }

    @Override
    public void actionCancelAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAssign_actionPerformed(e);
        KDTSelectManager userTableSManager = this.tblMain.getSelectManager();
        if (userTableSManager.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_RECORD"));
            return;
        }
        KDTRange selectedRange = userTableSManager.toRange();
        Iterator selectedIter = selectedRange.iterator();
        KDTSelectBlock oneBlock = null;
        IRow nextRow = null;
        String userId = null;
        final HashSet<String> userIdSet = new HashSet<String>();
        int top = -1;
        int bottom = -1;
        while (selectedIter.hasNext()) {
            oneBlock = (KDTSelectBlock)selectedIter.next();
            top = oneBlock.getTop();
            bottom = oneBlock.getBottom();
            int i = 0;
            while (i + top <= bottom) {
                nextRow = this.tblMain.getRow(i + top);
                userId = (String)nextRow.getCell("user.id").getValue();
                userIdSet.add(userId);
                ++i;
            }
        }
        final HashSet<String> orgIdSet = new HashSet<String>();
        orgIdSet.add(this.orgId);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"EXECUTE_UPDATEING"), (String)EASResource.getString((String)PERM_RESOURCE, (String)"WAITING"));
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    AuthenSchemeOrgUserFactory.getRemoteInstance().cancelAssignAuthenScheme(AuthenSchemeAsscreditUI.this.authenSchemeId, orgIdSet, userIdSet);
                    return "success";
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeAsscreditUI.this), (String)EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"EXECUTE_FAIL"), (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if ("success".equals(result)) {
                    AuthenSchemeAsscreditUI.this.tblMain.removeRows(true);
                    MsgBox.showInfo((String)EASResource.getString((String)AuthenSchemeAsscreditUI.PERM_RESOURCE, (String)"EXECUTE_COMPLATE"));
                }
            }
        });
        dialog.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        this.setMainQuery();
        return new FilterInfo();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

