/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.InheritPermFacadeFactory;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.client.AbstractOrgInheritFatherUserRoleUI;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class OrgInheritFatherUserRoleUI
extends AbstractOrgInheritFatherUserRoleUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgInheritFatherUserRoleUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private IObjectPK orgPK = null;
    private FullOrgUnitInfo orgInfo = null;
    private static final String USER_NAME = "user.name";
    private static final String USER_NUMBER = "user.number";
    private static final String USER_ID = "user.id";
    private static final String ROLE_ID = "roleId";
    private static final String ROLE_NAME = "roleName";
    private static final String ROLE_NUMBER = "roleNumber";

    public void onLoad() throws Exception {
        this.orgPK = (IObjectPK)this.getUIContext().get("orgId");
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnRemove.setVisible(false);
        this.kDLabel2.setText(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ParentUserLable"), this.getParentOrgInfo().getName()));
        this.kDLabel1.setText(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ParentUserRole"), ""));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    private FullOrgUnitInfo getFullOrgUnitInfo() {
        if (this.orgInfo == null) {
            try {
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("*"));
                selectors.add(new SelectorItemInfo("parent.*"));
                this.orgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo(this.orgPK, selectors);
            }
            catch (Exception e) {
                logger.error((Object)"getFullOrgUnitInfo", (Throwable)e);
                this.handleException(e);
            }
        }
        return this.orgInfo;
    }

    private FullOrgUnitInfo getParentOrgInfo() {
        return this.getFullOrgUnitInfo().getParent();
    }

    private IObjectPK getParentOrgPK() {
        return new ObjectUuidPK(this.getParentOrgInfo().getId());
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilter = super.getDefaultFilterForQuery();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo orgFilterItem = new FilterItemInfo("org.id", (Object)this.getParentOrgInfo().getId().toString());
        FilterItemInfo typeFilterItem = new FilterItemInfo("type", (Object)String.valueOf(10));
        filter.getFilterItems().add(orgFilterItem);
        filter.getFilterItems().add(typeFilterItem);
        try {
            filter.mergeFilter(this.getNotAdminUserFilter(), "AND");
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            ExceptionHandler.handle((Throwable)e1);
        }
        if (defaultFilter == null || defaultFilter.getFilterItems().size() == 0) {
            return filter;
        }
        try {
            defaultFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return defaultFilter;
    }

    private FilterInfo getNotAdminUserFilter() {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("user.type", (Object)"10", CompareType.NOTEQUALS));
        userFilterInfo.getFilterItems().add(new FilterItemInfo("user.type", (Object)"60", CompareType.NOTEQUALS));
        userFilterInfo.getFilterItems().add(new FilterItemInfo("user.type", (Object)"70", CompareType.NOTEQUALS));
        return userFilterInfo;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (e.getClickCount() == 1 && rowIndex < 0) {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (rowIndex >= 0 && row != null) {
            ObjectStringPK userPK = new ObjectStringPK(row.getCell(USER_ID).getValue().toString());
            String userName = (String)row.getCell(USER_NAME).getValue();
            this.kDLabel1.setText(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ParentUserRole"), userName));
            this.initRoleTables((IObjectPK)userPK);
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            this.tblMain.removeRows(false);
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            if (this.mainQuery != null) {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                IRowSet rowSet = exec.executeQuery();
                this.distinctRowSetbyUserNameNumber(rowSet);
                e.setRowSet(null);
            }
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    private void distinctRowSetbyUserNameNumber(IRowSet rowSet) throws Exception {
        if (rowSet instanceof DynamicRowSet) {
            IRowSetMetaData rowSetMetaData = rowSet.getRowSetMetaData();
            if (rowSetMetaData == null) {
                return;
            }
            int userNamePos = 0;
            int userNumberPos = 0;
            int userIdPos = 0;
            int size = rowSetMetaData.getColumnCount();
            for (int i = 1; i < size; ++i) {
                if (USER_NAME.equalsIgnoreCase(rowSetMetaData.getColumnName(i))) {
                    userNamePos = i;
                    continue;
                }
                if (USER_NUMBER.equalsIgnoreCase(rowSetMetaData.getColumnName(i))) {
                    userNumberPos = i;
                    continue;
                }
                if (!USER_ID.equalsIgnoreCase(rowSetMetaData.getColumnName(i))) continue;
                userIdPos = i;
            }
            if (userNamePos * userNumberPos * userIdPos == 0) {
                return;
            }
            HashSet<String> userNumberSet = new HashSet<String>();
            while (rowSet.next()) {
                String name = rowSet.getString(userNamePos);
                String number = rowSet.getString(userNumberPos);
                String userId = rowSet.getString(userIdPos);
                if (userNumberSet.contains(number)) continue;
                userNumberSet.add(number);
                this.tblMain_addRow(new String[]{name, number, userId});
            }
        }
    }

    private void tblMain_addRow(String[] params) {
        this.tblMain.addRow();
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(0).setValue((Object)params[0]);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(1).setValue((Object)params[1]);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(2).setValue((Object)params[2]);
    }

    private void initRoleTables(IObjectPK userPK) throws Exception {
        IUserRoleOrgManager userRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        RoleCollection[] roleCols = userRoleOrgManager.getUserRoles(userPK, this.getParentOrgPK(), "");
        RoleCollection roleCol = roleCols[0];
        RoleCollection grantRoleCol = roleCols[1];
        this.initRoleTable(this.kdtAccredit, roleCol);
        this.initRoleTable(this.kdtGrant, grantRoleCol);
    }

    private void initRoleTable(KDTable table, RoleCollection roleCol) {
        table.removeRows();
        for (int i = 0; i < roleCol.size(); ++i) {
            IRow row = table.addRow();
            RoleInfo role = roleCol.get(i);
            row.getCell(ROLE_NAME).setValue((Object)role.getName());
            row.getCell(ROLE_ID).setValue((Object)role.getId());
            row.getCell(ROLE_NUMBER).setValue((Object)role.getNumber());
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        InheritPermFacadeFactory.getRemoteInstance().inheritParentUserAndRole(this.orgPK);
        this.getUIWindow().close();
    }

    @Override
    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

