/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractRelatedPermUserViewUI;
import com.kingdee.eas.base.permission.client.tree.IPermissionTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewOUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class RelatedPermUserViewUI
extends AbstractRelatedPermUserViewUI {
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    private KDTreeNode branch;
    private IPermissionTreeBuilder builder = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman hander = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("curOrgPK", (Object)new ObjectStringPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
        hander.setRequestContext((Serializable)request);
        return hander;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTree();
        this.initOrgF7();
        this.selectDefOrg();
        this.initTableFormat();
    }

    private void initTableFormat() {
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm");
        this.tblMain.getColumn("invalidationDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm");
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        FullOrgUnitInfo defOrgUnit;
        boolean isCUAdmin = UserType.SYSTEM.equals((Object)this.getCurrentUser().getType());
        boolean isBizAdmin = this.getCurrentUser().isBizAdmin();
        if (isCUAdmin) {
            this.pmtOrg.setData((Object)this.getCurrentCU().castToFullOrgUnitInfo());
        } else if (isBizAdmin && (defOrgUnit = this.getOrgInfo((IObjectPK)new ObjectUuidPK(this.getCurrentUser().getDefOrgUnit().getId()))).getId().equals((Object)this.getCurrentCU().getId())) {
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private FullOrgUnitInfo getOrgInfo(IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        return iFullOrgUnit.getFullOrgUnitInfo(orgPK);
    }

    private void initTree() throws Exception {
        this.builder = PermissionTreeBuilderFactory.getPermItemTreeBuilder();
        this.createTreeBranch();
        this.addPopupMenu();
        this.clearTrees();
    }

    private void createTreeBranch() throws Exception {
        this.branch = this.builder.createTreeBranch();
    }

    private void addPopupMenu() {
        UIUtil.addStandardPopupMenu(this.tree);
    }

    private void clearTrees() {
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
    }

    private Map getUserOrgs() throws EASBizException, BOSException {
        IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
        Map map = iPermissionManager.getUserOrgs(this.getCurrentCUPK(), this.getCurrentUserPK(), OrgRangeType.BIZ_ORG_TYPE);
        return map;
    }

    private void initOrgF7() throws EASBizException, BOSException {
        NewOUUnionF7 orgF7 = new NewOUUnionF7((IUIObject)this);
        IObjectPK currentUserPK = this.getCurrentUserPK();
        if (Administrator.isSuperCUAdmin(currentUserPK)) {
            orgF7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            orgF7.setShowSub(true);
        } else if (Administrator.isCUAdmin(null, currentUserPK)) {
            orgF7.setRootUnitID(this.getCurrentCU().getId().toString());
        } else {
            String extraSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, currentUserPK, OrgRangeType.BIZ_ORG_TYPE);
            StringBuffer extraTreeFilter = new StringBuffer();
            extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(extraSQL).append(")");
            orgF7.setExtraTreeFilters(extraTreeFilter.toString());
            try {
                FilterInfo outerFilter = new FilterInfo("unit.id in (" + extraSQL + ")");
                orgF7.setOuterFilterInfo(outerFilter);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            orgF7.setNeedConsiderFaultTree(true);
        }
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(false);
        orgF7.setShowAssistantOrg(true);
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(this.getCurrentCU().getId());
    }

    private void buildTree() throws Exception {
        if (this.getSelectedOrgInfo() != null) {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            PermItemCollection leaves = iPermItem.getLeaves(this.getSelectedOrgPK());
            KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)leaves);
            ((DefaultTreeModel)this.tree.getModel()).setRoot((TreeNode)root);
        }
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        this.buildTree();
        this.tblMain.removeRows(this.canRefresh());
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        return (FullOrgUnitInfo)this.pmtOrg.getData();
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrgInfo().getId());
    }

    private String getRelatedUserSQL() {
        try {
            IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
            return iPermissionManager.getRelatedUserSQL(this.getSelectedOrgPK(), this.getPermItemPK());
        }
        catch (BOSException e1) {
            this.handUIException(e1);
            return null;
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
            return null;
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            if (this.canRefresh()) {
                this.processFilterInfo(this.getRelatedUserSQL());
                super.tblMain_doRequestRowSet(e);
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
    }

    private void processFilterInfo(String sql) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        if (this.getCurrentUser().isBizAdmin()) {
            FilterInfo orgRangeFilterInfo = new FilterInfo();
            String orgSql = PermissionRangeHelper.getUserOrgIdRangeSQL(null, this.getCurrentUserPK(), OrgRangeType.MANAGE_ORG_TYPE);
            orgRangeFilterInfo.getFilterItems().add(new FilterItemInfo("CU.id in (" + orgSql + ")"));
            filterInfo.mergeFilter(orgRangeFilterInfo, "AND");
        }
        if (this.mainQuery != null) {
            if (this.mainQuery.getFilter() != null) {
                if (this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    boolean hasUserIDFilter = false;
                    int size = this.mainQuery.getFilter().getFilterItems().size();
                    for (int i = 0; i < size; ++i) {
                        if (!this.mainQuery.getFilter().getFilterItems().get(i).getPropertyName().equals("id") || !this.mainQuery.getFilter().getFilterItems().get(i).getCompareType().equals((Object)CompareType.INNER)) continue;
                        this.mainQuery.getFilter().getFilterItems().get(i).setCompareValue((Object)sql);
                        hasUserIDFilter = true;
                    }
                    if (!hasUserIDFilter) {
                        this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
                    }
                } else {
                    this.mainQuery.setFilter(filterInfo);
                }
            } else {
                this.mainQuery.setFilter(filterInfo);
            }
        }
    }

    private boolean canRefresh() {
        return this.getSelectedOrgInfo() != null && this.getPermItemPK() != null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.canQuery();
        super.actionRefresh_actionPerformed(e);
    }

    private void canQuery() {
        if (this.getPermItemPK() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"functionIsNotSelected"));
            this.abort();
        }
        if (this.getSelectedOrgInfo() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"orgIsNotSelected"));
            this.abort();
        }
    }

    private IObjectPK getPermItemPK() {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object != null && object instanceof KDTreeNode) {
            PermItemInfo info = (PermItemInfo)((KDTreeNode)object).getUserObject();
            return new ObjectUuidPK(info.getId());
        }
        return null;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = RelatedPermUserViewUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && !this.isFirstDefaultQuery()) {
            this.canQuery();
            super.actionQuery_actionPerformed(e);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        this.tblMain.removeRows(this.canRefresh());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setShowSorter(false);
        return dlg;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

