/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.EntryWhereEnum;
import com.kingdee.eas.base.permission.IRule;
import com.kingdee.eas.base.permission.LeftBracketToken;
import com.kingdee.eas.base.permission.LogicToken;
import com.kingdee.eas.base.permission.RightBracketToken;
import com.kingdee.eas.base.permission.RuleCollection;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.RuleParser;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.client.AbstractRulePanel;
import com.kingdee.eas.base.permission.client.NewUserAccreditUI;
import com.kingdee.eas.base.permission.client.RuleEditUI;
import com.kingdee.eas.base.permission.client.RuleSelectorUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;

public class RulePanel
extends AbstractRulePanel {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private String ruleStructure = null;
    private RuleCollection ruleCollection = null;
    private BOSObjectType bizObjectType = null;
    private static final int RULE_INDEX = 0;
    private static final int LEFT_BRACKET_INDEX = 1;
    private static final int RULE_NUMBER = 2;
    private static final int RULE_NAME = 3;
    private static final int RIGHT_BRACKET_INDEX = 4;
    private static final int LOGIC_INDEX = 5;
    private IObjectPK ctrlUnitPK = null;

    public RulePanel() throws Exception {
        this.init();
    }

    private void init() {
        this.initTable();
        this.initButtons();
        this.initLayout();
    }

    public void setStatus(String oprtState) {
        this.tblRule.getStyleAttributes().setLocked(OprtState.VIEW.equals(oprtState));
        this.setButtonStatus(!OprtState.VIEW.equals(oprtState));
    }

    public void setButtonStatus(boolean flag) {
        this.btnAdd.setEnabled(flag);
        this.btnDel.setEnabled(flag);
        this.btnDown.setEnabled(flag);
        this.btnUp.setEnabled(flag);
    }

    private void initButtons() {
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDel.setText(null);
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUp.setText(null);
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setText(null);
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
    }

    private void initTable() {
        this.tblRule.checkParsed();
        KDComboBox leftComboBox = new KDComboBox(RuleUtil.addObjectToArray(LeftBracketToken.getEnumList().toArray(), null));
        KDTDefaultCellEditor leftBracketEditor = new KDTDefaultCellEditor((JComboBox)leftComboBox);
        this.tblRule.getColumn("leftBracket").setEditor((ICellEditor)leftBracketEditor);
        KDComboBox rightComboBox = new KDComboBox(RuleUtil.addObjectToArray(RightBracketToken.getEnumList().toArray(), null));
        KDTDefaultCellEditor rightBracketEditor = new KDTDefaultCellEditor((JComboBox)rightComboBox);
        this.tblRule.getColumn("rightBracket").setEditor((ICellEditor)rightBracketEditor);
        KDComboBox logicComboBox = new KDComboBox(RuleUtil.addObjectToArray(LogicToken.getEnumList().toArray(), null));
        KDTDefaultCellEditor logicEditor = new KDTDefaultCellEditor((JComboBox)logicComboBox);
        this.tblRule.getColumn("logic").setEditor((ICellEditor)logicEditor);
        this.tblRule.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
    }

    public KDTable getTable() {
        return this.tblRule;
    }

    private IObjectPK getCtrlUnitPK() {
        if (this.ctrlUnitPK == null) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
        }
        return this.ctrlUnitPK;
    }

    private boolean isBracketMatching() throws EASBizException, ParserException, BOSException {
        int balance = 0;
        int rowCount = this.tblRule.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object objRightBracket;
            if (this.tblRule.getRow(i).getStyleAttributes().isLocked()) {
                if (balance == 0) continue;
                return false;
            }
            Object objLeftBracket = this.tblRule.getRow(i).getCell(1).getValue();
            if (objLeftBracket != null && objLeftBracket instanceof LeftBracketToken) {
                ++balance;
            }
            if ((objRightBracket = this.tblRule.getRow(i).getCell(4).getValue()) == null || !(objRightBracket instanceof RightBracketToken)) continue;
            --balance;
        }
        return balance == 0;
    }

    private Set getTableRules() {
        HashSet<String> rules = new HashSet<String>();
        int count = this.tblRule.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblRule.getRow(i).getStyleAttributes().isLocked()) continue;
            rules.add(((RuleInfo)this.tblRule.getRow(i).getCell(0).getValue()).getId().toString());
        }
        return rules;
    }

    private HashMap getSelectedRuleNameAndNumber() {
        HashMap<String, RuleInfo> ruleMap = new HashMap<String, RuleInfo>();
        int count = this.tblRule.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblRule.getRow(i).getStyleAttributes().isLocked()) continue;
            String ruleID = ((RuleInfo)this.tblRule.getRow(i).getCell(0).getValue()).getId().toString();
            RuleInfo rule = new RuleInfo();
            String number = (String)this.tblRule.getRow(i).getCell(2).getValue();
            String name = (String)this.tblRule.getRow(i).getCell(3).getValue();
            Object logic = this.tblRule.getRow(i).getCell(5).getValue();
            rule.setNumber(number);
            rule.setName(name);
            rule.put("logic", logic);
            ruleMap.put(ruleID, rule);
        }
        return ruleMap;
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        if (this.bizObjectType == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"checkSelectedFP"));
        } else {
            UIContext uiContext = new UIContext((Object)this.getParent());
            uiContext.put((Object)"entity", (Object)this.getBizEntity());
            uiContext.put((Object)"rules", (Object)this.getTableRules());
            uiContext.put((Object)"ruleMap", (Object)this.getSelectedRuleNameAndNumber());
            uiContext.put((Object)"ctrlUnitPK", (Object)this.getCtrlUnitPK());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RuleSelectorUI.class.getName(), (Map)uiContext, null, null);
            uiWindow.show();
        }
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        super.btnDel_actionPerformed(e);
        int rowIndex = this.tblRule.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && !(row = this.tblRule.getRow(rowIndex)).getStyleAttributes().isLocked()) {
            RuleInfo ruleInfo = (RuleInfo)row.getCell(0).getValue();
            if (RuleUtil.isEntryRule(this.getBizEntity(), ruleInfo)) {
                if (this.isLastEntryRule(ruleInfo)) {
                    this.tblRule.removeRow(rowIndex);
                    if (rowIndex != 0) {
                        this.tblRule.removeRow(rowIndex - 1);
                    }
                } else {
                    this.tblRule.removeRow(rowIndex);
                }
            } else if (this.isLastMainRule(ruleInfo)) {
                if (this.tblRule.getRowCount() > rowIndex + 1) {
                    if (this.tblRule.getRow(rowIndex + 1).getStyleAttributes().isLocked()) {
                        this.tblRule.removeRow(rowIndex + 1);
                    }
                    this.tblRule.removeRow(rowIndex);
                } else {
                    this.tblRule.removeRow(rowIndex);
                }
            } else {
                this.tblRule.removeRow(rowIndex);
            }
        }
    }

    private boolean isLastEntryRule(RuleInfo ruleInfo) throws EASBizException, ParserException, BOSException {
        String deleteEntryPropertyName = RuleUtil.getEntryPropertyName(ruleInfo.getScript());
        int rowCount = this.tblRule.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.tblRule.getRow(i).getStyleAttributes().isLocked() || !RuleUtil.isEntryRule(this.getBizEntity(), (RuleInfo)this.tblRule.getRow(i).getCell(0).getValue())) continue;
            RuleInfo temp = (RuleInfo)this.tblRule.getRow(i).getCell(0).getValue();
            String entryPropertyName = RuleUtil.getEntryPropertyName(temp.getScript());
            if (temp.getId().equals((Object)ruleInfo.getId()) || !deleteEntryPropertyName.equals(entryPropertyName)) continue;
            return false;
        }
        return true;
    }

    private boolean isLastMainRule(RuleInfo ruleInfo) throws EASBizException, ParserException, BOSException {
        int rowCount = this.tblRule.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.tblRule.getRow(i).getStyleAttributes().isLocked()) continue;
            RuleInfo temp = (RuleInfo)this.tblRule.getRow(i).getCell(0).getValue();
            if (ruleInfo.getId().equals((Object)temp.getId()) || RuleUtil.isEntryRule(this.getBizEntity(), temp)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        int selectedRowIndex = this.tblRule.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1 || selectedRowIndex == this.tblRule.getRowCount() - 1) {
            return;
        }
        IRow sourceRow = this.tblRule.getRow(selectedRowIndex);
        if (sourceRow.getStyleAttributes().isLocked()) {
            return;
        }
        if (this.isBoundary(selectedRowIndex, false)) {
            return;
        }
        IRow targetRow = this.tblRule.getRow(selectedRowIndex + 1);
        this.swapRow(sourceRow, targetRow);
        this.tblRule.getSelectManager().select(selectedRowIndex + 1, this.tblRule.getSelectManager().getActiveColumnIndex());
        this.tblRule.repaint();
    }

    private void swapRow(IRow sourceRow, IRow targetRow) {
        IRow sourceRowCopy = (IRow)sourceRow.clone();
        IRow targetRowCopy = (IRow)targetRow.clone();
        sourceRow.getCell(0).setValue(targetRowCopy.getCell(0).getValue());
        sourceRow.getCell(2).setValue(targetRowCopy.getCell(2).getValue());
        sourceRow.getCell(3).setValue(targetRowCopy.getCell(3).getValue());
        targetRow.getCell(0).setValue(sourceRowCopy.getCell(0).getValue());
        targetRow.getCell(2).setValue(sourceRowCopy.getCell(2).getValue());
        targetRow.getCell(3).setValue(sourceRowCopy.getCell(3).getValue());
    }

    private boolean isBoundary(int rowIndex, boolean isUP) {
        if (isUP) {
            if (rowIndex == 0) {
                return true;
            }
            IRow row = this.tblRule.getRow(rowIndex - 1);
            return row.getStyleAttributes().isLocked();
        }
        if (this.tblRule.getRowCount() > rowIndex + 1) {
            IRow row = this.tblRule.getRow(rowIndex + 1);
            return row.getStyleAttributes().isLocked();
        }
        return true;
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        int selectedRowIndex = this.tblRule.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex <= 0) {
            return;
        }
        IRow sourceRow = this.tblRule.getRow(selectedRowIndex);
        if (sourceRow.getStyleAttributes().isLocked()) {
            return;
        }
        if (this.isBoundary(selectedRowIndex, true)) {
            return;
        }
        IRow targetRow = this.tblRule.getRow(selectedRowIndex - 1);
        this.swapRow(sourceRow, targetRow);
        this.tblRule.getSelectManager().select(selectedRowIndex - 1, this.tblRule.getSelectManager().getActiveColumnIndex());
        this.tblRule.repaint();
    }

    @Override
    protected void tblRule_editStarting(KDTEditEvent e) throws Exception {
        super.tblRule_editStarting(e);
        this.lockCell(e);
    }

    @Override
    protected void tblRule_tableClicked(KDTMouseEvent e) throws Exception {
        Object obj;
        int rowIndex;
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && (rowIndex = e.getRowIndex()) != -1 && (obj = this.tblRule.getRow(rowIndex).getCell(0).getValue()) instanceof RuleInfo) {
            RuleInfo rule = (RuleInfo)obj;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)rule.getId().toString());
            uiContext.put((Object)"bizObject", (Object)rule.getBizObject());
            uiContext.put((Object)"readonly", (Object)Boolean.TRUE);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RuleEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    private void lockCell(KDTEditEvent e) throws EASBizException, ParserException, BOSException {
        int rowIndex = e.getRowIndex();
        if (e.getColIndex() == 5 && this.isBoundary(rowIndex, false)) {
            e.setCancel(true);
        }
    }

    public void setCtrlUnitPK(IObjectPK ctrlUnitPK) {
        this.ctrlUnitPK = ctrlUnitPK;
    }

    public void setBizObjectType(BOSObjectType bizObjectType) {
        this.bizObjectType = bizObjectType;
    }

    public BOSObjectType getBizObjectType() {
        return this.bizObjectType;
    }

    public void setRuleStructure(String ruleStructure) throws BOSException {
        NewUserAccreditUI parentUserAccredit;
        if (this.getParent() instanceof NewUserAccreditUI) {
            parentUserAccredit = (NewUserAccreditUI)((Object)this.getParent());
            parentUserAccredit.checkRulelength(ruleStructure);
        }
        this.ruleStructure = ruleStructure;
        if (!StringUtils.isEmpty((String)ruleStructure)) {
            this.ruleCollection = this.getCurrentRules(ruleStructure);
            if (this.getParent() instanceof NewUserAccreditUI) {
                parentUserAccredit = (NewUserAccreditUI)((Object)this.getParent());
                parentUserAccredit.btnSubmit.setEnabled(true);
                parentUserAccredit.setNeedSaveNormal(true);
            }
        }
    }

    private RuleCollection getCurrentRules(String ruleStructure) throws BOSException {
        HashSet<String> ruleIDs = new HashSet<String>();
        String[] temps = StringUtils.split((String)ruleStructure, (String)" ");
        if (temps != null) {
            int length = temps.length;
            for (int i = 0; i < length; ++i) {
                if (!RuleUtil.isRuleID(temps[i])) continue;
                ruleIDs.add(temps[i]);
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (ruleIDs.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ruleIDs, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            IRule iRule = RuleFactory.getRemoteInstance();
            return iRule.getRuleCollection(entityViewInfo);
        }
        return null;
    }

    public void refresh() throws EASBizException, ParserException, BOSException {
        this.loadRules();
    }

    public void reset() {
        this.ruleStructure = null;
        this.bizObjectType = null;
        this.ruleCollection = null;
        this.tblRule.removeRows();
    }

    private void loadRules() throws EASBizException, ParserException, BOSException {
        this.tblRule.removeRows();
        if (!StringUtils.isEmpty((String)this.ruleStructure)) {
            ArrayList ruleRows = this.getRuleRows();
            int size = ruleRows.size();
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblRule.addRow();
                Object[] ruleRow = (Object[])ruleRows.get(i);
                if (ruleRow[0] == null && i != 0) {
                    this.tblRule.getMergeManager().mergeBlock(i, 0, i, 5);
                    row.getStyleAttributes().setLocked(true);
                    row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                    row.getCell(0).setValue((Object)EASResource.getString((String)RESOURCE, (String)"entryRuleSep"));
                    continue;
                }
                row.getCell(0).setValue(ruleRow[0]);
                row.getCell(1).setValue(ruleRow[1]);
                row.getCell(2).setValue(ruleRow[2]);
                row.getCell(3).setValue(ruleRow[3]);
                row.getCell(4).setValue(ruleRow[4]);
                row.getCell(5).setValue(ruleRow[5]);
            }
        }
    }

    private EntityObjectInfo getBizEntity() {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return metaDataLoader.getEntity(this.bizObjectType);
    }

    public ArrayList getRuleRows() throws EASBizException, ParserException, BOSException {
        assert (!StringUtils.isEmpty((String)this.ruleStructure));
        ArrayList<Object[]> ruleRows = new ArrayList<Object[]>();
        String[] strs = StringUtils.split((String)this.ruleStructure, (String)" ");
        HashSet<String> entryPropertyNames = new HashSet<String>();
        int nearlyRuleIDEndPos = 0;
        for (String str : strs) {
            String entryPropertyName;
            if (!RuleUtil.isRuleID(str)) continue;
            String ruleID = str;
            RuleInfo ruleInfo = this.ruleCollection.get(BOSUuid.read((String)ruleID));
            if (RuleUtil.isEntryRule(this.getBizEntity(), ruleInfo) && !entryPropertyNames.contains(entryPropertyName = RuleUtil.getEntryPropertyName(ruleInfo.getScript()))) {
                if (ruleRows.size() > 0) {
                    Object[] ruleRow = new Object[6];
                    ruleRows.add(ruleRow);
                }
                entryPropertyNames.add(entryPropertyName);
            }
            Object[] ruleRow = new Object[6];
            ruleRow[0] = ruleInfo;
            ruleRow[2] = ruleInfo.getNumber();
            ruleRow[3] = ruleInfo.getName();
            ruleRow[1] = this.getLeftBracket(this.ruleStructure, ruleID, nearlyRuleIDEndPos);
            ruleRow[4] = this.getRightBracket(this.ruleStructure, ruleID, nearlyRuleIDEndPos);
            ruleRow[5] = this.getLogic(this.ruleStructure, ruleID, nearlyRuleIDEndPos);
            ruleRows.add(ruleRow);
            nearlyRuleIDEndPos = this.ruleStructure.indexOf(ruleID, nearlyRuleIDEndPos) + ruleID.length();
        }
        return ruleRows;
    }

    private LeftBracketToken getLeftBracket(String ruleStructure, String ruleID, int nearlyRuleIDEndPos) {
        int beginIndex = ruleStructure.indexOf(ruleID, nearlyRuleIDEndPos);
        String str = ruleStructure.substring(nearlyRuleIDEndPos, beginIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (LeftBracketToken.getEnum(temp) == null) continue;
            return LeftBracketToken.getEnum(temp);
        }
        return null;
    }

    private RightBracketToken getRightBracket(String ruleStructure, String ruleID, int nearlyRuleIDEndPos) {
        String str = ruleStructure.substring(nearlyRuleIDEndPos);
        int beginIndex = str.indexOf(ruleID) + ruleID.length();
        int endIndex = -1;
        str = str.substring(beginIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (!RuleUtil.isRuleID(temp)) continue;
            endIndex = str.indexOf(temp);
            break;
        }
        str = str.substring(0, endIndex == -1 ? str.length() : endIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (RightBracketToken.getEnum(temp) == null) continue;
            return RightBracketToken.getEnum(temp);
        }
        return null;
    }

    private LogicToken getLogic(String ruleStructure, String ruleID, int nearlyRuleIDEndPos) {
        String str = ruleStructure.substring(nearlyRuleIDEndPos);
        int beginIndex = str.indexOf(ruleID) + ruleID.length();
        int endIndex = -1;
        str = str.substring(beginIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (!RuleUtil.isRuleID(temp)) continue;
            endIndex = str.indexOf(temp);
            break;
        }
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        str = str.substring(0, endIndex == -1 ? str.length() - 1 : endIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (LogicToken.getEnum(temp) == null) continue;
            return LogicToken.getEnum(temp);
        }
        return null;
    }

    public String getRuleStructure() throws EASBizException, ParserException, BOSException {
        StringBuffer structure = new StringBuffer(200);
        int rowCount = this.tblRule.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.tblRule.getRow(i).getStyleAttributes().isLocked()) {
                Object objLeftBracket = this.tblRule.getRow(i).getCell(1).getValue();
                Object objRightBracket = this.tblRule.getRow(i).getCell(4).getValue();
                Object objLogic = this.tblRule.getRow(i).getCell(5).getValue();
                RuleInfo ruleInfo = (RuleInfo)this.tblRule.getRow(i).getCell(0).getValue();
                boolean isEntryRule = RuleUtil.isEntryRule(this.getBizEntity(), ruleInfo);
                if (i == 0) {
                    structure.append(" " + this.getWhere(ruleInfo) + " ");
                }
                if (objLeftBracket != null && objLeftBracket instanceof LeftBracketToken) {
                    structure.append(" ").append(((LeftBracketToken)((Object)objLeftBracket)).getValue()).append(" ");
                }
                structure.append(" ").append(ruleInfo.getId().toString()).append(" ");
                if (objRightBracket != null && objRightBracket instanceof RightBracketToken) {
                    structure.append(" ").append(((RightBracketToken)((Object)objRightBracket)).getValue()).append(" ");
                }
                if (objLogic != null && objLogic instanceof LogicToken && i != rowCount - 1) {
                    structure.append(" ").append(((LogicToken)((Object)objLogic)).getValue()).append(" ");
                }
                if (!isEntryRule) continue;
                if (i == rowCount - 1) {
                    structure.append(" ON ").append(RuleUtil.getEntryPropertyName(ruleInfo.getScript())).append(" ");
                    continue;
                }
                Object obj = this.tblRule.getRow(i + 1).getCell(0).getValue();
                if (!(obj instanceof RuleInfo)) continue;
                RuleInfo downRuleInfo = (RuleInfo)obj;
                if (!this.tblRule.getRow(i + 1).getStyleAttributes().isLocked()) continue;
                structure.append(" ON ").append(RuleUtil.getEntryPropertyName(downRuleInfo.getScript())).append(" ");
                continue;
            }
            if (i >= rowCount - 1) continue;
            RuleInfo ruleInfo = (RuleInfo)this.tblRule.getRow(i + 1).getCell(0).getValue();
            structure.append(" ").append(this.getWhere(ruleInfo)).append(" ");
        }
        return structure.toString();
    }

    private String getWhere(RuleInfo ruleInfo) throws EASBizException, ParserException, BOSException {
        boolean isEntryRule = RuleUtil.isEntryRule(this.getBizEntity(), ruleInfo);
        if (isEntryRule) {
            if (EntryWhereEnum.ENTRY_WHERE.equals((Object)ruleInfo.getEntryDisplay())) {
                return "ENTRYWHERE";
            }
            if (EntryWhereEnum.ENTRY_ALL_WHERE.equals((Object)ruleInfo.getEntryDisplay())) {
                return "ENTRYALLWHERE";
            }
            return "ENTRYANYWHERE";
        }
        return "WHERE";
    }

    public boolean verify() throws EASBizException, ParserException, BOSException {
        if (StringUtils.isEmpty((String)this.ruleStructure)) {
            return true;
        }
        if (!this.isBracketMatching()) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"logicIsNull"));
            return false;
        }
        if (!this.isLogicExist()) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"logicIsNull"));
            return false;
        }
        IRule iRule = RuleFactory.getRemoteInstance();
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(this.bizObjectType);
            RuleParser ruleParser = new RuleParser(entity);
            ruleParser.setRuleStructure(this.ruleStructure);
            iRule.checkRuleExpr(ruleParser.buildExpr(), this.bizObjectType.toString());
        }
        catch (EASBizException e) {
            MsgBox.showWarning((String)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isLogicExist() {
        int rowCount = this.tblRule.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object objLogic;
            if (this.tblRule.getRow(i).getStyleAttributes().isLocked() || (objLogic = this.tblRule.getRow(i).getCell(5).getValue()) != null && objLogic instanceof LogicToken || this.isBoundary(i, false)) continue;
            return false;
        }
        return true;
    }
}

