/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.ISMSValidataUserManager;
import com.kingdee.eas.base.permission.SMSValidataUserManagerCollection;
import com.kingdee.eas.base.permission.SMSValidataUserManagerFactory;
import com.kingdee.eas.base.permission.SMSValidataUserManagerInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractSMSValidataUserManagerListUI;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SMSValidataUserManagerListUI
extends AbstractSMSValidataUserManagerListUI {
    private static final Logger logger = CoreUIObject.getLogger(SMSValidataUserManagerListUI.class);
    SelectorItemCollection userSelector = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBtnStatus();
    }

    private void setBtnStatus() {
        this.btnAddNew.setVisible(false);
        this.btnAddNew.setEnabled(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnSelectUser.setEnabled(true);
        this.btnSelectUser.setVisible(true);
        this.btnSelectUser.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnCancelUser.setEnabled(true);
        this.btnCancelUser.setVisible(true);
        this.btnCancelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelectUser_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        IUIWindow win = this.getUIWindow();
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        dlg.setEnabledMultiSelection(true);
        dlg.setSelectorCollection(this.getUserSelector());
        dlg.setQueryInfo(MetaDataPK.create((String)"com.kingdee.eas.base.permission.app.UserListQuery"));
        EntityViewInfo entityViewInfo = this.getMaySelectUser();
        dlg.setEntityViewInfo(entityViewInfo);
        dlg.show();
        if (!dlg.isCanceled() && (obj = dlg.getData()) != null) {
            Object[] objAry = (Object[])obj;
            for (int i = 0; i < objAry.length; ++i) {
                SMSValidataUserManagerInfo info = new SMSValidataUserManagerInfo();
                UserInfo userInfo = (UserInfo)objAry[i];
                info.setUser(userInfo);
                IObjectPK logPK = LogUtil.beginLog(null, (String)"addnew", (BOSObjectType)new BOSObjectType("7FE5A48B"), null, (String)(EASResource.getString((String)RESOURCE, (String)"ADDNEW_MSGCODE_EXCLUDE") + "\u201c" + userInfo.getNumber() + "\u201d"), (String)"sms_chose_user");
                this.getBizInterface().addnew((CoreBaseInfo)info);
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
        }
        this.refreshList();
    }

    private SelectorItemCollection getUserSelector() {
        if (this.userSelector != null) {
            return this.userSelector;
        }
        this.userSelector = new SelectorItemCollection();
        this.userSelector.add(new SelectorItemInfo("id"));
        this.userSelector.add(new SelectorItemInfo("number"));
        this.userSelector.add(new SelectorItemInfo("type"));
        this.userSelector.add(new SelectorItemInfo("name"));
        this.userSelector.add(new SelectorItemInfo("cu.name"));
        this.userSelector.add(new SelectorItemInfo("cell"));
        this.userSelector.add(new SelectorItemInfo("email"));
        return this.userSelector;
    }

    private EntityViewInfo getMaySelectUser() throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        List alreadlyUserIdList = this.getAlreadUserId();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadlyUserIdList, false), CompareType.NOTINCLUDE));
        ev.setFilter(filterInfo);
        return ev;
    }

    private List getAlreadUserId() throws Exception {
        ArrayList retList = new ArrayList();
        SMSValidataUserManagerCollection colls = this.getBizInterface().getSMSValidataUserManagerCollection("select id, user.id");
        if (colls == null || colls.isEmpty()) {
            return retList;
        }
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)colls, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                SMSValidataUserManagerInfo info = (SMSValidataUserManagerInfo)obj;
                if (info.getUser() != null && info.getUser().getId() != null) {
                    return info.getUser().getId().toString();
                }
                return null;
            }
        });
    }

    @Override
    public void actionRemoveUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        List userNumberList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, "user.number"));
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            IObjectPK logPK = LogUtil.beginLog(null, (String)"delete", (BOSObjectType)new BOSObjectType("7FE5A48B"), null, (String)(EASResource.getString((String)RESOURCE, (String)"MSG_CODE_PERSON_REMOVE") + "\u201c" + userNumberList.get(i) + "\u201d" + EASResource.getString((String)RESOURCE, (String)"MSG_CODE_PERSON_REMOVE")), (String)"sms_delete_user");
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(ids.get(i).toString()));
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        this.tblMain.refresh();
    }

    protected ISMSValidataUserManager getBizInterface() throws Exception {
        return SMSValidataUserManagerFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

