/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.AuthenMessageTypeEnum;
import com.kingdee.eas.base.permission.AuthenModeCollection;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeInfo;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.client.AbstractSetAuthenModelUI;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SetAuthenModelUI
extends AbstractSetAuthenModelUI {
    private static final Logger logger = CoreUIObject.getLogger(SetAuthenModelUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompStatus();
        this.addCompListener();
    }

    private void addCompListener() {
        this.ckIsNeedAuthen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    KDCheckBox ckIsNeedAuthenBox = (KDCheckBox)event.getSource();
                    if (ckIsNeedAuthenBox.isSelected()) {
                        AuthenModeFactory.getRemoteInstance().update(AuthenModeTypeEnum.OpenAuthen, true);
                        SetAuthenModelUI.this.ckIsNeedAuthenWhenAsscreditPerm.setSelected(true);
                        SetAuthenModelUI.this.changeCompStatus(true);
                    } else {
                        AuthenModeFactory.getRemoteInstance().update(AuthenModeTypeEnum.OpenAuthen, false);
                        AuthenModeFactory.getRemoteInstance().update(AuthenModeTypeEnum.UserPermChangeAuthen, false);
                        SetAuthenModelUI.this.ckIsNeedAuthenWhenAsscreditPerm.setSelected(false);
                        AuthenModeFactory.getRemoteInstance().update(AuthenModeTypeEnum.NewUserAuthen, false);
                        SetAuthenModelUI.this.ckIsNeedAuthenWhenCreateUser.setSelected(false);
                        SetAuthenModelUI.this.changeCompStatus(false);
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)SetAuthenModelUI.this), (String)(EASResource.getString((String)SetAuthenModelUI.RESOURCE, (String)"SET_FAIL") + "--ckIsNeedAuthenBox"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
                }
            }
        });
        this.ckIsNeedAuthenWhenCreateUser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    KDCheckBox ckIsNeedAuthenWhenCreateUserBox = (KDCheckBox)event.getSource();
                    boolean isNeedAuthenWhenCreateUser = ckIsNeedAuthenWhenCreateUserBox.isSelected();
                    AuthenModeFactory.getRemoteInstance().update(AuthenModeTypeEnum.NewUserAuthen, isNeedAuthenWhenCreateUser);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)SetAuthenModelUI.this), (String)(EASResource.getString((String)SetAuthenModelUI.RESOURCE, (String)"SET_FAIL") + "--ckIsNeedAuthenWhenCreateUser"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
                }
            }
        });
        this.ckIsNeedAuthenWhenAsscreditPerm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    KDCheckBox ckIsNeedAuthenWhenAsscreditPermBox = (KDCheckBox)event.getSource();
                    boolean isNeedAuthenWhenAsscreditPerm = ckIsNeedAuthenWhenAsscreditPermBox.isSelected();
                    AuthenModeFactory.getRemoteInstance().update(AuthenModeTypeEnum.UserPermChangeAuthen, isNeedAuthenWhenAsscreditPerm);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)SetAuthenModelUI.this), (String)(EASResource.getString((String)SetAuthenModelUI.RESOURCE, (String)"SET_FAIL") + "--ckIsNeedAuthenWhenAsscreditPerm"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
                }
            }
        });
        this.ckSysMessage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    KDCheckBox ckSysMessageBox = (KDCheckBox)event.getSource();
                    boolean sysMessage = ckSysMessageBox.isSelected();
                    AuthenRecordFactory.getRemoteInstance().dealAuthenMessageType((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"), AuthenMessageTypeEnum.SYSMESSAGE, sysMessage);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)SetAuthenModelUI.this), (String)(EASResource.getString((String)SetAuthenModelUI.RESOURCE, (String)"SET_FAIL") + "--ckSysMessage"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
                }
            }
        });
        this.ckSms.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    KDCheckBox ckSmsBox = (KDCheckBox)event.getSource();
                    boolean sms = ckSmsBox.isSelected();
                    AuthenRecordFactory.getRemoteInstance().dealAuthenMessageType((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"), AuthenMessageTypeEnum.SMS, sms);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)SetAuthenModelUI.this), (String)(EASResource.getString((String)SetAuthenModelUI.RESOURCE, (String)"SET_FAIL") + "--ckSms"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
                }
            }
        });
        this.ckEmail.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    KDCheckBox ckEmailBox = (KDCheckBox)event.getSource();
                    boolean email = ckEmailBox.isSelected();
                    AuthenRecordFactory.getRemoteInstance().dealAuthenMessageType((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F"), AuthenMessageTypeEnum.EMAIL, email);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)SetAuthenModelUI.this), (String)(EASResource.getString((String)SetAuthenModelUI.RESOURCE, (String)"SET_FAIL") + "--ckEmail"), (String)ThrowableHelper.toString((Exception)((Object)e)), (int)0);
                }
            }
        });
    }

    private void initCompStatus() throws BOSException {
        try {
            AuthenModeCollection collection = AuthenModeFactory.getRemoteInstance().getCollection();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AuthenModeInfo authenModeInfo = (AuthenModeInfo)iterator.next();
                AuthenModeTypeEnum modeType = authenModeInfo.getModeType();
                boolean isEnable = authenModeInfo.isIsEnable();
                if (AuthenModeTypeEnum.NewUserAuthen.equals((Object)modeType)) {
                    this.ckIsNeedAuthenWhenCreateUser.setSelected(isEnable);
                    continue;
                }
                if (AuthenModeTypeEnum.UserPermChangeAuthen.equals((Object)modeType)) {
                    this.ckIsNeedAuthenWhenAsscreditPerm.setSelected(isEnable);
                    continue;
                }
                if (!AuthenModeTypeEnum.OpenAuthen.equals((Object)modeType)) continue;
                this.ckIsNeedAuthen.setSelected(isEnable);
                this.changeCompStatus(isEnable);
            }
            List messageTypeList = AuthenRecordFactory.getRemoteInstance().getAuthenMessageType();
            for (String messageType : messageTypeList) {
                if (messageType.equals("10")) {
                    this.ckSysMessage.setSelected(true);
                    continue;
                }
                if (messageType.equals("20")) {
                    this.ckSms.setSelected(true);
                    continue;
                }
                if (!messageType.equals("30")) continue;
                this.ckEmail.setSelected(true);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private void changeCompStatus(boolean enable) {
        this.ckIsNeedAuthenWhenAsscreditPerm.setEnabled(enable);
        this.ckIsNeedAuthenWhenCreateUser.setEnabled(enable);
        this.ckSysMessage.setEnabled(enable);
        this.ckSms.setEnabled(enable);
        this.ckEmail.setEnabled(enable);
    }

    private void getBizInterface() {
    }
}

