/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionLogHelper;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.AbstractUserBatchUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.helper.NewUserAccreditTreeHelper;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.TreeHelper;
import com.kingdee.eas.base.permission.client.util.TreeOperator;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.ITreeFilterComp;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.TreeFilterEmpty;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.AccreditPermF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class UserBatchUI
extends AbstractUserBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(UserBatchUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private String targetUser = null;
    private UserInfo targetUserInfo = null;
    private int curTabPage = 1;
    private KDTree curOperTree = null;
    private TreeOperator treeOperator = null;
    private TreeHelper treeHelper = null;
    private boolean batchSave = true;
    private List selectOrgList = new ArrayList();
    private boolean selectAllOrg = false;
    private KDTreeNode branch = null;
    private IAccreditTreeBuilder builder = null;
    private KDTreeNode filterTreeNode4Wait = null;
    private List permList4Wait = null;
    private int MAX_NUM = 80000;
    private boolean isModified = false;
    private boolean isOnloading = false;
    private NewUserAccreditTreeHelper newTreeHelper = null;

    private FilterInfo getDefaultFilteInfo() {
        FilterInfo myFilterInfo = new FilterInfo();
        String idStr = this.getAccreditOrgIdStr();
        if (StringUtils.isEmpty((String)idStr)) {
            return null;
        }
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
        return myFilterInfo;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setText(null);
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnSave.setEnabled(true);
        Icon savePermIcon = EASResource.getIcon((String)"imgTbtn_save");
        this.btnSave.setIcon(savePermIcon);
        Icon deleteAllPermIcon = EASResource.getIcon((String)"imgTbtn_delete");
        this.btnDeleteAllPerm.setIcon(deleteAllPermIcon);
        this.btnDeleteAllPerm.setVisible(false);
        Icon selectOrgIcon = EASResource.getIcon((String)"imgTbtn_selectcompany");
        this.btnSelectOrg.setIcon(selectOrgIcon);
        try {
            this.initTab();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
    }

    private void initTab() throws EASBizException, BOSException {
        UserInfo targetUserInfo = ToolUtils.getSimpleUserInfo((IObjectPK)new ObjectStringPK(this.targetUser));
        if (!targetUserInfo.isBizAdmin()) {
            this.tabAssign.setEnabledAt(0, false);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    private String getTargetUser() {
        return this.targetUser;
    }

    private String getAccreditOrgIdStr() {
        if (this.selectOrgList == null || this.selectOrgList.isEmpty()) {
            return null;
        }
        return ToolUtils.aryToStr(this.selectOrgList, false);
    }

    private void initUserF7(UserInfo userInfo) throws EASBizException, BOSException, UuidException, ParserException {
        this.bizUser.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this.bizUser.setEditFormat("$number$");
        this.bizUser.setCommitFormat("$number$");
        this.bizUser.setDisplayFormat("$number$($name$)");
        this.bizUser.setData((Object)userInfo);
        EntityViewInfo evi = new EntityViewInfo();
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            evi.setFilter(new UserListUIHelper().getCurrentRangeUser());
        }
        this.bizUser.setEntityViewInfo(evi);
    }

    private TreeHelper getTreeHelper() {
        if (this.treeHelper == null) {
            try {
                this.treeHelper = new TreeHelper(ToolUtils.getCurrentUserPK(), ToolUtils.getCurrentCUPK(), PermissionTreeBuilderFactory.getUserOrgPermTreeBuilder());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIException(e);
            }
        }
        return this.treeHelper;
    }

    private void clearAllTrees() {
        ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
    }

    private UserInfo getTargetUserInfo() {
        return (UserInfo)this.getUIContext().get("targetUser");
    }

    public void onLoad() throws Exception {
        String disStr;
        UserInfo userInfo;
        this.isOnloading = true;
        this.builder = PermissionTreeBuilderFactory.getUserOrgPermTreeBuilder();
        this.branch = this.builder.createTreeBranch();
        this.targetUser = this.getUIContext().get("targetID").toString();
        this.targetUserInfo = userInfo = (UserInfo)this.getUIContext().get("targetUser");
        this.batchSave = Boolean.valueOf(this.getUIContext().get("batchSave").toString());
        if (this.batchSave) {
            disStr = EASResource.getString((String)RESOURCE, (String)"saveAssign");
            this.btnSave.setText(disStr);
            this.btnSave.setToolTipText(disStr);
        } else {
            disStr = EASResource.getString((String)RESOURCE, (String)"cancelAssign");
            this.btnSave.setText(EASResource.getString((String)RESOURCE, (String)"cancelAssign"));
            this.btnSave.setToolTipText(disStr);
        }
        super.onLoad();
        this.initUserF7(userInfo);
        FilterInfo filterInfo = new FilterInfo("orgNumber = 1 and orgNumber = -1");
        if (this.mainQuery != null) {
            this.mainQuery.setFilter(filterInfo);
        }
        this.clearAllTrees();
        this.treeOperator = new TreeOperator(PermissionTreeBuilderFactory.getUserOrgPermTreeBuilder());
        super.execQuery();
        this.isOnloading = false;
        this.addFunction();
    }

    private void addFunction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(65, 3), "biz");
        this.getActionMap().put("biz", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OUUnionF7 orgF7 = new OUUnionF7((IUIObject)UserBatchUI.this);
                    orgF7.setShowSub(true);
                    orgF7.disableTheOUWhichIsOnlyAdmin();
                    orgF7.setContainOUSealUp(false);
                    OrgHelper.setF7ByUser((OuF7PromptDialog)orgF7, (IObjectPK)new ObjectUuidPK(UserBatchUI.this.targetUserInfo.getId()));
                    orgF7.setIsDisplayMaintain(true);
                    orgF7.setCheckedOrgIDs(ToolUtils.trans2Map(UserBatchUI.this.selectOrgList).keySet());
                    orgF7.setShowAssistantOrg(true);
                    orgF7.setIsShowContainSealUp(true);
                    orgF7.show();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void setSortInfo(EntityViewInfo targetQuery) {
        targetQuery.getSorter().clear();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        targetQuery.getSorter().add(sorterItemInfo);
    }

    protected void execQuery() {
        FilterInfo filterInfo = this.getDefaultFilteInfo();
        if (this.mainQuery != null && filterInfo != null) {
            this.mainQuery.setFilter(filterInfo);
            this.setSortInfo(this.mainQuery);
        }
        super.execQuery();
    }

    @Override
    protected void bizUser_dataChanged(DataChangeEvent e) throws Exception {
        KDBizPromptBox userInfoBox = (KDBizPromptBox)e.getSource();
        UserInfo userInfo = (UserInfo)userInfoBox.getData();
        if (userInfo != null && userInfo.getId() != null) {
            this.targetUser = userInfo.getId().toString();
            this.targetUserInfo = userInfo;
        } else {
            this.targetUser = "";
        }
        this.selectOrgList.clear();
        FilterInfo filterInfo = new FilterInfo("orgNumber = 1 and orgNumber = -1");
        this.mainQuery.setFilter(filterInfo);
        this.execQuery();
        if (!this.isOnloading) {
            this.clearAllTrees();
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        return "orgId";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    private Collection getPermItemTypeCol() throws EASBizException, BOSException {
        if (this.targetUserInfo == null) {
            return null;
        }
        ArrayList<String> permItemTypeList = new ArrayList<String>();
        permItemTypeList.add("30");
        permItemTypeList.add("20");
        if (Administrator.isBizAdmin(null, (IObjectPK)new ObjectStringPK(this.targetUser))) {
            permItemTypeList.add("15");
        }
        return permItemTypeList;
    }

    private void treeFilterPermItem() throws Exception {
        try {
            this.filterTree4wait();
            ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot((TreeNode)this.filterTreeNode4Wait);
            TreeFilterEmpty treeFilterEmpty = new TreeFilterEmpty();
            treeFilterEmpty.filterTree(this.treeSourcePerm, new ITreeFilterComp(){

                @Override
                public String getKeyString(Object obj) {
                    return null;
                }

                @Override
                public boolean isLeaf(Object obj) {
                    UserOrgPermInfo userOrgPermInfo;
                    PermItemInfo permItemInfo;
                    if (obj != null && obj instanceof UserOrgPermInfo && (permItemInfo = (userOrgPermInfo = (UserOrgPermInfo)obj).getPermItem()) != null) {
                        return permItemInfo.isIsLeaf();
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    private void filterTree4wait() {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UserBatchUI.this.filterTree4waitDeal();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void filterTree4waitDeal() throws BOSException, EASBizException, Exception {
        PermItemCollection permItemCol = this.getPermItemCollection();
        UserOrgPermCollection userOrgPermCol = new UserOrgPermCollection();
        if (permItemCol != null) {
            int size = permItemCol.size();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
                userOrgPermInfo.setPermItem(permItemCol.get(i));
                userOrgPermCol.add(userOrgPermInfo);
            }
        }
        this.filterTreeNode4Wait = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPermCol);
    }

    private PermItemCollection getPermItemCollection() throws BOSException, EASBizException {
        LowTimer lowTime = new LowTimer();
        lowTime.reset();
        logger.info((Object)("" + lowTime.msValue()));
        FullOrgUnitCollection orgInfoCol = UIUtil.getSelectOrgCol(this.tblMain, ToolUtils.aryToStr(this.selectOrgList, false));
        logger.info((Object)("" + lowTime.msValue()));
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            return this.getPermItemCollectionByBizAdmin(orgInfoCol);
        }
        return this.getPermItemCollectionBySysAdmin(orgInfoCol);
    }

    private PermItemCollection getPermItemCollectionByBizAdmin(FullOrgUnitCollection orgInfoCol) throws EASBizException, BOSException {
        return UserOrgPermFactory.getRemoteInstance().getAuthorizePerms(ToolUtils.getCurrentUserPK(), ToolUtils.orgCol2List(orgInfoCol));
    }

    private PermItemCollection getPermItemCollectionBySysAdmin(FullOrgUnitCollection orgInfoCol) throws BOSException, EASBizException {
        PermItemCollection permItemCol = PermItemFactory.getRemoteInstance().getAllPermissionByOrgType(PermissionOrgTypeUtils.getSelectOrgType(orgInfoCol), this.getPermItemTypeCol());
        return permItemCol;
    }

    private void mayTreeFilter(List oldList, List newList) throws Exception {
        if (!oldList.containsAll(newList) || !newList.containsAll(oldList)) {
            if (!newList.isEmpty()) {
                this.treeFilterPermItem();
            } else {
                ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        IUserOrgPerm userOrgPerm = UserOrgPermFactory.getRemoteInstance();
        return userOrgPerm;
    }

    private KDTree getCurOperTree() {
        if (this.curTabPage == 0) {
            this.curOperTree = this.treeAuthorizedPerm;
        } else if (this.curTabPage == 2) {
            this.curOperTree = this.treeForbiddenPerm;
        } else if (this.curTabPage == 1) {
            this.curOperTree = this.treeNormalPerm;
        } else {
            throw new IllegalArgumentException("current operater tree is error! curTabPage is:" + this.curTabPage);
        }
        return this.curOperTree;
    }

    @Override
    protected void tabAssign_stateChanged(ChangeEvent e) throws Exception {
        this.curTabPage = this.tabAssign.getSelectedIndex();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.treeOperator.actionAdd(this.treeSourcePerm, this.getCurOperTree());
        this.setIcon2Tree();
        this.isModified = true;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        this.treeOperator.actionAddAll(this.treeSourcePerm, this.getCurOperTree());
        this.setIcon2Tree();
        this.isModified = true;
    }

    private void setIcon2Tree() {
        if (this.getCurOperTree() != null && this.getCurOperTree().getModel() != null) {
            this.getTreeHelper().setIcon2Tree((KDTreeNode)this.getCurOperTree().getModel().getRoot(), this.curTabPage);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.treeOperator.actionDelete(this.getCurOperTree());
        this.isModified = true;
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        this.treeOperator.actionDeleteAll(this.getCurOperTree());
        this.isModified = true;
    }

    private UserOrgPermCollection getAllpermData() {
        UserOrgPermCollection authUserOrgPermCol = TreeOperator.getUserOrgPermInTree(this.treeAuthorizedPerm, (IObjectPK)new ObjectStringPK(this.targetUser), null, PermType.AUTHORIZATION);
        UserOrgPermCollection forbidUserOrgPermCol = TreeOperator.getUserOrgPermInTree(this.treeForbiddenPerm, (IObjectPK)new ObjectStringPK(this.targetUser), null, PermType.FORBIDDEN);
        UserOrgPermCollection normalUserOrgPermCol = TreeOperator.getUserOrgPermInTree(this.treeNormalPerm, (IObjectPK)new ObjectStringPK(this.targetUser), null, PermType.NORMAL);
        UserOrgPermCollection allPermCol = new UserOrgPermCollection();
        if (authUserOrgPermCol != null && !authUserOrgPermCol.isEmpty()) {
            allPermCol.addCollection(authUserOrgPermCol);
        }
        if (forbidUserOrgPermCol != null && !forbidUserOrgPermCol.isEmpty()) {
            allPermCol.addCollection(forbidUserOrgPermCol);
        }
        if (normalUserOrgPermCol != null && !normalUserOrgPermCol.isEmpty()) {
            allPermCol.addCollection(normalUserOrgPermCol);
        }
        return allPermCol;
    }

    private boolean checkDataNum(FullOrgUnitCollection orgList, UserOrgPermCollection allPerms) {
        if (orgList.size() * allPerms.size() > this.MAX_NUM) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"dataNumTooBig"));
            return false;
        }
        return true;
    }

    private void save() throws Exception {
        if (StringUtils.isEmpty((String)this.targetUser)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectDataFirst"));
            return;
        }
        FullOrgUnitCollection orgList = ToolUtils.filterSameOrg(UIUtil.getSelectOrgCol(this.tblMain, ToolUtils.aryToStr(this.selectOrgList, false)));
        UserOrgPermCollection allPerms = this.getAllpermData();
        UserOrgPermCollection[] results = this.getUICurrentUOPs();
        if (orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
            return;
        }
        if (allPerms.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectDataFirst"));
            return;
        }
        boolean isEnabledAuthen = AuthenModeFactory.getRemoteInstance().isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
        if (isEnabledAuthen) {
            String msg;
            boolean isIncludeAuthenPerms = false;
            for (int i = 0; i < results.length && !(isIncludeAuthenPerms = PermissionUtils.isIncludeAuthenPerms(results[i])); ++i) {
            }
            if (isIncludeAuthenPerms && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_WILL_NEED_AUTHEN"), this.getTargetUserInfo().getNumber()))) == 2) {
                SysUtil.abort();
            }
        }
        IUserOrgPerm userOrgPerm = (IUserOrgPerm)this.getBizInterface();
        if (this.batchSave) {
            if (this.checkDataNum(orgList, allPerms)) {
                LogProxy logProxy = new LogProxy();
                Thread beginLogThread = new Thread(new BeginLogThread(true, logProxy, orgList, allPerms));
                beginLogThread.start();
                UserOrgPermCollection ret = userOrgPerm.saveUserOrgPermsBatch((IObjectPK)new ObjectStringPK(this.targetUser), ToolUtils.getCurrentCUPK(), orgList, allPerms);
                Thread endThread = new Thread(new EndLogThread(logProxy));
                endThread.start();
                UITools.showMsg((CoreUI)this, EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"), false);
                this.reloadTargetTrees(ret);
            }
        } else if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmDelete")) == 0) {
            IObjectPK sourceUserPK = this.getCurrentUserPK();
            IObjectPK targetUserPK = this.getTargetUserPK();
            LogProxy logProxy = new LogProxy();
            Thread beginLogThread = new Thread(new BeginLogThread(true, logProxy, orgList, allPerms));
            beginLogThread.start();
            IUserOrgPermFacade userOrgPermFacade = this.getNewBizInterface();
            userOrgPermFacade.deleteUserOrgPermsBatch(sourceUserPK, targetUserPK, ToolUtils.getCurrentCUPK(), orgList, results);
            Thread endThread = new Thread(new EndLogThread(logProxy));
            endThread.start();
            UITools.showMsg((CoreUI)this, EASResource.getString((String)RESOURCE, (String)"deleteSucceed"), false);
        }
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    public IUserOrgPermFacade getNewBizInterface() throws BOSException {
        return UserOrgPermFacadeFactory.getRemoteInstance();
    }

    private UserOrgPermCollection[] getUICurrentUOPs() {
        UserOrgPermCollection[] results = new UserOrgPermCollection[3];
        IObjectPK targetUserPK = this.getTargetUserPK();
        UserOrgPermCollection a_userOrgPerms = this.newTreeHelper.getUserOrgPermFromTree(this.treeAuthorizedPerm, targetUserPK, null, PermType.AUTHORIZATION);
        UserOrgPermCollection n_userOrgPerms = this.newTreeHelper.getUserOrgPermFromTree(this.treeNormalPerm, targetUserPK, null, PermType.NORMAL);
        UserOrgPermCollection f_userOrgPerms = this.newTreeHelper.getUserOrgPermFromTree(this.treeForbiddenPerm, targetUserPK, null, PermType.FORBIDDEN);
        results[0] = a_userOrgPerms;
        results[1] = n_userOrgPerms;
        results[2] = f_userOrgPerms;
        return results;
    }

    private void reloadTargetTrees(UserOrgPermCollection userOrgPermCollection) throws Exception {
        UserOrgPermCollection authorizePerms = new UserOrgPermCollection();
        UserOrgPermCollection normalPerms = new UserOrgPermCollection();
        UserOrgPermCollection forbidPerms = new UserOrgPermCollection();
        for (int i = 0; i < userOrgPermCollection.size(); ++i) {
            UserOrgPermInfo info = userOrgPermCollection.get(i);
            if (PermType.AUTHORIZATION.equals((Object)info.getPermType())) {
                authorizePerms.add(info);
                continue;
            }
            if (PermType.NORMAL.equals((Object)info.getPermType())) {
                normalPerms.add(info);
                continue;
            }
            forbidPerms.add(info);
        }
        KDTreeNode authorizeNode = this.builder.buildTreeRoot(this.branch, (IObjectCollection)authorizePerms);
        KDTreeNode normalNode = this.builder.buildTreeRoot(this.branch, (IObjectCollection)normalPerms);
        KDTreeNode forbidNode = this.builder.buildTreeRoot(this.branch, (IObjectCollection)forbidPerms);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot((TreeNode)authorizeNode);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot((TreeNode)normalNode);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot((TreeNode)forbidNode);
        this.builder.setForbiddenIcon(forbidNode);
        this.builder.setDataRuleIcon(normalNode);
    }

    private String getBatchSaveOrgPermLogDetail(FullOrgUnitCollection orgList, UserOrgPermCollection allPerms, String operStr) {
        int i;
        Locale locale = SysContext.getSysContext().getLocale();
        StringBuffer sb = new StringBuffer("");
        sb.append(LogNamesHelper.getLogName("operatorType4Log", locale) + " :" + operStr);
        String numberStr = "";
        if (this.targetUserInfo != null) {
            numberStr = this.targetUserInfo.getNumber();
        }
        sb.append("\n ").append(LogNamesHelper.getLogName("userNumber4Log", locale) + ":" + numberStr);
        sb.append(" \n " + LogNamesHelper.getLogName("orgNumber4Log", locale) + " (");
        int size = orgList.size();
        for (i = 0; i < size; ++i) {
            sb.append(orgList.get(i).getNumber()).append(",");
        }
        sb.append(")");
        sb.append("\n " + LogNamesHelper.getLogName("permName4Log", locale) + " {");
        size = allPerms.size();
        for (i = 0; i < size; ++i) {
            sb.append("\n [").append(LogNamesHelper.getLogName("permName4Log", locale) + ":").append(allPerms.get(i).getPermItem().getAlias()).append(",");
            sb.append("," + LogNamesHelper.getLogName("permType4Log", locale) + ":").append(allPerms.get(i).getPermType().getAlias()).append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isPrepareActionSave() {
        return true;
    }

    @Override
    public RequestContext prepareActionSave(IItemAction itemAction) throws Exception {
        return super.prepareActionSave(itemAction);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        if (PermissionHelper.isAuthenticateAdminEnabled() && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_WILL_NEED_AUTHEN"), this.getTargetUserInfo().getNumber()))) == 2) {
            SysUtil.abort();
        }
        this.longTimeSave();
    }

    private void longTimeSave() {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                Thread.sleep(100L);
                UserBatchUI.this.save();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.isModified = false;
    }

    @Override
    public void actionDeletePerm_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeletePerm_actionPerformed(e);
        this.longTimeSave();
    }

    @Override
    public boolean isPrepareActionSelectOrg() {
        return false;
    }

    @Override
    public RequestContext prepareActionSelectOrg(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSelectOrg(itemAction);
        request.put("getTargetUser", (Object)this.getTargetUser());
        return request;
    }

    @Override
    public void actionSelectOrg_actionPerformed(ActionEvent e) throws Exception {
        List oldList = (List)ObjectUtils.createCopy((Object)this.selectOrgList);
        super.actionSelectOrg_actionPerformed(e);
        this.selectOrgList();
        this.execQuery();
        this.mayTreeFilter(oldList, this.selectOrgList);
    }

    private void selectOrgList() throws EASBizException, BOSException {
        UserInfo targetUser = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(this.targetUserInfo.getId()));
        AccreditPermF7PromptDialog orgF7 = new AccreditPermF7PromptDialog((IUIObject)this, targetUser, true);
        HashSet tmp = new HashSet();
        tmp.addAll(this.selectOrgList);
        orgF7.setSelectedOrgIds(tmp);
        orgF7.show();
        if (!orgF7.isCanceled()) {
            this.selectOrgList.clear();
            Object obj = orgF7.getData();
            OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
            for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
            }
        }
    }

    public void setSelectOrgList(List selectOrgList) {
        this.selectOrgList = selectOrgList;
    }

    public boolean isSelectAllOrg() {
        return this.selectAllOrg;
    }

    public void setSelectAllOrg(boolean selectAllOrg) {
        this.selectAllOrg = selectAllOrg;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean destroyWindow() {
        if (this.isModified) {
            try {
                int isYes;
                FullOrgUnitCollection orgList = ToolUtils.filterSameOrg(UIUtil.getSelectOrgCol(this.tblMain, ToolUtils.aryToStr(this.selectOrgList, false)));
                UserOrgPermCollection allPerms = this.getAllpermData();
                if (!orgList.isEmpty() && !allPerms.isEmpty() && MsgBox.isYes((int)(isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"))))) {
                    this.longTimeSave();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    private class EndLogThread
    implements Runnable {
        private LogProxy logProxy;

        public EndLogThread(LogProxy logProxy) {
            this.logProxy = logProxy;
        }

        @Override
        public void run() {
            while (true) {
                if (this.logProxy != null && this.logProxy.getLogPK() != null && !StringUtils.isEmpty((String)this.logProxy.getLogPK().toString())) {
                    this.logProxy.end();
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                    continue;
                }
                break;
            }
        }
    }

    private class BeginLogThread
    implements Runnable {
        private LogProxy logProxy;
        private FullOrgUnitCollection orgList;
        private UserOrgPermCollection allPerms;
        private String methodAlias;
        private boolean isAdd;
        private String detail;

        public BeginLogThread(boolean isAdd, LogProxy logProxy, FullOrgUnitCollection orgList, UserOrgPermCollection allPerms) {
            this.logProxy = logProxy;
            this.orgList = orgList;
            this.allPerms = allPerms;
            this.isAdd = isAdd;
        }

        @Override
        public void run() {
            if (this.isAdd) {
                this.methodAlias = PermissionLogHelper.getUserBatchAccreditPermMethodAlias(null);
                this.detail = UserBatchUI.this.getBatchSaveOrgPermLogDetail(this.orgList, this.allPerms, "save");
            } else {
                this.methodAlias = PermissionLogHelper.getUserBatchDeletePermMethodAlias(null);
                this.detail = UserBatchUI.this.getBatchSaveOrgPermLogDetail(this.orgList, this.allPerms, "delete");
            }
            try {
                this.logProxy.beginLog(null, this.methodAlias, UserOrgPermFactory.getRemoteInstance().getType(), null, this.detail);
            }
            catch (BOSException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }
}

