/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.machine;

import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.client.machine.MachineCodeGenerator;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public final class MachineCodeUtil {
    private static Logger logger = Logger.getLogger(MachineCodeUtil.class);

    public static String getMachineCode(String plainText) throws IOException {
        if (plainText == null) {
            plainText = MachineCodeGenerator.getGenerator().getMachineCode();
        }
        logger.debug((Object)("pt:" + plainText));
        String machineCode = null;
        try {
            machineCode = CryptoTean.encrypt((String)"", (String)plainText);
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
            machineCode = "Crypt Fail";
        }
        if (!StringUtils.isEmpty((String)machineCode) && machineCode.length() > 99) {
            machineCode = machineCode.substring(0, 99);
        }
        return machineCode;
    }

    public static String getIpOrMacStr(int type) throws UnknownHostException, SocketException {
        String result = "";
        if (type == 2) {
            result = MachineCodeUtil.getIPStr();
        } else if (type == 4) {
            result = MachineCodeUtil.getMACStr();
        } else if (type == 6) {
            result = MachineCodeUtil.getIPStr() + MachineCodeUtil.getMACStr();
        }
        return result;
    }

    private static String getMACStr() throws UnknownHostException, SocketException {
        String result = "";
        InetAddress ia = InetAddress.getLocalHost();
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], ""));
        }
        result = sb.toString();
        return result;
    }

    private static String getIPStr() throws SocketException {
        String result = "";
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        block0: while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLinkLocalAddress() || address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                result = address.getHostAddress();
                continue block0;
            }
        }
        return result;
    }

    public static final void main(String[] args) {
    }
}

