/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.menusync.uiimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.client.SyncTreeUI;
import com.kingdee.eas.base.permission.client.menusync.IMenuSyncTreeUI;
import com.kingdee.eas.base.permission.client.menusync.NodeInfo;
import com.kingdee.eas.base.permission.client.menusync.PermItemGroupInfoModi;
import com.kingdee.eas.base.permission.client.menusync.PermissionWriter;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class PermTreeUIImpl
implements IMenuSyncTreeUI {
    private static Logger logger = Logger.getLogger((String)PermTreeUIImpl.class.getName());
    DependenceCollection dependenceCol = null;

    @Override
    public void setViewTree(SyncTreeUI souceUI) throws BOSException, EASBizException {
        PermissionInfo permissionInfo = null;
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        KDTreeNode customerNode = null;
        KDTreeNode standardNode = null;
        PermissionInfo standardPermissionInfo = MDReferenceFactory.getPermission();
        if (iPermItem.existCustomerFile()) {
            permissionInfo = iPermItem.getAllPermissionInfo();
            this.dependenceCol = permissionInfo.getDependences();
            customerNode = this.getPermissionNode(permissionInfo);
            standardNode = this.getPermissionNode(standardPermissionInfo);
        } else {
            this.dependenceCol = standardPermissionInfo.getDependences();
            customerNode = this.getPermissionNode(standardPermissionInfo);
            standardNode = (KDTreeNode)this.getCopyNode((DefaultKingdeeTreeNode)customerNode);
        }
        MDReferenceFactory.releasePermission();
        ((DefaultTreeModel)souceUI.getCustomTree(false).getModel()).setRoot((TreeNode)customerNode);
        ((DefaultTreeModel)souceUI.getCustomTree(true).getModel()).setRoot((TreeNode)standardNode);
    }

    private DefaultKingdeeTreeNode getCopyNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode anewNode = (DefaultKingdeeTreeNode)node.clone();
        anewNode.setUserObject(node.getUserObject());
        anewNode.setText(node.getText());
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            anewNode.add((MutableTreeNode)this.getCopyNode(tmpNode));
        }
        return anewNode;
    }

    private KDTreeNode getPermissionNode(PermissionInfo permissionInfo) {
        PermItemGroupInfoModi permItemGroupInfoModi = new PermItemGroupInfoModi();
        permItemGroupInfoModi.delGroupInfo(permissionInfo);
        KDTreeNode root = new KDTreeNode((Object)"");
        PermissionTreeHelper.generateItemTree(root, permissionInfo.getPermissionItems());
        KDTreeNode factRoot = (KDTreeNode)root.getRoot().getChildAt(0);
        int size = factRoot.getChildCount();
        for (int i = 0; i < size; ++i) {
            ((KDTreeNode)factRoot.getChildAt(i)).setParent((MutableTreeNode)factRoot);
        }
        factRoot.setParent(null);
        return factRoot;
    }

    @Override
    public void save(SyncTreeUI sourceUI) throws Exception {
        KDTreeNode treeNodePerm = (KDTreeNode)((DefaultTreeModel)sourceUI.getCustomTree(false).getModel()).getRoot();
        PermItemGroupInfoModi groupInfoModi = new PermItemGroupInfoModi();
        groupInfoModi.dealGroupInfo((DefaultKingdeeTreeNode)treeNodePerm);
        PermissionWriter permissionWriter = new PermissionWriter(treeNodePerm);
        permissionWriter.writer("", this.dependenceCol);
    }

    @Override
    public NodeInfo getNameByNode(DefaultKingdeeTreeNode curNode) {
        NodeInfo nodeInfo = new NodeInfo();
        if (curNode == null || curNode.getUserObject() == null) {
            logger.info((Object)"curNode is null!");
            return nodeInfo;
        }
        Object userObj = curNode.getUserObject();
        String fullName = this.getPath(curNode);
        if (userObj instanceof PermissionItemInfo) {
            PermissionItemInfo permItemInfo = (PermissionItemInfo)userObj;
            String key = permItemInfo.getName();
            nodeInfo.setKey(key);
            nodeInfo.setFullName(fullName);
            MutilLangeToolForParam.muti2Obj((IObjectValue)permItemInfo, (String)"alias", (IObjectValue)nodeInfo, (String)"name");
        }
        if (userObj instanceof String) {
            String key = (String)userObj;
            nodeInfo.setKey(key);
            nodeInfo.setFullName(fullName);
            MutilLangeToolForParam.muti2Obj((String)key, (IObjectValue)nodeInfo, (String)"name");
        }
        return nodeInfo;
    }

    @Override
    public boolean mayDelNode(DefaultKingdeeTreeNode curNode) {
        return true;
    }

    @Override
    public void modiNode(DefaultKingdeeTreeNode curNode, KDBizMultiLangBox obj) {
        if (curNode != null && obj != null) {
            if (curNode.getUserObject() instanceof String) {
                String text = obj.getSelectedItem().toString();
                curNode.setUserObject((Object)text);
            }
            if (curNode.getUserObject() instanceof PermissionItemInfo) {
                PermissionItemInfo permInfo = (PermissionItemInfo)curNode.getUserObject();
                permInfo.setAlias(obj.getSelectedItem().toString());
                permInfo.setAlias(StringUtils.cnulls((Object)obj.getItemDataByLang(new LanguageInfo(new Locale("L2")))), new Locale("L2"));
                permInfo.setAlias(StringUtils.cnulls((Object)obj.getItemDataByLang(new LanguageInfo(new Locale("L3")))), new Locale("L3"));
            }
            curNode.setText(obj.getSelectedItem().toString());
        }
    }

    @Override
    public Object getNodeUserObject(int text, String parentName) {
        return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"newNodePrompt"), text);
    }

    @Override
    public boolean existNode(DefaultKingdeeTreeNode curNode, DefaultKingdeeTreeNode rootNode) {
        Enumeration allNode = rootNode.breadthFirstEnumeration();
        Object o = curNode.getUserObject();
        String tmpCurNodeFullName = this.getPath(curNode);
        String curNodeName = "";
        if (o instanceof PermissionItemInfo) {
            curNodeName = ((PermissionItemInfo)o).getName();
        } else if (o instanceof String) {
            curNodeName = (String)o;
        }
        if (o instanceof PermissionItemInfo || o instanceof String) {
            DefaultKingdeeTreeNode node = null;
            while (allNode.hasMoreElements()) {
                node = (DefaultKingdeeTreeNode)allNode.nextElement();
                if (node == null) continue;
                Object obj = node.getUserObject();
                String tmpName = "";
                String tmpNodeFullName = this.getPath(node);
                if (obj instanceof PermissionItemInfo) {
                    tmpName = ((PermissionItemInfo)obj).getName();
                } else if (obj instanceof String) {
                    tmpName = (String)obj;
                }
                if (!curNodeName.equals(tmpName) || !tmpCurNodeFullName.equals(tmpNodeFullName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getPath(DefaultKingdeeTreeNode curNode) {
        StringBuffer sBuffer = new StringBuffer();
        if (curNode != null) {
            TreeNode[] pathTreeNodes = curNode.getPath();
            for (int i = 0; i < pathTreeNodes.length; ++i) {
                if (!(pathTreeNodes[i] instanceof DefaultKingdeeTreeNode)) continue;
                DefaultKingdeeTreeNode tmpTreeNode = (DefaultKingdeeTreeNode)pathTreeNodes[i];
                String string = tmpTreeNode.getText();
                if (i > 0) {
                    sBuffer.append(".").append(string);
                    continue;
                }
                sBuffer.append(string);
            }
        }
        return sBuffer.toString();
    }

    @Override
    public void flagNewNode(DefaultKingdeeTreeNode customerRootNode, DefaultKingdeeTreeNode standardRootNode) {
        HashSet customAllNodePathSet = this.getAllNodePathSet(customerRootNode);
        HashSet standardAllNodePathSet = this.getAllNodePathSet(standardRootNode);
        this.flagNewNode(customerRootNode, standardAllNodePathSet);
        this.flagNewNode(standardRootNode, customAllNodePathSet);
    }

    private HashSet getAllNodePathSet(DefaultKingdeeTreeNode rootNode) {
        Enumeration allNode = rootNode.breadthFirstEnumeration();
        HashSet<String> ret = new HashSet<String>();
        DefaultKingdeeTreeNode node = null;
        while (allNode.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)allNode.nextElement();
            ret.add(this.getPath(node));
        }
        return ret;
    }

    private void flagNewNode(DefaultKingdeeTreeNode rootNode, HashSet allNodePathSet) {
        Icon icon_Folder_Open = EASResource.getIcon((String)"imgTree_folder_openpick");
        Icon icon_Folder_Close = EASResource.getIcon((String)"imgTree_folder_closepick");
        Icon icon_Leaf = EASResource.getIcon((String)"imgTree_folder_leafpick");
        Icon icon_Folder_Open1 = EASResource.getIcon((String)"imgTree_folder_open");
        Icon icon_Folder_Close1 = EASResource.getIcon((String)"imgTree_folder_close");
        Icon icon_Leaf1 = EASResource.getIcon((String)"imgTree_folder_leaf");
        Enumeration allNode = rootNode.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        String path = null;
        while (allNode.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)allNode.nextElement();
            path = this.getPath(node);
            if (allNodePathSet.contains(path)) {
                if (node.isLeaf()) {
                    node.setCustomIcon(icon_Leaf);
                    continue;
                }
                node.setCustomClosedIcon(icon_Folder_Close);
                node.setCustomOpenIcon(icon_Folder_Open);
                continue;
            }
            if (node.isLeaf()) {
                node.setCustomIcon(icon_Leaf1);
                continue;
            }
            node.setCustomClosedIcon(icon_Folder_Close1);
            node.setCustomOpenIcon(icon_Folder_Open1);
        }
    }

    @Override
    public void moveNode(KDTree tree, DefaultKingdeeTreeNode standardChildNode, DefaultKingdeeTreeNode customerParentNode, boolean moveChild) {
        Object tmpInfo;
        Object obj = standardChildNode.getUserObject();
        DefaultKingdeeTreeNode anewNode = new DefaultKingdeeTreeNode();
        if (obj instanceof PermissionItemInfo) {
            tmpInfo = (PermissionItemInfo)obj;
            anewNode.setUserObject(tmpInfo.clone());
            anewNode.setText(standardChildNode.getText());
            tree.addNodeInto((MutableTreeNode)anewNode, (MutableTreeNode)customerParentNode);
        } else if (obj instanceof String) {
            tmpInfo = (String)obj;
            anewNode.setUserObject(tmpInfo);
            tree.addNodeInto((MutableTreeNode)anewNode, (MutableTreeNode)customerParentNode);
        }
        if (moveChild) {
            int count = standardChildNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)standardChildNode.getChildAt(i);
                this.moveNode(tree, tmpNode, anewNode, true);
            }
        }
    }

    @Override
    public void moveAllNewNode(KDTree tree, DefaultKingdeeTreeNode standardRootNode, DefaultKingdeeTreeNode customerRootNode) {
        Enumeration allNode = standardRootNode.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (allNode.hasMoreElements()) {
            DefaultKingdeeTreeNode parentNode;
            node = (DefaultKingdeeTreeNode)allNode.nextElement();
            if (this.existNode(node, customerRootNode) || (parentNode = (DefaultKingdeeTreeNode)node.getParent()) == null) continue;
            Object o = parentNode.getUserObject();
            String name = "";
            if (o instanceof String) {
                name = (String)o;
            } else if (o instanceof PermissionItemInfo) {
                name = ((PermissionItemInfo)o).getName();
            }
            String fullName = this.getPath(parentNode);
            DefaultKingdeeTreeNode parentCusNode = this.getNodeByName(customerRootNode, name, fullName);
            this.moveNode(tree, node, parentCusNode, true);
        }
    }

    @Override
    public DefaultKingdeeTreeNode getNodeByName(DefaultKingdeeTreeNode rootNode, String name) {
        Enumeration allNode = rootNode.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (allNode.hasMoreElements()) {
            PermissionItemInfo tmpInfo;
            String curName;
            Object o;
            node = (DefaultKingdeeTreeNode)allNode.nextElement();
            if (node == null || !((o = node.getUserObject()) instanceof PermissionItemInfo ? (curName = (tmpInfo = (PermissionItemInfo)o).getName()) != null && curName.equals(name) : o instanceof String && o != null && ((String)o).equals(name))) continue;
            return node;
        }
        return null;
    }

    @Override
    public void changeNodeUserObject(DefaultKingdeeTreeNode node, boolean changeChild) {
    }

    @Override
    public DefaultKingdeeTreeNode getNodeByName(DefaultKingdeeTreeNode rootNode, String name, String fullName) {
        Enumeration allNode = rootNode.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (allNode.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)allNode.nextElement();
            if (node == null) continue;
            Object o = node.getUserObject();
            String tmpFullName = this.getPath(node);
            if (o instanceof PermissionItemInfo) {
                PermissionItemInfo tmpInfo = (PermissionItemInfo)o;
                String tmpName = tmpInfo.getName();
                if (tmpName == null || tmpFullName == null || !tmpName.equals(name) || !tmpFullName.equals(fullName)) continue;
                return node;
            }
            if (!(o instanceof String)) continue;
            String tmpName = (String)o;
            if (o == null || !tmpName.equals(name) || !tmpFullName.equals(fullName)) continue;
            return node;
        }
        return null;
    }
}

