/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.IDSecondAuthorizeHelper;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.IReloginAction;
import org.apache.log4j.Logger;

public class ReloginAction
implements IReloginAction {
    Logger logger = Logger.getLogger(ReloginAction.class);

    public void doAction() throws Exception {
        if (this.needPasswordWhenRelogin() || Boolean.TRUE.equals(SysContext.getSysContext().getProperty((Object)"needPasswordWhenUpdatePw"))) {
            try {
                IDSecondAuthorizeHelper.checkPasswordWhenRelogin();
                SysContext.getSysContext().setProperty((Object)"needPasswordWhenUpdatePw", (Object)false);
            }
            catch (PermissionException e) {
                this.deleteSession();
                throw e;
            }
        }
        try {
            SystemEntry.instance.innerReLogin();
        }
        catch (Exception e) {
            this.logger.error((Object)"ReloginAction", (Throwable)e);
            throw e;
        }
    }

    private void deleteSession() {
        String sessionID = SysContext.getSysContext().getSessionID();
        try {
            this.logger.info((Object)"UserMonitorUI releaseLicenseBySessionID begin");
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            agent.releaseLicenseBySessionID(sessionID);
            this.logger.info((Object)"UserMonitorUI releaseLicenseBySessionID success");
            UserMonitorFactory.getRemoteInstance().deleteSessionAndUserMonitorInfo(sessionID, null);
        }
        catch (Exception e) {
            this.logger.error((Object)"deleteSession", (Throwable)e);
        }
    }

    private boolean needPasswordWhenRelogin() {
        LoginAuthorWayEnum loginWay;
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        if (currentUser != null && (LoginAuthorWayEnum.DYNAMIC.equals((Object)(loginWay = currentUser.getLoginAuthorWay())) || LoginAuthorWayEnum.USBKEY.equals((Object)loginWay))) {
            return true;
        }
        return UIConfig.needPasswordWhenRelogin();
    }
}

