/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SecurityValidatorHelper {
    private static Logger logger = Logger.getLogger(SecurityValidatorHelper.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static String getSecurityPolicy() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        SecurityValidator securityValidator = new SecurityValidator(userInfo);
        return securityValidator.getSecurityPolicy();
    }

    public static String getSecurityPolicy(Context ctx) {
        UserInfo userInfo = null;
        try {
            userInfo = UserFactory.getLocalInstance(ctx).getUserByID(ctx.getCaller());
            SecurityInfo securityInfo = SecurityFactory.getLocalInstance(ctx).getSecurityInfo((IObjectPK)new ObjectUuidPK(userInfo.getSecurity().getId()));
            userInfo.setSecurity(securityInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u5931\u8d25");
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u5931\u8d25");
        }
        SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
        return securityValidator.getSecurityPolicy();
    }

    public static String getPwdTip(Context context, String userNumber) {
        String pwdTip = "";
        StringBuffer permSql = new StringBuffer();
        try {
            permSql.append(" SELECT FPasswordLength,FIsComplex,FRequireSpecialChar,FRequireUpChar,FRequireLowChar,FRequireNotIncludeNumber,FRequireWeakPw FROM T_PM_User a ");
            permSql.append(" INNER JOIN T_PM_Security b ON a.FSecurityId=b.FID");
            permSql.append(" WHERE LOWER(a.FNumber)=? ");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new Object[]{userNumber.toLowerCase()});
            if (rs != null && rs.size() > 0 && rs.next()) {
                int passwordLength = rs.getInt("FPasswordLength");
                boolean isComplex = rs.getBoolean("FIsComplex");
                boolean isRequireSpecialChar = rs.getBoolean("FRequireSpecialChar");
                if (passwordLength > 0) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdLength", (Locale)context.getLocale()) + passwordLength + "; ";
                }
                if (isComplex) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdComplex", (Locale)context.getLocale()) + "; ";
                }
                if (isRequireSpecialChar) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdSpecialChar", (Locale)context.getLocale()) + "; ";
                }
                if (rs.getBoolean("FRequireUpChar")) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"requireUpChar", (Locale)context.getLocale()) + "; ";
                }
                if (rs.getBoolean("FRequireLowChar")) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"requireLowChar", (Locale)context.getLocale()) + "; ";
                }
                if (rs.getBoolean("FRequireNotIncludeNumber")) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"requireNotIncludeNumber", (Locale)context.getLocale()) + "; ";
                }
                if (rs.getBoolean("FRequireWeakPw")) {
                    pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"requireWeakPw", (Locale)context.getLocale()) + "; ";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPwdTip filter error ===", (Throwable)e);
        }
        return pwdTip;
    }

    public static boolean hasUpChar(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        boolean up = false;
        boolean low = false;
        for (int i = 0; i < password.length(); ++i) {
            char itemChar = password.charAt(i);
            if (up || itemChar < 'A' || itemChar > 'Z') continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowChar(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        boolean up = false;
        boolean low = false;
        for (int i = 0; i < password.length(); ++i) {
            char itemChar = password.charAt(i);
            if (low || itemChar < 'a' || itemChar > 'z') continue;
            return true;
        }
        return false;
    }
}

