/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleException;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RoleType;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CryptoUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class PermBizHelper {
    private static Logger logger = Logger.getLogger(PermBizHelper.class);

    public static boolean haveThisNumber(Context ctx, String tableName, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)tableName)) {
            logger.info((Object)("roleNumber or tableName is null,table is:" + StringUtils.cnulls((String)tableName) + " number is:" + StringUtils.cnulls((String)number)));
            return false;
        }
        String sqlStr = "select * from " + tableName + "  where fnumber = '" + number + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.info((Object)("roleNumber or tableName is null,table is:" + StringUtils.cnulls((String)tableName) + " number is:" + StringUtils.cnulls((String)number)));
            logger.error((Object)"sqlException :", (Throwable)e);
        }
        return false;
    }

    public static PermItemInfo findPermItemInfoByNumber(Context ctx, String permItemNumber) throws BOSException, EASBizException {
        IPermItem iPermItem = null;
        iPermItem = ctx == null ? PermItemFactory.getRemoteInstance() : PermItemFactory.getLocalInstance(ctx);
        boolean hasPermItemNumber = iPermItem.haveThisNumber(permItemNumber);
        if (hasPermItemNumber) {
            return iPermItem.getPermItemInfoByNumber(permItemNumber);
        }
        String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new PermItemInfo().getBOSType()).getAlias();
        Object[] params = new Object[]{objectName, permItemNumber};
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"numberNotFound"), params);
        throw new BOSException(msg);
    }

    public static UserInfo findUserInfoByNumber(Context ctx, String userNumber) throws BOSException, EASBizException {
        IUser iUser = null;
        iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
        boolean hasPermItemNumber = iUser.haveThisNumber(userNumber);
        if (hasPermItemNumber) {
            return iUser.getUserInfoByNumber(userNumber);
        }
        String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
        Object[] params = new Object[]{objectName, userNumber};
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"numberNotFound"), params);
        throw new BOSException(msg);
    }

    public static PermType findPermType(String permItemType) throws BOSException {
        if (StringUtils.isEmpty((String)permItemType)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"permitemtype_cannot_be_null");
            throw new BOSException(msg);
        }
        try {
            Integer permTypeInt = new Integer(permItemType.trim());
            return PermType.getEnum(permTypeInt);
        }
        catch (NumberFormatException ne) {
            logger.error((Object)("not a number, String is :" + permItemType.trim()));
            throw new BOSException();
        }
    }

    public static RoleType findRoleType(String roleItemType) throws RoleException {
        if (StringUtils.isEmpty((String)roleItemType)) {
            logger.error((Object)"role type is null");
            throw new RoleException(RoleException.ROLE_TYPE_NULL);
        }
        try {
            Integer permTypeInt = new Integer(roleItemType.trim());
            return RoleType.getEnum(permTypeInt);
        }
        catch (NumberFormatException ne) {
            logger.error((Object)("not a number, String is :" + roleItemType.trim()));
            throw new RoleException(RoleException.ROLE_TYPE_NOT_RIGHT);
        }
    }

    public static FullOrgUnitInfo findFullOrgUnfoByNumber(Context ctx, String orgNumber) throws BOSException {
        String oql;
        if (StringUtils.isEmpty((String)orgNumber)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"orgNumber_is_not_null");
            throw new BOSException(msg);
        }
        IFullOrgUnit iFullOrgUnit = null;
        iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullOrgCol = iFullOrgUnit.getFullOrgUnitCollection(oql = "select * where number = '" + orgNumber + "'");
        if (!fullOrgCol.isEmpty()) {
            return fullOrgCol.get(0);
        }
        Object[] params = new Object[]{orgNumber};
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"orgNumber_is_not_exist"), params);
        throw new BOSException(msg);
    }

    public static RoleInfo findRoleInfoByNumber(Context ctx, String roleNumber) throws BOSException {
        String oql;
        if (StringUtils.isEmpty((String)roleNumber)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"orgNumber_is_not_null");
            throw new BOSException(msg);
        }
        IRole iRole = null;
        iRole = ctx == null ? RoleFactory.getRemoteInstance() : RoleFactory.getLocalInstance(ctx);
        RoleCollection coll = iRole.getRoleCollection(oql = "select * where number = '" + roleNumber + "'");
        if (!coll.isEmpty()) {
            return coll.get(0);
        }
        Object[] params = new Object[]{roleNumber};
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"roleNumber_is_not_exist"), params);
        throw new BOSException(msg);
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        return PermissionUtils.matchPassword(userInfo, password);
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        assert (password != null);
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }
}

