/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.IWeakPwLib;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.WeakPwLibFactory;
import com.kingdee.eas.base.permission.helper.SecurityValidatorHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SecurityValidator {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String REGEX = "[a-zA-Z]+\\d+|\\d+[a-zA-Z]+|\\d+[\\W_]+[a-zA-Z]+|[a-zA-Z]+[\\W_]+\\d+";
    private static final String REGEX_WITH_SPECIAL_CHAR = "[\\W_]+";
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.SecurityValidator");
    private UserInfo userInfo = null;
    private Context context = null;

    public SecurityValidator(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public SecurityValidator(Context context, UserInfo userInfo) {
        this.context = context;
        this.userInfo = userInfo;
    }

    public void validate() throws EASBizException {
        log.info((Object)"validate start!");
        assert (this.userInfo != null);
        String password = this.userInfo.getPassword();
        SecurityInfo securityInfo = this.userInfo.getSecurity();
        SecurityValidator.validate(this.context, securityInfo, password, this.userInfo.getNumber());
    }

    public static void validate(SecurityInfo securityInfo, String password) throws EASBizException {
        SecurityValidator.validate(null, securityInfo, password, "");
    }

    public static void validate(Context context, SecurityInfo securityInfo, String password, String userNumber) throws EASBizException {
        Matcher matcher;
        int passwordLength;
        if (password == null) {
            password = "";
        }
        if ((passwordLength = password.trim().length()) < securityInfo.getPasswordLength()) {
            log.info((Object)"password length is shorter than security policy sets!");
            throw new SecurityException(SecurityException.SHORT_PASSWORD, new Object[]{securityInfo.getPasswordLength()});
        }
        Pattern pattern = null;
        if (securityInfo.isComplex() && !(matcher = (pattern = Pattern.compile(REGEX)).matcher(password)).find()) {
            log.info((Object)"regexpress is:[a-zA-Z]+\\d+|\\d+[a-zA-Z]+|\\d+[\\W_]+[a-zA-Z]+|[a-zA-Z]+[\\W_]+\\d+");
            throw new SecurityException(SecurityException.PASSWORD_TOO_SIMPLE);
        }
        if (securityInfo.isRequireSpecialChar()) {
            log.info((Object)"security policy requires special char!");
            pattern = Pattern.compile(REGEX_WITH_SPECIAL_CHAR);
            matcher = pattern.matcher(password);
            if (!matcher.find()) {
                log.info((Object)"regexpress is:[a-zA-Z]+\\d+|\\d+[a-zA-Z]+|\\d+[\\W_]+[a-zA-Z]+|[a-zA-Z]+[\\W_]+\\d+");
                throw new SecurityException(SecurityException.PASSWORD_SPECIAL_CHAR);
            }
        }
        if (securityInfo.isRequireUpChar()) {
            log.info((Object)"security policy requires up char!");
            if (!SecurityValidatorHelper.hasUpChar(password)) {
                throw new SecurityException(SecurityException.PASSWORD_UPCHAR);
            }
        }
        if (securityInfo.isRequireLowChar()) {
            log.info((Object)"security policy requires up char!");
            if (!SecurityValidatorHelper.hasLowChar(password)) {
                throw new SecurityException(SecurityException.PASSWORD_LOWCHAR);
            }
        }
        if (securityInfo.isRequireNotIncludeNumber()) {
            log.info((Object)"security policy requires not include userNumber");
            if (password.contains(userNumber)) {
                throw new SecurityException(SecurityException.PASSWORD_NOT_INCLUDE_NUMBER);
            }
        }
        if (securityInfo.isRequireWeakPw()) {
            log.info((Object)"security policy requires not include weak Password ");
            try {
                IWeakPwLib remoteInstance = context == null ? WeakPwLibFactory.getRemoteInstance() : WeakPwLibFactory.getLocalInstance(context);
                if (!remoteInstance.checkWeakPw(password)) {
                    throw new SecurityException(SecurityException.PASSWORD_WEAKPW);
                }
            }
            catch (BOSException e) {
                throw new SecurityException(SecurityException.PASSWORD_WEAKPW_500);
            }
        }
    }

    public boolean isRequireChangePassword() {
        log.info((Object)"Enter check if it is necessary to change password!");
        assert (this.userInfo != null);
        if (!LoginAuthorWayEnum.NORMAL.equals((Object)this.userInfo.getLoginAuthorWay())) {
            return false;
        }
        SecurityInfo securityInfo = this.userInfo.getSecurity();
        if (securityInfo == null) {
            log.info((Object)"securityInfo of current user is null!");
            return false;
        }
        if (securityInfo.isRequireChgPW() && !this.userInfo.isChangedPW()) {
            log.info((Object)"password of current user must be changed first !");
            return true;
        }
        if (securityInfo.isExpiredPassCanChg() && PermissionCommonUtil.isPassExpired(this.userInfo)) {
            log.info((Object)"password of current user is expired !");
            return true;
        }
        try {
            this.validate();
        }
        catch (EASBizException e) {
            log.error((Object)"isRequireChangePassword check", (Throwable)e);
            return true;
        }
        return false;
    }

    public String getSecurityPolicy() {
        SecurityInfo securityInfo = this.userInfo.getSecurity();
        int passwordLength = securityInfo.getPasswordLength();
        String pwdTip = "";
        if (securityInfo != null) {
            pwdTip = EASResource.getString((String)RESOURCE, (String)"pwdTip") + " ";
            pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdLength") + passwordLength + "; ";
            if (securityInfo.isComplex()) {
                pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdComplex") + "; ";
            }
            if (securityInfo.isRequireSpecialChar()) {
                pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdSpecialChar") + "; ";
            }
            if (securityInfo.isRequireUpChar()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireUpChar") + "; ";
            }
            if (securityInfo.isRequireLowChar()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireLowChar") + "; ";
            }
            if (securityInfo.isRequireNotIncludeNumber()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireNotIncludeNumber") + "; ";
            }
            if (securityInfo.isRequireWeakPw()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireWeakPw") + "; ";
            }
        }
        return pwdTip;
    }

    private boolean isPwExpired() {
        if (!this.userInfo.getSecurity().isPasswordForever() && this.userInfo.getSecurity().isExpiredPassCanChg()) {
            Date inuseDate = this.userInfo.getPWEffectiveDate();
            GregorianCalendar gcInuse = new GregorianCalendar();
            gcInuse.setTime(inuseDate);
            GregorianCalendar gcInvalid = new GregorianCalendar();
            gcInvalid.setTime(inuseDate);
            gcInvalid.add(5, this.userInfo.getSecurity().getPasswordCycle());
            Date invalidDate = new Date(gcInvalid.getTimeInMillis());
            Date now = new Date();
            if (DateTimeUtils.dayAfter((Date)inuseDate, (Date)now) || DateTimeUtils.dayAfter((Date)now, (Date)invalidDate)) {
                return true;
            }
        }
        return false;
    }

    private boolean isFirstLogin() {
        return !this.userInfo.isChangedPW() && this.userInfo.getSecurity().isRequireChgPW();
    }

    public String getUpdatePwReason() {
        if (this.isPwExpired()) {
            return EASResource.getString((String)RESOURCE, (String)"changePwForExpired");
        }
        if (this.isFirstLogin()) {
            return EASResource.getString((String)RESOURCE, (String)"changePwForFirstLogin");
        }
        if (this.isRequireChangePassword()) {
            return EASResource.getString((String)RESOURCE, (String)"changePwForSecurity");
        }
        return "";
    }

    public static void checkUserUpdatePw(String userId, String newPassword) throws UserException {
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userId)) {
            if (StringUtils.isEmpty((String)newPassword)) {
                throw new UserException(UserException.USER_EMPTY_PASSWORD);
            }
            if ("kdadmin".equals(newPassword)) {
                throw new UserException(UserException.USER_DEFAULT_PASSWORD);
            }
        }
        if ("256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(userId)) {
            if (StringUtils.isEmpty((String)newPassword)) {
                throw new UserException(UserException.USER_EMPTY_PASSWORD);
            }
            if ("kduser".equals(newPassword)) {
                throw new UserException(UserException.USER_DEFAULT_PASSWORD);
            }
        }
        if ("00000000-0000-0000-0000-00000000000113B7DE7F".equals(userId)) {
            if (StringUtils.isEmpty((String)newPassword)) {
                throw new UserException(UserException.USER_EMPTY_PASSWORD);
            }
            if ("authenticate".equals(newPassword)) {
                throw new UserException(UserException.USER_DEFAULT_PASSWORD);
            }
        }
        if (("00000000-0000-0000-0000-00000000000213B7DE7F".equals(userId) || "Wp3rRSFxRCaPFjuE2apQjRO33n8=".equals(userId) || "IpyedAEWEADgAAmlwKgTMBO33n8=".equals(userId)) && StringUtils.isEmpty((String)newPassword)) {
            throw new UserException(UserException.USER_EMPTY_PASSWORD);
        }
    }
}

