/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.app.EasXtSyncFacadeControllerBean;
import com.kingdee.eas.base.permission.util.EasXtSyncUtil;
import com.kingdee.eas.base.permission.util.LogUtil;
import com.kingdee.eas.base.permission.util.RSAUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Key;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class XtCommunicateUtil {
    private static Logger logger = Logger.getLogger(EasXtSyncFacadeControllerBean.class);
    private static Key key = null;
    private static String keyPath = System.getProperty("eas.properties.dir");
    private static String OPENACCESS_URL = EasXtSyncUtil.getInstance().getCloud() + "/openaccess";
    private static String GETATTIME_URL = OPENACCESS_URL + "/input/person/getAtTime";
    private static String ADDNEWPERSONS_URL = OPENACCESS_URL + "/input/person/add";
    private static String UPDATEPERSONS_URL = OPENACCESS_URL + "/input/person/updateInfo";
    private static String UPDATEPERSONSTATUS_URL = OPENACCESS_URL + "/input/person/updateStatus";
    private static String UPDATEPERSONDEPT_URL = OPENACCESS_URL + "/input/person/updateDept";
    private static String ADDDEPT_URL = OPENACCESS_URL + "/input/dept/add";

    public static JSONObject getDataAfterCheckTime(String lastCheckTime, int start, int length) throws Exception {
        String eid = EasXtSyncUtil.getInstance().getEip();
        JSONObject dataJSON = new JSONObject();
        dataJSON.put("eid", (Object)eid);
        dataJSON.put("time", (Object)lastCheckTime);
        dataJSON.put("begin", (Object)start);
        dataJSON.put("count", (Object)length);
        JSONObject response = XtCommunicateUtil.getResponseByForm(GETATTIME_URL, XtCommunicateUtil.buildRequestData(eid, dataJSON));
        return response;
    }

    private static JSONObject getResponseByForm(String url, String jsonBody) throws IOException {
        logger.error((Object)LogUtil.filterLogForging("*******1**********" + url));
        FilterOutputStream ds = null;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            URL sendUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)sendUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(60000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            logger.error((Object)"*******2**********");
            ds = new DataOutputStream(conn.getOutputStream());
            String content = "";
            JSONObject jsonObject = JSONObject.parseObject((String)jsonBody);
            for (Map.Entry entry : jsonObject.entrySet()) {
                content = content + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8") + "&";
            }
            content = content + "1=1";
            ((DataOutputStream)ds).writeBytes(content);
            ((DataOutputStream)ds).flush();
            ds.close();
            in = conn.getInputStream();
            logger.error((Object)"*******3**********");
            StringBuffer sb = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            conn.disconnect();
            logger.error((Object)"*******4**********");
            logger.error((Object)("****sb**********" + sb.toString()));
            JSONObject jSONObject = JSONObject.parseObject((String)new String(sb.toString().getBytes("UTF-8"), "UTF-8"));
            return jSONObject;
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String buildRequestData(String eid, JSONObject dataJSON) throws UnsupportedEncodingException, Exception {
        Key key = XtCommunicateUtil.getKey();
        String data = new String(Base64.encodeBase64((byte[])RSAUtils.encryptLarger(dataJSON.toString().getBytes("UTF-8"), key)), "UTF-8");
        String nonce = UUID.randomUUID().toString();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("eid", (Object)eid);
        jsonBody.put("data", (Object)data);
        jsonBody.put("nonce", (Object)nonce);
        return jsonBody.toString();
    }

    public static JSONObject syncAddNewOrgInfo(JSONArray orgs) throws BOSException {
        String eip = EasXtSyncUtil.getInstance().getEip();
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eip);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eip, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(ADDDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static JSONObject syncAddNewPersonInfo(JSONArray persons) throws BOSException {
        String eip = EasXtSyncUtil.getInstance().getEip();
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eip);
            dataJSON.put("persons", (Object)persons);
            dataJSON.put("productKey", (Object)"EAS");
            String jsonBody = XtCommunicateUtil.buildRequestData(eip, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(ADDNEWPERSONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static JSONObject updatePersonStatus(JSONArray persons) throws BOSException {
        String eip = EasXtSyncUtil.getInstance().getEip();
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eip);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eip, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONSTATUS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static JSONObject syncUpdatePersonInfo(JSONArray persons) throws BOSException {
        String eip = EasXtSyncUtil.getInstance().getEip();
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eip);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eip, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static JSONObject syncUpdateUserOrgInfo(JSONArray persons) throws BOSException {
        String eip = EasXtSyncUtil.getInstance().getEip();
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eip);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eip, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void clearKey() {
        key = null;
    }

    public static void resetURL() {
        OPENACCESS_URL = EasXtSyncUtil.getInstance().getCloud() + "/openaccess";
        GETATTIME_URL = OPENACCESS_URL + "/input/person/getAtTime";
        ADDNEWPERSONS_URL = OPENACCESS_URL + "/input/person/add";
        UPDATEPERSONS_URL = OPENACCESS_URL + "/input/person/updateInfo";
        UPDATEPERSONSTATUS_URL = OPENACCESS_URL + "/input/person/updateStatus";
        UPDATEPERSONDEPT_URL = OPENACCESS_URL + "/input/person/updateDept";
        ADDDEPT_URL = OPENACCESS_URL + "/input/dept/add";
    }

    private static Key getKey() throws Exception {
        if (key != null) {
            return key;
        }
        String filePath = keyPath + File.separator + EasXtSyncUtil.getInstance().getEip() + ".key";
        File file = new File(filePath);
        if (!file.exists()) {
            throw new Exception("\u627e\u4e0d\u5230 " + filePath);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            byte[] bytes = new byte[((InputStream)in).available()];
            ((InputStream)in).read(bytes);
            key = RSAUtils.restorePrivateKey(bytes);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return key;
    }
}

