/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.PrivacyHelper;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.ActiveStateEnum;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.service.ValidateCommunicationFactory;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import com.kingdee.eas.base.permission.util.PermissionThreadContext;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.permission.util.cloud.SynUserToCloudHelper;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.ProductGroup;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportAllUserHelper {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.util.cloud.ExportAllUserHelper");
    private String exportFilePath;
    private int dataRowStartIndex = 2;
    private int dataRowCount = 0;
    private int groupColumnStartIndex = 0;
    private Map userConfigMap = new HashMap();
    private Map groupConfigMap = new HashMap();
    private String delimeter = ",";
    List<String> lsLicenseGroupNumberName = null;

    public ExportAllUserHelper(String exportFilePath) {
        this.exportFilePath = exportFilePath;
    }

    public void execute(Context ctx) throws IOException, LicenseException, BOSException, SQLException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        this.fillHeader(ctx, sheet, false);
        this.fillData(ctx, sheet);
        this.writeToFile((Workbook)workbook);
    }

    public void executeAllUserGroup(Context ctx, List<CloudUserInfo> data) throws IOException, LicenseException, BOSException, SQLException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        this.fillHeader(ctx, sheet, true);
        this.fillData(ctx, sheet, data, true, true);
        this.writeToFile((Workbook)workbook);
    }

    public void execute(Context ctx, List<CloudUserInfo> data) throws IOException, LicenseException, BOSException, SQLException {
        this.writeToCSV(ctx, data);
    }

    public void synUserExecute(Context ctx, List<CloudUserInfo> data, List<JSONObject> synResult, boolean isSynOnline, boolean isIncludeGroups) throws IOException, LicenseException, BOSException, SQLException {
        logger.error((Object)"------------synUserExecute begin----------------", new Exception("view call statck!").getCause());
        XSSFWorkbook workbook = new XSSFWorkbook();
        logger.error((Object)"------------synUserExecute 1----------------");
        Sheet sheet = workbook.createSheet();
        logger.error((Object)"------------synUserExecute 2----------------");
        this.fillHeader4SynResult(ctx, sheet, isSynOnline, isIncludeGroups);
        logger.error((Object)"------------synUserExecute 3----------------");
        this.fillData4SynResult(ctx, sheet, data, synResult, isSynOnline, isIncludeGroups);
        logger.error((Object)"------------synUserExecute 4----------------");
        this.writeToFile((Workbook)workbook);
        logger.error((Object)"------------synUserExecute end----------------");
    }

    public void synUserExecute(Context ctx, List<CloudUserInfo> data) throws IOException, LicenseException, BOSException, SQLException {
        this.synUserExecute(ctx, data, null, false, true);
    }

    private void fillHeader4SynResult(Context ctx, Sheet wsheet, boolean isSynOnline, boolean isIncludeGroups) {
        List<Map<String, Object>> columnModel = this.columnModel4SynResult(isSynOnline);
        int columnIndex = this.fillUserInfoHeader(wsheet, columnModel);
        if (isIncludeGroups) {
            this.fillLicenseGroupHeader(ctx, wsheet, columnIndex);
        }
    }

    private void fillData4SynResult4SynOnline(Context ctx, Sheet wsheet, List<CloudUserInfo> data, List<JSONObject> synResult, boolean isIncludeGroups) throws LicenseException, BOSException, SQLException {
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = ctx != null ? CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup() : CloudRegistSrvAgentFactory.getRemoteInstance().getRegistUserMapGroup();
        }
        catch (LicenseException e) {
            logger.error((Object)"ExportAllUserHelper.fillData4SynResult():getRegistUserMapGroup error");
        }
        ArrayList<Map<String, String>> exportData = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        boolean isSynSuccess = true;
        for (CloudUserInfo cloudUser : data) {
            isSynSuccess = true;
            CloudRegistUserInfo cruInfo = (CloudRegistUserInfo)licenseUsersInfo.get(cloudUser.getErp_account());
            map = new HashMap<String, String>();
            String userNumber = cloudUser.getErp_account();
            String errorMsg = SynShrUserToCloudUtils.checkNeedSync(cloudUser, ctx);
            if (!StringUtils.isEmpty((String)errorMsg)) {
                map.put("reason", errorMsg);
                map.put("isSynSuc", EASResource.getString((String)RESOURCE, (String)"NO_SYNC"));
            } else {
                if (synResult != null) {
                    for (JSONObject object : synResult) {
                        if (!userNumber.equalsIgnoreCase(object.getString("erp_account"))) continue;
                        isSynSuccess = false;
                        map.put("reason", object.getString("reason"));
                        break;
                    }
                }
                if (isSynSuccess) {
                    if (cruInfo != null && cloudUser.equals(cruInfo) || cloudUser.getIs_delete() == 1 && cruInfo == null) {
                        map.put("isSynSuc", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_success"));
                    } else {
                        map.put("isSynSuc", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_failed"));
                        CommunicationInfo communicationInfo = null;
                        communicationInfo = ctx != null ? ValidateCommunicationFactory.getLocalInstance(ctx).getCloudCommunicationStategy() : ValidateCommunicationFactory.getRemoteInstance().getCloudCommunicationStategy();
                        if (cruInfo != null && !SynShrUserToCloudUtils.isCurSyncNoActiviationUser(cruInfo.getErpNumber(), ctx)) {
                            String email = cloudUser.getEmail() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : cloudUser.getEmail();
                            String phone = cruInfo.getPhone() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : cruInfo.getPhone().replaceFirst("\\+", "");
                            String phoneLocal = cloudUser.getPhone() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : cloudUser.getPhone().replaceFirst("\\+", "");
                            String emailCloud = cruInfo.getEmail() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : cruInfo.getEmail().replaceFirst("\\+", "");
                            int needEmail = communicationInfo.getNeedEmail();
                            int needPhone = communicationInfo.getNeedPhone();
                            if (needPhone == 0 && needEmail == 1) {
                                if (!emailCloud.equals(email)) {
                                    map.put("reason", MessageFormat.format(com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"emailDiff"), phone, email));
                                } else {
                                    map.put("reason", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"emailError"));
                                }
                            } else if (needPhone == 1 && needEmail == 0) {
                                if (!phoneLocal.equals(phone)) {
                                    map.put("reason", MessageFormat.format(com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"phoneDiff"), phone, phoneLocal));
                                }
                            } else if (!email.equals(phone) || !phoneLocal.equals(phone)) {
                                map.put("reason", MessageFormat.format(com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"userMsgError"), phone + " " + emailCloud, phoneLocal, email));
                            }
                        }
                    }
                } else {
                    map.put("isSynSuc", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_failed"));
                }
            }
            map.put("userNumber", userNumber);
            map.put("userName", cloudUser.getName());
            map.put("personNumber", cloudUser.getMid());
            int gender = cloudUser.getGender();
            genderAlias = 0 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"male") : (1 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"female") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"secret"));
            map.put("gender", genderAlias);
            map.put("birthday", cloudUser.getBirthday());
            map.put("email", PrivacyHelper.dofuzzy((Context)ctx, (String)cloudUser.getEmail(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.EMAIL));
            map.put("phone", PrivacyHelper.dofuzzy((Context)ctx, (String)cloudUser.getPhone(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.PHONE));
            map.put("position", cloudUser.getPosition());
            map.put("is_delete", cloudUser.getIs_delete() == 1 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            if (cruInfo != null && !StringUtils.isEmpty((String)cruInfo.getCloudUuId())) {
                map.put("cloudUuId", cruInfo.getCloudUuId());
            } else {
                map.put("cloudUuId", String.valueOf(cloudUser.getUid()));
            }
            map.put("status", cloudUser.getStatus() == 0 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            if (!isIncludeGroups) {
                exportData.add(map);
                continue;
            }
            group = cloudUser.getProd_group();
            if (group == null) {
                exportData.add(map);
                continue;
            }
            String[] groups = group.split(";");
            if (groups == null) {
                exportData.add(map);
                continue;
            }
            int len = groups.length;
            for (int i = 0; i < len; ++i) {
                ProductGroup pgroup;
                if (cloudUser.getMpGroups() == null || cloudUser.getMpGroups().get(groups[i]) == null || (pgroup = cloudUser.getMpGroups().get(groups[i])) == null || !pgroup.isValid()) continue;
                if (cruInfo == null || cruInfo.getGroup() == null || !cruInfo.getGroup().contains(groups[i])) {
                    map.put(groups[i], com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_failed"));
                    continue;
                }
                map.put(groups[i], com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_success"));
            }
            exportData.add(map);
        }
        List<Map<String, Object>> columnModel = this.columnModel4SynResult(true);
        if (isIncludeGroups) {
            this.fillDataToExcel(ctx, wsheet, exportData, columnModel);
        } else {
            this.fillDataToExcelByColumnModel(ctx, wsheet, exportData, columnModel);
        }
        this.setLicenseGroupValidation(ctx, wsheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCSV(Context ctx, List<CloudUserInfo> data) throws IOException, LicenseException, BOSException, SQLException {
        File file = new File(this.exportFilePath);
        try (BufferedWriter writer = null;){
            int i;
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GBK"), 1024);
            this.writeOneLine(writer, com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"exportInfo1"));
            this.writeOneLine(writer, com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"exportInfo2"));
            this.writeOneLine(writer, com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"exportInfo3"));
            this.writeOneLine(writer, com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"exportInfo4"));
            this.writeOneLine(writer, com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"exportInfo5"));
            this.writeOneLine(writer, com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"exportInfo1"));
            String[][] header = new String[2][];
            List<Map<String, Object>> columnModel = this.getColumnModel(false);
            List<Map<String, Object>> licenseGroup = this.getLicenseGroup(ctx);
            int size = columnModel.size();
            int groupSize = licenseGroup.size();
            header[0] = new String[size + groupSize];
            header[1] = new String[size + groupSize];
            for (i = 0; i < size; ++i) {
                header[0][i] = columnModel.get(i).get("name").toString();
                header[1][i] = columnModel.get(i).get("info").toString();
            }
            for (i = 0; i < licenseGroup.size(); ++i) {
                header[0][i + size] = licenseGroup.get(i).get("number").toString();
                header[1][i + size] = licenseGroup.get(i).get("name").toString();
            }
            this.writeData(writer, header);
            columnModel.addAll(licenseGroup);
            List<Map<String, String>> exportData = this.getExportData(ctx, data);
            int dataSize = exportData.size();
            String[][] detailDatas = new String[dataSize][];
            for (int i2 = 0; i2 < dataSize; ++i2) {
                Map<String, String> item = exportData.get(i2);
                detailDatas[i2] = new String[columnModel.size()];
                int columnIndex = 0;
                String columnNumber = null;
                for (Map<String, Object> column : columnModel) {
                    columnNumber = (String)column.get("number");
                    detailDatas[i2][columnIndex++] = item.get(columnNumber);
                }
            }
            this.writeData(writer, detailDatas);
        }
    }

    private void writeData(BufferedWriter bw, String[][] data) {
        if (data.length == 0) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            StringBuilder sb = new StringBuilder();
            String[] datum = data[i];
            for (int j = 0; j < datum.length; ++j) {
                String datumItem = datum[j];
                if (!StringUtils.isEmpty((String)datumItem)) {
                    sb.append(datumItem);
                }
                sb.append(this.delimeter);
            }
            this.writeOneLine(bw, sb.toString());
        }
    }

    private void writeOneLine(BufferedWriter bw, String str) {
        try {
            bw.write(str);
            bw.newLine();
            bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<Map<String, String>> getExportData(Context ctx, List<CloudUserInfo> data) throws LicenseException, BOSException, SQLException {
        if (data == null) {
            data = SynUserToCloudHelper.assembleCloudUserInfo(ctx);
        }
        ArrayList<Map<String, String>> exportData = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        boolean nofuzzy = PermissionThreadContext.getNofuzzy();
        PermissionThreadContext.clearNofuzzy();
        for (CloudUserInfo u : data) {
            map = new HashMap<String, String>();
            map.put("userNumber", "\t" + ExportAllUserHelper.dealCSVStr(u.getErp_account()));
            map.put("userName", ExportAllUserHelper.dealCSVStr(u.getName()));
            map.put("personNumber", null);
            int gender = u.getGender();
            genderAlias = 0 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"male") : (1 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"female") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"secret"));
            map.put("gender", genderAlias);
            map.put("birthday", u.getBirthday());
            map.put("email", nofuzzy ? u.getEmail() : PrivacyHelper.dofuzzy((Context)ctx, (String)u.getEmail(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.EMAIL));
            map.put("phone", "\t" + (nofuzzy ? u.getPhone() : PrivacyHelper.dofuzzy((Context)ctx, (String)u.getPhone(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.PHONE)));
            map.put("position", u.getPosition());
            map.put("is_delete", u.getIs_delete() == 1 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            map.put("cloudUuId", String.valueOf(u.getUid() == 0 ? "" : Integer.valueOf(u.getUid())));
            map.put("status", u.getStatus() == 0 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            group = u.getProd_group();
            if (group == null) {
                exportData.add(map);
                continue;
            }
            String[] groups = group.split(";");
            if (groups == null) {
                exportData.add(map);
                continue;
            }
            int len = groups.length;
            for (int i = 0; i < len; ++i) {
                ProductGroup pg = u.getMpGroups().get(groups[i]);
                if (pg == null || !pg.isValid()) continue;
                map.put(groups[i], com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes"));
            }
            exportData.add(map);
        }
        return exportData;
    }

    private void fillData4SynResult(Context ctx, Sheet wsheet, List<CloudUserInfo> data, List<JSONObject> synResult, boolean isSynOnline, boolean isIncludeGroups) throws LicenseException, BOSException, SQLException {
        if (data == null) {
            return;
        }
        if (isSynOnline) {
            this.fillData4SynResult4SynOnline(ctx, wsheet, data, synResult, isIncludeGroups);
            return;
        }
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = ctx != null ? CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup() : CloudRegistSrvAgentFactory.getRemoteInstance().getRegistUserMapGroup();
        }
        catch (LicenseException e) {
            logger.error((Object)"ExportAllUserHelper.fillData4SynResult():getRegistUserMapGroup error");
        }
        ArrayList<Map<String, String>> exportData = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        for (CloudUserInfo u : data) {
            map = new HashMap<String, String>();
            map.put("userNumber", u.getErp_account());
            CloudRegistUserInfo cruInfo = (CloudRegistUserInfo)licenseUsersInfo.get(u.getErp_account());
            if (cruInfo != null && u.equals(cruInfo) || u.getIs_delete() == 1 && cruInfo == null) {
                map.put("isSynSuc", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_success"));
            } else {
                map.put("isSynSuc", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_failed"));
                CommunicationInfo communicationInfo = null;
                communicationInfo = ctx != null ? ValidateCommunicationFactory.getLocalInstance(ctx).getCloudCommunicationStategy() : ValidateCommunicationFactory.getRemoteInstance().getCloudCommunicationStategy();
                if (cruInfo != null) {
                    String email = u.getEmail() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : u.getEmail();
                    String phone = cruInfo.getPhone() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : cruInfo.getPhone().replaceFirst("\\+", "");
                    String emailCloud = cruInfo.getEmail() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : cruInfo.getEmail();
                    String phoneLocal = u.getPhone() == null ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"none_tip") : u.getPhone().replaceFirst("\\+", "");
                    int needEmail = communicationInfo.getNeedEmail();
                    int needPhone = communicationInfo.getNeedPhone();
                    if (needPhone == 0 && needEmail == 1) {
                        if (emailCloud.indexOf("@") > 0 && !emailCloud.equalsIgnoreCase(email)) {
                            map.put("reason", MessageFormat.format(com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"emailDiff"), emailCloud, email));
                        } else {
                            map.put("reason", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"emailError"));
                        }
                    } else if (needPhone == 1 && needEmail == 0) {
                        if (!phone.trim().replaceFirst("\\+", "").equals(phoneLocal.trim().replaceFirst("\\+", ""))) {
                            map.put("reason", MessageFormat.format(com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"phoneDiff"), phone, phoneLocal));
                        }
                    } else if (!email.equals(emailCloud) || !phoneLocal.trim().replaceFirst("\\+", "").equals(phone)) {
                        map.put("reason", MessageFormat.format(com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"userMsgError"), phone + " " + emailCloud, phoneLocal, email));
                    }
                }
            }
            map.put("userName", u.getName());
            map.put("personNumber", u.getMid());
            int gender = u.getGender();
            genderAlias = 0 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"male") : (1 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"female") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"secret"));
            map.put("gender", genderAlias);
            map.put("birthday", u.getBirthday());
            map.put("email", PrivacyHelper.dofuzzy((Context)ctx, (String)u.getEmail(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.EMAIL));
            map.put("phone", PrivacyHelper.dofuzzy((Context)ctx, (String)u.getPhone(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.PHONE));
            map.put("position", u.getPosition());
            map.put("is_delete", u.getIs_delete() == 1 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            if (cruInfo != null && !StringUtils.isEmpty((String)cruInfo.getCloudUuId())) {
                map.put("cloudUuId", cruInfo.getCloudUuId());
            } else {
                map.put("cloudUuId", String.valueOf(u.getUid()));
            }
            map.put("status", u.getStatus() == 0 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            group = u.getProd_group();
            if (group == null) {
                exportData.add(map);
                continue;
            }
            String[] groups = group.split(";");
            if (groups == null) {
                exportData.add(map);
                continue;
            }
            int len = groups.length;
            for (int i = 0; i < len; ++i) {
                if (cruInfo == null || cruInfo.getGroup() == null || !cruInfo.getGroup().contains(groups[i])) {
                    map.put(groups[i], com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_failed"));
                    continue;
                }
                map.put(groups[i], com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"syn_success"));
            }
            exportData.add(map);
        }
        List<Map<String, Object>> columnModel = this.columnModel4SynResult(isSynOnline);
        this.fillDataToExcel(ctx, wsheet, exportData, columnModel);
        this.setLicenseGroupValidation(ctx, wsheet);
    }

    private List<Map<String, Object>> columnModel4SynResult(boolean isSynOnline) {
        List<Map<String, Object>> columnModel = this.getColumnModel(false);
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("number", "isSynSuc");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"is_syn_success"));
        columnModel.add(item);
        if (isSynOnline) {
            item = new HashMap();
            item.put("number", "reason");
            item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"reason"));
            columnModel.add(item);
        }
        return columnModel;
    }

    private void fillHeader(Context ctx, Sheet wsheet, boolean isExportAll) {
        List<Map<String, Object>> columnModel = this.getColumnModel(isExportAll);
        int columnIndex = this.fillUserInfoHeader(wsheet, columnModel);
        this.fillLicenseGroupHeader(ctx, wsheet, columnIndex);
    }

    private int fillUserInfoHeader(Sheet wsheet, List<Map<String, Object>> columnModel) {
        Row firstRow = wsheet.getRow(0);
        if (firstRow == null) {
            firstRow = wsheet.createRow(0);
        }
        Cell cell = null;
        CellRangeAddress region = null;
        Workbook workbook = wsheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex());
        int index = 0;
        for (Map<String, Object> item : columnModel) {
            cell = firstRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("name").toString());
            region = new CellRangeAddress(0, 1, index, index);
            wsheet.addMergedRegion(region);
            Integer width = (Integer)item.get("width");
            if (width != null) {
                wsheet.setColumnWidth(index, width.intValue());
            }
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            ++index;
        }
        return index;
    }

    private void fillLicenseGroupHeader(Context ctx, Sheet wsheet, int columnIndex) {
        int index;
        Row secondRow;
        List<Map<String, Object>> licenseGroup = this.getLicenseGroup(ctx);
        Row firstRow = wsheet.getRow(0);
        if (firstRow == null) {
            firstRow = wsheet.createRow(0);
        }
        if ((secondRow = wsheet.getRow(1)) == null) {
            secondRow = wsheet.createRow(1);
        }
        Cell cell = null;
        CellStyle cellStyle = wsheet.getWorkbook().createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        this.groupColumnStartIndex = index = columnIndex;
        for (Map<String, Object> item : licenseGroup) {
            cell = firstRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("number").toString());
            cell = secondRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("name").toString());
            Integer width = (Integer)item.get("width");
            if (width != null) {
                wsheet.setColumnWidth(index, width.intValue());
            }
            ++index;
        }
    }

    private void fillData(Context ctx, Sheet wsheet, List<CloudUserInfo> data) throws LicenseException, BOSException, SQLException {
        this.fillData(ctx, wsheet, data, false, false);
    }

    private void fillData(Context ctx, Sheet wsheet, List<CloudUserInfo> data, boolean isExportActive, boolean isExportAll) throws LicenseException, BOSException, SQLException {
        if (data == null) {
            data = SynUserToCloudHelper.assembleCloudUserInfo(ctx);
        }
        ArrayList<Map<String, String>> exportData = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        for (CloudUserInfo u : data) {
            int gender;
            map = new HashMap<String, String>();
            map.put("userNumber", u.getErp_account());
            map.put("userName", u.getName());
            map.put("personNumber", null);
            if (isExportAll) {
                map.put("deptName", u.getDepartment());
                map.put("cu", u.getCU());
            }
            genderAlias = 0 == (gender = u.getGender()) ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"male") : (1 == gender ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"female") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"secret"));
            map.put("gender", genderAlias);
            map.put("birthday", u.getBirthday());
            map.put("email", PrivacyHelper.dofuzzy((Context)ctx, (String)u.getEmail(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.EMAIL));
            map.put("phone", PrivacyHelper.dofuzzy((Context)ctx, (String)u.getPhone(), (PrivacyHelper.ContentType)PrivacyHelper.ContentType.PHONE));
            map.put("position", u.getPosition());
            map.put("is_delete", u.getIs_delete() == 1 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            map.put("cloudUuId", String.valueOf(u.getUid() == 0 ? "" : Integer.valueOf(u.getUid())));
            map.put("status", u.getStatus() == 0 ? com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes") : com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no"));
            group = u.getProd_group();
            if (group == null) {
                exportData.add(map);
                continue;
            }
            String[] groups = group.split(";");
            if (groups == null) {
                exportData.add(map);
                continue;
            }
            int len = groups.length;
            for (int i = 0; i < len && u.getMpGroups() != null; ++i) {
                ProductGroup pg = u.getMpGroups().get(groups[i]);
                if (isExportActive) {
                    if (pg != null && pg.isValid()) {
                        map.put(groups[i], ActiveStateEnum.Active_YES.getAlias());
                        continue;
                    }
                    map.put(groups[i], ActiveStateEnum.Active_NO.getAlias());
                    continue;
                }
                if (pg == null || !pg.isValid()) continue;
                map.put(groups[i], com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes"));
            }
            exportData.add(map);
        }
        List<Map<String, Object>> columnModel = this.getColumnModel(isExportAll);
        this.fillDataToExcel(ctx, wsheet, exportData, columnModel);
        this.setLicenseGroupValidation(ctx, wsheet);
    }

    private void fillData(Context ctx, Sheet wsheet) throws LicenseException, BOSException, SQLException {
        this.fillData(ctx, wsheet, null);
    }

    private void fillDataToExcel(Context ctx, Sheet wsheet, List<Map<String, String>> noCloudUserData, List<Map<String, Object>> columnModel) {
        columnModel.addAll(this.getLicenseGroup(ctx));
        this.fillDataToExcelByColumnModel(ctx, wsheet, noCloudUserData, columnModel);
    }

    private void fillDataToExcelByColumnModel(Context ctx, Sheet wsheet, List<Map<String, String>> noCloudUserData, List<Map<String, Object>> columnModel) {
        Row row = null;
        Cell cell = null;
        Workbook workbook = wsheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        DataFormat fmt = workbook.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("@"));
        int index = 0;
        for (Map<String, String> item : noCloudUserData) {
            row = wsheet.createRow(this.dataRowStartIndex + index);
            item.put("index", String.valueOf(index + 1));
            int columnIndex = 0;
            String columnNumber = null;
            for (Map<String, Object> column : columnModel) {
                columnNumber = (String)column.get("number");
                cell = row.createCell(columnIndex++);
                cell.setCellValue(item.get(columnNumber));
                cell.setCellStyle(cellStyle);
            }
            ++index;
            ++this.dataRowCount;
        }
    }

    private void setLicenseGroupValidation(Context ctx, Sheet sheet) {
        String[] validation = new String[]{com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"yes"), com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"no")};
        int firstRow = this.dataRowStartIndex;
        int endRow = firstRow + this.dataRowCount;
        int firstCol = this.groupColumnStartIndex;
        int endCol = firstCol + this.getLicenseGroup(ctx).size();
        this.setExcelValidation(sheet, validation, firstRow, endRow, firstCol, endCol);
    }

    private void setExcelValidation(Sheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
    }

    private void writeToFile(Workbook workbook) throws IOException {
        logger.error((Object)"------------writeToFile begin----------------", new Exception("view call statck!").getCause());
        File file = new File(this.exportFilePath);
        logger.error((Object)"------------writeToFile 1----------------");
        FileOutputStream fileOut = new FileOutputStream(file);
        logger.error((Object)"------------writeToFile 2----------------");
        workbook.write((OutputStream)fileOut);
        logger.error((Object)"------------writeToFile 3----------------");
        fileOut.close();
        logger.error((Object)"------------writeToFile end----------------");
    }

    private List<Map<String, Object>> getColumnModel(boolean isExportAll) {
        ArrayList<Map<String, Object>> columnModel = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("number", "index");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"index"));
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "personNumber");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"person_number"));
        item.put("width", 3000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "userName");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"user_name"));
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"info1") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "gender");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"gender"));
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"info2") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "birthday");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"birthday"));
        item.put("width", 4000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "idCardNO");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"id_card_NO"));
        item.put("width", 5000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "phone");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"phone"));
        item.put("width", 4000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"info3") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "email");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"email"));
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"info4") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "deptName");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"dept_name"));
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "position");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"position"));
        item.put("width", 5000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "userNumber");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"user_number"));
        item.put("width", 4000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"info3") + ")");
        columnModel.add(item);
        if (isExportAll) {
            item = new HashMap();
            item.put("number", "cu");
            item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"ctrlUnitName"));
            item.put("width", 5000);
            columnModel.add(item);
        }
        item = new HashMap();
        item.put("number", "cloudUuId");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"cloud_uuid") + "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"dont_write") + ")");
        item.put("width", 5000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"info5") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "status");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"is_forbid"));
        item.put("width", 4000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "is_delete");
        item.put("name", com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"is_delete"));
        item.put("width", 4000);
        item.put("info", "(" + com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE, (String)"chooseWrite") + ")");
        columnModel.add(item);
        return columnModel;
    }

    public List<Map<String, Object>> getLicenseGroup(Context ctx) {
        ArrayList<Map<String, Object>> group = new ArrayList<Map<String, Object>>();
        int defaultWidth = 5000;
        if (this.lsLicenseGroupNumberName == null) {
            try {
                this.lsLicenseGroupNumberName = ctx != null ? UserFacadeFactory.getLocalInstance(ctx).getLicenseGroup() : UserFacadeFactory.getRemoteInstance().getLicenseGroup();
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        if (this.lsLicenseGroupNumberName == null) {
            return group;
        }
        int len = this.lsLicenseGroupNumberName.size();
        for (int i = 0; i < len; ++i) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            String[] strNumName = this.lsLicenseGroupNumberName.get(i).split(";");
            item.put("number", strNumName[0]);
            item.put("name", strNumName[1]);
            item.put("width", defaultWidth);
            group.add(item);
        }
        return group;
    }

    public int getDataRowStartIndex() {
        return this.dataRowStartIndex;
    }

    public int getGroupColumnStartIndex() {
        return this.groupColumnStartIndex;
    }

    public Map getUserConfigMap() {
        List<Map<String, Object>> colModel = this.getColumnModel(true);
        colModel.remove(0);
        ++this.groupColumnStartIndex;
        for (Map<String, Object> item : colModel) {
            this.userConfigMap.put(item.get("number"), this.groupColumnStartIndex);
            ++this.groupColumnStartIndex;
        }
        return this.userConfigMap;
    }

    public List<String> getUserConfigNameList() {
        ArrayList<String> userConfiglist = new ArrayList<String>();
        List<Map<String, Object>> colModel = this.getColumnModel(false);
        for (Map<String, Object> item : colModel) {
            userConfiglist.add(item.get("name").toString());
        }
        return userConfiglist;
    }

    public Map getGroupConfigMap(Context ctx) {
        for (Map<String, Object> item : this.getLicenseGroup(ctx)) {
            this.groupConfigMap.put(item.get("number"), this.groupColumnStartIndex);
            ++this.groupColumnStartIndex;
        }
        return this.groupConfigMap;
    }

    private static String dealCSVStr(String text) {
        if (text.startsWith("@") || text.startsWith("=") || text.startsWith("+") || text.startsWith("-")) {
            text = "'" + text + "'";
        }
        return text;
    }
}

