/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class Administrator {
    private static Logger logger = Logger.getLogger((String)Administrator.class.getName());
    public static final String ID = "00000000-0000-0000-0000-00000000000013B7DE7F";
    public static final String SUPER_CERTIFY_ADMIN_ID = "00000000-0000-0000-0000-00000000000113B7DE7F";
    public static final String SUPER_AUDIT_ADMIN_ID = "00000000-0000-0000-0000-00000000000213B7DE7F";
    public static final String SUPER_SSC_ADMIN_ID = "Wp3rRSFxRCaPFjuE2apQjRO33n8=";
    public static final String USER_ID = "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F";
    public static final String VIRTUAL_USER_ID = "IpyedAEWEADgAAmlwKgTMBO33n8=";

    private Administrator() {
    }

    public static boolean isDefaultUser(BOSUuid userID) {
        return ID.equals(StringUtils.cnulls((Object)userID)) || SUPER_CERTIFY_ADMIN_ID.equals(StringUtils.cnulls((Object)userID)) || SUPER_AUDIT_ADMIN_ID.equals(StringUtils.cnulls((Object)userID)) || SUPER_SSC_ADMIN_ID.equals(StringUtils.cnulls((Object)userID)) || USER_ID.equals(StringUtils.cnulls((Object)userID));
    }

    public static boolean isAdmin(BOSUuid userID) {
        return ID.equals(StringUtils.cnulls((Object)userID));
    }

    public static boolean isAdminType(UserType type) {
        return UserType.SYSTEM.equals((Object)type) || UserType.AUTHENTICATEADMIN.equals((Object)type) || UserType.AUDITADMIN.equals((Object)type);
    }

    public static boolean isCUAdminType(UserType type) {
        return UserType.SYSTEM.equals((Object)type);
    }

    public static boolean isAuthenAdminType(UserType type) {
        return UserType.AUTHENTICATEADMIN.equals((Object)type);
    }

    public static boolean isAuditAdminType(UserType type) {
        return UserType.AUDITADMIN.equals((Object)type);
    }

    public static boolean isSuperCUAdmin(IObjectPK userPK) {
        return ID.equals(userPK.toString());
    }

    public static boolean isSuperAuditAdmin(IObjectPK userPK) {
        return SUPER_AUDIT_ADMIN_ID.equals(userPK.toString());
    }

    public static boolean isSuperCertifyAdmin(IObjectPK userPK) {
        return SUPER_CERTIFY_ADMIN_ID.equals(userPK.toString());
    }

    public static boolean isSuperAdmin(BOSUuid userID) {
        ObjectStringPK userPK = new ObjectStringPK(userID.toString());
        return Administrator.isSuperAdmin((IObjectPK)userPK);
    }

    public static boolean isSuperAdmin(IObjectPK userPK) {
        return Administrator.isSuperCUAdmin(userPK) || Administrator.isSuperCertifyAdmin(userPK) || Administrator.isSuperAuditAdmin(userPK);
    }

    public static boolean isSuperAuAdmin(IObjectPK userPK) {
        return Administrator.isSuperCertifyAdmin(userPK) || Administrator.isSuperAuditAdmin(userPK);
    }

    public static boolean isCUAdmin(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        assert (userPK != null);
        if (Administrator.isSuperCUAdmin(userPK)) {
            return true;
        }
        return UserType.SYSTEM.equals((Object)Administrator.getTypeUserInfo(ctx, userPK).getType());
    }

    public static boolean isCertifyAdmin(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        assert (userPK != null);
        if (Administrator.isSuperCertifyAdmin(userPK)) {
            return true;
        }
        return Administrator.isAuthenAdmin(ctx, userPK);
    }

    public static boolean isAuditAdmin(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        assert (userPK != null);
        if (Administrator.isSuperAuditAdmin(userPK)) {
            return true;
        }
        return UserType.AUDITADMIN.equals((Object)Administrator.getTypeUserInfo(ctx, userPK).getType());
    }

    public static boolean isAdmin(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        assert (userPK != null);
        if (Administrator.isSuperAdmin(userPK)) {
            return true;
        }
        UserInfo userInfo = Administrator.getTypeUserInfo(ctx, userPK);
        if (userInfo == null) {
            return false;
        }
        return Administrator.isAdminType(userInfo.getType());
    }

    private static UserInfo getTypeUserInfo(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        assert (userPK != null);
        IUser iUser = null;
        iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("type"));
        UserInfo userInfo = iUser.getUserInfo(userPK, selectors);
        return userInfo;
    }

    public static boolean isBizAdmin(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        assert (userPK != null);
        if (Administrator.isSuperCUAdmin(userPK)) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT bizAdmin WHERE id = '").append(userPK.toString()).append("' ");
        IUser iUser = null;
        iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
        UserInfo userInfo = iUser.getUserInfo(buffer.toString());
        return userInfo.isBizAdmin();
    }

    public static void addCURange(Context ctx, FullOrgUnitInfo fullOrgInfo) throws EASBizException, BOSException {
        if (fullOrgInfo == null || fullOrgInfo.getId() == null) {
            logger.error((Object)"CtrlUnitInfo or id is null!");
            throw new IllegalArgumentException("CtrlUnitInfo or id is null!");
        }
        Administrator.addCu2SuperAdmin(ctx, fullOrgInfo, ID);
        Administrator.addCu2SuperAdmin(ctx, fullOrgInfo, SUPER_CERTIFY_ADMIN_ID);
        Administrator.addCu2SuperAdmin(ctx, fullOrgInfo, SUPER_AUDIT_ADMIN_ID);
    }

    private static void addOrgToSuperAdmin(Context ctx, FullOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        IOrgRange iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance(ctx);
        String autoAddOrgToSuperior = ParamManager.getParamValue((Context)ctx, null, (String)"AutoAddOrgToSuperior");
        if ("true".equalsIgnoreCase(autoAddOrgToSuperior)) {
            iOrgRange.addOrgToSuperAdmin(orgInfo, OrgRangeType.BIZ_ORG_TYPE);
        }
    }

    public static String getCurrentUserPK(Context ctx) {
        String curUserId = null;
        curUserId = ctx != null ? ctx.getCaller().toString() : SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return curUserId;
    }

    public static void addcu2admin(Context ctx, FullOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        String autoAddCu2Admin = ParamManager.getParamValue((Context)ctx, null, (String)"AutoAddOrg");
        if ("true".equalsIgnoreCase(autoAddCu2Admin)) {
            String curUserId = Administrator.getCurrentUserPK(ctx);
            Administrator.addUserOrgRangeInfo(ctx, curUserId, orgInfo);
            Administrator.addOrgToSuperAdmin(ctx, orgInfo);
        }
    }

    public static void addcu2AuthenAdmin(Context ctx, FullOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        if (orgInfo == null || orgInfo.getId() == null) {
            logger.error((Object)"CtrlUnitInfo or id is null!");
            throw new IllegalArgumentException("CtrlUnitInfo or id is null!");
        }
        Administrator.addCu2SuperAdmin(ctx, orgInfo, SUPER_CERTIFY_ADMIN_ID);
    }

    private static void addUserOrgRangeInfo(Context ctx, String userPK, FullOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        OrgRangeIncludeSubOrgInfo orgRangeInfo = new OrgRangeIncludeSubOrgInfo();
        orgRangeInfo.setOrg(orgInfo);
        orgRangeInfo.setIsIncludeSubOrg(false);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userPK));
        orgRangeInfo.setUser(userInfo);
        orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        OrgRangeHelper.saveOrgRangeIncludeSubOrgToBoth(ctx, orgRangeInfo);
    }

    private static void addUserOrgRangeIncludeSubInfo(Context ctx, String userPK, FullOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        OrgRangeIncludeSubOrgInfo orgRangeInfo = new OrgRangeIncludeSubOrgInfo();
        orgRangeInfo.setOrg(orgInfo);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userPK));
        orgRangeInfo.setUser(userInfo);
        orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        orgRangeInfo.setIsIncludeSubOrg(false);
        IOrgRangeIncludeSubOrg iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeIncludeSubOrgFactory.getRemoteInstance() : OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        iOrgRange.addnew(orgRangeInfo);
    }

    private static void addCu2SuperAdmin(Context ctx, FullOrgUnitInfo fullOrgInfo, String superAdminID) throws EASBizException, BOSException {
        Administrator.addUserOrgRangeInfo(ctx, superAdminID, fullOrgInfo);
    }

    public static FilterInfo getNotAdminUserFilter() {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"10", CompareType.NOTEQUALS));
        userFilterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"60", CompareType.NOTEQUALS));
        userFilterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"70", CompareType.NOTEQUALS));
        return userFilterInfo;
    }

    public static FilterInfo getNotAuUserFilter() {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"60", CompareType.NOTEQUALS));
        userFilterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"70", CompareType.NOTEQUALS));
        return userFilterInfo;
    }

    public static boolean isAuthenAdmin(Context ctx, IObjectPK userPk) throws BOSException, EASBizException {
        assert (userPk != null);
        IUser iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
        SelectorItemCollection selectorItemCol = new SelectorItemCollection();
        selectorItemCol.add(new SelectorItemInfo("isAuthenAdmin"));
        UserInfo userInfo = iUser.getUserInfo(userPk, selectorItemCol);
        return userInfo.isIsAuthenAdmin();
    }

    public static boolean canUserPerm(Context ctx, IObjectPK userPk) throws BOSException, EASBizException {
        assert (userPk != null);
        IUser iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
        SelectorItemCollection selectorItemCol = new SelectorItemCollection();
        selectorItemCol.add(new SelectorItemInfo("type"));
        UserInfo userInfo = iUser.getUserInfo(userPk, selectorItemCol);
        UserType userType = userInfo.getType();
        return UserType.PERSON.equals((Object)userType) || UserType.CUSTOMER.equals((Object)userType) || UserType.OTHER.equals((Object)userType) || UserType.SUPPLIER.equals((Object)userType);
    }
}

