/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.ObjectTypeFieldPermissionMap;
import com.kingdee.eas.base.permission.OrgObjectTypeFieldAccessInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OrgObjectTypeFieldPermissionMap
implements Serializable {
    private static final long serialVersionUID = -812903465630431979L;
    private Map orgObjectTypeFieldPermissionMap = null;
    private Collection orgPKCol;
    private Collection orgObjectTypeFieldAccessCol = new ArrayList();
    private boolean isInited = false;

    public Collection getOrgObjectTypeFieldAccessList() {
        return this.orgObjectTypeFieldAccessCol;
    }

    public void addOrgTypeFieldAccess(OrgObjectTypeFieldAccessInfo orgObjectTypeFieldAccess) {
        this.orgObjectTypeFieldAccessCol.add(orgObjectTypeFieldAccess);
    }

    public Collection getOrgPKCol() {
        return this.orgPKCol;
    }

    public void setOrgPKCol(Collection orgPKCol) {
        this.orgPKCol = orgPKCol;
    }

    public OrgObjectTypeFieldPermissionMap() {
        this.orgObjectTypeFieldPermissionMap = new HashMap();
    }

    public ObjectTypeFieldPermissionMap getObjectTypeFieldPermissionMap(String orgID) {
        return (ObjectTypeFieldPermissionMap)this.orgObjectTypeFieldPermissionMap.get(orgID);
    }

    public void put(String orgID, ObjectTypeFieldPermissionMap objectTypeFieldPermission) {
        this.orgObjectTypeFieldPermissionMap.put(orgID, objectTypeFieldPermission);
    }

    public boolean containsKey(String orgID) {
        return this.orgObjectTypeFieldPermissionMap.containsKey(orgID);
    }

    public Set keySet() {
        return this.orgObjectTypeFieldPermissionMap.keySet();
    }

    public int size() {
        return this.orgObjectTypeFieldPermissionMap.size();
    }

    public OrgObjectTypeFieldPermissionMap getMainOrgObjectTypeFieldPermission(Context ctx, Map objTypeOrgTypeMap) throws BOSException, EASBizException {
        this.initOrgObjectTypeFieldPermissionMap(objTypeOrgTypeMap);
        OrgObjectTypeFieldPermissionMap noneTypeMap = new OrgObjectTypeFieldPermissionMap();
        OrgObjectTypeFieldPermissionMap contextTypeMap = new OrgObjectTypeFieldPermissionMap();
        OrgObjectTypeFieldPermissionMap orgTypeMap = new OrgObjectTypeFieldPermissionMap();
        Set keySet = this.keySet();
        Iterator keyItr = keySet.iterator();
        String none = "NONE";
        while (keyItr.hasNext()) {
            String orgID = keyItr.next().toString();
            if (this.orgPKCol.contains(orgID)) {
                orgTypeMap.put(orgID, this.getObjectTypeFieldPermissionMap(orgID));
                continue;
            }
            if (none.equalsIgnoreCase(orgID)) {
                noneTypeMap.put(none, this.getObjectTypeFieldPermissionMap(none));
                continue;
            }
            contextTypeMap.put(orgID, this.getObjectTypeFieldPermissionMap(orgID));
        }
        HashSet orgIds = new HashSet(this.orgPKCol);
        Map orgIDOrgInfoMap = this.getOrgIDOrgInfoMap(ctx, orgIds);
        Iterator orgIDItr = this.orgPKCol.iterator();
        while (orgIDItr.hasNext()) {
            String orgID = orgIDItr.next().toString();
            FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)orgIDOrgInfoMap.get(orgID);
            ObjectTypeFieldPermissionMap otfpm = orgTypeMap.getObjectTypeFieldPermissionMap(orgID);
            if (otfpm == null) {
                otfpm = new ObjectTypeFieldPermissionMap();
                orgTypeMap.put(orgID, otfpm);
            }
            otfpm.addObjectTypeFieldPermissionMap(noneTypeMap.getObjectTypeFieldPermissionMap(none));
            Iterator contextOrgItr = contextTypeMap.keySet().iterator();
            while (contextOrgItr.hasNext()) {
                String contextOrgID = contextOrgItr.next().toString();
                ObjectTypeFieldPermissionMap contextOTFPM = contextTypeMap.getObjectTypeFieldPermissionMap(contextOrgID);
                Iterator contextObjTypeItr = contextOTFPM.keySet().iterator();
                while (contextObjTypeItr.hasNext()) {
                    String objType = contextObjTypeItr.next().toString();
                    OrgType orgType = (OrgType)objTypeOrgTypeMap.get(objType);
                    if (OrgUtils.isOrgType((OrgUnitInfo)orgInfo, (OrgType)orgType)) continue;
                    otfpm.put(objType, contextOTFPM.getFieldPermission(objType));
                }
            }
        }
        return orgTypeMap;
    }

    private Map getOrgIDOrgInfoMap(Context context, Collection orgIDs) throws BOSException, EASBizException {
        HashMap<String, FullOrgUnitInfo> ret = new HashMap<String, FullOrgUnitInfo>();
        if (orgIDs == null || orgIDs.size() < 1) {
            return ret;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)context).getFullOrgUnitCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            FullOrgUnitInfo org = col.get(i);
            ret.put(org.getId().toString(), org);
        }
        return ret;
    }

    private void initOrgObjectTypeFieldPermissionMap(Map objTypeOrgTypeMap) throws BOSException, EASBizException {
        if (this.isInited) {
            return;
        }
        for (OrgObjectTypeFieldAccessInfo info : this.orgObjectTypeFieldAccessCol) {
            String orgID = info.getOrgID();
            String objectType = info.getObjectType();
            FieldAccessInfo fieldAccess = info.getFieldAccessInfo();
            String fieldName = fieldAccess.getFieldName();
            ObjectTypeFieldPermissionMap otfpm = new ObjectTypeFieldPermissionMap();
            FieldPermission fp = new FieldPermission();
            if (this.containsKey(orgID)) {
                otfpm = this.getObjectTypeFieldPermissionMap(orgID);
                if (otfpm.containsKey(objectType)) {
                    fp = otfpm.getFieldPermission(objectType);
                    if (fp.containFieldName(fieldName)) {
                        FieldAccessInfo existFieldAccess = fp.getFieldAccessInfo(fieldName);
                        if (fieldAccess.isViewable()) {
                            existFieldAccess.setViewable(true);
                        }
                        if (fieldAccess.isEditable()) {
                            existFieldAccess.setEditable(true);
                        }
                    } else {
                        fp.add(fieldAccess);
                    }
                } else {
                    fp.add(fieldAccess);
                }
            } else {
                fp.add(fieldAccess);
            }
            otfpm.put(objectType, fp);
            this.put(orgID, otfpm);
        }
        this.isInited = true;
    }

    public void clear() {
        this.isInited = false;
        this.orgObjectTypeFieldPermissionMap.clear();
    }
}

