/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserInfoRpcHelper {
    private static Logger logger = Logger.getLogger((String)UserInfoRpcHelper.class.getName());

    public static String getforbidDetail(UserCollection userCol, String pmtStr, boolean isForbidden, Locale locale) {
        if (userCol == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        if ("forbidUsers".equals(pmtStr)) {
            if (isForbidden) {
                sb.append(LogNamesHelper.getLogName("forbidUser", locale));
            } else {
                sb.append(LogNamesHelper.getLogName("startUser", locale));
            }
        } else if ("lockUser".equals(pmtStr)) {
            if (isForbidden) {
                sb.append(LogNamesHelper.getLogName("lockUser", locale));
            } else {
                sb.append(LogNamesHelper.getLogName("unlockUser", locale));
            }
        } else if ("delete".equals(pmtStr) && isForbidden) {
            sb.append(LogNamesHelper.getLogName("deleteUser", locale));
        }
        sb.append("\n " + LogNamesHelper.getLogName("userNumber4Log", locale) + " (");
        int size = userCol.size();
        for (int i = 0; i < size; ++i) {
            sb.append(userCol.get(i).getNumber()).append(",");
        }
        String retStr = sb.toString();
        if (retStr.endsWith(",")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        retStr = retStr + ")";
        return retStr;
    }

    public static Set findWf(Context ctx, IObjectPK userId) throws UserException {
        HashSet<String> set = new HashSet<String>();
        try {
            if (userId == null) {
                return set;
            }
            IEnactmentService enactmentService = null;
            enactmentService = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo[] assignInfos = enactmentService.checkAssignmentInfos(userId.toString());
            if (assignInfos == null || assignInfos.length == 0) {
                return set;
            }
            int n = assignInfos.length;
            for (int i = 0; i < n; ++i) {
                String procInstId = assignInfos[i].getProcInstId();
                if (set.contains(procInstId)) continue;
                set.add(procInstId);
            }
        }
        catch (WfException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
        return set;
    }

    public static boolean hasUserWorkflow(Context ctx, List userIdList) throws UserException {
        if (userIdList == null || userIdList.isEmpty()) {
            return false;
        }
        int size = userIdList.size();
        for (int i = 0; i < size; ++i) {
            Set set = UserInfoRpcHelper.findWf(ctx, (IObjectPK)userIdList.get(i));
            if (set == null || set.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static EntityViewInfo getRegisterInfo(String cuIdStr) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.type", (Object)"10"));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)cuIdStr));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("user.id");
        viewInfo.getSelector().add("user.number");
        viewInfo.getSelector().add("user.name");
        return viewInfo;
    }
}

