/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.AbstractAdvancedPermissionServiceControllerBean;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.base.permission.app.service.impl.AdvancedDataPermissionService;
import com.kingdee.eas.base.permission.app.service.impl.AdvancedOrgPermissionService;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdvancedPermissionServiceControllerBean
extends AbstractAdvancedPermissionServiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AdvancedPermissionServiceControllerBean");

    @Override
    protected PermItemCollection _getPermItemsByUser(Context ctx, String userPK) throws BOSException, EASBizException {
        Object conn = null;
        Object ps = null;
        Object rs = null;
        StringBuilder sql = new StringBuilder();
        Object permItemCol = null;
        sql.append("select fpermitemid from t_pm_userorgperm uop where fowner = '").append(userPK).append("' union all select rm.fpermitemid fpermitemid from t_pm_roleperm rm where exists(select 1 from t_pm_userroleorg urg where  rm.froleid = urg.froleid  and urg.fuserid = '").append(userPK).append("')");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("longIndex"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("alias"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filterInfo);
        return PermItemFactory.getLocalInstance(ctx).getPermItemCollection(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getPermItemIDsByUserOrgs(Context ctx, String userPK, String orgIDs) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select fpermitemid from t_pm_userorgperm uop where fowner = '").append(userPK).append("' and forgid in(").append(orgIDs).append(") union all select rm.fpermitemid fpermitemid from t_pm_roleperm rm where exists(select 1 from t_pm_userroleorg urg where  rm.froleid = urg.froleid  and urg.fuserid = '").append(userPK).append("' and urg.forgid in(").append(orgIDs).append("))");
        ArrayList<String> permitemIds = new ArrayList<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                permitemIds.add(rs.getString("fpermitemid"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"=============_getPermItemIDsByUserOrgs=============", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return permitemIds;
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrgsWithCU(Context context, IObjectPK userPK, OrgType orgType, String permItemName, boolean isCU) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && (orgType.equals((Object)OrgType.NONE) || orgType.equals((Object)OrgType.UnionDebt))) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE or OrgType.UnionDebt");
        }
        ObjectUuidPK orgTreePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrg(userPK, orgType, (IObjectPK)orgTreePK);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRange(userPK, orgType, (IObjectPK)orgTreePK);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (PermissionFactory.getLocalInstance(context).hasFunctionPermission(userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRange(userPK, orgType, (IObjectPK)orgTreePK);
            }
            return new FullOrgUnitCollection();
        }
        return new AdvancedOrgPermissionService(context).getAuthorizedOrgWithCUFilter(userPK, (IObjectPK)orgTreePK, permItemName, isCU);
    }

    private boolean hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, boolean orgExtFromCtx) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return true;
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName()) || service.hasPermission(userPK, orgPK, permItemName = bind[i].getName(), true)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected Map _getPermissionRule(Context ctx, IObjectPK userPK, Set orgPks, String permItemName) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        if (orgPks == null || orgPks.isEmpty()) {
            return new HashMap();
        }
        AdvancedDataPermissionService service = new AdvancedDataPermissionService(ctx);
        Map map = null;
        try {
            map = service.getPermissionRule(userPK, orgPks, permItemName);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        long end = System.currentTimeMillis();
        logger.error((Object)("_getPermissionRule " + permItemName + " cost:" + (end - start)));
        return map;
    }
}

