/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessCollection;
import com.kingdee.eas.base.permission.FieldAccessException;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.app.AbstractFieldAccessControllerBean;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FieldAccessControllerBean
extends AbstractFieldAccessControllerBean {
    private static Logger logger = Logger.getLogger(FieldAccessControllerBean.class);

    @Override
    protected void _save(Context ctx, FieldAccessCollection result) throws BOSException, EASBizException {
        assert (result != null);
        int size = result.size();
        if (size == 0) {
            return;
        }
        BOSObjectType objectType = this.getBOSType();
        String bizObjectType = this.getBizObjectType(result);
        String currentUserID = ctx.getCaller().toString();
        Date currentTime = new Date(System.currentTimeMillis());
        String targetUserID = this.getUserID(result);
        String targetOrgID = this.getOrgID(result);
        String targetRoleID = this.getRoleID(result);
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            boolean isUserAccredit;
            cn = this.getConnection(ctx);
            boolean bl = isUserAccredit = this.getUserID(result) != null;
            if (isUserAccredit) {
                ps = cn.prepareStatement(" DELETE FROM T_PM_FieldAccess WHERE FBizObjectType = ? AND FUserID = ? AND FOrgID = ? ");
                ps.setString(1, bizObjectType);
                ps.setString(2, targetUserID);
                ps.setString(3, targetOrgID);
            } else {
                ps = cn.prepareStatement(" DELETE FROM T_PM_FieldAccess WHERE FBizObjectType = ? AND FRoleID = ? ");
                ps.setString(1, bizObjectType);
                ps.setString(2, targetRoleID);
            }
            ps.executeUpdate();
            StringBuffer sql = new StringBuffer(200);
            sql.append(" INSERT INTO T_PM_FieldAccess (FID, FBizObjectType, FFieldName, ").append(" FUserID, FOrgID, FRoleID, FAccessValue, FCreatorID, FCreateTime, ").append(" FLastUpdateUserID, FLastUpdateTime, FControlUnitID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = cn.prepareStatement(sql.toString());
            for (int i = 0; i < size; ++i) {
                FieldAccessInfo info = result.get(i);
                String cuID = info.getCU().getId().toString();
                ps.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
                ps.setString(2, bizObjectType);
                ps.setString(3, info.getFieldName());
                if (StringUtils.isEmpty((String)targetUserID)) {
                    ps.setNull(4, 12);
                } else {
                    ps.setString(4, targetUserID);
                }
                if (StringUtils.isEmpty((String)targetOrgID)) {
                    ps.setNull(5, 12);
                } else {
                    ps.setString(5, targetOrgID);
                }
                if (StringUtils.isEmpty((String)targetRoleID)) {
                    ps.setNull(6, 12);
                } else {
                    ps.setString(6, targetRoleID);
                }
                ps.setInt(7, info.getAccessValue());
                ps.setString(8, currentUserID);
                ps.setDate(9, currentTime);
                ps.setString(10, currentUserID);
                ps.setDate(11, currentTime);
                ps.setString(12, cuID);
                ps.addBatch();
            }
            ps.executeBatch();
            this.handleCallBack(ctx, new FieldAccessCollection[]{result});
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new FieldAccessException(FieldAccessException.SAVE_FIELDACCESS_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private String getBizObjectType(FieldAccessCollection result) {
        assert (result.size() > 0);
        return result.get(0).getBizObjectType();
    }

    private String getUserID(FieldAccessCollection result) {
        assert (result.size() > 0);
        if (result.get(0).getUser() != null && result.get(0).getUser().getId() != null) {
            return result.get(0).getUser().getId().toString();
        }
        return null;
    }

    private String getOrgID(FieldAccessCollection result) {
        assert (result.size() > 0);
        if (result.get(0).getUser() != null && result.get(0).getOrg().getId() != null) {
            return result.get(0).getOrg().getId().toString();
        }
        return null;
    }

    private String getRoleID(FieldAccessCollection result) {
        assert (result.size() > 0);
        if (result.get(0).getRole() != null && result.get(0).getRole().getId() != null) {
            return result.get(0).getRole().getId().toString();
        }
        return null;
    }

    private void handleCallBack(Context ctx, FieldAccessCollection[] facs) throws EASBizException, BOSException {
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            IObjectPK[][] roleAndUserPKs = this.getRoleAndUserPKs(facs);
            IObjectPK[] rolePKs = roleAndUserPKs[0];
            IObjectPK[] userPKs = roleAndUserPKs[1];
            if (rolePKs != null && rolePKs.length > 0) {
                helper.setRolePKs(rolePKs);
            }
            if (userPKs != null && userPKs.length > 0) {
                helper.setUserPKs(userPKs);
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("com.kingdee.eas.base.permission.app.ClearCacheListener");
            helper.exceChange(ctx, list);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    private IObjectPK[][] getRoleAndUserPKs(FieldAccessCollection[] facs) {
        HashSet<ObjectUuidPK> rolePKSet = new HashSet<ObjectUuidPK>();
        HashSet<ObjectUuidPK> userPKSet = new HashSet<ObjectUuidPK>();
        for (int i = 0; i < facs.length; ++i) {
            FieldAccessCollection dpc = facs[i];
            for (int j = 0; j < dpc.size(); ++j) {
                FieldAccessInfo info = dpc.get(j);
                if (info.getRole() != null) {
                    rolePKSet.add(new ObjectUuidPK(info.getRole().getId()));
                }
                if (info.getUser() == null) continue;
                userPKSet.add(new ObjectUuidPK(info.getUser().getId()));
            }
        }
        IObjectPK[] rolePKs = this.setToArray(rolePKSet);
        IObjectPK[] userPKs = this.setToArray(userPKSet);
        IObjectPK[][] roleAndUserPKs = new IObjectPK[][]{rolePKs, userPKs};
        return roleAndUserPKs;
    }

    private IObjectPK[] setToArray(Set pkSet) {
        IObjectPK[] ret = new IObjectPK[pkSet.size()];
        Object[] temp = pkSet.toArray();
        for (int i = 0; i < temp.length; ++i) {
            ret[i] = (IObjectPK)temp[i];
        }
        return ret;
    }
}

