/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IGetPermItemInfoAble;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.app.AbstractPermission3DViewFacadeControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Permission3DViewFacadeControllerBean
extends AbstractPermission3DViewFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.Permission3DViewFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public Map<String, List<String>> getBeenPermItems(Context ctx, List<String> permList) throws BOSException, EASBizException {
        HashMap<String, List<String>> beenPermMap = new HashMap<String, List<String>>();
        String sql = "Select fid,fdependencyid from T_PM_PermDependency where fid in (" + ToolUtils.aryToStr(permList) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fdependencyid = rs.getString("fdependencyid");
                List permDenpencyIds = !beenPermMap.containsKey(fid) ? new ArrayList() : (List)beenPermMap.get(fid);
                permDenpencyIds.add(fdependencyid);
                beenPermMap.put(fid, permDenpencyIds);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return beenPermMap;
    }

    public Map<String, List<String>> getByBeenPermItems(Context ctx, List<String> permList) throws BOSException, EASBizException {
        HashMap<String, List<String>> beenPermMap = new HashMap<String, List<String>>();
        String sql = "Select fdependencyid,fid from T_PM_PermDependency where fdependencyid in (" + ToolUtils.aryToStr(permList) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String fdependencyid = rs.getString("fdependencyid");
                String fid = rs.getString("fid");
                ArrayList<String> byIds = (ArrayList<String>)beenPermMap.get(fdependencyid);
                if (byIds == null) {
                    byIds = new ArrayList<String>();
                }
                byIds.add(fid);
                beenPermMap.put(fdependencyid, byIds);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return beenPermMap;
    }

    public EntityViewInfo getEntityViewInfo(List<String> permIDs) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id in (" + ToolUtils.aryToStr(permIDs) + ")"));
        view.setFilter(filter);
        return view;
    }

    private List<String> warningPerms(Context ctx, List<String> perms) throws BOSException {
        ArrayList<String> permItems = new ArrayList<String>();
        String PermsSql = "Select falias_" + ContextUtils.getLocaleFromEnv().toString() + " falias from t_pm_permitem where fid in (" + ToolUtils.aryToStr(perms) + ")";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)PermsSql);
        try {
            while (result.next()) {
                permItems.add(result.getString("falias"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        return permItems;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deletePerms(Context ctx, List<UserOrgPermInfo> cancelPerms) throws BOSException {
        Connection connection = null;
        PreparedStatement statement = null;
        String deleteSql = "delete from t_pm_userorgperm where fid =?";
        try {
            connection = this.getConnection(ctx);
            statement = connection.prepareStatement(deleteSql);
            BOSUuid userPermOrgUuid = null;
            String userPermOrgId = null;
            for (UserOrgPermInfo userOrgPermInfo : cancelPerms) {
                userPermOrgUuid = userOrgPermInfo == null ? null : userOrgPermInfo.getId();
                userPermOrgId = userPermOrgUuid == null ? null : userPermOrgUuid.toString();
                statement.setString(1, userPermOrgId);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLDataException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
                catch (SQLException e2) {
                    logger.error((Object)e2.getMessage());
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteRolesPerms(Context ctx, List<RolePermInfo> cancelPerms) throws BOSException {
        Connection connection = null;
        PreparedStatement statement = null;
        String deleteSql = "delete from t_pm_roleperm where fid =?";
        try {
            connection = this.getConnection(ctx);
            statement = connection.prepareStatement(deleteSql);
            for (RolePermInfo rolePermInfo : cancelPerms) {
                statement.setString(1, rolePermInfo.getSelfId());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLDataException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
                catch (SQLException e2) {
                    logger.error((Object)e2.getMessage());
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteUserRoles(Context ctx, List<UserRoleOrgInfo> cancelRoles) throws BOSException {
        Connection connection = null;
        PreparedStatement statement = null;
        String deletesql = "delete from t_pm_userroleorg where fuserid=? and forgid=? and froleid=?";
        try {
            connection = this.getConnection(ctx);
            statement = connection.prepareStatement(deletesql);
            UserRoleOrgInfo userRoleOrgInfo = null;
            for (int i = 0; i < cancelRoles.size(); ++i) {
                userRoleOrgInfo = cancelRoles.get(i);
                statement.setString(1, userRoleOrgInfo.getUserId());
                statement.setString(2, userRoleOrgInfo.getOrgId());
                statement.setString(3, userRoleOrgInfo.getRoleId());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLDataException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
                catch (SQLException e2) {
                    logger.error((Object)e2.getMessage());
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    @Override
    protected List _batchCancelUserOrgPerms(Context ctx, List selectedPerms) throws BOSException, EASBizException {
        ArrayList<String> warning = new ArrayList<String>();
        StringBuffer bf = new StringBuffer();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ArrayList<UserOrgPermInfo> cancelPerms = new ArrayList<UserOrgPermInfo>(selectedPerms);
        if (Administrator.isBizAdmin(ctx, (IObjectPK)userPK)) {
            List<UserOrgPermInfo> notDels = this.filterBizAdminCancelPerms(ctx, (IObjectPK)userPK, cancelPerms);
            for (UserOrgPermInfo info : notDels) {
                IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getLocalInstance(ctx);
                info = iUserOrgPerm.getUserOrgPermInfo("select *,org.*,owner.*,permItem.* where id='" + info.getId().toString() + "'");
                bf.append("\n ").append("\u3010" + EASResource.getString((String)RESOURCE, (String)"USER_ACCOUNT1") + "" + info.getOwner().getNumber()).append("\n" + EASResource.getString((String)RESOURCE, (String)"USER_REAL_NAME") + info.getOwner().getName()).append("\n" + EASResource.getString((String)RESOURCE, (String)"ORG_NUMBER") + info.getOrg().getNumber()).append("\n" + EASResource.getString((String)RESOURCE, (String)"ORG_NAME") + info.getOrg().getName()).append("\n" + EASResource.getString((String)RESOURCE, (String)"PERMISSION_NUMBER") + info.getPermItemNumber()).append("\n" + EASResource.getString((String)RESOURCE, (String)"PERMISSION_NAME") + info.getPermItem().getName()).append("\n" + EASResource.getString((String)RESOURCE, (String)"PERMISSION_NAME") + info.getPermItem().getAlias()).append("\n" + EASResource.getString((String)RESOURCE, (String)"PERMISSION_NAME") + (Object)((Object)info.getPermType())).append("\u3011");
            }
        }
        if (cancelPerms != null && !cancelPerms.isEmpty()) {
            this.deleteByBeenPerms(ctx, cancelPerms);
            this.deletePerms(ctx, cancelPerms);
        }
        warning.add(bf.toString());
        return warning;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteByBeenPerms(Context ctx, List<UserOrgPermInfo> cancelPerms) throws BOSException, EASBizException {
        Map<String, List<String>> byBeenPermItems = this.getByBeenPermItems(ctx, this.getAllPermIds(cancelPerms));
        HashMap<String, ArrayList<String>> deleteSqls = new HashMap<String, ArrayList<String>>();
        for (UserOrgPermInfo userOrgPermInfo : cancelPerms) {
            String ownerId = userOrgPermInfo.getUserId();
            String orgId = userOrgPermInfo.getOrgId();
            String string = userOrgPermInfo.getPermItemId();
            String key = "delete from t_pm_userorgperm where fowner='" + ownerId + "' and forgId='" + (String)orgId + "' and FPERMITEMID in";
            ArrayList<String> byPerms = (ArrayList<String>)deleteSqls.get(key);
            List<String> byperms2 = byBeenPermItems.get(string);
            if (byperms2 == null || byperms2.isEmpty()) continue;
            if (byPerms == null) {
                byPerms = new ArrayList<String>();
            }
            byPerms.addAll(byperms2);
            deleteSqls.put(key, byPerms);
        }
        Set deleteSqlsSet = deleteSqls.entrySet();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection(ctx);
            statement = connection.createStatement();
            for (Map.Entry entry : deleteSqlsSet) {
                String deleteSql = (String)entry.getKey() + " (" + ToolUtils.aryToStr((List)entry.getValue()) + ")";
                statement.execute(deleteSql);
            }
        }
        catch (SQLDataException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
                catch (SQLException e2) {
                    logger.error((Object)e2.getMessage());
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    private List<UserOrgPermInfo> filterBizAdminCancelPerms(Context ctx, IObjectPK userPK, List<UserOrgPermInfo> cancelPerms) throws BOSException {
        ArrayList<UserOrgPermInfo> notCanOpt = new ArrayList<UserOrgPermInfo>();
        List<String> ids = this.geGrandOrgId(ctx, userPK.toString());
        Iterator<UserOrgPermInfo> cancelPermsIterator = cancelPerms.iterator();
        while (cancelPermsIterator.hasNext()) {
            UserOrgPermInfo userPermOrgInfo = cancelPermsIterator.next();
            if (ids.contains(userPermOrgInfo.getOrgId().toString())) continue;
            cancelPermsIterator.remove();
            notCanOpt.add(userPermOrgInfo);
        }
        return notCanOpt;
    }

    @Override
    protected List _batchCancleRolePerms(Context ctx, List selectedPerms) throws BOSException, EASBizException {
        ArrayList warningPerms = new ArrayList();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ArrayList<RolePermInfo> cancelPerms = new ArrayList<RolePermInfo>(selectedPerms);
        if (cancelPerms != null && !cancelPerms.isEmpty()) {
            this.deleteByBeenRolePerms(ctx, cancelPerms);
            this.deleteRolesPerms(ctx, cancelPerms);
        }
        return warningPerms;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteByBeenRolePerms(Context ctx, List<RolePermInfo> cancelPerms) throws BOSException, EASBizException {
        Map<String, List<String>> byBeenPermItems = this.getByBeenPermItems(ctx, this.getAllPermIds(cancelPerms));
        HashMap<String, ArrayList<String>> deleteSqls = new HashMap<String, ArrayList<String>>();
        for (RolePermInfo rolePermInfo : cancelPerms) {
            String roleId = rolePermInfo.getRoleId();
            String fpermid = rolePermInfo.getPermItemId();
            String string = "delete from t_pm_roleperm where froleId ='" + roleId + "' and FPERMITEMID in";
            ArrayList<String> byPerms = (ArrayList<String>)deleteSqls.get(string);
            List<String> byperms2 = byBeenPermItems.get(fpermid);
            if (byperms2 == null || byperms2.isEmpty()) continue;
            if (byPerms == null) {
                byPerms = new ArrayList<String>();
            }
            byPerms.addAll(byperms2);
            deleteSqls.put(string, byPerms);
        }
        Set deleteSqlsSet = deleteSqls.entrySet();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection(ctx);
            statement = connection.createStatement();
            for (Map.Entry entry : deleteSqlsSet) {
                String deleteSql = (String)entry.getKey() + " (" + ToolUtils.aryToStr((List)entry.getValue()) + ")";
                statement.execute(deleteSql);
            }
        }
        catch (SQLDataException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
                catch (SQLException e2) {
                    logger.error((Object)e2.getMessage());
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    @Override
    protected List _batchCancelUserOrgRoles(Context ctx, List selectedRoles) throws BOSException, EASBizException {
        ArrayList<UserRoleOrgInfo> cancelRoles = new ArrayList<UserRoleOrgInfo>();
        HashSet<String> roleIdList = new HashSet<String>();
        ArrayList<String> orgIdList = new ArrayList<String>();
        ArrayList<AbstractCollection> wainInfo = new ArrayList<AbstractCollection>();
        ArrayList<String> assignRoleList = new ArrayList<String>();
        ArrayList<String> assignOrgList = new ArrayList<String>();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        if (Administrator.isCUAdmin(ctx, (IObjectPK)userPK)) {
            cancelRoles.addAll(selectedRoles);
        } else {
            String roleSql = "Select froleid,forgid from T_PM_GrantUserRoleOrg where fuserid ='" + userPK.toString() + "' and forgid in(" + ToolUtils.aryToStr(this.geGrandOrgId(ctx, userPK.toString())) + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)roleSql);
            try {
                while (rs.next()) {
                    assignRoleList.add(rs.getString("froleid"));
                    assignOrgList.add(rs.getString("forgid"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
            }
            UserRoleOrgInfo userRoleOrgInfo = null;
            String roleId = null;
            String orgId = null;
            for (Object userRoleOrg : selectedRoles) {
                RoleInfo info;
                userRoleOrgInfo = (UserRoleOrgInfo)userRoleOrg;
                roleId = userRoleOrgInfo.getRoleId();
                orgId = userRoleOrgInfo.getOrgId();
                if (assignRoleList.contains(roleId) && assignOrgList.contains(orgId)) {
                    cancelRoles.add(userRoleOrgInfo);
                    continue;
                }
                if (!assignRoleList.contains(roleId)) {
                    IRole irole = RoleFactory.getLocalInstance(ctx);
                    info = irole.getRoleInfo((IObjectPK)new ObjectStringPK(roleId));
                    roleIdList.add(info.getName());
                }
                if (assignOrgList.contains(orgId)) continue;
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                info = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
                orgIdList.add(info.getName());
            }
        }
        wainInfo.add(roleIdList);
        wainInfo.add(orgIdList);
        if (cancelRoles != null && !cancelRoles.isEmpty()) {
            this.deleteUserRoles(ctx, cancelRoles);
        }
        return wainInfo;
    }

    private Map<String, List<String>> getUserRolepermMap(List selectData) {
        HashMap<String, List<String>> userRolepermMap = new HashMap<String, List<String>>();
        ArrayList<String> permList = null;
        String key = null;
        String permItemId = null;
        for (Object data : selectData) {
            if (data instanceof UserOrgPermInfo) {
                key = ((UserOrgPermInfo)data).getUserId();
                permItemId = ((UserOrgPermInfo)data).getPermItemId();
            } else {
                if (!(data instanceof RolePermInfo)) continue;
                key = ((RolePermInfo)data).getRoleId();
                permItemId = ((RolePermInfo)data).getPermItemId();
            }
            permList = (ArrayList<String>)userRolepermMap.get(key);
            if (permList == null) {
                permList = new ArrayList<String>();
                userRolepermMap.put(key, permList);
            }
            permList.add(permItemId);
        }
        return userRolepermMap;
    }

    public List<String> geGrandOrgId(Context ctx, String userId) throws BOSException {
        try {
            StringBuffer queryGrandOrgIdSql = new StringBuffer();
            queryGrandOrgIdSql.append("select unit.fid orgId from t_org_baseunit unit ").append(" inner join T_PM_OrgRange range on unit.fcontrolunitid = range.forgid ").append(" where range.ftype =30 and range.fuserid=?");
            IRowSet queryGrandOrgIdResultSet = DbUtil.executeQuery((Context)ctx, (String)queryGrandOrgIdSql.toString(), (Object[])new Object[]{userId});
            ArrayList<String> grandOrgIds = new ArrayList<String>();
            while (queryGrandOrgIdResultSet.next()) {
                grandOrgIds.add(queryGrandOrgIdResultSet.getString("orgId"));
            }
            return grandOrgIds;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public List<String> getAllPermIds(List<? extends IGetPermItemInfoAble> selectData) {
        ArrayList<String> allPermIds = new ArrayList<String>();
        String permItemId = null;
        for (IGetPermItemInfoAble iGetPermItemInfoAble : selectData) {
            permItemId = iGetPermItemInfoAble.getPermItemId();
            if (allPermIds.contains(permItemId)) continue;
            allPermIds.add(permItemId);
        }
        return allPermIds;
    }
}

