/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleException;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RoleType;
import com.kingdee.eas.base.permission.app.AbstractRoleControllerBean;
import com.kingdee.eas.base.permission.app.helper.RolePermHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class RoleControllerBean
extends AbstractRoleControllerBean {
    private static Logger logger = Logger.getLogger(RoleControllerBean.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RoleInfo info = this.getRoleInfo(ctx, pk);
        this.checkCanModify(ctx, (IObjectValue)info);
        this.checkIsUsing(ctx, (IObjectValue)info);
        this.removeUserRoleOrg(ctx, info.getId().toString());
        RolePermFactory.getLocalInstance(ctx).delete("where role = '" + pk.toString() + "'");
        super._delete(ctx, pk);
    }

    protected void removeUserRoleOrg(Context ctx, String roleId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_PM_UserRoleOrg WHERE  FROLEID =? ", (Object[])new Object[]{roleId});
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkCanModify(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkCanModify(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RoleInfo info = (RoleInfo)model;
        if (RoleType.DEFAULT.equals((Object)info.getType())) {
            Object[] params = new Object[]{info.getNumber()};
            throw new RoleException(RoleException.CAN_NOT_MODIFY_DEF_ROLE, params);
        }
        if (!OrgRangeService.inCUOrgRange(ctx, ctx.getCaller(), StringUtils.cnulls((Object)info.getCU().getId()))) {
            Object[] params = new Object[]{info.getNumber()};
            throw new PermissionException(PermissionException.CAN_NOT_MODIFY_OTHER_CU_DATA, params);
        }
    }

    private void checkIsUsing(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RoleInfo info = (RoleInfo)model;
        Object[] params = new Object[]{info.getId().toString()};
        String sql = "SELECT 1 FROM T_PM_USER u INNER JOIN T_PM_UserRoleOrg uro on u.FID = uro.FUSERID where u.FISDELETE = 0 and uro.FROLEID =?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowSet.next()) {
                throw new RoleException(RoleException.ROLE_BEEN_ASSIGNED);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(RoleException.GET_ROLE_FAIL, e);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RoleInfo roleInfo = (RoleInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)roleInfo.getNumber());
        filterInfo.getFilterItems().add(filterItem);
        if (roleInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)roleInfo.getId(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterItem);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (this.exists(ctx, filterInfo)) {
            String number = this._getPropertyAlias(ctx, roleInfo, "number") + roleInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected boolean _haveThisNumber(Context ctx, String roleNumber) throws BOSException, EASBizException {
        return PermBizHelper.haveThisNumber(ctx, "t_pm_role", roleNumber);
    }

    @Override
    protected IObjectValue _getRoleInfoByNumber(Context ctx, String roleNumber) throws BOSException, EASBizException {
        String oql = "select * where number ='" + roleNumber + "'";
        return this._getValue(ctx, oql);
    }

    @Override
    protected IObjectPK _saveAs(Context ctx, IObjectPK sourcePK, IObjectValue newValue, boolean isCopyPerm, boolean isCopyUserOrg) throws BOSException, EASBizException {
        IObjectPK rolePK = this._addnew(ctx, newValue);
        if (isCopyPerm) {
            this.copyRolePerm(ctx, sourcePK, rolePK);
        }
        if (isCopyUserOrg) {
            this.copyRoleUserOrg(ctx, sourcePK, rolePK);
        }
        return null;
    }

    private void copyRolePerm(Context ctx, IObjectPK sourcePK, IObjectPK targetPK) throws BOSException, EASBizException {
        String sql = "insert into t_pm_roleperm(FID,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr) select newbosid('9FBAB53A'),'" + targetPK + "',FPermItemID,FPermType,FRuleStructure,FRuleExpr from t_pm_roleperm where froleid='" + sourcePK.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        String creatorId = ctx.getCaller().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = format.format(new Date());
        String sqlDate = "{ts'" + dateStr + "'}";
        String controlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String fieldAccessSql = "insert into t_pm_fieldAccess(fid,fbizobjecttype,fFieldName,fRoleId,FAccessValue,FCreatorID,FCreateTime,FLastUpdateUserId,FLastUpdateTime,FControlUnitID)select newbosid('D8F779CA'),fbizobjecttype,fFieldName,'" + targetPK + "',FAccessValue,'" + creatorId + "'," + sqlDate + ",'" + creatorId + "'," + sqlDate + ",'" + controlUnitId + "' from t_pm_fieldAccess where FRoleId = '" + sourcePK + "'";
        DbUtil.execute((Context)ctx, (String)fieldAccessSql);
        String grantRoleFieldSql = "insert into t_pm_grantrolefield(fid,FRoleId,FFieldName,FBizObjectType)  select newbosid('CBCD0A1C'),'" + targetPK + "',FFieldName,FBizObjectType from  t_pm_grantrolefield where FRoleId='" + sourcePK + "'";
        DbUtil.execute((Context)ctx, (String)grantRoleFieldSql);
    }

    private void copyRoleUserOrg(Context ctx, IObjectPK sourcePK, IObjectPK targetPK) throws BOSException, EASBizException {
        String sql = "insert into t_pm_userroleorg(FuserID,FRoleID,ForgID) select FUserID,'" + targetPK + "',ForgID from t_pm_userroleorg where froleid='" + sourcePK + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _updateDefRoleByID(Context ctx, List idList, boolean isDefRole) throws BOSException, EASBizException {
        String idStr = ToolUtils.aryToStr(idList);
        Connection conn = null;
        Statement statement = null;
        try {
            RoleCollection roleCollection = RoleFactory.getLocalInstance(ctx).getRoleCollection("select number,name where id in (" + idStr + ")");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < roleCollection.size(); ++i) {
                RoleInfo roleInfo = roleCollection.get(i);
                stringBuilder.append(roleInfo.getNumber()).append(" ").append(roleInfo.getName());
            }
            String logItemName = isDefRole ? "bs_permission_role_set_default" : "bs_permission_role_cancel_default";
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"DEFAULT_ROLE"), (BOSObjectType)new BOSObjectType("13B6732A"), null, (String)stringBuilder.toString(), (String)logItemName);
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlStr = new StringBuffer();
            if (isDefRole) {
                sqlStr.append("UPDATE T_PM_ROLE SET FIsDefRole=0 WHERE FIsDefRole=1");
                statement.addBatch(sqlStr.toString());
            }
            sql.append("UPDATE T_PM_ROLE SET FIsDefRole = ").append(isDefRole ? 1 : 0).append(" WHERE FID IN (").append(idStr).append(")");
            statement.addBatch(sql.toString());
            statement.executeBatch();
            ORMValueCacheService.getInstance().discardType(ctx, new RoleInfo().getBOSType());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new RoleException(RoleException.SET_DEF_ROLE);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    @Override
    protected void _roleCopy(Context ctx, IObjectCollection sourceRole, IObjectPK targetRoleId, boolean isCopyPerm, boolean isCopyUserOrg) throws BOSException, EASBizException {
        ArrayList<String> roleIDs = new ArrayList<String>();
        StringBuilder logDetailSb = new StringBuilder(EASResource.getString((String)RESOURCE, (String)"COPY_ROLE"));
        for (int i = 0; i < sourceRole.size(); ++i) {
            RoleInfo info = (RoleInfo)sourceRole.getObject(i);
            roleIDs.add(info.getId().toString());
            logDetailSb.append(info.getNumber()).append(" ").append(info.getName());
            logDetailSb.append(i == sourceRole.size() - 1 ? " " : ",");
        }
        RoleInfo targetRole = RoleFactory.getLocalInstance(ctx).getRoleInfo("select name,number where id = '" + targetRoleId + "'");
        logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"TO_ROLE")).append(targetRole.getNumber()).append(" ").append(targetRole.getName());
        logDetailSb.append("\uff0c" + EASResource.getString((String)RESOURCE, (String)"COPY_CONTENT") + ":").append(isCopyPerm ? EASResource.getString((String)RESOURCE, (String)"ROLE_PERMISSION") : "").append(" ").append(isCopyUserOrg ? EASResource.getString((String)RESOURCE, (String)"ROLE_USERORG") : "");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"COPY_ROLE"), (BOSObjectType)targetRole.getBOSType(), null, (String)logDetailSb.toString(), (String)"bs_permission_role_copy");
        if (isCopyPerm) {
            RolePermCollection oldRolePerms = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select id,role.id,permItem.id,permType,ruleStructure,ruleExpr where role.id = '" + targetRoleId + "'");
            this.copyRolePermNew(ctx, roleIDs, targetRoleId);
            RolePermCollection newRolePerms = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select id,role.id,permItem.id,permType,ruleStructure,ruleExpr where role.id = '" + targetRoleId + "'");
            RolePermCollection addRolePerms = RolePermHelper.removeUserPermOrg(newRolePerms, oldRolePerms);
            RoleInfo roleInfo = RoleFactory.getLocalInstance(ctx).getRoleInfo(targetRoleId);
            GroupLicenseUseInfoUtil.changeRolePermitem(ctx, roleInfo, addRolePerms, new RolePermCollection());
        }
        if (isCopyUserOrg) {
            this.copyRoleUserOrgNew(ctx, roleIDs, targetRoleId);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void copyRoleUserOrgNew(Context ctx, List roleIDs, IObjectPK targetRoleId) throws BOSException {
        String sql = "insert into t_pm_userroleorg(FuserID,FRoleID,ForgID) select FUserID,'" + targetRoleId + "',ForgID from t_pm_userroleorg uro where uro.froleid in(" + ToolUtils.aryToStr(roleIDs) + ") and not exists(select 1 from t_pm_userroleorg uro2  where uro2.FROLEID = '" + targetRoleId + "' and uro2.FUserID = uro.fuserid and uro2.FORGID = uro.forgid) group by uro.fuserid,uro.forgid";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void copyRolePermNew(Context ctx, List roleIDs, IObjectPK targetRoleId) throws BOSException {
        String sql = "";
        sql = roleIDs.size() > 1 ? "insert into t_pm_roleperm(FID,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr) select newbosid('9FBAB53A'),'" + targetRoleId + "',FPermItemID,FPermType,FRuleStructure,FRuleExpr FROM T_PM_ROLEPERM where fid in( SELECT max(fid) FROM t_pm_roleperm rp where rp.FROLEID in(" + ToolUtils.aryToStr(roleIDs) + ") and not exists (SELECT 1  FROM t_pm_roleperm rp2 where rp2.FROLEID = '" + targetRoleId + "' and rp2.FPERMITEMID=rp.FPERMITEMID) group by rp.fpermitemid)" : "insert into t_pm_roleperm(FID,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr) select newbosid('9FBAB53A'),'" + targetRoleId + "',FPermItemID,FPermType,FRuleStructure,FRuleExpr from t_pm_roleperm rp where rp.FROLEID = '" + roleIDs.get(0).toString() + "' and not exists (SELECT 1  FROM t_pm_roleperm rp2 where rp2.FROLEID = '" + targetRoleId + "' and rp2.FPERMITEMID=rp.FPERMITEMID)";
        DbUtil.execute((Context)ctx, (String)sql);
        String creatorId = ctx.getCaller().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = format.format(new Date());
        String sqlDate = "{ts'" + dateStr + "'}";
        String controlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String fieldAccessSql = "";
        fieldAccessSql = roleIDs.size() > 1 ? "insert into t_pm_fieldAccess(fid,fbizobjecttype,fFieldName,fRoleId,FAccessValue,FCreatorID,FCreateTime,FLastUpdateUserId,FLastUpdateTime,FControlUnitID)select newbosid('D8F779CA'),fbizobjecttype,fFieldName,'" + targetRoleId + "',FAccessValue,'" + creatorId + "'," + sqlDate + ",'" + creatorId + "'," + sqlDate + ",'" + controlUnitId + "' from t_pm_fieldAccess where fid in(select max(fid) from t_pm_fieldAccess fa where fa.FRoleId in(" + ToolUtils.aryToStr(roleIDs) + ") and not exists (SELECT 1  FROM t_pm_fieldAccess fa2 where fa2.FROLEID = '" + targetRoleId + "' and fa2.FFIELDNAME=fa.FFIELDNAME) group by fa.FFIELDNAME)" : "insert into t_pm_fieldAccess(fid,fbizobjecttype,fFieldName,fRoleId,FAccessValue,FCreatorID,FCreateTime,FLastUpdateUserId,FLastUpdateTime,FControlUnitID)select newbosid('D8F779CA'),fbizobjecttype,fFieldName,'" + targetRoleId + "',FAccessValue,'" + creatorId + "'," + sqlDate + ",'" + creatorId + "'," + sqlDate + ",'" + controlUnitId + "' from t_pm_fieldAccess fa where FRoleId = '" + roleIDs.get(0).toString() + "' and not exists (SELECT 1  FROM t_pm_fieldAccess fa2 where fa2.FROLEID = '" + targetRoleId + "' and fa2.FFIELDNAME=fa.FFIELDNAME)";
        DbUtil.execute((Context)ctx, (String)fieldAccessSql);
        String grantRoleFieldSql = "";
        grantRoleFieldSql = roleIDs.size() > 1 ? "insert into t_pm_grantrolefield(fid,FRoleId,FFieldName,FBizObjectType)  select newbosid('CBCD0A1C'),'" + targetRoleId + "',FFieldName,FBizObjectType from t_pm_grantrolefield where fid in(select max(fid) from t_pm_grantrolefield gf where gf.FRoleId in(" + ToolUtils.aryToStr(roleIDs) + ")and not exists(SELECT 1 FROM t_pm_grantrolefield gf2 where gf2.FRoleId = '" + targetRoleId + "' and gf2.FFieldName = gf.FFieldName) group by gf.FFieldName)" : "insert into t_pm_grantrolefield(fid,FRoleId,FFieldName,FBizObjectType)  select newbosid('CBCD0A1C'),'" + targetRoleId + "',gf.FFieldName,gf.FBizObjectType from t_pm_grantrolefield gf where gf.FRoleId = '" + roleIDs.get(0).toString() + "' and not exists(select 1 from t_pm_grantrolefield gf2 where FRoleId = '" + targetRoleId + "' and gf2.FFieldName = gf.FFieldName) ";
        DbUtil.execute((Context)ctx, (String)grantRoleFieldSql);
    }
}

