/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RuleException;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.RuleParser;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractRuleControllerBean;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RuleControllerBean
extends AbstractRuleControllerBean {
    private static Logger logger = Logger.getLogger(RuleControllerBean.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanModify(ctx, this.getRuleInfo(ctx, pk));
        this.checkRuleIsUsing(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkRuleIsUsing(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String id = "%" + pk.toString() + "%";
        Object[] params = new Object[]{id, id};
        sql.append("SELECT 1 WHERE EXISTS( ");
        sql.append("SELECT 1 FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FRuleStructure is not null and UserOrgPerm.FRuleStructure LIKE ? ");
        sql.append(" UNION ALL ");
        sql.append("SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE RolePerm.FRuleStructure is not null and RolePerm.FRuleStructure LIKE ? )");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                throw new RuleException(RuleException.RULE_BEEN_REFERED);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RuleException(RuleException.GET_RULE_FAIL, e);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkCanModify(ctx, (RuleInfo)model);
        this.checkNumberDup(ctx, (RuleInfo)model);
        RuleInfo oldRuleInfo = this.getRuleInfo(ctx, pk);
        super._update(ctx, pk, model);
        RuleInfo newRuleInfo = (RuleInfo)model;
        boolean isRuleScriptChanged = this.isRuleScriptChanged(newRuleInfo, oldRuleInfo);
        if (isRuleScriptChanged) {
            this.syncRule(ctx, newRuleInfo, oldRuleInfo);
        }
    }

    private boolean isRuleScriptChanged(RuleInfo newRuleInfo, RuleInfo oldRuleInfo) {
        if (!StringUtils.equals((String)newRuleInfo.getScript(), (String)oldRuleInfo.getScript())) {
            return true;
        }
        if (newRuleInfo.getLogic() != null && !newRuleInfo.getLogic().equals((Object)oldRuleInfo.getLogic())) {
            return true;
        }
        return !StringUtils.equals((String)newRuleInfo.getDataIds(), (String)oldRuleInfo.getDataIds());
    }

    private void syncRule(Context ctx, RuleInfo newRuleInfo, RuleInfo oldRuleInfo) throws BOSException, EASBizException {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entiryInfo = metaDataLoader.getEntity(BOSObjectType.create((String)newRuleInfo.getBizObject()));
        this.syncUserPermRule(ctx, oldRuleInfo, newRuleInfo, entiryInfo);
        this.syncRolePermRule(ctx, oldRuleInfo, newRuleInfo, entiryInfo);
        CacheUtil.clearRuleCache();
    }

    private boolean isModifyEntryRule(String ruleStructure, RuleInfo newRuleInfo, EntityObjectInfo entiryInfo) throws EASBizException, ParserException, BOSException {
        return RuleUtil.isEntryRule(entiryInfo, newRuleInfo) || ruleStructure != null && ruleStructure.indexOf("ENTRYALLWHERE") != -1;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncUserPermRule(Context ctx, RuleInfo oldRuleInfo, RuleInfo newRuleInfo, EntityObjectInfo entiryInfo) throws BOSException, EASBizException {
        ObjectStringPK rulePK = new ObjectStringPK(newRuleInfo.getId().toString());
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String id = "%" + rulePK.toString() + "%";
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT UserOrgPerm.FID, PermItem.FObjectType, UserOrgPerm.FRuleStructure,UserOrgPerm.fOwner,UserOrgPerm.fOrgId,UserOrgPerm.FPermItemID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FRuleStructure is not null and UserOrgPerm.FRuleStructure LIKE ? ");
            cn = this.getConnection(ctx);
            ps = cn.prepareStatement(sql.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            ps = cn.prepareStatement("UPDATE T_PM_UserOrgPerm SET FRuleStructure= ?,FRuleExpr = ? WHERE FID = ? ");
            while (rs.next()) {
                String fID = rs.getString("FID");
                String fOwner = rs.getString("fOwner");
                String fOrgId = rs.getString("fOrgId");
                String fPermItemID = rs.getString("FPermItemID");
                String fObjectType = rs.getString("FObjectType");
                String fRuleStructure = rs.getString("FRuleStructure");
                this.checkRuleIsCanChange(ctx, fOwner, fOrgId, fPermItemID, fRuleStructure, oldRuleInfo, newRuleInfo, entiryInfo);
                RuleParser ruleParser = new RuleParser(ctx, BOSObjectType.create((String)fObjectType));
                ruleParser.setRuleStructure(fRuleStructure);
                ps.setString(1, fRuleStructure);
                ps.setString(2, ruleParser.buildExpr());
                ps.setString(3, fID);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new RuleException(RuleException.RULE_UPDATE_FAIL, e);
                catch (ParserException e2) {
                    logger.error((Object)e2);
                    throw new RuleException(RuleException.RULE_UPDATE_FAIL, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
    }

    private void checkRuleIsCanChange(Context ctx, String userId, String orgId, String permiItemId, String ruleStructure, RuleInfo oldRuleInfo, RuleInfo newRuleInfo, EntityObjectInfo entiryInfo) throws EASBizException, ParserException, BOSException {
        boolean newIsEntry;
        boolean oldIsEntry = RuleUtil.isEntryRule(entiryInfo, oldRuleInfo);
        if (oldIsEntry != (newIsEntry = RuleUtil.isEntryRule(entiryInfo, newRuleInfo))) {
            boolean containHeadAndEntry;
            boolean bl = containHeadAndEntry = ruleStructure.trim().startsWith("WHERE") && (ruleStructure.contains("ENTRYWHERE") || ruleStructure.contains("ENTRYALLWHERE") || ruleStructure.contains("ENTRYANYWHERE"));
            if (containHeadAndEntry) {
                String oldType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                String newType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                if (oldIsEntry) {
                    oldType = EASResource.getString((String)RESOURCE, (String)"ENTRIES");
                    newType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                } else {
                    oldType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                    newType = EASResource.getString((String)RESOURCE, (String)"ENTRIES");
                }
                IUser iuser = UserFactory.getLocalInstance(ctx);
                IFullOrgUnit iorg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                IPermItem iperm = PermItemFactory.getLocalInstance(ctx);
                UserInfo user = iuser.getUserInfo((IObjectPK)new ObjectStringPK(userId));
                FullOrgUnitInfo orgInfo = iorg.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
                PermItemInfo perm = iperm.getPermItemInfo((IObjectPK)new ObjectStringPK(permiItemId));
                throw new PermissionException(PermissionException.USER_PERM_RULE_CHANGE_ERROR, new Object[]{user.getNumber(), orgInfo.getName(), perm.getName(), oldType, newType});
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncRolePermRule(Context ctx, RuleInfo oldRuleInfo, RuleInfo newRuleInfo, EntityObjectInfo entiryInfo) throws BOSException, EASBizException {
        ObjectStringPK rulePK = new ObjectStringPK(newRuleInfo.getId().toString());
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String id = "%" + rulePK.toString() + "%";
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT RolePerm.FID, PermItem.FObjectType, RolePerm.FRuleStructure,RolePerm.FRoleId,RolePerm.FPermItemID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE RolePerm.FRuleStructure is not null and RolePerm.FRuleStructure LIKE ? ");
            cn = this.getConnection(ctx);
            ps = cn.prepareStatement(sql.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            ps = cn.prepareStatement("UPDATE T_PM_RolePerm SET FRuleStructure = ?,FRuleExpr = ? WHERE FID = ? ");
            while (rs.next()) {
                String fid = rs.getString("FID");
                String froleId = rs.getString("FRoleId");
                String fPermItemID = rs.getString("FPermItemID");
                String fObjectType = rs.getString("FObjectType");
                String fRuleStructure = rs.getString("FRuleStructure");
                this.checkRuleIsCanChange(ctx, froleId, fPermItemID, fRuleStructure, oldRuleInfo, newRuleInfo, entiryInfo);
                RuleParser ruleParser = new RuleParser(ctx, BOSObjectType.create((String)fObjectType));
                ruleParser.setRuleStructure(fRuleStructure);
                ps.setString(1, fRuleStructure);
                ps.setString(2, ruleParser.buildExpr());
                ps.setString(3, fid);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new RuleException(RuleException.RULE_UPDATE_FAIL, e);
                catch (ParserException e2) {
                    logger.error((Object)e2);
                    throw new RuleException(RuleException.RULE_UPDATE_FAIL, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
    }

    private void checkRuleIsCanChange(Context ctx, String roleId, String permiItemId, String ruleStructure, RuleInfo oldRuleInfo, RuleInfo newRuleInfo, EntityObjectInfo entiryInfo) throws EASBizException, ParserException, BOSException {
        boolean newIsEntry;
        boolean oldIsEntry = RuleUtil.isEntryRule(entiryInfo, oldRuleInfo);
        if (oldIsEntry != (newIsEntry = RuleUtil.isEntryRule(entiryInfo, newRuleInfo))) {
            boolean containHeadAndEntry;
            boolean bl = containHeadAndEntry = ruleStructure.trim().startsWith("WHERE") && (ruleStructure.contains("ENTRYWHERE") || ruleStructure.contains("ENTRYALLWHERE") || ruleStructure.contains("ENTRYANYWHERE"));
            if (containHeadAndEntry) {
                String oldType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                String newType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                if (oldIsEntry) {
                    oldType = EASResource.getString((String)RESOURCE, (String)"ENTRIES");
                    newType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                } else {
                    oldType = EASResource.getString((String)RESOURCE, (String)"GAUGE_OUTFIT");
                    newType = EASResource.getString((String)RESOURCE, (String)"ENTRIES");
                }
                IRole iRole = RoleFactory.getLocalInstance(ctx);
                IPermItem iperm = PermItemFactory.getLocalInstance(ctx);
                RoleInfo role = iRole.getRoleInfo((IObjectPK)new ObjectStringPK(roleId));
                PermItemInfo perm = iperm.getPermItemInfo((IObjectPK)new ObjectStringPK(permiItemId));
                throw new PermissionException(PermissionException.ROLE_PERM_RULE_CHANGE_ERROR, new Object[]{role.getName(), perm.getName(), oldType, newType});
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (RuleInfo)model);
        return super._addnew(ctx, model);
    }

    protected void checkNumberDup(Context ctx, RuleInfo ruleInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)ruleInfo.getNumber()));
        if (ruleInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ruleInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            Object[] objects = new Object[]{ruleInfo.getNumber()};
            throw new RuleException(RuleException.NUMBER_IS_DUPLICATED, objects);
        }
    }

    private void checkCanModify(Context ctx, RuleInfo ruleInfo) throws BOSException, EASBizException {
        if (!ruleInfo.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()) && !Administrator.isCUAdmin(ctx, ctx.getCaller())) {
            Object[] params = new Object[]{ruleInfo.getNumber()};
            throw new PermissionException(PermissionException.CAN_NOT_MODIFY_OTHER_CU_DATA, params);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RuleInfo ruleInfo = this.getRuleInfo(ctx, pk);
        return ruleInfo.getNumber() + " " + ruleInfo.getName();
    }

    @Override
    protected String _buidRuleExpr(Context ctx, String bizObjType, String ruleStructure) throws BOSException, EASBizException {
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bizObjType));
            RuleParser ruleParser = new RuleParser(entity);
            ruleParser.setRuleStructure(ruleStructure);
            return ruleParser.buildExpr();
        }
        catch (ParserException pe) {
            logger.error((Object)"parse error!", (Throwable)pe);
            return "";
        }
    }

    @Override
    protected void _checkRuleExpr(Context ctx, String ruleExpr, String objectType) throws BOSException, EASBizException {
        try {
            EntityViewInfo ruleEntityView = new EntityViewInfo(ruleExpr);
            ImplUtils.processEntryFilter((BOSObjectType)new BOSObjectType(objectType), (EntityViewInfo)ruleEntityView, (Context)ctx);
        }
        catch (Exception e) {
            throw new PermissionException(PermissionException.PERMISSIONRULEERROR, new Object[]{""});
        }
    }
}

