/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.OwnerExceptPermitemInfo;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SpecialDataPermServerHelper {
    private static final Logger logger = Logger.getLogger(SpecialDataPermServerHelper.class);

    public static List getOldSpecialDirectorPermList(Context ctx) throws BOSException, EASBizException {
        String sql = "select a.FID FID,a.fbizObjectType bizObjectType,a.FControlUnitID cu from T_PM_SpecialDataPerm a left join T_PM_SpecialDirectorPermitem b on a.fbizObjectType=b.FObjType and a.FControlUnitID=b.FControlUnitID where b.fid is null";
        Connection con = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        ArrayList<SpecialDataPermInfo> specialDataPermList = new ArrayList<SpecialDataPermInfo>();
        try {
            con = EJBFactory.getConnection((Context)ctx);
            state = con.prepareStatement(sql);
            rs = state.executeQuery();
            while (rs.next()) {
                SpecialDataPermInfo info = new SpecialDataPermInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setBizObjectType(rs.getString("bizObjectType"));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rs.getString("cu")));
                info.setCU(cu);
                specialDataPermList.add(info);
            }
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"upgradeSpecialDirector error:", (Throwable)se);
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, state, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)con);
        return specialDataPermList;
    }

    public static List getOldOwnerExceptPermList(Context ctx) throws BOSException, EASBizException {
        String sql = "select a.FID FID,a.fbizObjectType bizObjectType,a.FControlUnitID cu from T_PM_SpecialDataPerm a left join T_PM_OwnerExceptPermitem b on a.FControlUnitID=b.FControlUnitID and a.fbizObjectType=b.FObjType where b.fid is null";
        Connection con = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        ArrayList<SpecialDataPermInfo> specialDataPermInfo = new ArrayList<SpecialDataPermInfo>();
        try {
            con = EJBFactory.getConnection((Context)ctx);
            state = con.prepareStatement(sql);
            rs = state.executeQuery();
            while (rs.next()) {
                SpecialDataPermInfo info = new SpecialDataPermInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setBizObjectType(rs.getString("bizObjectType"));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rs.getString("cu")));
                info.setCU(cu);
                specialDataPermInfo.add(info);
            }
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"upgradeSpecialDirector error:", (Throwable)se);
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, state, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)con);
        return specialDataPermInfo;
    }

    public static List getNewSpecialDirectorPermList(Context ctx, List oldSpecialDataPermList) throws BOSException, EASBizException {
        if (oldSpecialDataPermList == null || oldSpecialDataPermList.size() < 1) {
            return new ArrayList();
        }
        HashSet<String> entitySet = new HashSet<String>();
        for (int i = 0; i < oldSpecialDataPermList.size(); ++i) {
            entitySet.add(((SpecialDataPermInfo)oldSpecialDataPermList.get(i)).getBizObjectType());
        }
        Map entityTypePermItemMap = SpecialDataPermServerHelper.getObjectTypeAndPermItemMap(ctx, entitySet);
        ArrayList<SpecialDirectorPermitemInfo> newDirectorPermList = new ArrayList<SpecialDirectorPermitemInfo>();
        for (int i = 0; i < oldSpecialDataPermList.size(); ++i) {
            SpecialDataPermInfo info = (SpecialDataPermInfo)oldSpecialDataPermList.get(i);
            Set perms = (Set)entityTypePermItemMap.get(info.getBizObjectType());
            if (perms == null) continue;
            Iterator itr = perms.iterator();
            while (itr.hasNext()) {
                String permId = itr.next().toString();
                SpecialDirectorPermitemInfo newInfo = new SpecialDirectorPermitemInfo();
                PermItemInfo perm = new PermItemInfo();
                perm.setId(BOSUuid.read((String)permId));
                newInfo.setPermItem(perm);
                newInfo.setCU(info.getCU());
                newInfo.setObjType(info.getBizObjectType());
                newDirectorPermList.add(newInfo);
            }
        }
        return newDirectorPermList;
    }

    public static List getNewOwnerExceptPermList(Context ctx, List oldSpecialDataPermList) throws BOSException, EASBizException {
        if (oldSpecialDataPermList == null || oldSpecialDataPermList.size() < 1) {
            return new ArrayList();
        }
        HashSet<String> entitySet = new HashSet<String>();
        for (int i = 0; i < oldSpecialDataPermList.size(); ++i) {
            entitySet.add(((SpecialDataPermInfo)oldSpecialDataPermList.get(i)).getBizObjectType());
        }
        Map entityTypePermItemMap = SpecialDataPermServerHelper.getObjectTypeAndPermItemMap(ctx, entitySet);
        ArrayList<OwnerExceptPermitemInfo> newOwnerExceptPermList = new ArrayList<OwnerExceptPermitemInfo>();
        for (int i = 0; i < oldSpecialDataPermList.size(); ++i) {
            SpecialDataPermInfo info = (SpecialDataPermInfo)oldSpecialDataPermList.get(i);
            Set perms = (Set)entityTypePermItemMap.get(info.getBizObjectType());
            if (perms == null) continue;
            Iterator itr = perms.iterator();
            while (itr.hasNext()) {
                String permId = itr.next().toString();
                OwnerExceptPermitemInfo newInfo = new OwnerExceptPermitemInfo();
                PermItemInfo perm = new PermItemInfo();
                perm.setId(BOSUuid.read((String)permId));
                newInfo.setPermItem(perm);
                newInfo.setCU(info.getCU());
                newInfo.setObjType(info.getBizObjectType());
                newOwnerExceptPermList.add(newInfo);
            }
        }
        return newOwnerExceptPermList;
    }

    public static void addSpecialDirectorPermBatch(Context ctx, List directorPermList) throws BOSException, EASBizException {
        String sql = "insert into T_PM_SpecialDirectorPermitem(FID,FPermItemID,FPermType,FControlUnitID,FObjType) values(?,?,?,?,?)";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            BOSObjectType specialDirectorPermitemType = new SpecialDirectorPermitemInfo().getBOSType();
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(sql);
            for (int i = 0; i < directorPermList.size(); ++i) {
                SpecialDirectorPermitemInfo info = (SpecialDirectorPermitemInfo)directorPermList.get(i);
                ps.setString(1, BOSUuid.create((BOSObjectType)specialDirectorPermitemType).toString());
                ps.setString(2, info.getPermItem().getId().toString());
                ps.setInt(3, 10);
                ps.setString(4, info.getCU().getId().toString());
                ps.setString(5, info.getObjType());
                ps.addBatch();
                if (i <= 0 || i % 2000 != 0) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"addSpecialDirectorPermBatch error:", (Throwable)se);
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    public static void addOwnerExceptPermBatch(Context ctx, List ownerExceptPermList) throws BOSException, EASBizException {
        String sql = "insert into T_PM_OwnerExceptPermitem(FID,FPermItemID,FPermType,FControlUnitID,FObjType) values(?,?,?,?,?)";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            BOSObjectType ownerExceptPermitemType = new OwnerExceptPermitemInfo().getBOSType();
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(sql);
            for (int i = 0; i < ownerExceptPermList.size(); ++i) {
                OwnerExceptPermitemInfo info = (OwnerExceptPermitemInfo)ownerExceptPermList.get(i);
                ps.setString(1, BOSUuid.create((BOSObjectType)ownerExceptPermitemType).toString());
                ps.setString(2, info.getPermItem().getId().toString());
                ps.setInt(3, 10);
                ps.setString(4, info.getCU().getId().toString());
                ps.setString(5, info.getObjType());
                ps.addBatch();
                if (i <= 0 || i % 2000 != 0) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"addSpecialDirectorPermBatch error:", (Throwable)se);
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    public static Map getObjectTypeAndPermItemMap(Context ctx, Collection entityCol) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        if (entityCol == null || entityCol.size() < 1) {
            return ret;
        }
        IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
        String entityStr = ToolUtils.aryToStr(entityCol);
        String oql = "SELECT id, objectType WHERE objectType IS NOT NULL AND enableDataPermission = 1 AND operationType <> 'ADDNEW' and objectType in (" + entityStr + ")";
        PermItemCollection allPermItems = iPermItem.getPermItemCollection(oql);
        HashMap map = new HashMap();
        int size = allPermItems.size();
        for (int i = 0; i < size; ++i) {
            Set<String> permItems;
            PermItemInfo permItemInfo = allPermItems.get(i);
            String objectType = permItemInfo.getObjectType();
            if (StringUtils.isEmpty((String)objectType)) continue;
            if (map.containsKey(objectType)) {
                permItems = (Set)map.get(objectType);
                permItems.add(permItemInfo.getId().toString());
                continue;
            }
            permItems = new HashSet();
            permItems.add(permItemInfo.getId().toString());
            map.put(objectType, permItems);
        }
        return map;
    }

    public static void upgradeSpecialDirector(Context ctx) throws BOSException, EASBizException {
        List directorPermList = SpecialDataPermServerHelper.getOldSpecialDirectorPermList(ctx);
        if (directorPermList.size() > 0) {
            List newDirectorPermList = SpecialDataPermServerHelper.getNewSpecialDirectorPermList(ctx, directorPermList);
            SpecialDataPermServerHelper.addSpecialDirectorPermBatch(ctx, newDirectorPermList);
        }
    }

    public static void upgradeOwnerPermExcept(Context ctx) throws BOSException, EASBizException {
        List ownerExceptPermList = SpecialDataPermServerHelper.getOldOwnerExceptPermList(ctx);
        if (ownerExceptPermList.size() > 0) {
            List newOwnerExceptPermList = SpecialDataPermServerHelper.getNewOwnerExceptPermList(ctx, ownerExceptPermList);
            SpecialDataPermServerHelper.addOwnerExceptPermBatch(ctx, newOwnerExceptPermList);
        }
    }
}

