/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.SpecialDirectorPermCollection;
import com.kingdee.eas.base.permission.app.AbstractSpecialDirectorPermControllerBean;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecialDirectorPermControllerBean
extends AbstractSpecialDirectorPermControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.SpecialDirectorPermControllerBean");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected SpecialDirectorPermCollection _getSpecialDirectorCol(Context ctx, List bizObjectTypeList, IObjectPK cuOrgPK) throws BOSException, EASBizException {
        if (bizObjectTypeList == null || bizObjectTypeList.isEmpty()) {
            return new SpecialDirectorPermCollection();
        }
        String oql = "select *,userOrgRange.*,userOrgRange.user.*, userOrgRange.org.* where bizObjectType in (" + ToolUtils.aryToStr(bizObjectTypeList, true) + ") and CU.id = '" + cuOrgPK.toString() + "'";
        return this.getSpecialDirectorPermCollection(ctx, oql);
    }

    @Override
    protected void _save(Context ctx, List bizObjectTypeList, List userOrg, IObjectPK cuOrgPK) throws BOSException, EASBizException {
        IOrgRange iorgRange = OrgRangeFactory.getLocalInstance(ctx);
        HashSet<String> orgRangeIdListSet = new HashSet<String>();
        OrgRangeCollection orgRangeColl = new OrgRangeCollection();
        for (int i = 0; i < userOrg.size(); ++i) {
            Map data = (Map)userOrg.get(i);
            OrgRangeCollection coll = iorgRange.getOrgRangeCollection("select id,user.number,org.name where user.id='" + (String)data.get("userId") + "' and org.id = '" + (String)data.get("orgId") + "' and type = 20");
            if (coll == null || coll.isEmpty()) continue;
            orgRangeIdListSet.add(coll.get(0).getId().toString());
            orgRangeColl.addCollection(coll);
        }
        ArrayList orgRangeIdList = new ArrayList(orgRangeIdListSet);
        if (bizObjectTypeList == null || bizObjectTypeList.isEmpty()) {
            return;
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"SPECIAL_DATA_MANAGE"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)this.getLogDetail(ctx, bizObjectTypeList, orgRangeColl, cuOrgPK), (String)"bs_permission_specialDataPerm_setDirector");
        this.delExceptionUser(ctx, bizObjectTypeList, orgRangeIdList, cuOrgPK.toString());
        if (orgRangeIdList == null || orgRangeIdList.isEmpty()) {
            CacheUtil.clearRuleCache();
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            return;
        }
        String sql = "insert into T_PM_SpecialDirectorPerm(fid,FUserOrgRangeID,FBizObjectType,FControlUnitID) values(?,?,?,?)";
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            this.addNewExpectUser(ps, bizObjectTypeList, orgRangeIdList, cuOrgPK.toString());
            ps.executeBatch();
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("sql error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
        CacheUtil.clearRuleCache();
    }

    private String getLogDetail(Context ctx, List objTypeList, OrgRangeCollection orgRangeColl, IObjectPK cuOrgPK) {
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            sb.append(EASResource.getString((String)RESOURCE, (String)"ON_CTRLUNIT"));
            FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select name where id = '" + cuOrgPK + "'");
            sb.append(orgUnitInfo.getName()).append("): " + EASResource.getString((String)RESOURCE, (String)"BILL1"));
            for (i = 0; i < objTypeList.size(); ++i) {
                String entityType = objTypeList.get(i).toString();
                EntityObjectInfo entity = loader.getEntity(new BOSObjectType(entityType));
                sb.append(entity.getAlias());
                sb.append(i == objTypeList.size() - 1 ? " " : ",");
            }
            sb.append(")").append(EASResource.getString((String)RESOURCE, (String)"DESIGN_SUPERVISOR") + "(");
            for (i = 0; i < orgRangeColl.size(); ++i) {
                sb.append(orgRangeColl.get(i).getUser().getNumber());
                sb.append(i == orgRangeColl.size() - 1 ? " " : ",");
            }
            sb.append(")");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sb.toString();
    }

    private void delExceptionUser(Context ctx, List objTypeList, List orgRangeIdList, String cuId) throws BOSException {
        String sql = " delete from T_PM_SpecialDirectorPerm where  FBizObjectType in (" + ToolUtils.aryToStr(objTypeList, true) + ")and FControlUnitID = '" + cuId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void addNewExpectUser(PreparedStatement ps, List objTypeList, List orgRangeIdList, String cuId) throws SQLException {
        for (int index = 0; index < objTypeList.size(); ++index) {
            for (int userIndex = 0; userIndex < orgRangeIdList.size(); ++userIndex) {
                ps.setString(1, BOSUuid.create((BOSObjectType)this.getBOSType()).toString());
                ps.setString(2, orgRangeIdList.get(userIndex).toString());
                ps.setString(3, objTypeList.get(index).toString());
                ps.setString(4, cuId);
                ps.addBatch();
            }
        }
    }
}

