/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.app.AbstractUserAuthenWayChangeFacadeControllerBean;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UserAuthenWayChangeFacadeControllerBean
extends AbstractUserAuthenWayChangeFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserAuthenWayChangeFacadeControllerBean");

    @Override
    protected void _userAuthenWayChange(Context ctx, List userList, int userAuthenWayChangeState, String authenWayChangeDesc) throws BOSException, EASBizException {
        if (userList == null || userList.size() == 0) {
            return;
        }
        boolean isEnabledAuthen = PermissionParameterFactory.getLocalInstance(ctx).isAuthenticateAdminEnabled();
        if (!isEnabledAuthen) {
            return;
        }
        String insertSql = "INSERT INTO T_PM_AuthenRecord(FAuthentorID,FID,FPermChangeID,FAuthenStatus,FDescription,FCU) values(?,?,?,?,?,?) ";
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        UserCollection userCollection = UserFactory.getLocalInstance(ctx).getUserCollection("select * where id in (" + ToolUtils.aryToStr(userList) + ")");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList = new ArrayList();
        for (int i = 0; i < userCollection.size(); ++i) {
            UserInfo userInfo = userCollection.get(i);
            String ctrlUnitId = userInfo.getCU().getId().toString();
            List<String> authentorList = this.getAuthentorByCtrlUnit(ctx, ctrlUnitId);
            if (authentorList == null || authentorList.isEmpty()) continue;
            String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, "60", userInfo.getNumber(), userInfo.getName(), "user");
            for (String authentodId : authentorList) {
                Object[] params = new Object[]{authentodId, BOSUuid.create((String)"B0E636B6").toString(), permChangeId, "10", authenWayChangeDesc, ctrlUnitId};
                paramsList.add(params);
                AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, authentodId);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
    }

    private List<String> getAuthentorByCtrlUnit(Context ctx, String ctrlUnit) throws BOSException {
        ArrayList<String> authentorList = new ArrayList<String>();
        String sql = "SELECT FID FROM T_PM_USER WHERE FType=60 AND FID IN(SELECT DISTINCT FUserId FROM T_PM_OrgRange WHERE FType=10 AND FOrgid='" + ctrlUnit + "')";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                authentorList.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return authentorList;
    }
}

