/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermCacheFacadeFactory;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionManagerException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermException;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermIdInfo;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.AbstractUserOrgPermFacadeControllerBean;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.helper.PermCacheHelper;
import com.kingdee.eas.base.permission.app.helper.SavePermCallBackThread;
import com.kingdee.eas.base.permission.app.helper.UserPermHelper;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.FilterHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.app.util.interior.permgroup.UserPermChangeListener;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.app.MainMenuQuickHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class UserOrgPermFacadeControllerBean
extends AbstractUserOrgPermFacadeControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserOrgPermFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private PermItemInfo rootPermItem = null;
    private static final int maxBatchAccreditNumber = 30000;
    private UserOrgPermCollection auto_coll = null;
    private UserOrgPermCollection norm_coll = null;
    private UserOrgPermCollection forb_coll = null;

    private StringBuffer getAuthorizedFilter(IObjectPK sourceUserPK, FullOrgUnitCollection orgCol, List listParams, String joinField) {
        StringBuffer sql = new StringBuffer();
        sql.append(" AND (                                                              \r\n");
        sql.append(" EXISTS(                                                            \r\n");
        sql.append(" SELECT uop2.FPermItemID                                            \r\n");
        sql.append(" FROM T_PM_UserOrgPerm uop2                                         \r\n");
        sql.append(" WHERE uop2.FOwner = ?                                              \r\n");
        listParams.add(sourceUserPK.toString());
        sql.append(" AND uop2.FPermType = ").append(30).append("  \r\n");
        List orgIdList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                FullOrgUnitInfo it = (FullOrgUnitInfo)obj;
                if (it.isIsUnion() && it.getMaintainCU() != null) {
                    return it.getMaintainCU().getId().toString();
                }
                return it.getCU().getId().toString();
            }
        });
        orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
        sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
        sql.append(" AND (uop2.FPermItemID = " + joinField + " )  \r\n");
        sql.append(" )  \r\n");
        sql.append(" OR EXISTS(                                                    \r\n");
        sql.append(" SELECT rolePerm.FPermItemID                                        \r\n");
        sql.append(" FROM T_PM_RolePerm rolePerm                                        \r\n");
        sql.append(" INNER JOIN T_PM_UserRoleOrg userRoleOrg                            \r\n");
        sql.append(" \tON userRoleOrg.FRoleID = rolePerm.FRoleID                       \r\n");
        sql.append(" WHERE userRoleOrg.FUserID = ?                                      \r\n");
        listParams.add(sourceUserPK.toString());
        sql.append(" AND rolePerm.FPermType = ").append(30).append("  \r\n");
        List orgIdListForRole = ToolUtils.orgCol2List(orgCol);
        sql.append(this.getOrgIdFilter(orgIdListForRole, "FOrgID", listParams));
        sql.append(" AND (rolePerm.FPermItemID = " + joinField + " )  \r\n");
        sql.append(" ))  \r\n");
        return sql;
    }

    private boolean hasUnionOrg(FullOrgUnitCollection orgCol) throws EASBizException, BOSException {
        boolean ret = false;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        if (orgCol == null || orgCol.size() == 0) {
            return ret;
        }
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            fullOrgUnitInfo = orgCol.get(i);
            if (!fullOrgUnitInfo.isIsUnion()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private UserOrgPermCollection filterCslrptPermItem(UserOrgPermCollection uops) {
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (uops != null) {
            Set cslrptPermItemNames = ConfigurationLoader.getInstance().getConfigurationInfo().getCslrptPermItemNames();
            int size = uops.size();
            for (int i = 0; i < size; ++i) {
                PermItemInfo permInfo = uops.get(i).getPermItem();
                if (cslrptPermItemNames.contains(permInfo.getNumber()) || cslrptPermItemNames.contains(permInfo.getName())) continue;
                result.add(uops.get(i));
            }
        }
        return result;
    }

    private List<Object[]> getAddUOPBatchParams(UserOrgPermCollection uops) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        BOSObjectType objectType = this.getBOSType();
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            Object[] params = new Object[8];
            UserOrgPermInfo info = uops.get(i);
            params[0] = BOSUuid.create((BOSObjectType)objectType).toString();
            params[1] = info.getOwner().getId().toString();
            params[2] = info.getOrg().getId().toString();
            params[3] = info.getPermItem().getId().toString();
            params[4] = info.getPermType().getValue();
            params[5] = info.getRuleStructure();
            params[6] = info.getRuleExpr();
            params[7] = info.getCtrlUnit().getId().toString();
            ret.add(params);
        }
        return ret;
    }

    private List<Object[]> getUpdateUOPBatchParams(UserOrgPermCollection uops) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            Object[] params = new Object[6];
            UserOrgPermInfo info = uops.get(i);
            params[0] = info.getRuleStructure();
            params[1] = info.getRuleExpr();
            params[2] = info.getUserId();
            params[3] = OrgType.NONE.equals((Object)info.getPermItem().getOrgRelation()) ? "11111111-1111-1111-1111-111111111111CCE7AED4" : info.getOrgId();
            params[4] = info.getPermItemId();
            params[5] = info.getPermType().getValue();
            ret.add(params);
        }
        return ret;
    }

    private Set createUOPSet(UserOrgPermCollection uops) {
        HashSet<String> set = new HashSet<String>(10000);
        if (uops == null) {
            return set;
        }
        UserOrgPermInfo uopInfo = null;
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            uopInfo = uops.get(i);
            set.add(PermissionCommonUtil.getKey(uopInfo));
        }
        return set;
    }

    private Map createUOPMap(UserOrgPermCollection uops) {
        HashMap<String, UserOrgPermInfo> map = new HashMap<String, UserOrgPermInfo>();
        UserOrgPermInfo uopInfo = null;
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            uopInfo = uops.get(i);
            map.put(PermissionCommonUtil.getKey(uopInfo), uopInfo);
        }
        return map;
    }

    private void handleCallBack(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPK(userPK);
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    private void cleanPermissionCache(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        PermCacheFacadeFactory.getLocalInstance(ctx).removeAllPermCacheByUser(userPK.toString());
        CacheUtil.clearCache4User(userPK);
    }

    private boolean isRuleChanged(String ruleA, String ruleB) {
        if (StringUtils.isEmpty((String)ruleA) || StringUtils.isEmpty((String)ruleB)) {
            return !StringUtils.isEmpty((String)ruleA) || !StringUtils.isEmpty((String)ruleB);
        }
        return !ruleA.equals(ruleB);
    }

    @Override
    protected UserOrgPermCollection _getTopSourceUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, boolean isBatch, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        try {
            if (Administrator.isCUAdmin(ctx, sourceUserPK)) {
                return this.getTopSourceUOPs4CUAdmin(ctx, sourceUserPK, userPK, orgCol, permType);
            }
            return this.getTopSourceUOPs4Normal(ctx, sourceUserPK, userPK, orgCol, isBatch, permType);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
    }

    @Override
    protected UserOrgPermCollection _getSourceUOPS(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, boolean isBatch, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        Object[] permsDirRt = this.getPermsDir(ctx);
        Map permsDir = (Map)permsDirRt[0];
        List permsDirOrder = (List)permsDirRt[1];
        Map<Object, Object> leafPerms = new HashMap();
        leafPerms = Administrator.isCUAdmin(ctx, sourceUserPK) ? this.getSourceUOPs4CUAdmin(ctx, orgCol, permType) : this.getSourceUOPsBizAdmin(ctx, sourceUserPK, orgCol, isBatch, permType);
        List<PermItemInfo> sourceTreePermData = this.comBineLeafAndDirPerms(permsDirOrder, permsDir, leafPerms);
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        UserOrgPermCollection result = this.transmitToUserOrgPermColl(sourceTreePermData, userInfo, orgCol.get(0), permType);
        return result;
    }

    @Override
    protected UserOrgPermCollection _getTargetUOPS(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, boolean isOr, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        Object[] permsDirRt = this.getPermsDir(ctx);
        Map permsDir = (Map)permsDirRt[0];
        List permsDirOrder = (List)permsDirRt[1];
        HashMap<String, PermItemInfo> leafPerms = new HashMap();
        ObjectStringPK orgPk = new ObjectStringPK(orgCol.get(0).getId().toString());
        leafPerms = this.getTargetUOPs(ctx, userPK, (IObjectPK)orgPk, permType);
        List<PermItemInfo> sourceTreePermData = this.comBineLeafAndDirPerms(permsDirOrder, permsDir, leafPerms);
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)orgPk);
        return this.transmitToUserOrgPermColl(sourceTreePermData, userInfo, fullOrgUnitInfo, permType);
    }

    protected UserOrgPermCollection getCurUOPS(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, Integer[] permTypes) throws EASBizException, BOSException {
        UserOrgPermCollection uops = new UserOrgPermCollection();
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        for (Integer permType : permTypes) {
            for (int i = 0; i < orgCol.size(); ++i) {
                ObjectUuidPK orgPK = new ObjectUuidPK(orgCol.get(i).getId());
                FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)orgPK);
                Map<String, PermItemInfo> leafPerms = this.getTargetUOPs(ctx, userPK, (IObjectPK)orgPK, permType);
                uops.addCollection(this.transmitToUserOrgPermColl(leafPerms.values(), userInfo, fullOrgUnitInfo, permType));
            }
        }
        return uops;
    }

    private List<PermItemInfo> comBineLeafAndDirPerms(List<PermItemInfo> dirPermsOrder, Map<String, PermItemInfo> dirPerms, Map<String, PermItemInfo> leafPerms) {
        Set<String> leafPermKeys = leafPerms.keySet();
        HashMap<String, PermItemInfo> needdirPerms = new HashMap<String, PermItemInfo>();
        for (String key : leafPermKeys) {
            PermItemInfo parant = leafPerms.get(key).getParent();
            while (parant != null) {
                String dirKey = parant.getId().toString();
                if (!needdirPerms.containsKey(dirKey)) {
                    parant = dirPerms.get(dirKey);
                    needdirPerms.put(dirKey, parant);
                }
                if (parant == null) continue;
                parant = parant.getParent();
            }
        }
        Iterator<PermItemInfo> iter = dirPermsOrder.iterator();
        while (iter.hasNext()) {
            PermItemInfo permDir = iter.next();
            if (needdirPerms.containsKey(permDir.getId().toString())) continue;
            iter.remove();
        }
        dirPermsOrder.addAll(leafPerms.values());
        return dirPermsOrder;
    }

    private List<PermItemInfo> comBineLeafAndDirPermsAddFlag(List<PermItemInfo> baseDirPermsOrder, Map<String, PermItemInfo> baseDirPermsMap, Map<String, PermItemInfo> sourceLeafPerms, Map<String, PermItemInfo> targetLeafPerms) {
        Set<String> leafPermKeys = sourceLeafPerms.keySet();
        HashMap<String, PermItemInfo> needdirPerms = new HashMap<String, PermItemInfo>();
        block0: for (String key : leafPermKeys) {
            boolean isContain = false;
            if (targetLeafPerms.containsKey(key)) {
                isContain = true;
            }
            PermItemInfo permItemInfo = sourceLeafPerms.get(key);
            permItemInfo.setExtendedProperty("flag", isContain ? "1" : "0");
            for (PermItemInfo parant = permItemInfo.getParent(); parant != null; parant = parant.getParent()) {
                String flag;
                String dirKey = parant.getId().toString();
                if ((parant = (PermItemInfo)needdirPerms.get(dirKey)) == null) {
                    parant = baseDirPermsMap.get(dirKey);
                    if (parant == null) {
                        logger.error((Object)("permitemn.id:" + permItemInfo.getId().toString() + "\u7236\u8282\u70b9permitem.id:" + dirKey + "\u4e0d\u5b58\u5728!"));
                        continue block0;
                    }
                    needdirPerms.put(dirKey, parant);
                }
                if ((flag = parant.getExtendedProperty("flag")) != null && !"0".equals(flag) || !isContain) continue;
                parant.setExtendedProperty("flag", "1");
            }
        }
        Iterator<PermItemInfo> iter = baseDirPermsOrder.iterator();
        while (iter.hasNext()) {
            PermItemInfo permDir = iter.next();
            if (needdirPerms.containsKey(permDir.getId().toString())) continue;
            iter.remove();
        }
        baseDirPermsOrder.addAll(sourceLeafPerms.values());
        return baseDirPermsOrder;
    }

    private UserOrgPermCollection transmitToUserOrgPermColl(Collection<PermItemInfo> perms, UserInfo owner, FullOrgUnitInfo org, int permType) {
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        for (PermItemInfo permItemInfo : perms) {
            UserOrgPermInfo uop = new UserOrgPermInfo();
            uop.setOwner(owner);
            uop.setOrg(org);
            uop.setPermType(PermType.getEnum(permType));
            uop.setPermItem(permItemInfo);
            uop.setRuleExpr(permItemInfo.getExtendedProperty("FRuleExpr"));
            uop.setRuleStructure(permItemInfo.getExtendedProperty("FRuleStructure"));
            String userOrgId = permItemInfo.getString("userOrgId");
            if (!StringUtils.isEmpty((String)userOrgId)) {
                uop.setId(BOSUuid.read((String)userOrgId));
            }
            userOrgPerms.add(uop);
        }
        return userOrgPerms;
    }

    private Object[] getPermsDir(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
        sql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber,FLongIndex, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 ").append(" from T_PM_PermItem where FIsLeaf =0 ").append(this.getPermTypeFilter("FType")).append(" order by FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, PermItemInfo> permsMap = new HashMap<String, PermItemInfo>();
        LinkedList<PermItemInfo> orderList = new LinkedList<PermItemInfo>();
        try {
            while (rs.next()) {
                PermItemInfo permInfo = new PermItemInfo();
                String id = rs.getString("FID");
                permInfo.setId(BOSUuid.read((String)id));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                permsMap.put(id, permInfo);
                orderList.add(permInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        Object[] rt = new Object[]{permsMap, orderList};
        return rt;
    }

    private UserOrgPermCollection getTopSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        return this.getSourceUOPs4CUAdmin(ctx, sourceUserPK, userPK, orgCol, null, permType);
    }

    private UserOrgPermCollection getTopSourceUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, boolean isBatch, int permType) throws BOSException, EASBizException {
        return this.getSourceUOPs4Normal(ctx, sourceUserPK, userPK, orgCol, null, isBatch, permType);
    }

    @Override
    protected UserOrgPermCollection _getTopTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        return this.getTargetUOPs(ctx, sourceUserPK, userPK, orgCol, null, permType);
    }

    @Override
    protected UserOrgPermCollection _getTopViewUOPs(Context ctx, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        return this.getViewUOPs(ctx, userPK, orgCol, null, permType);
    }

    @Override
    protected UserOrgPermCollection _getLevelViewUOPs(Context ctx, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        return this.getViewUOPs(ctx, userPK, orgCol, parentPerm, permType);
    }

    @Override
    protected UserOrgPermCollection _getLevelSourceUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, boolean isBatch, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        try {
            if (Administrator.isCUAdmin(ctx, sourceUserPK)) {
                return this.getLevelSourceUOPs4CUAdmin(ctx, sourceUserPK, userPK, orgCol, parentPerm, permType);
            }
            return this.getLevelSourceUOPs4Normal(ctx, sourceUserPK, userPK, orgCol, parentPerm, isBatch, permType);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
    }

    @Override
    protected Set _getHasAccreditedPermSet(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, List permItemIdList, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        HashSet result = new HashSet();
        ArrayList listParams = new ArrayList();
        if (userPK == null || orgCol == null) {
            return result;
        }
        PermItemInfo permItemInfo = null;
        if (permItemIdList.size() > 0) {
            String parentPermId = permItemIdList.get(0).toString();
            permItemInfo = PermItemFactory.getLocalInstance(ctx).getPermItemInfo((IObjectPK)new ObjectUuidPK(parentPermId));
        }
        Set<String> coll = this._getHasAccreditedPermSet(ctx, userPK, orgCol, permItemInfo, permType);
        return coll;
    }

    protected Set<String> _getHasAccreditedPermSet(Context ctx, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        HashSet<String> result = new HashSet<String>();
        ArrayList listParams = new ArrayList();
        if (userPK == null || orgCol == null) {
            return result;
        }
        try {
            String parentPermLongNumber = this.getRootPermItem(ctx).getLongNumber();
            if (parentPerm != null) {
                parentPermLongNumber = parentPerm.getLongNumber();
            }
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            StringBuffer unionHeadSql = new StringBuffer();
            String unionTailSql = " ";
            if (parentPerm == null) {
                StringBuffer rootPermSql = new StringBuffer();
                rootPermSql.append("SELECT FID FROM T_PM_PermItem WHERE FParentID is null");
                sql.append(rootPermSql);
                sql.append(" UNION ALL                  \r\n");
                sql.append(" SELECT distinct pitem1.FID \r\n");
            } else {
                sql.append(" SELECT pitem1.FID \r\n");
            }
            sql.append(" FROM T_PM_PermItem pitem1      \r\n");
            sql.append(" INNER JOIN     \r\n");
            sql.append(" (SELECT substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2);
            if (parentPerm == null) {
                sql.append(")-1) as FLongNumber from T_PM_PermItem ipitem  \r\n");
            } else {
                sql.append(")-1) as FLongNumber from T_PM_PermItem ipitem  \r\n");
            }
            sql.append("  INNER JOIN  T_PM_UserOrgPerm iuop   \r\n");
            sql.append(" ON ipitem.FID = iuop.FPermItemID                                 \r\n");
            sql.append(" WHERE iuop.FOwner = '" + userPK.toString() + "' \r\n");
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'  \r\n");
            if (permType != 0) {
                sql.append(" AND iuop.FPermType = " + permType + "   \r\n");
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(") uop on pitem1.FLongNumber = uop.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%' \r\n");
            sql.append(" WHERE 1=1        \r\n");
            if (parentPerm != null) {
                sql.append(" AND pitem1.FParentID = '" + parentPerm.getId().toString() + "' ");
            }
            sql.append(" UNION ALL    \r\n");
            if (parentPerm == null) {
                sql.append(" SELECT distinct pitem1.FID \r\n");
            } else {
                sql.append(" SELECT pitem1.FID \r\n");
            }
            sql.append(" FROM T_PM_PermItem pitem1      \r\n");
            sql.append(" INNER JOIN     \r\n");
            sql.append(" (SELECT substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2);
            if (parentPerm == null) {
                sql.append(")-1) as FLongNumber from T_PM_PermItem ipitem  \r\n");
            } else {
                sql.append(")-1) as FLongNumber from T_PM_PermItem ipitem  \r\n");
            }
            sql.append(" INNER JOIN  T_PM_RolePerm irp                                           \r\n");
            sql.append(" ON ipitem.FID = irp.FPermItemID                                         \r\n");
            sql.append(" INNER JOIN  T_PM_UserRoleOrg iuro                                       \r\n");
            sql.append(" ON irp.FRoleID = iuro.FRoleID                                           \r\n");
            sql.append(" WHERE iuro.FUserID = '" + userPK.toString() + "'                                                  \r\n");
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            List orgIdListForRole = ToolUtils.orgCol2List(orgCol);
            sql.append(this.getOrgIdFilter(orgIdListForRole, "FOrgID", listParams));
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'         \r\n");
            if (permType != 0) {
                sql.append(" AND irp.FPermType = " + permType + "   \r\n");
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(") uop on pitem1.FLongNumber = uop.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%' \r\n");
            sql.append(" WHERE 1=1        \r\n");
            if (parentPerm != null) {
                sql.append(" AND pitem1.FParentID = '" + parentPerm.getId().toString() + "' ");
            }
            sql.append(unionTailSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashMap mapPermItem = new HashMap();
            while (rs.next()) {
                String permItemID = rs.getString("FID");
                result.add(permItemID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("_getViewUOPs  " + (endTime - beginTime)));
        }
        return result;
    }

    private UserOrgPermCollection getLevelSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        return this.getSourceUOPs4CUAdmin(ctx, sourceUserPK, userPK, orgCol, parentPerm, permType);
    }

    private UserOrgPermCollection getLevelSourceUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, boolean isBatch, int permType) throws BOSException, EASBizException {
        return this.getSourceUOPs4Normal(ctx, sourceUserPK, userPK, orgCol, parentPerm, isBatch, permType);
    }

    private PermItemInfo getRootPermItem(Context ctx) throws BOSException, EASBizException {
        if (this.rootPermItem != null) {
            return this.rootPermItem;
        }
        String oql = "select id,longNumber where parent is null ";
        CoreBaseCollection colls = PermItemFactory.getLocalInstance(ctx).getCollection(oql);
        if (colls != null && colls.size() > 0) {
            this.rootPermItem = (PermItemInfo)colls.get(0);
        }
        return this.rootPermItem;
    }

    private UserOrgPermCollection getSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList<String> listParams = new ArrayList<String>();
        if (sourceUserPK == null || orgCol == null) {
            return userOrgPerms;
        }
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            String parentPermLongNumber = this.getRootPermItem(ctx).getLongNumber();
            if (parentPerm != null) {
                parentPermLongNumber = parentPerm.getLongNumber();
            }
            StringBuffer sql = new StringBuffer();
            StringBuffer unionHeadSql = new StringBuffer(500);
            unionHeadSql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber,FLongIndex, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 FROM (");
            sql.append(unionHeadSql);
            if (parentPerm == null) {
                StringBuffer rootPermSql = new StringBuffer();
                rootPermSql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber,FLongIndex, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 \r\n").append(" FROM T_PM_PermItem WHERE FParentID is null              \r\n");
                sql.append(rootPermSql);
                sql.append(" UNION ALL                                                \r\n");
            }
            sql.append("SELECT FID, FName, ").append(aliasField).append(", ppi.FLongNumber,ppi.FLongIndex, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 \r\n").append(" FROM T_PM_PermItem ppi where ppi.FParentID = ? ");
            if (parentPerm != null) {
                listParams.add(parentPerm.getId().toString());
            } else {
                listParams.add(this.getRootPermItem(ctx).getId().toString());
            }
            sql.append(" and exists ( SELECT 1 from T_PM_PermItem ");
            sql.append(" WHERE FIsLeaf = 1 ");
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            if (permType == 30) {
                sql.deleteCharAt(sql.lastIndexOf(")"));
                sql.append(" OR FOrgRelation =").append(8).append(") ");
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(" AND FLongNumber like ? ");
            listParams.add(parentPermLongNumber + "!%");
            sql.append(" and Charindex(ppi.flongnumber,flongnumber)>0");
            sql.append(" )  ");
            sql.append(") PA ORDER BY FLongIndex,FLongNumber ASC");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> sourceUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (sourceUOPSet.contains(rs.getString("FID"))) continue;
                sourceUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.AUTHORIZATION);
                uopInfo.setOwner(userInfo);
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return userOrgPerms;
    }

    private Map<String, PermItemInfo> getSourceUOPs4CUAdmin(Context ctx, FullOrgUnitCollection orgCol, int permType) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
        sql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber,FLongIndex, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 ");
        sql.append(" from T_PM_PermItem ");
        sql.append(" WHERE FIsLeaf = 1 ");
        sql.append(this.getPermTypeFilter("FType"));
        sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", null));
        if (permType == 30) {
            sql.deleteCharAt(sql.lastIndexOf(")"));
            sql.append(" OR FOrgRelation =").append(8).append(") ");
        }
        if (!this.hasUnionOrg(orgCol) && permType != 30) {
            sql.append(this.getCslrptPermNameFilter());
        }
        sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
        sql.append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, PermItemInfo> permsMap = new HashMap<String, PermItemInfo>();
        try {
            while (rs.next()) {
                PermItemInfo permInfo = new PermItemInfo();
                String id = rs.getString("FID");
                permInfo.setId(BOSUuid.read((String)id));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                permsMap.put(id, permInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return permsMap;
    }

    private Map<String, PermItemInfo> getSourceUOPsBizAdmin(Context ctx, IObjectPK sourceUserPK, FullOrgUnitCollection orgCol, boolean isBatch, int permType) throws BOSException, EASBizException {
        HashMap<String, PermItemInfo> permsMap = new HashMap<String, PermItemInfo>();
        if (sourceUserPK == null || orgCol == null) {
            return permsMap;
        }
        if (!isBatch && orgCol.size() > 1) {
            throw new IllegalArgumentException("when isBatch is false but orgCol size > 1");
        }
        FullOrgUnitInfo tmp = null;
        HashSet<String> cuIds = new HashSet<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            tmp = orgCol.get(i);
            cuIds.add(tmp.isIsUnion() ? tmp.getMaintainCU().getId().toString() : tmp.getCU().getId().toString());
        }
        boolean isCrossCu = cuIds.size() > 1;
        ArrayList<String> listParams = new ArrayList<String>();
        String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ipitem.FID as FID, ipitem.FName as FName, ").append(aliasField).append(", FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 ");
        sql.append(" FROM T_PM_PermItem ipitem  \r\n");
        sql.append(" INNER JOIN  T_PM_UserOrgPerm iuop                                   \r\n");
        sql.append(" ON ipitem.FID = iuop.FPermItemID                                    \r\n");
        sql.append(" WHERE iuop.FOwner = ?                                               \r\n");
        listParams.add(sourceUserPK.toString());
        sql.append(this.getPermTypeFilter("FType"));
        sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
        ArrayList<String> cuIdList = new ArrayList<String>(cuIds);
        if (!isCrossCu) {
            cuIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
        }
        sql.append(this.getOrgIdFilter(cuIdList, "FOrgID", listParams));
        if (!this.hasUnionOrg(orgCol) && permType != 30) {
            sql.append(this.getCslrptPermNameFilter());
        }
        sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
        sql.append("\r\n");
        sql.append(" AND iuop.FPermType = ").append(30).append(" \r\n");
        if (isCrossCu) {
            sql.append(" Group By FLongNumber Having count(FOrgID)>=").append(cuIdList.size());
            sql.append(" union all");
            sql.append(" SELECT FLongNumber FROM T_PM_PermItem ipitem ");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm iuop ");
            sql.append(" ON ipitem.FID = iuop.FPermItemID ");
            sql.append(" WHERE iuop.FOwner = '").append(sourceUserPK.toString()).append("'");
            sql.append(this.getPermTypeFilter("FType"));
            if (!this.isAllOrgIsUnion(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(" AND FOrgRelation = ").append(-1);
            sql.append(" AND FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
            sql.append(" AND iuop.FPermType = ").append(30);
        }
        sql.append(" UNION ALL    \r\n");
        sql.append("SELECT ipitem.FID as FID, ipitem.FName as FName, ").append(aliasField).append(", FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 ");
        sql.append("FROM T_PM_PermItem ipitem  \r\n");
        sql.append(" INNER JOIN  T_PM_RolePerm irp                                           \r\n");
        sql.append(" ON ipitem.FID = irp.FPermItemID                                         \r\n");
        sql.append(" INNER JOIN  T_PM_UserRoleOrg iuro                                       \r\n");
        sql.append(" ON irp.FRoleID = iuro.FRoleID                                           \r\n");
        sql.append(" WHERE iuro.FUserID = ?                                                  \r\n");
        listParams.add(sourceUserPK.toString());
        sql.append(this.getPermTypeFilter("FType"));
        sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
        sql.append(this.getOrgIdFilter(cuIdList, "FOrgID", listParams));
        sql.append(" AND irp.FPermType = ").append(30).append(" \r\n");
        if (isCrossCu) {
            sql.append(" Group By FLongNumber Having count(distinct FOrgID)>=").append(cuIdList.size());
            sql.append(" union all");
            sql.append(" SELECT FLongNumber FROM T_PM_PermItem ipitem ");
            sql.append(" INNER JOIN  T_PM_RolePerm irp ");
            sql.append(" ON ipitem.FID = irp.FPermItemID ");
            sql.append(" INNER JOIN  T_PM_UserRoleOrg iuro ");
            sql.append(" ON irp.FRoleID = iuro.FRoleID ");
            sql.append(" WHERE iuro.FUserID = '").append(sourceUserPK.toString()).append("'");
            sql.append(this.getPermTypeFilter("FType"));
            if (!this.isAllOrgIsUnion(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(" and FOrgRelation = ").append(-1);
            sql.append(" and FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
            sql.append(" and irp.FPermType = ").append(30);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
        try {
            while (rs.next()) {
                PermItemInfo permInfo = new PermItemInfo();
                String id = rs.getString("FID");
                permInfo.setId(BOSUuid.read((String)id));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                permsMap.put(id, permInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return permsMap;
    }

    protected Map<String, PermItemInfo> getTargetUOPs(Context ctx, IObjectPK userPK, IObjectPK orgPK, int permType) throws BOSException, EASBizException {
        String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(userPK.toString());
        listParams.add(permType);
        sql.append("SELECT perm.FID as FID,  FName, ").append(aliasField).append(", FOrgRelation, FIsLeaf, FLongNumber, FParentID, FObjectType, FIsApplyToF7 , FRuleStructure, FRuleExpr,uop.FID userOrgId").append(" from T_PM_UserOrgPerm uop INNER JOIN T_PM_Permitem  perm on uop.FPERMITEMID  = perm.FID  where  uop.FOWNER =? and uop.FPERMTYPE = ? ");
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(orgPK.toString());
        orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
        sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
        HashMap<String, PermItemInfo> permsMap = new HashMap<String, PermItemInfo>();
        try {
            while (rs.next()) {
                PermItemInfo permInfo = new PermItemInfo();
                String id = rs.getString("FID");
                permInfo.setId(BOSUuid.read((String)id));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setLongNumber(rs.getString("FlongNumber"));
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                permInfo.setExtendedProperty("FRuleStructure", rs.getString("FRuleStructure"));
                permInfo.setExtendedProperty("FRuleExpr", rs.getString("FRuleExpr"));
                permInfo.setString("userOrgId", rs.getString("userOrgId"));
                permsMap.put(id, permInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return permsMap;
    }

    private UserOrgPermCollection getSourceUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, boolean isBatch, int permType) throws BOSException, EASBizException {
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        if (sourceUserPK == null || orgCol == null) {
            return userOrgPerms;
        }
        if (!isBatch && orgCol.size() > 1) {
            throw new IllegalArgumentException("when isBatch is false but orgCol size > 1");
        }
        FullOrgUnitInfo tmp = null;
        HashSet<String> cuIds = new HashSet<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            tmp = orgCol.get(i);
            cuIds.add(tmp.isIsUnion() ? tmp.getMaintainCU().getId().toString() : tmp.getCU().getId().toString());
        }
        boolean isCrossCu = cuIds.size() > 1;
        ArrayList<String> listParams = new ArrayList<String>();
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            String parentPermLongNumber = this.getRootPermItem(ctx).getLongNumber();
            if (parentPerm != null) {
                parentPermLongNumber = parentPerm.getLongNumber();
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 FROM (");
            if (parentPerm == null) {
                StringBuffer rootPermSql = new StringBuffer();
                rootPermSql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7  ").append(" FROM T_PM_PermItem WHERE FParentID is null ");
                sql.append(rootPermSql);
                sql.append(" UNION ALL  ");
            }
            sql.append(" SELECT distinct ppi.FID, ");
            sql.append(" ppi.FName, ");
            sql.append(" ppi.").append(aliasField);
            sql.append(", ppi.FlongNumber, ppi.FOrgRelation, ppi.FIsLeaf,         \r\n");
            sql.append(" ppi.FParentID, ppi.FObjectType, ppi.FIsApplyToF7         \r\n");
            sql.append(" FROM (SELECT FID, FName, ").append(aliasField).append(", pitem1.FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 FROM T_PM_PermItem pitem1   \r\n");
            sql.append(" INNER JOIN (SELECT distinct substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2).append(")-1) as FLongNumber FROM (SELECT FLongNumber FROM T_PM_PermItem ipitem  \r\n");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm iuop                                   \r\n");
            sql.append(" ON ipitem.FID = iuop.FPermItemID                                    \r\n");
            sql.append(" WHERE iuop.FOwner = ?                                               \r\n");
            listParams.add(sourceUserPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            ArrayList<String> cuIdList = new ArrayList<String>(cuIds);
            if (!isCrossCu) {
                cuIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            sql.append(this.getOrgIdFilter(cuIdList, "FOrgID", listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(" AND iuop.FPermType = ").append(30).append(" \r\n");
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'  \r\n");
            if (isCrossCu) {
                sql.append(" Group By FLongNumber Having count(FOrgID)>=").append(cuIdList.size());
                sql.append(" union all");
                sql.append(" SELECT FLongNumber FROM T_PM_PermItem ipitem ");
                sql.append(" INNER JOIN  T_PM_UserOrgPerm iuop ");
                sql.append(" ON ipitem.FID = iuop.FPermItemID ");
                sql.append(" WHERE iuop.FOwner = '").append(sourceUserPK.toString()).append("'");
                sql.append(this.getPermTypeFilter("FType"));
                if (!this.isAllOrgIsUnion(orgCol) && permType != 30) {
                    sql.append(this.getCslrptPermNameFilter());
                }
                sql.append(" AND FOrgRelation = ").append(-1);
                sql.append(" AND FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
                sql.append(" AND iuop.FPermType = ").append(30);
                sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%' ");
            }
            sql.append(" ) t ) pitem2 on pitem1.FLongNumber = pitem2.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%') ppi   \r\n");
            sql.append(" WHERE 1=1  \r\n");
            if (parentPerm != null) {
                sql.append(" AND ppi.FParentID = ? ");
                listParams.add(parentPerm.getId().toString());
            }
            sql.append(" UNION ALL    \r\n");
            sql.append(" SELECT distinct ppi.FID, \r\n");
            sql.append(" ppi.FName, \r\n ");
            sql.append(" ppi.").append(aliasField);
            sql.append(", ppi.FlongNumber, ppi.FOrgRelation, ppi.FIsLeaf, \r\n");
            sql.append(" ppi.FParentID, ppi.FObjectType, ppi.FIsApplyToF7 \r\n");
            sql.append(" FROM (SELECT FID, FName, ").append(aliasField).append(", pitem1.FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 FROM T_PM_PermItem pitem1   \r\n");
            sql.append(" INNER JOIN (SELECT distinct substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2).append(")-1) as FLongNumber FROM (SELECT FLongNumber FROM T_PM_PermItem ipitem  \r\n");
            sql.append(" INNER JOIN  T_PM_RolePerm irp                                           \r\n");
            sql.append(" ON ipitem.FID = irp.FPermItemID                                         \r\n");
            sql.append(" INNER JOIN  T_PM_UserRoleOrg iuro                                       \r\n");
            sql.append(" ON irp.FRoleID = iuro.FRoleID                                           \r\n");
            sql.append(" WHERE iuro.FUserID = ?                                                  \r\n");
            listParams.add(sourceUserPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            sql.append(this.getOrgIdFilter(cuIdList, "FOrgID", listParams));
            sql.append(" AND irp.FPermType = ").append(30).append(" \r\n");
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%' \r\n");
            if (isCrossCu) {
                sql.append(" Group By FLongNumber Having count(distinct FOrgID)>=").append(cuIdList.size());
                sql.append(" union all");
                sql.append(" SELECT FLongNumber FROM T_PM_PermItem ipitem ");
                sql.append(" INNER JOIN  T_PM_RolePerm irp ");
                sql.append(" ON ipitem.FID = irp.FPermItemID ");
                sql.append(" INNER JOIN  T_PM_UserRoleOrg iuro ");
                sql.append(" ON irp.FRoleID = iuro.FRoleID ");
                sql.append(" WHERE iuro.FUserID = '").append(sourceUserPK.toString()).append("'");
                sql.append(this.getPermTypeFilter("FType"));
                if (!this.isAllOrgIsUnion(orgCol) && permType != 30) {
                    sql.append(this.getCslrptPermNameFilter());
                }
                sql.append(" and FOrgRelation = ").append(-1);
                sql.append(" and FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
                sql.append(" and irp.FPermType = ").append(30);
                sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'");
            }
            sql.append(" ) t ) pitem2 on pitem1.FLongNumber = pitem2.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%') ppi \r\n");
            sql.append(" WHERE 1=1  \r\n");
            if (parentPerm != null) {
                sql.append(" AND ppi.FParentID = ? ");
                listParams.add(parentPerm.getId().toString());
            }
            sql.append(") PA ORDER BY FLongNumber ASC");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> sourceUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (sourceUOPSet.contains(rs.getString("FID"))) continue;
                sourceUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.AUTHORIZATION);
                uopInfo.setOwner(userInfo);
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return userOrgPerms;
    }

    public boolean isAllOrgIsUnion(FullOrgUnitCollection orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            if (orgCol.get(i).isIsUnion()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected UserOrgPermCollection _getLevelTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        return this.getTargetUOPs(ctx, sourceUserPK, userPK, orgCol, parentPerm, permType);
    }

    protected UserOrgPermCollection getTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        UserOrgPermCollection result = new UserOrgPermCollection();
        ArrayList<Object> listParams = new ArrayList<Object>();
        if (userPK == null || orgCol == null) {
            return result;
        }
        if (!Administrator.isCUAdmin(ctx, sourceUserPK) && permType == 30) {
            return result;
        }
        try {
            String parentPermLongNumber = null;
            parentPermLongNumber = parentPerm == null ? this.getRootPermItem(ctx).getLongNumber() : parentPerm.getLongNumber();
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            StringBuffer unionHeadSql = new StringBuffer();
            unionHeadSql.append("SELECT PA.FID,  FName, ").append(aliasField).append(", FOrgRelation, FIsLeaf, FLongNumber, FParentID, FObjectType, FIsApplyToF7,FRuleStructure, FRuleExpr FROM (");
            sql.append(unionHeadSql);
            if (parentPerm == null) {
                sql.append("SELECT FID,  FName, ").append(aliasField).append(", FOrgRelation, FIsLeaf, FLongNumber,FLongIndex, FParentID, FObjectType,FIsApplyToF7 ").append(" FROM T_PM_PermItem WHERE FParentID is null");
                sql.append(" UNION ALL  \r\n");
            }
            sql.append(" SELECT pitem1.FID, pitem1.FName,  \r\n");
            if (parentPerm == null) {
                parentPerm = this.getRootPermItem(ctx);
            }
            sql.append(" pitem1.").append(aliasField);
            sql.append(", pitem1.FOrgRelation, pitem1.FIsLeaf, pitem1.FlongNumber,   pitem1.FLongIndex,                           \r\n");
            sql.append(" pitem1.FParentID, pitem1.FObjectType, pitem1.FIsApplyToF7  ");
            sql.append(" FROM T_PM_PermItem pitem1   where pitem1.FParentId= ? ");
            listParams.add(parentPerm.getId().toString());
            sql.append(" and exists ").append(" (select 1 from t_pm_permitem ipitem where ").append(" ipitem.flongnumber like ? ");
            listParams.add(parentPermLongNumber + "!%");
            sql.append(" and charindex(pitem1.flongnumber||'!',ipitem.flongnumber||'!')>0 ").append(" and exists ").append("(select 1 from t_pm_userorgperm uop where fowner=? ");
            listParams.add(userPK.toString());
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            sql.append(" AND uop.FPermType = ?  ");
            listParams.add(new Integer(permType));
            sql.append(" and FPermItemId = ipitem.FId ");
            sql.append(")");
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            if (permType == 30) {
                sql.deleteCharAt(sql.lastIndexOf(")"));
                sql.append(" OR FOrgRelation =").append(8).append(") ");
            }
            sql.append(this.getPermTypeFilter("FType"));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            if (!Administrator.isCUAdmin(ctx, sourceUserPK)) {
                sql.append(this.getAuthorizedFilter(sourceUserPK, orgCol, listParams, "ipitem.FId"));
            }
            sql.append(")");
            sql.append(") PA ");
            sql.append(" left join ");
            sql.append(" (select FPermItemId,FRuleStructure,FRuleExpr from t_pm_userorgperm where fowner=? ");
            listParams.add(userPK.toString());
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            sql.append(" AND FPermType = ?  ) uop1 on PA.FID=uop1.FPermItemId");
            listParams.add(new Integer(permType));
            sql.append(" ORDER BY FLongIndex,FLongNumber ASC");
            long start = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            logger.error((Object)("getTargetUOPs permtype:" + permType + " cost:" + (System.currentTimeMillis() - start)));
            HashSet<String> targetUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (targetUOPSet.contains(rs.getString("FID"))) continue;
                targetUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo info = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setLongNumber(rs.getString("FlongNumber"));
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                PermItemInfo parent = null;
                if (!StringUtils.isEmpty((String)parentID)) {
                    parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                }
                permInfo.setParent(parent);
                info.setRuleStructure(rs.getString("FRuleStructure"));
                info.setRuleExpr(rs.getString("FRuleExpr"));
                info.setPermItem(permInfo);
                info.setPermType(PermType.getEnum(permType));
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    protected UserOrgPermCollection getViewUOPs(Context ctx, IObjectPK userPK, FullOrgUnitCollection orgCol, PermItemInfo parentPerm, int permType) throws BOSException, EASBizException {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection result = new UserOrgPermCollection();
        ArrayList listParams = new ArrayList();
        if (userPK == null || orgCol == null) {
            return result;
        }
        try {
            String parentPermLongNumber = this.getRootPermItem(ctx).getLongNumber();
            if (parentPerm != null) {
                parentPermLongNumber = parentPerm.getLongNumber();
            }
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            StringBuffer unionHeadSql = new StringBuffer();
            String unionTailSql = ") PA ORDER BY FLongNumber ASC";
            if (parentPerm == null) {
                unionHeadSql.append("SELECT FID, FPermType, FOwner, ").append(aliasField).append(",  FIsLeaf, FLongNumber, FParentID, FObjectType, FIsApplyToF7 FROM (");
                sql.append(unionHeadSql);
                StringBuffer rootPermSql = new StringBuffer();
                rootPermSql.append("SELECT FID, 100 as FPermType, '" + userPK.toString() + "' as FOwner,  ").append(aliasField).append(",  FIsLeaf, FLongNumber, FParentID, FObjectType, FIsApplyToF7 \r\n").append(" FROM T_PM_PermItem WHERE FParentID is null");
                sql.append(rootPermSql);
                sql.append(" UNION ALL                  \r\n");
                sql.append(" SELECT distinct pitem1.FID, uop.FPermType, uop.FOwner,   \r\n");
            } else {
                unionHeadSql.append("SELECT FID, FPermType, FOwner, FRuleStructure, FRuleExpr, ").append(aliasField).append(",  FIsLeaf, FLongNumber, FParentID, FObjectType, FIsApplyToF7 FROM (");
                sql.append(unionHeadSql);
                sql.append(" SELECT pitem1.FID, uop.FPermType, uop.FOwner, uop.FRuleStructure, uop.FRuleExpr,  \r\n");
            }
            sql.append(" pitem1.").append(aliasField);
            sql.append(", pitem1.FIsLeaf, pitem1.FlongNumber,                               \r\n");
            sql.append(" pitem1.FParentID, pitem1.FObjectType, pitem1.FIsApplyToF7                               \r\n");
            sql.append(" FROM T_PM_PermItem pitem1      \r\n");
            sql.append(" INNER JOIN     \r\n");
            sql.append(" (SELECT substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2);
            if (parentPerm == null) {
                sql.append(")-1) as FLongNumber,iuop.FPermItemID,iuop.FPermType,iuop.FOwner from T_PM_PermItem ipitem  \r\n");
            } else {
                sql.append(")-1) as FLongNumber,iuop.FPermItemID,iuop.FPermType,iuop.FOwner,iuop.FRuleStructure,iuop.FRuleExpr from T_PM_PermItem ipitem  \r\n");
            }
            sql.append("  INNER JOIN  T_PM_UserOrgPerm iuop   \r\n");
            sql.append(" ON ipitem.FID = iuop.FPermItemID                                 \r\n");
            sql.append(" WHERE iuop.FOwner = '" + userPK.toString() + "' \r\n");
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'  \r\n");
            if (permType != 0) {
                sql.append(" AND iuop.FPermType = " + permType + "   \r\n");
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(") uop on pitem1.FLongNumber = uop.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%' \r\n");
            sql.append(" WHERE 1=1        \r\n");
            if (parentPerm != null) {
                sql.append(" AND pitem1.FParentID = '" + parentPerm.getId().toString() + "' ");
            }
            sql.append(" UNION ALL    \r\n");
            if (parentPerm == null) {
                sql.append(" SELECT distinct pitem1.FID, uop.FPermType, uop.FOwner,  \r\n");
            } else {
                sql.append(" SELECT pitem1.FID, uop.FPermType, uop.FOwner, uop.FRuleStructure, uop.FRuleExpr, \r\n");
            }
            sql.append(" pitem1.").append(aliasField);
            sql.append(", pitem1.FIsLeaf, pitem1.FlongNumber,                               \r\n");
            sql.append(" pitem1.FParentID, pitem1.FObjectType, pitem1.FIsApplyToF7                               \r\n");
            sql.append(" FROM T_PM_PermItem pitem1      \r\n");
            sql.append(" INNER JOIN     \r\n");
            sql.append(" (SELECT substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2);
            if (parentPerm == null) {
                sql.append(")-1) as FLongNumber,irp.FPermItemID,irp.FPermType,'").append(userPK.toString()).append("' as FOwner from T_PM_PermItem ipitem  \r\n");
            } else {
                sql.append(")-1) as FLongNumber,irp.FPermItemID,irp.FPermType,'").append(userPK.toString()).append("' as FOwner,irp.FRuleStructure,irp.FRuleExpr from T_PM_PermItem ipitem  \r\n");
            }
            sql.append(" INNER JOIN  T_PM_RolePerm irp                                           \r\n");
            sql.append(" ON ipitem.FID = irp.FPermItemID                                         \r\n");
            sql.append(" WHERE  irp.FRoleID in (select distinct iuro.FRoleID from  T_PM_UserRoleOrg iuro where  iuro.FUserID = '").append(userPK.toString()).append("' ");
            List orgIdListForRole = ToolUtils.orgCol2List(orgCol);
            sql.append(this.getOrgIdFilter(orgIdListForRole, "FOrgID", listParams)).append(")");
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'         \r\n");
            if (permType != 0) {
                sql.append(" AND irp.FPermType = " + permType + "   \r\n");
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(") uop on pitem1.FLongNumber = uop.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%' \r\n");
            sql.append(" WHERE 1=1        \r\n");
            if (parentPerm != null) {
                sql.append(" AND pitem1.FParentID = '" + parentPerm.getId().toString() + "' ");
            }
            sql.append(" UNION ALL    \r\n");
            if (parentPerm == null) {
                sql.append(" SELECT distinct pitem1.FID, uop.FPermType, uop.FOwner, \r\n");
            } else {
                sql.append(" SELECT pitem1.FID, uop.FPermType, uop.FOwner, uop.FRuleStructure, uop.FRuleExpr,  \r\n");
            }
            sql.append(" pitem1.").append(aliasField);
            sql.append(",pitem1.FIsLeaf, pitem1.FlongNumber,                               \r\n");
            sql.append(" pitem1.FParentID, pitem1.FObjectType, pitem1.FIsApplyToF7                               \r\n");
            sql.append(" FROM T_PM_PermItem pitem1      \r\n");
            sql.append(" INNER JOIN     \r\n");
            sql.append(" (SELECT substring(FLongNumber,0,charindex('!',FLongNumber||'!',").append(parentPermLongNumber.length() + 2);
            if (parentPerm == null) {
                sql.append(")-1) as FLongNumber,irp.FPermItemID,irp.FPermType,'").append(userPK.toString()).append("' as FOwner from T_PM_PermItem ipitem  \r\n");
            } else {
                sql.append(")-1) as FLongNumber,irp.FPermItemID,irp.FPermType,'").append(userPK.toString()).append("' as FOwner,irp.FRuleStructure,irp.FRuleExpr from T_PM_PermItem ipitem  \r\n");
            }
            sql.append(" INNER JOIN  T_PM_RolePerm irp                                           \r\n");
            sql.append(" ON ipitem.FID = irp.FPermItemID                                         \r\n");
            sql.append(" WHERE  irp.FRoleID in (select distinct iuro.FRoleID from  T_PM_UserRoleOrg iuro where  iuro.FUserID = '").append(userPK.toString()).append("')");
            sql.append(" and (FOrgRelation = -1)");
            sql.append(" AND ipitem.FLongNumber like '" + parentPermLongNumber + "!%'         \r\n");
            if (permType != 0) {
                sql.append(" AND irp.FPermType = " + permType + "   \r\n");
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(") uop on pitem1.FLongNumber = uop.FLongNumber and pitem1.FLongNumber like '" + parentPermLongNumber + "!%' \r\n");
            sql.append(" WHERE 1=1        \r\n");
            if (parentPerm != null) {
                sql.append(" AND pitem1.FParentID = '" + parentPerm.getId().toString() + "' ");
            }
            sql.append(unionTailSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashMap<String, UserOrgPermInfo> mapPermItem = new HashMap<String, UserOrgPermInfo>();
            while (rs.next()) {
                UserOrgPermInfo info = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                String permItemID = rs.getString("FID");
                permItemInfo.setId(BOSUuid.read((String)permItemID));
                permItemInfo.setAlias(rs.getString(aliasField));
                permItemInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permItemInfo.setLongNumber(rs.getString("FlongNumber"));
                permItemInfo.setObjectType(rs.getString("FObjectType"));
                permItemInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                String parentID = rs.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    permItemInfo.setParent(parent);
                }
                info.setPermItem(permItemInfo);
                info.setPermType(PermType.getEnum(rs.getInt("FPermType")));
                if (permItemInfo.isIsLeaf() && parentPerm != null) {
                    info.setRuleExpr(rs.getString("FRuleExpr"));
                    info.setRuleStructure(rs.getString("FRuleStructure"));
                }
                if (mapPermItem.containsKey(PermissionCommonUtil.getKey(info))) {
                    UserOrgPermInfo existInfo = (UserOrgPermInfo)mapPermItem.get(PermissionCommonUtil.getKey(info));
                    if (StringUtils.isEmpty((String)existInfo.getRuleStructure())) {
                        existInfo.setRuleStructure(info.getRuleStructure());
                        existInfo.setRuleExpr(info.getRuleExpr());
                        continue;
                    }
                    if (StringUtils.isEmpty((String)info.getRuleStructure())) continue;
                    String roleRuleExpr = existInfo.getRuleStructure();
                    roleRuleExpr = this.rebuildRuleStructure(roleRuleExpr);
                    String userRuleExpr = info.getRuleStructure();
                    userRuleExpr = this.rebuildRuleStructure(userRuleExpr);
                    String oql = RuleUtil.mergeOQL(roleRuleExpr, userRuleExpr, "OR");
                    oql = StringUtils.replace((String)oql, (String)"fid =", (String)"");
                    oql = StringUtils.replace((String)oql, (String)"'", (String)"");
                    existInfo.setRuleStructure(oql);
                    continue;
                }
                mapPermItem.put(PermissionCommonUtil.getKey(info), info);
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        catch (ParserException e) {
            logger.error((Object)"ParserException:", (Throwable)e);
            throw new PermissionManagerException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("_getViewUOPs  " + (endTime - beginTime)));
        }
        return result;
    }

    private String rebuildRuleStructure(String ruleStructure) {
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)ruleStructure)) {
            for (String str : StringUtils.split((String)ruleStructure, (String)" ")) {
                if (RuleUtil.isRuleID(str)) {
                    result.append(" ");
                    result.append(" fid = ' " + str + " '");
                    result.append(" ");
                    continue;
                }
                result.append(" ");
                result.append(str);
                result.append(" ");
            }
        }
        return result.toString();
    }

    private UserOrgPermCollection getExpandUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection uopParents, int permType, boolean sourceFlag, boolean isBatch) throws BOSException, EASBizException {
        if (sourceFlag) {
            return this.getSourceExpandUOPs(ctx, sourceUserPK, userPK, orgCol, uopParents, permType, isBatch);
        }
        return this.getTargetExpandUOPs(ctx, sourceUserPK, userPK, orgCol, uopParents, permType);
    }

    private UserOrgPermCollection getSourceExpandUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection uopParents, int permType, boolean isBatch) throws BOSException, EASBizException {
        assert (sourceUserPK != null && orgCol != null);
        assert (uopParents != null && uopParents.size() > 0);
        try {
            if (Administrator.isCUAdmin(ctx, sourceUserPK)) {
                return this.getSourceExpandUOPs4CUAdmin(ctx, sourceUserPK, userPK, orgCol, uopParents, permType);
            }
            return this.getSourceExpandUOPs4Normal(ctx, sourceUserPK, userPK, orgCol, uopParents, permType, isBatch);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
    }

    private UserOrgPermCollection getSourceExpandUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection uopParents, int permType) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList listParams = new ArrayList();
        if (sourceUserPK == null || orgCol == null) {
            return userOrgPerms;
        }
        if (uopParents == null || uopParents.size() == 0) {
            return userOrgPerms;
        }
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID, FNumber,  FOrgRelation ").append(" FROM T_PM_PermItem ppi ");
            sql.append(" WHERE FIsLeaf = 1 ");
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            if (permType == 30) {
                sql.deleteCharAt(sql.lastIndexOf(")"));
                sql.append(" OR FOrgRelation =").append(8).append(") ");
            }
            sql.append(this.getLongNumberFilter(uopParents, listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(" ORDER BY ppi.FLongNumber ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            while (rowSet.next()) {
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                permInfo.setNumber(rowSet.getString("FNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(permType));
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return userOrgPerms;
    }

    private UserOrgPermCollection getSourceExpandUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection uopParents, int permType, boolean isBatch) throws BOSException, EASBizException {
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        if (!isBatch && orgCol.size() > 1) {
            throw new IllegalArgumentException("when isBatch is false but orgCol size > 1");
        }
        FullOrgUnitInfo tmp = null;
        HashSet<String> cuIds = new HashSet<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            tmp = orgCol.get(i);
            cuIds.add(tmp.isIsUnion() ? tmp.getMaintainCU().getId().toString() : tmp.getCU().getId().toString());
        }
        boolean isCrossCu = cuIds.size() > 1;
        ArrayList<String> listParams = new ArrayList<String>();
        if (sourceUserPK == null || orgCol == null) {
            return userOrgPerms;
        }
        if (uopParents == null || uopParents.size() == 0) {
            return userOrgPerms;
        }
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        try {
            StringBuffer sql = new StringBuffer();
            StringBuffer unionHeadSql = new StringBuffer();
            unionHeadSql.append("SELECT FID, FNumber, ").append("  FOrgRelation FROM (");
            String unionTailSql = ") PA ";
            sql.append(unionHeadSql);
            sql.append(" SELECT distinct ppi.FID,ppi.FNumber,ppi.FOrgRelation ");
            sql.append(" FROM T_PM_PermItem ppi INNER JOIN ( ");
            sql.append(" SELECT distinct FPermItemID FROM T_PM_PermItem\tpitem ");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm uop ");
            sql.append(" ON pitem.FID = uop.FPermItemID ");
            sql.append(" WHERE pitem.FIsLeaf = 1 ");
            sql.append(" AND uop.FPermType = ").append(30);
            sql.append(" AND  uop.FOwner = ? ");
            listParams.add(sourceUserPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            ArrayList<String> cuIdList = new ArrayList<String>(cuIds);
            if (!isCrossCu) {
                cuIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            sql.append(this.getOrgIdFilter(cuIdList, "FOrgID", listParams));
            sql.append(this.getLongNumberFilter(uopParents, listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            if (isCrossCu) {
                sql.append(" Group By FPermItemID Having count(FOrgID)>=").append(cuIdList.size());
                sql.append(" union all ");
                sql.append(" SELECT distinct FPermItemID FROM T_PM_PermItem\tpitem ");
                sql.append(" INNER JOIN  T_PM_UserOrgPerm uop ");
                sql.append(" ON pitem.FID = uop.FPermItemID ");
                sql.append(" WHERE pitem.FIsLeaf = 1 ");
                sql.append(" AND uop.FPermType = ").append(30);
                sql.append(" AND  uop.FOwner = '").append(sourceUserPK.toString()).append("'");
                sql.append(this.getPermTypeFilter("FType"));
                sql.append(" AND FOrgRelation = ").append(-1);
                sql.append(" AND FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
                sql.append(this.getLongNumberFilter(uopParents, listParams));
                if (!this.isAllOrgIsUnion(orgCol) && permType != 30) {
                    sql.append(this.getCslrptPermNameFilter());
                }
            }
            sql.append(") pitem2 on ppi.FID = pitem2.FPermItemID \r\n");
            sql.append(" UNION ALL    \r\n");
            sql.append(" SELECT distinct ppi.FID, ");
            sql.append(" ppi.FNumber,  ");
            sql.append(" ppi.FOrgRelation ");
            sql.append(" FROM T_PM_PermItem ppi INNER JOIN (\t\t\t        \r\n");
            sql.append(" SELECT distinct FPermItemID FROM T_PM_PermItem\tpitem\t\r\n");
            sql.append(" INNER JOIN  T_PM_RolePerm rp                           \r\n");
            sql.append(" ON pitem.FID = rp.FPermItemID                          \r\n");
            sql.append(" INNER JOIN  T_PM_UserRoleOrg uro                       \r\n");
            sql.append(" ON rp.FRoleID = uro.FRoleID                            \r\n");
            sql.append(" WHERE pitem.FIsLeaf = 1                                \r\n");
            sql.append(" AND rp.FPermType = ").append(30).append("  \r\n");
            sql.append(" AND uro.FUserID = ?                               \r\n");
            listParams.add(sourceUserPK.toString());
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            sql.append(this.getOrgIdFilter(cuIdList, "FOrgID", listParams));
            sql.append(this.getLongNumberFilter(uopParents, listParams));
            if (isCrossCu) {
                sql.append(" Group By FPermItemID Having count(distinct FOrgID)>=").append(cuIdList.size());
                sql.append(" union all");
                sql.append(" SELECT distinct FPermItemID FROM T_PM_PermItem\tpitem ");
                sql.append(" INNER JOIN  T_PM_RolePerm rp ");
                sql.append(" ON pitem.FID = rp.FPermItemID ");
                sql.append(" INNER JOIN  T_PM_UserRoleOrg uro ");
                sql.append(" ON rp.FRoleID = uro.FRoleID ");
                sql.append(" WHERE pitem.FIsLeaf = 1 ");
                sql.append(" AND rp.FPermType = ").append(30);
                sql.append(" AND uro.FUserID = '").append(sourceUserPK.toString()).append("'");
                if (!this.isAllOrgIsUnion(orgCol) && permType != 30) {
                    sql.append(this.getCslrptPermNameFilter());
                }
                sql.append(this.getPermTypeFilter("FType"));
                sql.append(" AND FOrgRelation = ").append(-1);
                sql.append(" AND FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'");
                sql.append(this.getLongNumberFilter(uopParents, listParams));
            }
            sql.append(") pitem2 on ppi.FID = pitem2.FPermItemID \r\n");
            sql.append(unionTailSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> sourceUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (sourceUOPSet.contains(rs.getString("FID"))) continue;
                sourceUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                permInfo.setNumber(rs.getString("FNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(permType));
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return userOrgPerms;
    }

    private UserOrgPermCollection getTargetExpandUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection uopParents, int permType) throws BOSException, EASBizException {
        assert (userPK != null && orgCol != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList<String> listParams = new ArrayList<String>();
        if (userPK == null || orgCol == null) {
            return userOrgPerms;
        }
        try {
            StringBuffer sql = new StringBuffer();
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            sql.append(" SELECT ppi.FID, ");
            sql.append(" ppi.FNumber, ppi.FOrgRelation,uop.FRuleStructure,uop.FRuleExpr  FROM T_PM_PermItem ppi ");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm uop ");
            sql.append(" ON ppi.FID = uop.FPermItemID ");
            sql.append(" WHERE ppi.FIsLeaf = 1 ");
            sql.append(" AND uop.FPermType = ").append(permType).append(" ");
            sql.append(this.getLongNumberFilter(uopParents, listParams));
            sql.append(" AND  uop.FOwner = ?                                 \r\n");
            listParams.add(userPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            if (permType == 30) {
                sql.deleteCharAt(sql.lastIndexOf(")"));
                sql.append(" OR FOrgRelation =").append(8).append(") ");
            }
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            if (!Administrator.isCUAdmin(ctx, sourceUserPK)) {
                sql.append(this.getAuthorizedFilter(sourceUserPK, orgCol, listParams, "uop.FPermItemId"));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> targetUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (targetUOPSet.contains(rs.getString("FID"))) continue;
                targetUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                permInfo.setNumber(rs.getString("FNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(permType));
                uopInfo.setRuleExpr(rs.getString("FRuleExpr"));
                uopInfo.setRuleStructure(rs.getString("FRuleStructure"));
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("getTargetExpandUOPs  " + (endTime - beginTime)));
        }
        return userOrgPerms;
    }

    @Override
    protected UserOrgPermCollection _getAllTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && userPK != null && orgCol != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList<String> listParams = new ArrayList<String>();
        if (userPK == null || orgCol == null) {
            return userOrgPerms;
        }
        try {
            StringBuffer sql = new StringBuffer();
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            sql.append(" SELECT uop.FID, uop.FPermItemID, uop.FPermType,  \r\n");
            sql.append(" uop.FRuleStructure, uop.FRuleExpr, ppi.FName,             \r\n");
            sql.append(" ppi.").append(aliasField);
            sql.append(", ppi.FlongNumber, ppi.FOrgRelation, ppi.FIsLeaf,          \r\n");
            sql.append(" ppi.FParentID, ppi.FObjectType, ppi.FIsApplyToF7          \r\n");
            sql.append(" FROM T_PM_PermItem ppi  \t\t\t\t\t\t\t\t   \r\n");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm uop                          \r\n");
            sql.append(" ON ppi.FID = uop.FPermItemID                              \r\n");
            sql.append(" WHERE ppi.FIsLeaf = 1                                     \r\n");
            if (permType != 0) {
                sql.append(" AND uop.FPermType = ").append(permType).append("      \r\n");
            }
            sql.append(" AND  uop.FOwner = ?                                       \r\n");
            listParams.add(userPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            if (!Administrator.isCUAdmin(ctx, sourceUserPK)) {
                sql.append(this.getAuthorizedFilter(sourceUserPK, orgCol, listParams, "uop.FPermItemId"));
            }
            sql.append(" ORDER BY ppi.FLongNumber ASC");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> targetUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (targetUOPSet.contains(rs.getString("FID"))) continue;
                targetUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                uopInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FPermItemID")));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(rs.getInt("FPermType")));
                uopInfo.setRuleStructure(rs.getString("FRuleStructure"));
                uopInfo.setRuleExpr(rs.getString("FRuleExpr"));
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("getAllTargetUOPs  " + (endTime - beginTime)));
        }
        return userOrgPerms;
    }

    protected UserOrgPermCollection _getTargetUOPsByTypes(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, Integer[] permTypes) throws BOSException, EASBizException {
        assert (sourceUserPK != null && userPK != null && orgCol != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList<String> listParams = new ArrayList<String>();
        if (userPK == null || orgCol == null) {
            return userOrgPerms;
        }
        try {
            StringBuffer sql = new StringBuffer();
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            sql.append(" SELECT uop.FID, uop.FPermItemID, uop.FPermType,  \r\n");
            sql.append(" uop.FRuleStructure, uop.FRuleExpr, ppi.FName,   uop.fOwner ,uop.fOrgid ,         \r\n");
            sql.append(" ppi.").append(aliasField);
            sql.append(", ppi.FlongNumber, ppi.FOrgRelation, ppi.FIsLeaf,          \r\n");
            sql.append(" ppi.FParentID, ppi.FObjectType, ppi.FIsApplyToF7          \r\n");
            sql.append(" FROM T_PM_PermItem ppi  \t\t\t\t\t\t\t\t   \r\n");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm uop                          \r\n");
            sql.append(" ON ppi.FID = uop.FPermItemID                              \r\n");
            sql.append(" WHERE ppi.FIsLeaf = 1                                     \r\n");
            StringBuffer types = new StringBuffer();
            boolean existsAuth = false;
            if (permTypes.length > 0) {
                boolean flag = false;
                boolean hasUnion = this.hasUnionOrg(orgCol);
                int sum = 0;
                for (int i = 0; i < permTypes.length; ++i) {
                    if (permTypes[i] == 30 && !hasUnion) {
                        existsAuth = true;
                        flag = true;
                        continue;
                    }
                    if (sum > 0) {
                        types.append(",");
                    }
                    types.append(permTypes[i]);
                    ++sum;
                }
                if (hasUnion) {
                    sql.append(" AND uop.FPermType in ( ").append(types.toString()).append(")      \r\n");
                } else if (flag && sum > 0) {
                    sql.append(" AND (uop.FPermType=30 or uop.FPermType in ( ").append(types.toString()).append(")").append(this.getCslrptPermNameFilter()).append(")");
                } else if (flag && sum <= 0) {
                    sql.append(" AND uop.FPermType = 30 ");
                } else {
                    sql.append(" AND (uop.FPermType in ( ").append(types.toString()).append(")").append(this.getCslrptPermNameFilter()).append(")");
                }
            }
            sql.append(" AND  uop.FOwner = ?                                       \r\n");
            listParams.add(userPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            if (existsAuth) {
                sql.deleteCharAt(sql.lastIndexOf(")"));
                sql.append(" OR FOrgRelation =").append(8).append(") ");
            }
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            if (!Administrator.isCUAdmin(ctx, sourceUserPK)) {
                sql.append(this.getAuthorizedFilter(sourceUserPK, orgCol, listParams, "uop.FPermItemId"));
            }
            sql.append(" ORDER BY ppi.FLongNumber ASC");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> targetUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (targetUOPSet.contains(rs.getString("FID"))) continue;
                targetUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                uopInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FPermItemID")));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(rs.getInt("FPermType")));
                uopInfo.setRuleStructure(rs.getString("FRuleStructure"));
                uopInfo.setRuleExpr(rs.getString("FRuleExpr"));
                UserInfo owner = new UserInfo();
                owner.setId(BOSUuid.read((String)rs.getString("fOwner")));
                uopInfo.setOwner(owner);
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)rs.getString("fOrgid")));
                uopInfo.setOrg(org);
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("getAllTargetUOPs  " + (endTime - beginTime)));
        }
        return userOrgPerms;
    }

    private UserOrgPermCollection getAllSourceUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        assert (sourceUserPK != null && userPK != null && orgCol != null);
        try {
            if (Administrator.isCUAdmin(ctx, sourceUserPK)) {
                return this.getAllSourceUOPs4CUAdmin(ctx, sourceUserPK, userPK, orgCol, permType);
            }
            return this.getAllSourceUOPs4Normal(ctx, sourceUserPK, userPK, orgCol, permType);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
    }

    private UserOrgPermCollection getAllSourceUOPs4CUAdmin(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList listParams = new ArrayList();
        if (sourceUserPK == null || orgCol == null) {
            return userOrgPerms;
        }
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 \r\n").append(" FROM T_PM_PermItem ppi                        \r\n");
            sql.append(" WHERE FIsLeaf = 1 ");
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(" ORDER BY ppi.FLongNumber ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            while (rowSet.next()) {
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                permInfo.setName(rowSet.getString("FName"));
                permInfo.setAlias(rowSet.getString(aliasField));
                permInfo.setLongNumber(rowSet.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rowSet.getString("FObjectType"));
                permInfo.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(permType));
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return userOrgPerms;
    }

    private UserOrgPermCollection getAllSourceUOPs4Normal(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        ArrayList<String> listParams = new ArrayList<String>();
        if (sourceUserPK == null || orgCol == null) {
            return userOrgPerms;
        }
        UserInfo userInfo = null;
        if (userPK != null) {
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userPK.toString()));
        }
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            StringBuffer unionHeadSql = new StringBuffer();
            unionHeadSql.append("SELECT FID, FName, ").append(aliasField).append(", FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 FROM (");
            String unionTailSql = ") PA ORDER BY FLongNumber ASC";
            sql.append(unionHeadSql);
            sql.append(" SELECT distinct ppi.FID,                                 \r\n");
            sql.append(" ppi.FName,                                               \r\n");
            sql.append(" ppi.").append(aliasField);
            sql.append(", ppi.FlongNumber, ppi.FOrgRelation, ppi.FIsLeaf,         \r\n");
            sql.append(" ppi.FParentID, ppi.FObjectType, ppi.FIsApplyToF7         \r\n");
            sql.append(" FROM T_PM_PermItem ppi  \t\t\t\t\t\t\t\t  \r\n");
            sql.append(" INNER JOIN  T_PM_UserOrgPerm uop                         \r\n");
            sql.append(" ON ppi.FID = uop.FPermItemID                             \r\n");
            sql.append(" WHERE ppi.FIsLeaf = 1                                    \r\n");
            sql.append(" AND uop.FPermType = ").append(30).append(" \r\n");
            sql.append(" AND  uop.FOwner = ?                                                    \r\n");
            listParams.add(sourceUserPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "FObjectType", "FOperationType"));
            sql.append("\r\n");
            sql.append(" UNION ALL    \r\n");
            sql.append(" SELECT distinct ppi.FID, \r\n");
            sql.append(" ppi.FName, \r\n ");
            sql.append(" ppi.").append(aliasField);
            sql.append(", ppi.FlongNumber, ppi.FOrgRelation, ppi.FIsLeaf,  \r\n");
            sql.append(" ppi.FParentID, ppi.FObjectType, ppi.FIsApplyToF7  \r\n");
            sql.append(" FROM T_PM_PermItem ppi                            \r\n");
            sql.append(" INNER JOIN  T_PM_RolePerm rp                      \r\n");
            sql.append(" ON ppi.FID = rp.FPermItemID                       \r\n");
            sql.append(" INNER JOIN  T_PM_UserRoleOrg uro                  \r\n");
            sql.append(" ON rp.FRoleID = uro.FRoleID                       \r\n");
            sql.append(" WHERE ppi.FIsLeaf = 1                             \r\n");
            sql.append(" AND rp.FPermType = ").append(30).append("  \r\n");
            sql.append(" AND uro.FUserID = ?                               \r\n");
            listParams.add(sourceUserPK.toString());
            sql.append(this.getPermTypeFilter("FType"));
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(this.getCslrptPermNameFilter());
            }
            sql.append(this.getOrgRelationFilter(orgCol, "FOrgRelation", listParams));
            List orgIdListForRole = ToolUtils.orgCol2List(orgCol);
            sql.append(this.getOrgIdFilter(orgIdListForRole, "FOrgID", listParams));
            sql.append(unionTailSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            HashSet<String> sourceUOPSet = new HashSet<String>();
            while (rs.next()) {
                if (sourceUOPSet.contains(rs.getString("FID"))) continue;
                sourceUOPSet.add(rs.getString("FID"));
                UserOrgPermInfo uopInfo = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                permInfo.setName(rs.getString("FName"));
                permInfo.setAlias(rs.getString(aliasField));
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                permInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
                permInfo.setIsLeaf(rs.getInt("FIsLeaf") == 1);
                permInfo.setObjectType(rs.getString("FObjectType"));
                permInfo.setEnableDataPermission(rs.getInt("FIsApplyToF7") == 1);
                uopInfo.setPermItem(permInfo);
                uopInfo.setPermType(PermType.getEnum(permType));
                userOrgPerms.add(uopInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return userOrgPerms;
    }

    private String getLongNumberFilter(UserOrgPermCollection uopParents, List listParams) {
        PermItemInfo parentPerm = null;
        StringBuffer sql = new StringBuffer();
        if (uopParents == null || uopParents.size() == 0) {
            return "";
        }
        sql.append(" AND (");
        int size = uopParents.size();
        for (int i = 0; i < size; ++i) {
            parentPerm = uopParents.get(i).getPermItem();
            if (i == 0) {
                sql.append(" FLongNumber like '" + parentPerm.getLongNumber() + "!%'");
                continue;
            }
            sql.append(" OR FLongNumber like '" + parentPerm.getLongNumber() + "!%'");
        }
        sql.append(") \r\n ");
        return sql.toString();
    }

    private String getOrgRelationFilter(FullOrgUnitCollection orgCol, String fieldName, List listParams) {
        StringBuffer sql = new StringBuffer();
        if (orgCol == null || orgCol.size() == 0) {
            return "";
        }
        sql.append(" AND (");
        Set orgTypeSet = PermissionOrgTypeUtils.getSelectOrgType(orgCol);
        Iterator orgTypeItr = orgTypeSet.iterator();
        while (orgTypeItr.hasNext()) {
            String orgTypeStr = (String)orgTypeItr.next();
            sql.append(fieldName).append(" = " + orgTypeStr);
            if (!orgTypeItr.hasNext()) continue;
            sql.append(" OR ");
        }
        sql.append(") \r\n ");
        return sql.toString();
    }

    private String getOrgIdFilter(List orgIdList, String fieldName, List listParams) {
        StringBuffer sql = new StringBuffer();
        if (orgIdList == null || orgIdList.size() == 0) {
            return "";
        }
        sql.append(" AND (");
        sql.append(this.getOrgIdFilterWithoutLogic(orgIdList, fieldName, listParams));
        sql.append(") \r\n ");
        return sql.toString();
    }

    private String getOrgIdFilterWithoutLogic(List orgIdList, String fieldName, List listParams) {
        StringBuffer sql = new StringBuffer();
        int size = orgIdList.size();
        for (int i = 0; i < size; ++i) {
            String orgId = orgIdList.get(i).toString();
            if (i > 0) {
                sql.append(" OR ");
            }
            sql.append(fieldName).append(" = ?");
            listParams.add(orgId);
        }
        return sql.toString();
    }

    private String getPermTypeFilter(String fieldName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" AND (");
        sql.append(fieldName).append("=").append(20);
        sql.append(" OR ").append(fieldName).append("=").append(30);
        sql.append(" )  \r\n");
        return sql.toString();
    }

    private String getS1BaseDataFilter(FullOrgUnitCollection orgCol, String objectTypeName, String operationTypeName) {
        ObjectUuidPK orgPK = null;
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            orgPK = new ObjectUuidPK(orgCol.get(i).getId());
            if (!"00000000-0000-0000-0000-000000000000CCE7AED4".equals(orgPK.toString())) continue;
            return "";
        }
        return FilterHelper.getS1BaseDataFilter(orgPK, objectTypeName, operationTypeName);
    }

    private String getCslrptPermNameFilter() {
        String sql = " and fname NOT IN (select FPermItemName from t_pm_cslPermItem) ";
        return sql;
    }

    private boolean isSourceFlag(UserOrgPermInfo uop) {
        return "true".equals(uop.getExtendedProperty("sourceFlag"));
    }

    private boolean isExpended(UserOrgPermInfo uop) {
        return "true".equals(uop.getExtendedProperty("expended"));
    }

    private boolean isLeaf(UserOrgPermInfo uop) {
        boolean ret = false;
        PermItemInfo piInfo = uop.getPermItem();
        if (piInfo != null) {
            ret = piInfo.isIsLeaf();
        }
        return ret;
    }

    private UserOrgPermCollection getUOPByPermType(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection permUops, int permType, boolean isBatch) throws BOSException, EASBizException {
        UserOrgPermCollection ret = new UserOrgPermCollection();
        if (permUops == null) {
            return ret;
        }
        UserOrgPermCollection temp_s_expends = new UserOrgPermCollection();
        UserOrgPermCollection temp_t_expends = new UserOrgPermCollection();
        for (int i = 0; i < permUops.size(); ++i) {
            UserOrgPermInfo uop = permUops.get(i);
            if (this.isLeaf(uop)) {
                ret.add(uop);
                continue;
            }
            if (this.isSourceFlag(uop)) {
                temp_s_expends.add(uop);
                continue;
            }
            temp_t_expends.add(uop);
        }
        if (temp_s_expends.size() > 0) {
            ret.addCollection(this.getExpandUOPs(ctx, sourceUserPK, userPK, orgCol, temp_s_expends, permType, true, isBatch));
        }
        if (temp_t_expends.size() > 0) {
            ret.addCollection(this.getExpandUOPs(ctx, sourceUserPK, userPK, orgCol, temp_t_expends, permType, false, isBatch));
        }
        return ret;
    }

    private UserOrgPermCollection getAllPermsFromUI(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops, boolean isBatch) throws BOSException, EASBizException {
        assert (uops != null);
        UserOrgPermCollection newUOPs = new UserOrgPermCollection();
        ExecutorService exec = Executors.newFixedThreadPool(3);
        Integer[] permTypes = new Integer[]{30, 10, 20};
        try {
            ArrayList<AllPermFromUIThread> tasks = new ArrayList<AllPermFromUIThread>(3);
            tasks.add(new AllPermFromUIThread(ctx, sourceUserPK, userPK, orgCol, uops[0], isBatch, permTypes[0]));
            tasks.add(new AllPermFromUIThread(ctx, sourceUserPK, userPK, orgCol, uops[1], isBatch, permTypes[1]));
            tasks.add(new AllPermFromUIThread(ctx, sourceUserPK, userPK, orgCol, uops[2], isBatch, permTypes[2]));
            exec.invokeAll(tasks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        exec.shutdown();
        newUOPs.addCollection(this.auto_coll);
        newUOPs.addCollection(this.norm_coll);
        newUOPs.addCollection(this.forb_coll);
        IObjectValue[] extendInfo = this.getUopExtendInfo(uops);
        UserInfo userInfo = (UserInfo)extendInfo[0];
        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)extendInfo[1];
        CtrlUnitInfo ctrlInfo = (CtrlUnitInfo)extendInfo[2];
        int size = newUOPs.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo newUOP = newUOPs.get(i);
            newUOP.setOwner(userInfo);
            newUOP.setOrg(fullOrgUnitInfo);
            newUOP.setCtrlUnit(ctrlInfo);
        }
        return newUOPs;
    }

    @Override
    protected void _saveUserOrgPerms(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops, boolean isEnabledAuthen) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        assert (uops != null);
        UserOrgPermCollection newUOPs = new UserOrgPermCollection();
        int length = 0;
        for (UserOrgPermCollection ops : uops) {
            if (ops == null) continue;
            newUOPs.addCollection(ops);
            ++length;
        }
        Integer[] opsTypes = new Integer[length];
        int beginIndex = 0;
        if (uops[0] != null) {
            opsTypes[beginIndex] = 30;
            ++beginIndex;
        }
        if (uops[1] != null) {
            opsTypes[beginIndex] = 10;
            ++beginIndex;
        }
        if (uops[2] != null) {
            opsTypes[beginIndex] = 20;
        }
        UserOrgPermCollection oldUOPs = this.getCurUOPS(ctx, sourceUserPK, userPK, orgCol, opsTypes);
        UserOrgPermCollection[] operations = UserPermHelper.getDiffUserOrgPerm(ctx, oldUOPs, newUOPs);
        if (!isEnabledAuthen) {
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(userPK);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"USER_ASSIGN_PERM"), (BOSObjectType)this.getBOSType(), (IObjectPK)userPK, (String)this.getLogDetail(userInfo, orgCol, operations));
            this.saveUOPsByDbUtil(ctx, sourceUserPK, userPK, orgCol, oldUOPs, operations, isEnabledAuthen);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        } else {
            this.saveUOPsWhenEnableAuthen(ctx, sourceUserPK, userPK, orgCol, oldUOPs, operations);
            UserOrgPermCollection eUOPs = this._getTargetUOPsByTypes(ctx, sourceUserPK, userPK, orgCol, opsTypes);
            UserOrgPermCollection[] userorgPerms = UserPermHelper.getDiffUserOrgPermWithOutAddDepPerm(ctx, oldUOPs, eUOPs);
            UserOrgPermCollection addUOPs = userorgPerms[0];
            UserOrgPermCollection delUOPs = userorgPerms[1];
            GroupLicenseUseInfoUtil.assignPermitem(ctx, userPK.toString(), UserPermHelper.getSingleUserPermIds(addUOPs));
            GroupLicenseUseInfoUtil.disAssignPermitems(ctx, userPK.toString(), UserPermHelper.getSingleUserPermIds(delUOPs));
        }
    }

    private String getLogDetail(UserInfo userInfo, FullOrgUnitCollection orgCol, UserOrgPermCollection[] operations) {
        UserOrgPermInfo userOrgPermInfo;
        int i;
        UserOrgPermCollection allAddUOPs = operations[0];
        UserOrgPermCollection allDelUOPs = operations[1];
        UserOrgPermCollection updateUOPs = operations[2];
        StringBuilder logContent = new StringBuilder();
        if (userInfo != null) {
            logContent.append(EASResource.getString((String)RESOURCE, (String)"OPERATE_USER") + "\uff1a");
            logContent.append(userInfo.getNumber());
        }
        logContent.append("\n" + EASResource.getString((String)RESOURCE, (String)"ORG"));
        for (i = 0; i < orgCol.size(); ++i) {
            logContent.append(orgCol.get(i).getDisplayName()).append(",");
        }
        if (allAddUOPs != null && !allAddUOPs.isEmpty()) {
            logContent.append("\n");
            logContent.append(EASResource.getString((String)RESOURCE, (String)"ADDNEW_PERM_INCLUDE"));
        }
        for (i = 0; i < allAddUOPs.size(); ++i) {
            userOrgPermInfo = allAddUOPs.get(i);
            logContent.append("\n" + userOrgPermInfo.getPermItemAlias() + "(" + userOrgPermInfo.getPermType().getAlias() + ")");
            if (StringUtils.isEmpty((String)userOrgPermInfo.getRuleExpr())) continue;
            logContent.append("-----" + EASResource.getString((String)RESOURCE, (String)"AUTHOR_RULES") + ":" + userOrgPermInfo.getRuleExpr());
        }
        if (!StringUtils.isEmpty((String)logContent.toString())) {
            logContent.append("\n");
        }
        if (allDelUOPs != null && !allDelUOPs.isEmpty()) {
            logContent.append(EASResource.getString((String)RESOURCE, (String)"DELETE_PERM_INCLUDE"));
        }
        for (i = 0; i < allDelUOPs.size(); ++i) {
            userOrgPermInfo = allDelUOPs.get(i);
            logContent.append("\n" + userOrgPermInfo.getPermItemAlias() + "(" + userOrgPermInfo.getPermType().getAlias() + ")");
        }
        if (!StringUtils.isEmpty((String)logContent.toString())) {
            logContent.append("\n");
        }
        if (updateUOPs != null && !updateUOPs.isEmpty()) {
            logContent.append(EASResource.getString((String)RESOURCE, (String)"UPDATE_PERM_INCLUDE"));
        }
        for (i = 0; i < updateUOPs.size(); ++i) {
            userOrgPermInfo = updateUOPs.get(i);
            logContent.append("\n" + userOrgPermInfo.getPermItemAlias() + "(" + userOrgPermInfo.getPermType().getAlias() + ")-----" + EASResource.getString((String)RESOURCE, (String)"UPDATE_AUTHOR_RULE") + ":" + userOrgPermInfo.getRuleExpr());
        }
        return logContent.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveUOPsWhenEnableAuthen(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection allUOPs, UserOrgPermCollection[] operations) throws BOSException, EASBizException {
        Connection conn;
        block8: {
            TableManager tableManager = null;
            String tmpTableName = null;
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                Set existUOPKeys = this.createUOPSet(allUOPs);
                Set addUOPKeys = this.createUOPSet(operations[0]);
                UserOrgPermCollection delUOPs = operations[1];
                UserOrgPermCollection allDelUOPs = this.getAllDelUOPs(ctx, delUOPs, existUOPKeys, addUOPKeys);
                UserOrgPermCollection addUOPs = operations[0];
                UserOrgPermCollection allAddUOPs = this.getAllAddUOPs(ctx, addUOPs, existUOPKeys, addUOPKeys);
                UserOrgPermCollection updateUOPs = operations[2];
                if (allAddUOPs.size() > 0 || updateUOPs.size() > 0) {
                    tableManager = TableManager.getTableManager((Context)ctx);
                    tmpTableName = tableManager.getTableName("permid");
                    StringBuffer createTmpSql = new StringBuffer();
                    createTmpSql.append("create table ").append(tmpTableName).append(" ").append("(").append("fpermitemid varchar(44), ").append("fpermtype int, ").append("frulestructure nvarchar(500), ").append("fruleexpr nvarchar(500), ").append("fpermassigntype int, ").append("forgid varchar(44), ").append("fctrlunit varchar(44), ").append("fuserorgperm varchar(44)").append(")");
                    tableManager.createTable(createTmpSql.toString());
                    this.dealAllAddAndUpdatePermsWhenEnableAuthen(ctx, conn, tmpTableName, userPK, allAddUOPs, updateUOPs, orgCol);
                }
                UserPermHelper.removeUserOrgPerms(ctx, allDelUOPs);
                this.cleanPermissionCache(ctx, userPK);
                this.handleCallBack(ctx, userPK);
                if (tableManager == null) break block8;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                    catch (Exception e2) {
                        logger.error((Object)e2);
                        throw new BOSException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (tableManager != null && !StringUtils.isEmpty(tmpTableName)) {
                        tableManager.releaseTable(tmpTableName);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((String)tmpTableName)) {
                tableManager.releaseTable(tmpTableName);
            }
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private boolean isUserOrgPermCollectionEmpty(UserOrgPermCollection userOrgPermCollection) {
        return userOrgPermCollection == null || userOrgPermCollection.isEmpty();
    }

    private void dealAllAddAndUpdatePermsWhenEnableAuthen(Context ctx, Connection conn, String tableName, IObjectPK userPK, UserOrgPermCollection allAddUOPs, UserOrgPermCollection updateUOPs, FullOrgUnitCollection orgCol) throws BOSException, EASBizException {
        if (this.isUserOrgPermCollectionEmpty(allAddUOPs) && this.isUserOrgPermCollectionEmpty(updateUOPs)) {
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into ").append(tableName).append(" ").append("(fpermitemid, fpermtype, frulestructure, fruleexpr, fpermassigntype, forgid,fctrlunit,fuserorgperm) ").append("values(?, ?, ?, ?, ?, ?, ?,?)");
            preparedStatement = conn.prepareStatement(insertSql.toString());
            String targetOrgId = orgCol.get(0).getId().toString();
            FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetOrgId));
            String ctrlUnitId = orgInfo.getCU().getId().toString();
            Iterator allAddUOPsIter = allAddUOPs.iterator();
            Iterator updateUOPsIter = updateUOPs.iterator();
            int count = 0;
            UserOrgPermInfo addUOPInfo = null;
            while (allAddUOPsIter.hasNext()) {
                addUOPInfo = (UserOrgPermInfo)allAddUOPsIter.next();
                preparedStatement.setString(1, addUOPInfo.getPermItem().getId().toString());
                preparedStatement.setInt(2, addUOPInfo.getPermType().getValue());
                preparedStatement.setString(3, addUOPInfo.getRuleStructure());
                preparedStatement.setString(4, addUOPInfo.getRuleExpr());
                preparedStatement.setInt(5, Integer.parseInt("10"));
                preparedStatement.setString(6, addUOPInfo.getOrg().getId().toString());
                preparedStatement.setString(7, ctrlUnitId);
                preparedStatement.setString(8, BOSUuid.create((String)"896DC075").toString());
                preparedStatement.addBatch();
                if (++count <= 30000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                count = 0;
            }
            UserOrgPermInfo updateUOPInfo = null;
            while (updateUOPsIter.hasNext()) {
                updateUOPInfo = (UserOrgPermInfo)updateUOPsIter.next();
                preparedStatement.setString(1, updateUOPInfo.getPermItem().getId().toString());
                preparedStatement.setInt(2, updateUOPInfo.getPermType().getValue());
                preparedStatement.setString(3, updateUOPInfo.getRuleStructure());
                preparedStatement.setString(4, updateUOPInfo.getRuleExpr());
                preparedStatement.setInt(5, Integer.parseInt("30"));
                preparedStatement.setString(6, updateUOPInfo.getOrg().getId().toString());
                preparedStatement.setString(7, ctrlUnitId);
                preparedStatement.setString(8, updateUOPInfo.getId().toString());
                preparedStatement.addBatch();
                if (++count <= 30000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                count = 0;
            }
            UserInfo userInfo = (UserInfo)UserFactory.getLocalInstance(ctx).getValue(userPK);
            this.dealNotNeedAuthenPerms(conn, tableName, userInfo, ctrlUnitId, targetOrgId);
            this.dealNeedAuthenPerms(ctx, conn, tableName, userInfo, ctrlUnitId, targetOrgId, 10);
            if (!ContextUtil.getCurrentUserInfo((Context)ctx).isBizAdmin() && userInfo.isBizAdmin()) {
                this.dealNeedAuthenPerms(ctx, conn, tableName, userInfo, ctrlUnitId, targetOrgId, 30);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preparedStatement);
    }

    private void dealNeedAuthenPerms(Context ctx, Connection con, String tableName, UserInfo userInfo, String ctrlUnitId, String targetOrgId, int permType) throws BOSException, SQLException, EASBizException {
        String userId = userInfo.getId().toString();
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Map permItemToUserMap = this.getAuthentorByTableNewMethod(con, targetOrgId, tableName, ctrlUnitId, permType);
        if (permItemToUserMap == null || permItemToUserMap.isEmpty()) {
            return;
        }
        String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, permType == 10 ? "10" : "80", userInfo.getNumber(), userInfo.getName(), "user");
        this.insertAuthenSnapViewInfo(con, tableName, permChangeId, ctrlUnitId, permType);
        this.insertIntoTableChange(con, permChangeId, userId, ctrlUnitId, targetOrgId, tableName, permType);
        this.insertAuthenRecord(ctx, con, ctrlUnitId, permItemToUserMap, permChangeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAuthenRecord(Context ctx, Connection con, String ctrlUnitId, Map permItemToUserMap, String permChangeId) throws SQLException, EASBizException, BOSException {
        if (permItemToUserMap == null || permItemToUserMap.isEmpty()) {
            return;
        }
        PreparedStatement statement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_authenrecord(fid, fpermchangeid, fauthenstatus, fauthentorid, fcu) ").append("values(newbosid('B0E636B6'), ?, ?, ?, ?)");
            statement = con.prepareStatement(insertSql.toString());
            Set keySet = permItemToUserMap.keySet();
            HashSet userIdSet = new HashSet();
            Set thisUserIdSet = null;
            for (Object permItemIdObj : keySet) {
                thisUserIdSet = (Set)permItemToUserMap.get(permItemIdObj);
                userIdSet.addAll(thisUserIdSet);
            }
            int count = 0;
            for (Object authentorIdObj : userIdSet) {
                statement.setString(1, permChangeId);
                statement.setString(2, "10");
                statement.setObject(3, authentorIdObj);
                statement.setString(4, ctrlUnitId);
                statement.addBatch();
                if (++count <= 8000) continue;
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, userIdSet);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoTableChange(Connection con, String permChangeId, String userId, String ctrlUnitId, String targetOrgId, String tableName, int permType) throws SQLException {
        PreparedStatement statement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_userorgpermchange(fid, fuserorgperm, fpermchangeid, fownerid, ").append("forgid, fpermitemid, fassigntype, fpermtype, frulestructure, fruleexpr, fauthenstatus, fctrlunitid) ").append("select newbosid('5592d485'), fuserorgperm, '").append(permChangeId).append("', '").append(userId).append("', forgid, fpermitemid, ").append("tbl.fpermassigntype").append(", fpermtype,frulestructure,fruleexpr, '").append("10").append("', '").append(ctrlUnitId).append("' ").append("from ").append(tableName).append(" as tbl ").append("where tbl.fpermtype = ? ").append("and tbl.fpermitemid in (").append("select schemeperm.fpermitemid ").append("from t_pm_authenschemeperm as schemeperm ").append("inner join t_pm_authenschemeorguser as asou on schemeperm.fauthenschemeid = asou.fauthenschemeid ").append("where asou.forgid = ?) and ").append("(tbl.forgid = ? or tbl.forgid=?)");
            statement = con.prepareStatement(insertSql.toString());
            statement.setInt(1, permType);
            statement.setString(2, ctrlUnitId);
            statement.setString(3, targetOrgId);
            statement.setString(4, "11111111-1111-1111-1111-111111111111CCE7AED4");
            statement.execute();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement);
    }

    private void insertAuthenSnapViewInfo(Connection con, String tableName, String permChangeId, String targetOrgId, int permType) throws BOSException {
        PreparedStatement preparedStatement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_authenschemesnapview(fid, froleid, fuserid, fpermitemid, fpermchangerecordid, fisrule)").append("select newbosid('38B94EC5'), '', asou.fuserid, tbl.fpermitemid, '").append(permChangeId).append("', authenrule.fisrule ").append("from ").append(tableName).append(" as tbl ").append("inner join t_pm_authenschemeperm as schemeperm on tbl.fpermitemid = schemeperm.fpermitemid ").append("inner join t_pm_authenschemeorguser as asou on schemeperm.fauthenschemeid = asou.fauthenschemeid and ").append("(asou.forgid = tbl.fctrlunit or tbl.forgid = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("') ").append("inner join t_pm_authenschemerule as authenrule on authenrule.fauthenschemeid = asou.fauthenschemeid and authenrule.forgid = asou.forgid ").append("where asou.forgid = ? and ").append("tbl.fpermtype = ?");
            preparedStatement = con.prepareStatement(insertSql.toString());
            preparedStatement.setString(1, targetOrgId);
            preparedStatement.setInt(2, permType);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAuthentorByTableNewMethod(Connection con, String targetOrgId, String tableName, String ctrlUnitId, int permType) throws SQLException {
        PreparedStatement statement = null;
        HashMap permItemToUserMap = new HashMap();
        ResultSet resultSet = null;
        try {
            StringBuffer queryAuthentorSql = new StringBuffer();
            queryAuthentorSql.append("select asou.fuserid userid, schemeperm.fpermitemid permid ").append("from t_pm_authenschemeorguser as asou ").append("inner join t_pm_authenschemeperm as schemeperm on schemeperm.fauthenschemeid = asou.fauthenschemeid ").append("inner join ").append(tableName).append(" as tbl on tbl.fpermitemid = schemeperm.fpermitemid ").append("where asou.forgid = ? ").append("and (tbl.forgid = ? or tbl.forgid = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("') ").append("and tbl.fpermtype = ? ").append("order by permid");
            statement = con.prepareStatement(queryAuthentorSql.toString());
            statement.setString(1, ctrlUnitId);
            statement.setString(2, targetOrgId);
            statement.setInt(3, permType);
            resultSet = statement.executeQuery();
            String userId = null;
            String permItemId = null;
            String lastPermItemId = null;
            HashSet<String> userIdSet = null;
            while (resultSet.next()) {
                userId = resultSet.getString("userid");
                permItemId = resultSet.getString("permid");
                if (!permItemId.equals(lastPermItemId)) {
                    userIdSet = (HashSet<String>)permItemToUserMap.get(permItemId);
                }
                if (userIdSet == null) {
                    userIdSet = new HashSet<String>();
                    permItemToUserMap.put(permItemId, userIdSet);
                }
                userIdSet.add(userId);
                lastPermItemId = permItemId;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(resultSet, statement);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement);
        return permItemToUserMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNotNeedAuthenPerms(Connection con, String tableName, UserInfo userInfo, String ctrlUnitId, String targetOrgId) throws SQLException {
        PreparedStatement insertStatement = null;
        PreparedStatement updateStatement = null;
        try {
            String owner = userInfo.getId().toString();
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_userorgperm(fid, fowner, forgid, fpermitemid, fpermtype, frulestructure, fruleexpr, fctrlunitid) ").append("select tbl.fuserorgperm, '").append(owner).append("', tbl.forgid, ").append("tbl.fpermitemid, tbl.fpermtype, tbl.frulestructure, tbl.fruleexpr, '").append(ctrlUnitId).append("' ").append("from ").append(tableName).append(" tbl ").append("left join t_pm_userorgperm hasperm on hasperm.fowner = '").append(owner).append("' and tbl.forgid = hasperm.forgid and tbl.fpermitemid = hasperm.fpermitemid and tbl.fpermtype = hasperm.fpermtype ").append("where hasperm.fid is null and ").append("tbl.fpermassigntype = ? and ").append("( ").append("(tbl.fpermitemid not in (").append("select schemeperm.fpermitemid ").append("from t_pm_authenschemeperm as schemeperm ").append("inner join t_pm_authenschemeorguser as asou on asou.fauthenschemeid = schemeperm.fauthenschemeid ").append("where asou.forgid = ? ").append("and schemeperm.fpermitemid = tbl.fpermitemid").append(") and tbl.fpermtype <> ?) or ").append("tbl.fpermtype = ?)");
            insertStatement = con.prepareStatement(insertSql.toString());
            insertStatement.setInt(1, Integer.parseInt("10"));
            insertStatement.setString(2, ctrlUnitId);
            insertStatement.setInt(3, 20);
            insertStatement.setInt(4, 20);
            insertStatement.execute();
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_pm_userorgperm uop ").append("set (frulestructure, fruleexpr) = (").append("select tbl.frulestructure, tbl.fruleexpr ").append("from ").append(tableName).append(" tbl ").append("where tbl.fuserorgperm = uop.fid ").append(") ").append("where uop.fid in (").append("select tbl2.fuserorgperm ").append("from ").append(tableName).append(" tbl2 ").append("where tbl2.fpermassigntype = ? and ").append("tbl2.fpermitemid not in (").append("select schemeperm.fpermitemid ").append("from t_pm_authenschemeperm as schemeperm ").append("inner join t_pm_authenschemeorguser as asou on asou.fauthenschemeid = schemeperm.fauthenschemeid ").append("where asou.forgid = ? ").append("and schemeperm.fpermitemid = tbl2.fpermitemid").append(")").append(")");
            updateStatement = con.prepareStatement(updateSql.toString());
            updateStatement.setInt(1, Integer.parseInt("30"));
            updateStatement.setString(2, ctrlUnitId);
            updateStatement.execute();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(insertStatement);
            SQLUtils.cleanup(updateStatement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)insertStatement);
        SQLUtils.cleanup((Statement)updateStatement);
    }

    private void saveUOPsByDbUtil(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection allUOPs, UserOrgPermCollection[] operations, boolean isEnabledAuthen) throws BOSException, EASBizException {
        if (this.canIgnore(operations)) {
            return;
        }
        try {
            UserOrgPermCollection allAddUOPs = operations[0];
            UserOrgPermCollection allDelUOPs = operations[1];
            UserOrgPermCollection updateUOPs = operations[2];
            UserPermHelper.removeUserOrgPerms(ctx, allDelUOPs);
            if (allAddUOPs.size() > 0) {
                this.dealAllAddPerms(ctx, userPK, allAddUOPs);
            }
            if (updateUOPs.size() > 0) {
                this.dealUpdatePerms(ctx, updateUOPs);
            }
            ArrayList<String> addPermitemIds = new ArrayList<String>();
            int size = allAddUOPs.size();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo urpi = allAddUOPs.get(i);
                PermItemInfo item = urpi.getPermItem();
                addPermitemIds.add(item.getId().toString());
            }
            long start0 = System.currentTimeMillis();
            if (addPermitemIds.size() > 0 && !GroupLicenseUseInfoUtil.assignPermitem(ctx, userPK.toString(), addPermitemIds)) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"notEnoughGroup"));
            }
            logger.error((Object)("GroupLicenseUseInfoUtil.assignPermitem:" + (System.currentTimeMillis() - start0)));
            if (allDelUOPs.size() > 0) {
                ArrayList<String> delPermitemIds = new ArrayList<String>();
                int size2 = allDelUOPs.size();
                for (int i = 0; i < size2; ++i) {
                    UserOrgPermInfo urpi = allDelUOPs.get(i);
                    PermItemInfo item = urpi.getPermItem();
                    delPermitemIds.add(item.getId().toString());
                }
                long start = System.currentTimeMillis();
                GroupLicenseUseInfoUtil.disAssignPermitems(ctx, userPK.toString(), delPermitemIds);
                logger.error((Object)("GroupLicenseUseInfoUtil.disAssignPermitems:" + (System.currentTimeMillis() - start)));
            }
            this.cleanPermissionCache(ctx, userPK);
            SavePermCallBackThread sthd = new SavePermCallBackThread();
            sthd.setCtx(ctx);
            sthd.setUserPK(userPK);
            Thread t = new Thread(sthd);
            t.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserOrgPermException(UserOrgPermException.ACCREDIT_FAIL, e);
        }
    }

    private void dealAllAddPerms(Context ctx, IObjectPK userPK, UserOrgPermCollection allAddUOPs) throws Exception {
        Connection conn = null;
        PreparedStatement state = null;
        try {
            conn = this.getConnection(ctx);
            String orgid = allAddUOPs.get(0).getOrg().getId().toString();
            FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
            String ctrlUnitId = orgInfo.getCU().getId().toString();
            String userPKStr = userPK.toString();
            String insertSql = "INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr, FCtrlUnitID) Values(newbosid('896DC075'), ? , ? , ? , ? , ? , ? , ?)";
            state = conn.prepareStatement(insertSql);
            if (allAddUOPs.size() > 0) {
                int firstCount = 0;
                int maxCount = 999;
                int pageSize = 999;
                int totalCount = allAddUOPs.size();
                int totalPage = (totalCount - 1) / pageSize + 1;
                for (int j = 0; j < totalPage; ++j) {
                    firstCount = pageSize * j;
                    maxCount = pageSize * (j + 1);
                    if (maxCount > totalCount) {
                        maxCount = totalCount;
                    }
                    for (int i = firstCount; i < maxCount; ++i) {
                        UserOrgPermInfo userOrgPermInfo = allAddUOPs.get(i);
                        state.setString(1, userPKStr);
                        state.setString(2, UserPermHelper.getOrgIdStr(userOrgPermInfo.getOrg().getId()));
                        state.setString(3, UserPermHelper.getPermIdStr(userOrgPermInfo.getPermItem().getId()));
                        state.setInt(4, userOrgPermInfo.getPermType().getValue());
                        state.setString(5, userOrgPermInfo.getRuleStructure());
                        state.setString(6, userOrgPermInfo.getRuleExpr());
                        state.setString(7, ctrlUnitId);
                        state.addBatch();
                    }
                    state.executeBatch();
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"dealAllAddPerms\u65b0\u589e\u6743\u9650\u63d2\u5165\u5931\u8d25!");
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private void dealPermWhenNotNeedAuthen(Context ctx, String tableName, IObjectPK userPK, String ctrlUnitId) throws BOSException {
        String sql = "INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr, FCtrlUnitID) SELECT FUserOrgPerm,'" + userPK.toString() + "',ForgId,FpermItemId,FpermType,FRuleStructure,FRuleExpr,'" + ctrlUnitId + "' from " + tableName + "";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void insertAuthenRecord(Context ctx, String ctrlUnitId, Set<String> authentorSet, String permChangeId) throws BOSException, SQLException, EASBizException {
        if (authentorSet == null || authentorSet.isEmpty()) {
            return;
        }
        for (String authentorId : authentorSet) {
            String sql = "INSERT INTO T_PM_AuthenRecord(FID,FPermChangeID,FAuthenStatus,FAuthentorID,FCU) VALUES('" + BOSUuid.create((String)"B0E636B6").toString() + "','" + permChangeId + "','" + "10" + "','" + authentorId + "','" + ctrlUnitId + "')";
            DbUtil.execute((Context)ctx, (String)sql);
            AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, authentorId);
        }
    }

    private void insertAuthenRecord(Context ctx, Connection conn, String ctrlUnitId, Set<String> authentorSet, String permChangeId) throws BOSException, SQLException, EASBizException {
        PreparedStatement preparedStatement = null;
        try {
            if (authentorSet == null || authentorSet.isEmpty()) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into t_pm_authenrecord(fid, fpermchangeid, fauthenstatus, fauthentorid, fcu)").append("values(newbosid('B0E636B6'), ?, ?, ?, ?)");
            preparedStatement = conn.prepareStatement(sql.toString());
            for (String authentorId : authentorSet) {
                preparedStatement.setString(1, permChangeId);
                preparedStatement.setString(2, "10");
                preparedStatement.setString(3, authentorId);
                preparedStatement.setString(4, ctrlUnitId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            for (String authentorId : authentorSet) {
                AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, authentorId);
            }
            SQLUtils.cleanup((Statement)preparedStatement);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(preparedStatement);
        }
    }

    private Set<String> getAuthentorByTable(Context ctx, String ctrlUnitId, String targetOrgId, String tableName, int permType) throws BOSException, SQLException {
        HashSet<String> authentorSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AUOU.FUSERID as  fauthentorid                      ");
        sql.append("   FROM T_PM_AUTHENSCHEME SM                              ");
        sql.append("  INNER JOIN T_PM_AUTHENSCHEMEPERM AUPERM                 ");
        sql.append("     ON SM.FID = AUPERM.FAUTHENSCHEMEID                   ");
        sql.append("  INNER JOIN T_PM_AUTHENSCHEMEORGUSER AUOU                ");
        sql.append("     ON SM.FID = AUOU.FAUTHENSCHEMEID                     ");
        sql.append("  INNER JOIN " + tableName + " TMPTABLE                       ");
        sql.append("     ON TMPTABLE.FORGID = AUOU.FORGID                     ");
        sql.append("     AND TMPTABLE.FPERMITEMID = AUPERM.FPERMITEMID        ");
        sql.append("    where tmptable.fpermtype=" + permType);
        sql.append("    AND tmptable.FORGID='" + targetOrgId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet.next()) {
            authentorSet.add(rowSet.getString("fauthentorid"));
        }
        return authentorSet;
    }

    private Set<String> getAuthentorByTable(Connection conn, String ctrlUnitId, String targetOrgId, String tableName, int permType) throws BOSException, SQLException {
        HashSet<String> hashSet;
        HashSet<String> authentorSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String sql = "select fauthentorid from T_PM_PermAuthentor atr where atr.fpermitemid in (select distinct FpermItemId from  " + tableName + " where fpermtype=" + permType + " and forgid='" + targetOrgId + "') and atr.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')) group by fauthentorid";
            preparedStatement = conn.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                authentorSet.add(resultSet.getString("fauthentorid"));
            }
            hashSet = authentorSet;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement);
        return hashSet;
    }

    private void dealPermWhenNeedAuthen(Context ctx, Connection conn, IObjectPK userPK, String tableName, String ctrlUnitId, UserOrgPermCollection allAddUOPs) throws BOSException, EASBizException, SQLException {
        if (allAddUOPs == null || allAddUOPs.isEmpty()) {
            return;
        }
        String targetOrgId = allAddUOPs.get(0).getOrg().getId().toString();
        UserInfo userInfo = (UserInfo)UserFactory.getLocalInstance(ctx).getValue(userPK);
        List needAuthenPermIds = this.getNeedAuthenPermIds(ctx, ctrlUnitId);
        List normalPermIds = this.getWithoutAuthenPermIds(needAuthenPermIds, allAddUOPs);
        ExecutorService exec = Executors.newFixedThreadPool(3);
        try {
            ArrayList<NeedAuthenPermsThread> tasks = new ArrayList<NeedAuthenPermsThread>(3);
            tasks.add(new NeedAuthenPermsThread(ctx, conn, tableName, userInfo, ctrlUnitId, targetOrgId, normalPermIds, -1));
            tasks.add(new NeedAuthenPermsThread(ctx, conn, tableName, userInfo, ctrlUnitId, targetOrgId, normalPermIds, 10));
            tasks.add(new NeedAuthenPermsThread(ctx, conn, tableName, userInfo, ctrlUnitId, targetOrgId, normalPermIds, 30));
            exec.invokeAll(tasks);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        exec.shutdown();
    }

    public List getNeedAuthenPermIds(Context ctx, String ctrlUnitId) {
        ArrayList<String> result = (ArrayList<String>)PermCacheHelper.getPermCacheValue(PermCacheHelper.AUTHENPERMCACHE, ctrlUnitId, null);
        if (result == null) {
            result = new ArrayList<String>();
            String sql = "select pa.fpermitemid from T_PM_PermAuthentor pa where pa.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "'))";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List getWithoutAuthenPermIds(List needAuhtenPermIds, UserOrgPermCollection allAddUOPs) {
        ArrayList<String> withoutAuthenPermIds = new ArrayList<String>();
        for (int i = 0; i < allAddUOPs.size(); ++i) {
            String permId = allAddUOPs.get(i).getPermItem().getId().toString();
            if (needAuhtenPermIds == null || needAuhtenPermIds.contains(permId)) continue;
            withoutAuthenPermIds.add(permId);
        }
        return withoutAuthenPermIds;
    }

    private void copyNotNeedAuthenPerms(Context ctx, String tableName, UserInfo userInfo, String ctrlUnitId) throws BOSException {
        String sql = "INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr, FCtrlUnitID) SELECT FUserOrgPerm,'" + userInfo.getId().toString() + "',FOrgid,FpermItemId,FpermType,FRuleStructure,FRuleExpr,'" + ctrlUnitId + "' from " + tableName + " tbl where tbl.FpermType=" + 20 + " OR tbl.FpermType<>" + 20 + " AND tbl.FpermItemId not in (select pa.fpermitemid from T_PM_PermAuthentor pa where pa.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')))";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void copyNotNeedAuthenPerms(Connection conn, String tableName, UserInfo userInfo, String ctrlUnitId) throws BOSException {
        PreparedStatement preparedStatement = null;
        try {
            String sql = "INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr, FCtrlUnitID) SELECT FUserOrgPerm,'" + userInfo.getId().toString() + "',FOrgid,FpermItemId,FpermType,FRuleStructure,FRuleExpr,'" + ctrlUnitId + "' from " + tableName + " tbl where tbl.FpermType=" + 20 + " OR tbl.FpermType<>" + 20 + " AND tbl.FpermItemId not in (select pa.fpermitemid from T_PM_PermAuthentor pa where pa.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')))";
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preparedStatement);
    }

    private void copyNeedAuthenPerms(Context ctx, String tableName, UserInfo userInfo, String ctrlUnitId, String targetOrgId, int permType) throws EASBizException, BOSException, SQLException {
        String userId = userInfo.getId().toString();
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Set<String> authentorSet = this.getAuthentorByTable(ctx, ctrlUnitId, targetOrgId, tableName, permType);
        if (authentorSet == null || authentorSet.isEmpty()) {
            return;
        }
        String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, permType == 10 ? "10" : "80", userInfo.getNumber(), userInfo.getName(), "user");
        String sql = "INSERT INTO T_PM_UserOrgPermChange (FID,FUserOrgPerm,FPermChangeID,FOwnerid, FOrgID, FPermItemID, FASSIGNTYPE,FPermType, FRuleStructure, FRuleExpr, FAuthenStatus,FCtrlUnitID) SELECT FUserOrgPermChange,FUserOrgPerm,'" + permChangeId + "','" + userId + "',FOrgid,FpermItemId,'" + "10" + "',FpermType,FRuleStructure,FRuleExpr,'" + "10" + "','" + ctrlUnitId + "'from " + tableName + " tbl where tbl.FPermType=" + permType + " AND tbl.FpermItemId in (select pa.fpermitemid from T_PM_PermAuthentor pa where pa.fpermitemid = tbl.FpermItemId and pa.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')))";
        DbUtil.execute((Context)ctx, (String)sql);
        this.insertAuthenRecord(ctx, ctrlUnitId, authentorSet, permChangeId);
    }

    private void copyNeedAuthenPerms(Context ctx, Connection conn, String tableName, UserInfo userInfo, String ctrlUnitId, String targetOrgId, int permType) throws EASBizException, BOSException, SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String userId = userInfo.getId().toString();
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Set<String> authentorSet = this.getAuthentorByTable(conn, ctrlUnitId, targetOrgId, tableName, permType);
            if (authentorSet == null || authentorSet.isEmpty()) {
                return;
            }
            String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, permType == 10 ? "10" : "80", userInfo.getNumber(), userInfo.getName(), "user");
            String sql = "INSERT INTO T_PM_UserOrgPermChange (FID,FUserOrgPerm,FPermChangeID,FOwnerid, FOrgID, FPermItemID, FASSIGNTYPE,FPermType, FRuleStructure, FRuleExpr, FAuthenStatus,FCtrlUnitID) SELECT FUserOrgPermChange,FUserOrgPerm,'" + permChangeId + "','" + userId + "',FOrgid,FpermItemId,'" + "10" + "',FpermType,FRuleStructure,FRuleExpr,'" + "10" + "','" + ctrlUnitId + "'from " + tableName + " tbl where tbl.FPermType=" + permType + " AND tbl.FpermItemId in (select pa.fpermitemid from T_PM_PermAuthentor pa where pa.fpermitemid = tbl.FpermItemId and pa.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')))";
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.execute();
            this.insertAuthenRecord(ctx, conn, ctrlUnitId, authentorSet, permChangeId);
            SQLUtils.cleanup((Statement)preparedStatement);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(preparedStatement);
        }
    }

    private void dealUpdatePerms(Context ctx, UserOrgPermCollection updateUOPs) throws BOSException {
        if (updateUOPs == null || updateUOPs.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_PM_UserOrgPerm SET FRuleStructure = ?, FRuleExpr = ? WHERE fowner = ? and forgid = ? and FPermItemID = ? and fpermtype = ?";
        DbUtil.executeBatch((Context)ctx, (String)sql, this.getUpdateUOPBatchParams(updateUOPs));
    }

    @Override
    protected void _saveUserOrgPermsBatch(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops) throws BOSException, EASBizException {
        assert (uops != null);
        UserOrgPermCollection perms = this.getAllPermsFromUI(ctx, sourceUserPK, userPK, orgCol, uops, true);
        if (perms.size() * orgCol.size() > 30000) {
            throw new PermissionException(PermissionException.ORGPERMTOOMANY, new Object[]{new Integer(30000)});
        }
        this.saveUOPsBatch(ctx, userPK, cuPK, orgCol, perms);
        UserOrgPermCollection addUOPs = uops[1];
        UserOrgPermCollection delUOPs = uops[2];
        ArrayList<String> addPermitemIds = new ArrayList<String>();
        int size = this.norm_coll.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo urpi = this.norm_coll.get(i);
            PermItemInfo item = urpi.getPermItem();
            addPermitemIds.add(item.getId().toString());
        }
        if (!GroupLicenseUseInfoUtil.assignPermitem(ctx, userPK.toString(), addPermitemIds)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"ASSIGN_DATA_NOTENOUGH"));
        }
        if (this.forb_coll.size() > 0) {
            ArrayList<String> delPermitemIds = new ArrayList<String>();
            int size2 = this.forb_coll.size();
            for (int i = 0; i < size2; ++i) {
                UserOrgPermInfo urpi = this.forb_coll.get(i);
                PermItemInfo item = urpi.getPermItem();
                delPermitemIds.add(item.getId().toString());
            }
            GroupLicenseUseInfoUtil.disAssignPermitems(ctx, userPK.toString(), delPermitemIds);
        }
        String flagName = "FClientFlag";
        try {
            Class<?> class1 = Class.forName("com.kingdee.portal.biz.facade.portal.facade.PortalCacheFacade");
            Object obj = class1.newInstance();
            Method method = class1.getMethod("updateCacheFlag", Context.class, String.class);
            method.invoke(obj, ctx, flagName);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void saveUOPsBatch(Context ctx, IObjectPK userPK, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection perms) throws BOSException, EASBizException {
        HashMap<String, List<String>> cuOrgHashMap = this.cuOrgListHashMap(ctx, orgCol);
        List orgIdList = ToolUtils.orgCol2List(orgCol);
        boolean isNeedAddSysCu = ToolUtils.addSysOrgId(orgIdList);
        if (isNeedAddSysCu) {
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            fullOrgUnitInfo.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            if (orgCol != null && !orgCol.isEmpty()) {
                orgCol.add(fullOrgUnitInfo);
            }
        }
        UserOrgPermCollection permsWithDep = this.addDepPerm(ctx, perms, false);
        List userOrgPermIdCol = this.getUserOrgPermIdCol(ctx, userPK, cuPK, orgCol, permsWithDep);
        this.saveInDTempTable(ctx, userOrgPermIdCol, cuPK.toString(), userPK.toString(), cuOrgHashMap);
        this.cleanPermissionCache(ctx, userPK);
        this.handleCallBack(ctx, userPK);
    }

    private HashMap<String, List<String>> cuOrgListHashMap(Context ctx, FullOrgUnitCollection orgCol) throws EASBizException, BOSException {
        HashMap<String, List<String>> cuOrgHasmMap = new HashMap<String, List<String>>();
        if (orgCol == null || orgCol.isEmpty()) {
            return cuOrgHasmMap;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            String currentOrg = orgCol.get(i).getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrg));
            String cuIDStr = fullOrgUnitInfo.getCU().getId().toString();
            List<String> orgList = cuOrgHasmMap.get(cuIDStr);
            if (orgList == null || orgList.isEmpty()) {
                orgList = new ArrayList<String>();
                orgList.add(currentOrg);
            } else {
                orgList.add(currentOrg);
            }
            cuOrgHasmMap.put(cuIDStr, orgList);
        }
        return cuOrgHasmMap;
    }

    @Override
    protected void _deleteUserOrgPermsBatch(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops) throws BOSException, EASBizException {
        assert (uops != null);
        UserOrgPermCollection perms = this.getAllPermsFromUI(ctx, sourceUserPK, userPK, orgCol, uops, true);
        if (perms.size() * orgCol.size() > 30000) {
            throw new PermissionException(PermissionException.ORGPERMTOOMANY, new Object[]{new Integer(30000)});
        }
        perms = this.addDepPerm(ctx, perms, true);
        this.deleteUOPsBatchByDbUtil(ctx, userPK, cuPK, orgCol, perms);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteUOPsBatchByDbUtil(Context ctx, IObjectPK userPK, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection perms) throws BOSException, EASBizException {
        Connection conn;
        PreparedStatement state;
        block7: {
            if (userPK == null) return;
            if (orgCol == null) return;
            if (orgCol.isEmpty()) return;
            if (cuPK == null) {
                return;
            }
            TableManager manager = null;
            state = null;
            conn = this.getConnection(ctx);
            String tableName = null;
            ArrayList<String> permitemIdList = new ArrayList<String>();
            try {
                manager = TableManager.getTableManager((Context)ctx);
                tableName = manager.getTableName("permid");
                String createSql = "create table " + tableName + " (FpermId varchar(44),FpermType INT)";
                manager.createTable(createSql);
                String insertTmpSql = "insert into " + tableName + " (FpermId,FpermType) values(?,?)";
                state = conn.prepareStatement(insertTmpSql);
                for (int i = 0; i < perms.size(); ++i) {
                    permitemIdList.add(perms.get(i).getPermItem().getId().toString());
                    UserOrgPermInfo userOrgPermInfo = perms.get(i);
                    state.setString(1, userOrgPermInfo.getPermItem().getId().toString());
                    state.setInt(2, userOrgPermInfo.getPermType().getValue());
                    state.addBatch();
                }
                state.executeBatch();
                List orgIdAry = ToolUtils.orgCol2List(orgCol);
                ToolUtils.addSysOrgId(orgIdAry);
                String orgStr = ToolUtils.aryToStr(orgIdAry, true);
                StringBuffer sql = new StringBuffer();
                sql.append("delete from t_pm_userorgperm where fowner = '").append(userPK.toString()).append("' and forgid in (").append(orgStr).append(")").append(" and exists (select 1 from " + tableName + " t where t.FpermId=t_pm_userorgperm.FPERMITEMID ").append(" and t.FpermType = t_pm_userorgperm.FpermType)");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                this.cleanPermissionCache(ctx, userPK);
                this.handleCallBack(ctx, userPK);
                if (manager == null || tableName == null) break block7;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    throw new UserOrgPermException(UserOrgPermException.ACCREDIT_FAIL, e);
                }
                catch (Throwable throwable) {
                    if (manager != null && tableName != null) {
                        manager.releaseTable(tableName);
                    }
                    SQLUtils.cleanup(state, (Connection)conn);
                    throw throwable;
                }
            }
            manager.releaseTable(tableName);
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private boolean canIgnore(UserOrgPermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i].size() <= 0) continue;
            return false;
        }
        return true;
    }

    private UserOrgPermCollection getAllDelUOPs(Context context, UserOrgPermCollection delUOPs, Set existUOPKeys, Set addUOPKeys) throws BOSException, EASBizException {
        UserOrgPermCollection result = (UserOrgPermCollection)((Object)delUOPs.clone());
        Set currentDelUOPs = this.createUOPSet(result);
        int size = delUOPs.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = delUOPs.get(i);
            PermItemCollection beenDepPerms = PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
            if (beenDepPerms == null) continue;
            int size1 = beenDepPerms.size();
            for (int j = 0; j < size1; ++j) {
                String key;
                PermItemInfo beenDepPerm = beenDepPerms.get(j);
                if (!info.getPermItem().getOrgRelation().equals((Object)beenDepPerms.get(j).getOrgRelation()) || !existUOPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) && !addUOPKeys.contains(key) || currentDelUOPs.contains(key)) continue;
                result.removeObject(info.getId());
            }
        }
        return result;
    }

    private UserOrgPermCollection getAllAddUOPs(Context context, UserOrgPermCollection addUOPs, Set existUOPKeys, Set addUOPKeys) throws BOSException, EASBizException {
        UserOrgPermInfo info;
        int i;
        UserOrgPermCollection result = new UserOrgPermCollection();
        UserOrgPermCollection uops = (UserOrgPermCollection)((Object)addUOPs.clone());
        CtrlUnitInfo sysCU = new CtrlUnitInfo();
        sysCU.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        int size = uops.size();
        for (i = 0; i < size; ++i) {
            info = uops.get(i);
            if (!info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) continue;
            info.setOrg(sysCU.castToFullOrgUnitInfo());
            info.setCtrlUnit(sysCU);
        }
        size = addUOPs.size();
        for (i = 0; i < size; ++i) {
            PermItemInfo beenDepPerm;
            PermItemCollection beenDepPerms;
            UserOrgPermInfo newUOP;
            String key;
            int j;
            int size1;
            info = addUOPs.get(i);
            if (info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL)) {
                PermItemInfo depPerm;
                PermItemCollection depPerms = PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
                if (depPerms == null) continue;
                if (info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) {
                    size1 = depPerms.size();
                    for (j = 0; j < size1; ++j) {
                        depPerm = depPerms.get(j);
                        if (!depPerm.getOrgRelation().equals((Object)OrgType.NONE) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                        newUOP = (UserOrgPermInfo)info.clone();
                        newUOP.setOrg(sysCU.castToFullOrgUnitInfo());
                        newUOP.setCtrlUnit(sysCU);
                        newUOP.setPermItem(depPerm);
                        newUOP.setRuleStructure(null);
                        newUOP.setRuleExpr(null);
                        uops.add(newUOP);
                        addUOPKeys.add(key);
                    }
                    continue;
                }
                size1 = depPerms.size();
                for (j = 0; j < size1; ++j) {
                    depPerm = depPerms.get(j);
                    if (depPerm.getOrgRelation().equals((Object)info.getPermItem().getOrgRelation())) {
                        key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType());
                        if (existUOPKeys.contains(key) || addUOPKeys.contains(key)) continue;
                        newUOP = (UserOrgPermInfo)info.clone();
                        newUOP.setPermItem(depPerm);
                        newUOP.setRuleStructure(null);
                        newUOP.setRuleExpr(null);
                        uops.add(newUOP);
                        addUOPKeys.add(key);
                        continue;
                    }
                    if (!depPerm.getOrgRelation().equals((Object)OrgType.NONE) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                    newUOP = (UserOrgPermInfo)info.clone();
                    newUOP.setOrg(sysCU.castToFullOrgUnitInfo());
                    newUOP.setCtrlUnit(sysCU);
                    newUOP.setPermItem(depPerm);
                    newUOP.setRuleStructure(null);
                    newUOP.setRuleExpr(null);
                    uops.add(newUOP);
                    addUOPKeys.add(key);
                }
                continue;
            }
            if (!info.getPermType().equals((Object)PermType.FORBIDDEN) || (beenDepPerms = PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()))) == null) continue;
            if (info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) {
                size1 = beenDepPerms.size();
                for (j = 0; j < size1; ++j) {
                    beenDepPerm = beenDepPerms.get(j);
                    if (!beenDepPerm.getOrgRelation().equals((Object)OrgType.NONE) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                    newUOP = (UserOrgPermInfo)info.clone();
                    newUOP.setOrg(sysCU.castToFullOrgUnitInfo());
                    info.setCtrlUnit(sysCU);
                    newUOP.setPermItem(beenDepPerm);
                    newUOP.setRuleStructure(null);
                    newUOP.setRuleExpr(null);
                    uops.add(newUOP);
                    addUOPKeys.add(key);
                }
                continue;
            }
            size1 = beenDepPerms.size();
            for (j = 0; j < size1; ++j) {
                beenDepPerm = beenDepPerms.get(j);
                if (!beenDepPerm.getOrgRelation().equals((Object)info.getPermItem().getOrgRelation()) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                newUOP = (UserOrgPermInfo)info.clone();
                newUOP.setPermItem(beenDepPerm);
                newUOP.setRuleStructure(null);
                newUOP.setRuleExpr(null);
                uops.add(newUOP);
                addUOPKeys.add(key);
            }
        }
        UserOrgPermInfo userOrgPermInfo = null;
        int size2 = uops.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            userOrgPermInfo = uops.get(i2);
            if (existUOPKeys.contains(PermissionCommonUtil.getKey(userOrgPermInfo))) continue;
            result.add(userOrgPermInfo);
        }
        return result;
    }

    private IObjectValue[] getUopExtendInfo(UserOrgPermCollection[] uops) {
        assert (uops != null);
        IObjectValue[] rets = new IObjectValue[3];
        int length = uops.length;
        for (int i = 0; i < length; ++i) {
            if (uops[i] == null || uops[i].size() <= 0) continue;
            rets[0] = uops[i].get(0).getOwner();
            rets[1] = uops[i].get(0).getOrg();
            rets[2] = uops[i].get(0).getCtrlUnit();
            break;
        }
        return rets;
    }

    public UserOrgPermCollection addDepPerm(Context context, UserOrgPermCollection UserOrgPermColl, boolean isDelete) throws EASBizException, BOSException {
        int i;
        UserOrgPermCollection ret = new UserOrgPermCollection();
        HashSet<String> alreadyAddedPerm = new HashSet<String>();
        int size = UserOrgPermColl.size();
        for (i = 0; i < size; ++i) {
            String key = this.getUniqueKey(UserOrgPermColl.get(i));
            alreadyAddedPerm.add(key);
        }
        for (i = 0; i < UserOrgPermColl.size(); ++i) {
            UserOrgPermInfo info = UserOrgPermColl.get(i);
            ret.add(info);
            PermItemCollection depPerms = new PermItemCollection();
            depPerms = !isDelete ? (info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()))) : (info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())));
            if (depPerms == null) continue;
            for (int j = 0; j < depPerms.size(); ++j) {
                UserOrgPermInfo depUserOrgPermInfo = new UserOrgPermInfo();
                depUserOrgPermInfo.setOrg(info.getOrg());
                depUserOrgPermInfo.setOwner(info.getOwner());
                depUserOrgPermInfo.setPermType(info.getPermType());
                depUserOrgPermInfo.setCtrlUnit(info.getCtrlUnit());
                depUserOrgPermInfo.setPermItem(depPerms.get(j));
                String key = this.getUniqueKey(depUserOrgPermInfo);
                if (alreadyAddedPerm.contains(key)) continue;
                alreadyAddedPerm.add(key);
                ret.add(depUserOrgPermInfo);
            }
        }
        return ret;
    }

    private String getUniqueKey(UserOrgPermInfo info) {
        return new StringBuffer().append(info.getOwner().getId()).append("-").append(info.getOrg().getId()).append("-").append(info.getPermItem().getId()).append("-").append((Object)info.getPermType()).toString();
    }

    private List getUserOrgPermIdCol(Context ctx, IObjectPK userPK, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection userOrgPermCol) {
        ArrayList<UserOrgPermIdInfo> ret = new ArrayList<UserOrgPermIdInfo>();
        if (userPK == null || orgCol == null || orgCol.isEmpty() || cuPK == null || userOrgPermCol == null) {
            return ret;
        }
        Map<OrgType, UserOrgPermCollection> orgTypeOUPMap = this.getOrgTypeUOPMap(userOrgPermCol);
        Iterator<OrgType> orgTypeItr = orgTypeOUPMap.keySet().iterator();
        String sysCuId = "11111111-1111-1111-1111-111111111111CCE7AED4";
        ConfigurationLoader loader = ConfigurationLoader.getInstance();
        ConfigurationInfo configInfo = loader.getConfigurationInfo();
        while (orgTypeItr.hasNext()) {
            UserOrgPermInfo userOrgPerm;
            int j;
            int size2;
            FullOrgUnitInfo orgInfo;
            int size1;
            int i;
            OrgType orgType = orgTypeItr.next();
            UserOrgPermCollection uopCol = orgTypeOUPMap.get(orgType);
            if (orgType.getValue() == -1) {
                int size = uopCol.size();
                for (i = 0; i < size; ++i) {
                    UserOrgPermInfo userOrgPerm2 = uopCol.get(i);
                    ret.add(this.getUserOrgPermIdInfo(userOrgPerm2, userPK.toString(), sysCuId));
                }
                continue;
            }
            if (orgType.getValue() == 1) {
                size1 = orgCol.size();
                for (i = 0; i < size1; ++i) {
                    orgInfo = orgCol.get(i);
                    if (!orgInfo.isIsUnion()) continue;
                    size2 = uopCol.size();
                    for (j = 0; j < size2; ++j) {
                        userOrgPerm = uopCol.get(j);
                        if (!configInfo.getCslrptPermItemNames().contains(userOrgPerm.getPermItem().getNumber())) continue;
                        ret.add(this.getUserOrgPermIdInfo(userOrgPerm, userPK.toString(), orgInfo.getId().toString()));
                    }
                }
            }
            size1 = orgCol.size();
            for (i = 0; i < size1; ++i) {
                orgInfo = orgCol.get(i);
                if (!OrgCommonUtils.isOrgType((OrgUnitInfo)orgInfo, (OrgType)orgType)) continue;
                size2 = uopCol.size();
                for (j = 0; j < size2; ++j) {
                    userOrgPerm = uopCol.get(j);
                    ret.add(this.getUserOrgPermIdInfo(userOrgPerm, userPK.toString(), orgInfo.getId().toString()));
                }
            }
        }
        return ret;
    }

    private Map<OrgType, UserOrgPermCollection> getOrgTypeUOPMap(UserOrgPermCollection userOrgPermCol) {
        HashMap<OrgType, UserOrgPermCollection> ret = new HashMap<OrgType, UserOrgPermCollection>();
        int size = userOrgPermCol.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo uop = userOrgPermCol.get(i);
            OrgType orgType = uop.getPermItem().getOrgRelation();
            UserOrgPermCollection value = (UserOrgPermCollection)((Object)ret.get(orgType));
            value = value != null ? (UserOrgPermCollection)((Object)ret.get(orgType)) : new UserOrgPermCollection();
            value.add(uop);
            ret.put(orgType, value);
        }
        return ret;
    }

    private UserOrgPermIdInfo getUserOrgPermIdInfo(UserOrgPermInfo info, String userId, String orgId) {
        UserOrgPermIdInfo ret = new UserOrgPermIdInfo();
        ret.setPermItemID(info.getPermItem().getId().toString());
        ret.setPermType(info.getPermType().getValue());
        ret.setOrgID(orgId);
        ret.setUserID(userId);
        return ret;
    }

    private void saveInDTempTable(Context ctx, List uopIds, String cuPK, String userId, HashMap<String, List<String>> cuOrgHashMap) throws BOSException, EASBizException {
        TableManager manager = null;
        String tableName = null;
        try {
            manager = TableManager.getTableManager((Context)ctx);
            if (manager != null) {
                tableName = manager.getTableName("permissionBatch");
                String createSql = "create table " + tableName + " (FOwner varchar(44),FOrgId varchar(44),FPermItemId varchar(44),FPermType int)";
                manager.createTable(createSql);
            }
            this.addUserOrgPermTmpBatchByDbUtil(ctx, uopIds, tableName);
            this.insertIntoUOP(ctx, tableName, cuPK, userId, cuOrgHashMap);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (manager != null && tableName != null) {
                manager.releaseTable(tableName);
            }
        }
    }

    private List<Object[]> getAddUserOrgPermTmpBatchParams(List uopIds) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        int size = uopIds.size();
        for (int i = 0; i < size; ++i) {
            Object[] params = new Object[4];
            UserOrgPermIdInfo info = (UserOrgPermIdInfo)uopIds.get(i);
            params[0] = info.getUserID();
            params[1] = info.getOrgID();
            params[2] = info.getPermItemID();
            params[3] = info.getPermType();
            ret.add(params);
        }
        return ret;
    }

    private void addUserOrgPermTmpBatchByDbUtil(Context ctx, List uopIds, String tmpTableName) throws BOSException {
        String sql = "insert into " + tmpTableName + "( fowner,forgid,fpermitemid,fpermType) values(?,?,?,?)";
        List<Object[]> paramsList = this.getAddUserOrgPermTmpBatchParams(uopIds);
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    private void insertIntoUOP(Context ctx, String tmpTableName, String cuPK, String userId, HashMap<String, List<String>> cuOrgHashMap) throws BOSException, EASBizException, SQLException {
        boolean isEnabledAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
        if (!isEnabledAuthen) {
            this.batchAssignPermsWhenPermAuthenDisabled(ctx, tmpTableName, cuPK);
        } else {
            this.batchAssignPermsWhenPermAuthenEnabled(ctx, tmpTableName, cuPK, userId, cuOrgHashMap);
        }
    }

    private void batchAssignPermsWhenPermAuthenEnabled(Context ctx, String tmpTableName, String cuPK, String userId, HashMap<String, List<String>> cuOrgHashMap) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo targetUserInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        Set<String> orgCUSet = cuOrgHashMap.keySet();
        if (orgCUSet == null || orgCUSet.isEmpty()) {
            return;
        }
        for (String ctrlUnitId : orgCUSet) {
            String orgIdListStr = ToolUtils.aryToStr(cuOrgHashMap.get(ctrlUnitId));
            sql = new StringBuffer();
            sql = new StringBuffer();
            sql.append("insert into t_pm_userOrgPerm(fid,fowner,forgid,fpermitemid,FPermType,FCtrlUnitID) ");
            sql.append("   SELECT NEWBOSID('896DC075'),TMPTABLE.FOWNER,TMPTABLE.FORGID,TMPTABLE.FPERMITEMID,TMPTABLE.FPERMTYPE,'" + cuPK);
            sql.append("'   FROM T_PM_AUTHENSCHEME SM                                                                              ");
            sql.append("  INNER JOIN T_PM_AUTHENSCHEMEPERM AUPERM                                                                 ");
            sql.append("     ON SM.FID = AUPERM.FAUTHENSCHEMEID                                                                   ");
            sql.append("  INNER JOIN T_PM_AUTHENSCHEMEORGUSER AUOU                                                                ");
            sql.append("     ON SM.FID = AUOU.FAUTHENSCHEMEID                                                                     ");
            sql.append("  RIGHT JOIN " + tmpTableName + " TMPTABLE                                                                    ");
            sql.append("     ON TMPTABLE.FORGID = AUOU.FORGID                                                                     ");
            sql.append("    AND TMPTABLE.FPERMITEMID = AUPERM.FPERMITEMID                                                         ");
            sql.append("    WHERE TMPTABLE.FORGID in (" + orgIdListStr + ")                                                           ");
            sql.append("   AND (AUOU.FORGID IS NULL  OR AUPERM.FPERMITEMID IS NULL)                                               ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            for (String orgId : cuOrgHashMap.get(ctrlUnitId)) {
                this.copyBactchAssignNeedAuthenPerms(ctx, tmpTableName, targetUserInfo, orgId, ctrlUnitId, cuPK, 10);
                if (currentUserInfo.isBizAdmin() || !targetUserInfo.isBizAdmin()) continue;
                this.copyBactchAssignNeedAuthenPerms(ctx, tmpTableName, targetUserInfo, orgId, ctrlUnitId, cuPK, 30);
            }
        }
    }

    private void copyBactchAssignNeedAuthenPerms(Context ctx, String tableName, UserInfo userInfo, String orgId, String ctrlUnitId, String cuPK, int permType) throws EASBizException, BOSException, SQLException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Set<String> authentorSet = this.getAuthentorByTable(ctx, ctrlUnitId, orgId, tableName, permType);
        if (authentorSet == null || authentorSet.isEmpty()) {
            return;
        }
        String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, permType == 10 ? "10" : "80", userInfo.getNumber(), userInfo.getName(), "user");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_PM_UserOrgPermChange (FID,FUserOrgPerm,FPermChangeID,FOwnerid,");
        sql.append(" FOrgID,FPermItemID,FPermType,FASSIGNTYPE,FAuthenStatus,FCtrlUnitID) ");
        sql.append("SELECT NEWBOSID('5592D485'),NEWBOSID('896DC075'),'" + permChangeId + "',TMPTABLE.FOWNER,TMPTABLE.FORGID,TMPTABLE.FPERMITEMID,TMPTABLE.FPERMTYPE,'" + "10" + "','" + "10" + "','" + cuPK + "'");
        sql.append("   FROM T_PM_AUTHENSCHEME SM                                                                                 ");
        sql.append("  INNER JOIN T_PM_AUTHENSCHEMEPERM AUPERM                                                                    ");
        sql.append("     ON SM.FID = AUPERM.FAUTHENSCHEMEID                                                                      ");
        sql.append("  INNER JOIN T_PM_AUTHENSCHEMEORGUSER AUOU                                                                   ");
        sql.append("     ON SM.FID = AUOU.FAUTHENSCHEMEID                                                                        ");
        sql.append("  INNER JOIN " + tableName + " TMPTABLE                                                                          ");
        sql.append("     ON TMPTABLE.FORGID = AUOU.FORGID                                                                        ");
        sql.append("    AND TMPTABLE.FPERMITEMID = AUPERM.FPERMITEMID                                                            ");
        sql.append("    where tmptable.fpermtype=" + permType);
        sql.append("    AND tmptable.FORGID='" + orgId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer sql2 = new StringBuffer();
        sql2.append("\tINSERT INTO t_pm_authenschemesnapview (FPERMITEMID ,FROLEID ,FUSERID ,FPERMCHANGERECORDID ,FISRULE ,FID  )                  ");
        sql2.append(" \tSELECT AUPERM.FPERMITEMID,'', AUOU.FUSERID,'" + permChangeId + "',case when fisrule is null then 0 else fisrule end , newbosid('80F563B9')");
        sql2.append("\t  FROM T_PM_AUTHENSCHEME SM                                                                                                 ");
        sql2.append("\t INNER JOIN T_PM_AUTHENSCHEMEPERM AUPERM                                                                                    ");
        sql2.append("\t    ON SM.FID = AUPERM.FAUTHENSCHEMEID                                                                                      ");
        sql2.append("\t INNER JOIN T_PM_AUTHENSCHEMEORGUSER AUOU                                                                                   ");
        sql2.append("\t    ON SM.FID = AUOU.FAUTHENSCHEMEID                                                                                        ");
        sql2.append("\t INNER JOIN " + tableName + " TMPTABLE                                                                                           ");
        sql2.append("                 ON TMPTABLE.FORGID = AUOU.FORGID                                                                               ");
        sql2.append("                 AND TMPTABLE.FPERMITEMID = AUPERM.FPERMITEMID                                                                  ");
        sql2.append("\t LEFT JOIN T_PM_AUTHENSCHEMERULE AURULE                                                                                     ");
        sql2.append("\t    ON AUOU.FAUTHENSCHEMEID = AURULE.FAUTHENSCHEMEID                                                                        ");
        sql2.append("\t   AND AUOU.FORGID = AURULE.FORGID                                                                                          ");
        sql2.append("    AND tmptable.FORGID='" + orgId + "'");
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        this.insertAuthenRecord(ctx, ctrlUnitId, authentorSet, permChangeId);
    }

    private void batchAssignPermsWhenPermAuthenDisabled(Context ctx, String tmpTableName, String cuPK) throws BOSException {
        StringBuffer sql = new StringBuffer().append("insert into t_pm_userOrgPerm(fid,fowner,forgid,fpermitemid,FPermType,FCtrlUnitID) ").append(" select newBOSId('896DC075'),a.fowner,a.forgid,a.fpermitemid,a.fpermtype,'").append(cuPK).append("' from ").append(tmpTableName).append(" a left join t_pm_userorgperm b on ").append(" a.fowner=b.fowner and a.forgid=b.forgid and a.fpermitemid=b.fpermitemid and a.fpermtype=b.fpermtype ").append(" where b.fid is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected UserOrgPermCollection _getUserOrgPerms(Context ctx, String userId, String orgId, String permId) throws BOSException, EASBizException {
        assert (userId != null && orgId != null && permId != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection result = new UserOrgPermCollection();
        ArrayList<String> listParams = new ArrayList<String>();
        if (userId == null || orgId == null || permId == null) {
            return result;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FRuleStructure\t\t\t\t                                 \r\n");
            sql.append(" FROM T_PM_UserOrgPerm                                               \r\n");
            sql.append(" WHERE FOwner = ?                                                    \r\n");
            listParams.add(userId);
            sql.append(" AND FOrgID = ?   \r\n");
            listParams.add(orgId);
            sql.append(" AND FPermItemID = ?   \r\n");
            listParams.add(permId);
            sql.append(" AND FRuleStructure is not null \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            while (rs.next()) {
                UserOrgPermInfo info = new UserOrgPermInfo();
                info.setRuleStructure(rs.getString("FRuleStructure"));
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("_getUserOrgPerms  " + (endTime - beginTime)));
        }
        return result;
    }

    @Override
    protected PermItemCollection _getTopSourcePermitems(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_pm_permitem where fnumber = 'EAS\u7cfb\u7edf'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String fid = "";
            while (rs.next()) {
                fid = rs.getString("fid");
            }
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection sorterc = new SorterItemCollection();
            sorterc.add(new SorterItemInfo("longnumber"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)fid));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            view.setSorter(sorterc);
            return PermItemFactory.getLocalInstance(ctx).getPermItemCollection(view);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
    }

    @Override
    protected PermItemCollection _getlevelPermitemsByParent(Context ctx, String parentPermId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorterc = new SorterItemCollection();
        sorterc.add(new SorterItemInfo("longnumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentPermId));
        view.setFilter(filter);
        view.setSorter(sorterc);
        return PermItemFactory.getLocalInstance(ctx).getPermItemCollection(view);
    }

    @Override
    protected String _insertPermChange(Context ctx, String assigner, String oprtType, String number, String name, String oprtObjectType) throws BOSException {
        BOSObjectType bosObjectType = new BOSObjectType("AB724BE5");
        String fid = BOSUuid.create((BOSObjectType)bosObjectType).toString();
        String sql = "INSERT INTO t_pm_permChangeRecord(FID,FAssignerID,FOperType,FAssignedObjectNumber,FAssignedObjectName,FChangeTime,FASSIGNEDOBJECTTYPE) VALUES(?,?,?,?,?,NOW(),?)";
        String objectType = "";
        objectType = oprtObjectType.equals("user") ? EASResource.getString((String)RESOURCE, (String)"user") : EASResource.getString((String)RESOURCE, (String)"ROLE1");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fid, assigner, oprtType, number, name, objectType});
        return fid;
    }

    @Override
    protected UserOrgPermCollection[] _getAllUopResults(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops, UserOrgPermCollection oldUOPs) throws BOSException, EASBizException {
        String key;
        UserOrgPermCollection newUOPs = this.getAllPermsFromUI(ctx, sourceUserPK, targetUserPK, orgCol, uops, false);
        UserOrgPermCollection addUOPs = new UserOrgPermCollection();
        UserOrgPermCollection delUOPs = new UserOrgPermCollection();
        UserOrgPermCollection updateUOPs = new UserOrgPermCollection();
        Map mapOldUOP = this.createUOPMap(oldUOPs);
        int size = newUOPs.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo newUOP = newUOPs.get(i);
            key = PermissionCommonUtil.getKey(newUOP);
            if (mapOldUOP.containsKey(key)) {
                UserOrgPermInfo oldUOP = (UserOrgPermInfo)mapOldUOP.get(key);
                if (!this.isRuleChanged(oldUOP.getRuleStructure(), newUOP.getRuleStructure())) continue;
                newUOP.setId(oldUOP.getId());
                updateUOPs.add(newUOP);
                continue;
            }
            addUOPs.add(newUOP);
        }
        Map mapNewUOP = this.createUOPMap(newUOPs);
        int size2 = oldUOPs.size();
        for (int i = 0; i < size2; ++i) {
            key = PermissionCommonUtil.getKey(oldUOPs.get(i));
            if (mapNewUOP.containsKey(key)) continue;
            delUOPs.add(oldUOPs.get(i));
        }
        UserOrgPermCollection[] operations = new UserOrgPermCollection[]{addUOPs, delUOPs, updateUOPs};
        return operations;
    }

    @Override
    protected UserOrgPermCollection _getAllPathTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, int permType) throws BOSException, EASBizException {
        UserOrgPermCollection result = new UserOrgPermCollection();
        ArrayList<Object> listParams = new ArrayList<Object>();
        if (userPK == null || orgCol == null) {
            return result;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT pitem.FLongNumber as FLongNumber                                 \r\n");
            sql.append(" FROM T_PM_UserOrgPerm uop                                               \r\n");
            sql.append(" INNER JOIN T_PM_PermItem pitem ON pitem.FID = uop.FPermItemID           \r\n");
            sql.append(" WHERE uop.FOwner = ?                                                    \r\n");
            listParams.add(userPK.toString());
            sql.append(this.getPermTypeFilter("pitem.FType"));
            sql.append(this.getOrgRelationFilter(orgCol, "pitem.FOrgRelation", listParams));
            List orgIdList = ToolUtils.orgCol2List(orgCol);
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            sql.append(this.getOrgIdFilter(orgIdList, "FOrgID", listParams));
            if (permType != 0) {
                sql.append(" AND uop.FPermType = ?   \r\n");
                listParams.add(new Integer(permType));
            }
            if (!this.hasUnionOrg(orgCol) && permType != 30) {
                sql.append(" AND pitem.FName NOT IN (select FPermItemName from t_pm_cslPermItem) \r\n ");
            }
            sql.append(this.getS1BaseDataFilter(orgCol, "pitem.FObjectType", "pitem.FOperationType"));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])listParams.toArray());
            while (rs.next()) {
                UserOrgPermInfo info = new UserOrgPermInfo();
                PermItemInfo permInfo = new PermItemInfo();
                permInfo.setLongNumber(rs.getString("FLongNumber"));
                info.setPermItem(permInfo);
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    @Override
    protected Map _getAllTopTargetUOPs(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol) throws BOSException, EASBizException {
        MainMenuQuickHelper helper = new MainMenuQuickHelper();
        HashMap<PermType, UserOrgPermCollection> ret = new HashMap<PermType, UserOrgPermCollection>();
        List permTypeList = PermType.getEnumList();
        int size = permTypeList.size();
        for (int i = 0; i < size; ++i) {
            PermType type = (PermType)((Object)permTypeList.get(i));
            UserOrgPermCollection uopCol = this._getTopTargetUOPs(ctx, sourceUserPK, userPK, orgCol, type.getValue());
            ret.put(type, uopCol);
        }
        return ret;
    }

    @Override
    protected void _saveUsersOrgPermsBatch(Context ctx, IObjectPK sourceUserPK, List userPKs, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops) throws BOSException, EASBizException {
        for (int i = 0; i < userPKs.size(); ++i) {
            try {
                FullOrgUnitCollection orgColCopy = (FullOrgUnitCollection)ObjectUtils.createCopy((Object)orgCol);
                this._saveUserOrgPermsBatch(ctx, sourceUserPK, (IObjectPK)new ObjectUuidPK(userPKs.get(i).toString()), cuPK, orgColCopy, uops);
                continue;
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _deleteUsersOrgPermsBatch(Context ctx, IObjectPK sourceUserPK, List userPKs, IObjectPK cuPK, FullOrgUnitCollection orgCol, UserOrgPermCollection[] uops) throws BOSException, EASBizException {
        UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, PermissionUtil.getPkIds(userPKs), EASResource.getString((String)RESOURCE, (String)"MULTI_CANCEL_PERM"));
        userPermChangeListener.before();
        for (int i = 0; i < userPKs.size(); ++i) {
            this._deleteUserOrgPermsBatch(ctx, sourceUserPK, (IObjectPK)new ObjectUuidPK(userPKs.get(i).toString()), cuPK, orgCol, uops);
        }
        userPermChangeListener.after();
    }

    class NeedAuthenPermsThread
    implements Callable<Void> {
        private Context ctx;
        private String tableName;
        private UserInfo userInfo;
        private String ctrlUnitId;
        private String targetOrgId;
        private int permType;
        private List<String> permIds;
        private Connection conn;

        public NeedAuthenPermsThread(Context ctx, Connection conn, String tableName, UserInfo userInfo, String ctrlUnitId, String targetOrgId, List permIds, int permType) {
            this.ctx = ctx;
            this.tableName = tableName;
            this.userInfo = userInfo;
            this.ctrlUnitId = ctrlUnitId;
            this.targetOrgId = targetOrgId;
            this.permType = permType;
            this.permIds = permIds;
            this.conn = conn;
        }

        @Override
        public Void call() throws Exception {
            try {
                if (10 == this.permType) {
                    UserOrgPermFacadeControllerBean.this.copyNeedAuthenPerms(this.ctx, this.conn, this.tableName, this.userInfo, this.ctrlUnitId, this.targetOrgId, 10);
                } else if (30 == this.permType && !ContextUtil.getCurrentUserInfo((Context)this.ctx).isBizAdmin() && this.userInfo.isBizAdmin()) {
                    UserOrgPermFacadeControllerBean.this.copyNeedAuthenPerms(this.ctx, this.conn, this.tableName, this.userInfo, this.ctrlUnitId, this.targetOrgId, 30);
                } else if (-1 == this.permType) {
                    UserOrgPermFacadeControllerBean.this.copyNotNeedAuthenPerms(this.conn, this.tableName, this.userInfo, this.ctrlUnitId);
                }
                PermCacheFacadeFactory.getLocalInstance(this.ctx).removeAllPermCacheByUser(this.userInfo.getId().toString());
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw e;
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            return null;
        }
    }

    class AllPermFromUIThread
    implements Callable<Void> {
        private Context ctx;
        private IObjectPK sourceUserPK;
        private IObjectPK userPK;
        private FullOrgUnitCollection orgCol;
        private UserOrgPermCollection uops;
        private boolean isBatch;
        private int permType;

        public AllPermFromUIThread(Context ctx, IObjectPK sourceUserPK, IObjectPK userPK, FullOrgUnitCollection orgCol, UserOrgPermCollection uops, boolean isBatch, int permType) {
            this.ctx = ctx;
            this.sourceUserPK = sourceUserPK;
            this.userPK = userPK;
            this.orgCol = orgCol;
            this.uops = uops;
            this.isBatch = isBatch;
            this.permType = permType;
        }

        @Override
        public Void call() throws Exception {
            try {
                UserOrgPermCollection tmpColl = UserOrgPermFacadeControllerBean.this.getUOPByPermType(this.ctx, this.sourceUserPK, this.userPK, this.orgCol, this.uops, this.permType, this.isBatch);
                if (this.permType == 30) {
                    UserOrgPermFacadeControllerBean.this.auto_coll = tmpColl;
                } else if (this.permType == 10) {
                    UserOrgPermFacadeControllerBean.this.norm_coll = tmpColl;
                } else if (this.permType == 20) {
                    UserOrgPermFacadeControllerBean.this.forb_coll = tmpColl;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw e;
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            return null;
        }
    }
}

