/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.datatrans.UserOrgRangeBlock;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserOrgRangeTransmission
extends AbstractDataTransmission {
    private Logger logger = Logger.getLogger(UserOrgRangeTransmission.class);
    private Map<String, List<String>> localOrgIdsCache = new HashMap<String, List<String>>();
    private Map<String, UserInfo> localUserInfoCache = new HashMap<String, UserInfo>();

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (this.getMainFields() == null) {
            return super.isSameBlock(firstData, currentData);
        }
        if (firstData == null || currentData == null) {
            return false;
        }
        boolean isSameBlock = true;
        for (int i = 0; i < this.getMainFields().length; ++i) {
            Object curValue;
            Object firstValue = firstData.get(this.getMainFields()[i]);
            if (firstValue == null) {
                firstValue = "";
            }
            if ((curValue = currentData.get(this.getMainFields()[i])) == null) {
                curValue = "";
            }
            if (firstValue.equals(curValue)) continue;
            isSameBlock = false;
        }
        return isSameBlock;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            CoreBaseInfo head = null;
            for (int i = 0; i < hsData.size(); ++i) {
                Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
                if (i == 0 && (head = this.createHead(lineData, ctx)) == null) {
                    return null;
                }
                this.createEntry(head, lineData, ctx);
            }
            return head;
        }
        catch (TaskExternalException te) {
            throw te;
        }
        catch (EASBizException ee) {
            this.logger.info((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)ee));
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception e) {
            String excLinkStackTrace = ExceptionUtil.getExcLinkStackTrace((Throwable)e);
            this.logger.error((Object)excLinkStackTrace);
            throw new TaskExternalException(excLinkStackTrace);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FUser_number", StringUtils.cnulls((String)rs.getString("USER.NUMBER")));
            result.put("FUser_name_l2", StringUtils.cnulls((String)rs.getString("USER.NAME")));
            result.put("FOrg_number", StringUtils.cnulls((String)rs.getString("ORG.NUMBER")));
            result.put("FOrg_name_l2", StringUtils.cnulls((String)rs.getString("ORG.NAME")));
            result.put("FType", StringUtils.cnulls((String)rs.getString("TYPE")));
            result.put("FIsIncludeSubOrg", rs.getBoolean("ISINCLUDESUBORG") ? 1 : 0);
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        String FType;
        OrgRangeType type;
        String FUser_number = (String)((DataToken)hsData.get((Object)"FUser_number")).data;
        UserInfo user = this.localUserInfoCache.get(FUser_number);
        if (user == null) {
            user = UserFactory.getLocalInstance(ctx).getUserInfoByNumber(FUser_number);
            if (user == null) {
                return null;
            }
            this.localUserInfoCache.put(FUser_number, user);
        }
        if ((type = OrgRangeType.getEnum(Integer.valueOf((FType = (String)((DataToken)hsData.get((Object)"FType")).data).trim()))) == null) {
            return null;
        }
        UserOrgRangeBlock block = new UserOrgRangeBlock();
        block.setUserNumber(FUser_number);
        block.setOrgRangeType(type);
        return block;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        String isIncludeSubOrgStr;
        List<OrgRangeIncludeSubOrgInfo> includeSubOrgs;
        if (head == null) {
            return;
        }
        UserOrgRangeBlock block = (UserOrgRangeBlock)head;
        ArrayList<String> addedOrgIds = block.getAddedOrgIds();
        if (addedOrgIds == null) {
            addedOrgIds = new ArrayList<String>();
            block.setAddedOrgIds(addedOrgIds);
        }
        if ((includeSubOrgs = block.getChangedOrgRangeIncludeSubOrg()) == null) {
            includeSubOrgs = new ArrayList<OrgRangeIncludeSubOrgInfo>();
            block.setChangedOrgRangeIncludeSubOrg(includeSubOrgs);
        }
        boolean isIncludeSubOrg = StringUtils.isEmpty((String)(isIncludeSubOrgStr = (String)((DataToken)hsData.get((Object)"FIsIncludeSubOrg")).data)) ? false : Integer.valueOf(isIncludeSubOrgStr.trim()) == 1;
        String orgNumber = (String)((DataToken)hsData.get((Object)"FOrg_number")).data;
        String userNumber = (String)((DataToken)hsData.get((Object)"FUser_number")).data;
        String type = (String)((DataToken)hsData.get((Object)"FType")).data;
        List<String> orgIds = this.localOrgIdsCache.get(orgNumber + userNumber + type);
        if (orgIds == null) {
            orgIds = new ArrayList<String>();
            FullOrgUnitCollection coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id, ISADMINORGUNIT where number = '" + orgNumber + "'");
            if (coll == null || coll.isEmpty()) {
                return;
            }
            for (int i = 0; i < coll.size(); ++i) {
                FullOrgUnitInfo org = coll.get(i);
                orgIds.add(org.getId().toString());
                if (block.getOrgRangeType() != OrgRangeType.ADMIN_ORG_TYPE || !org.isIsAdminOrgUnit() || !isIncludeSubOrg) continue;
                OrgRangeIncludeSubOrgInfo suborgInfo = new OrgRangeIncludeSubOrgInfo();
                suborgInfo.setOrg(org);
                suborgInfo.setUser(this.localUserInfoCache.get(block.getUserNumber()));
                suborgInfo.setIsIncludeSubOrg(isIncludeSubOrg);
                suborgInfo.setType(block.getOrgRangeType());
                includeSubOrgs.add(suborgInfo);
            }
            this.localOrgIdsCache.put(orgNumber + userNumber + type, orgIds);
        }
        addedOrgIds.addAll(orgIds);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            UserOrgRangeBlock block = (UserOrgRangeBlock)coreBaseInfo;
            OrgRangeParam orgRangeParam = new OrgRangeParam();
            orgRangeParam.setUserPK((IObjectPK)new ObjectStringPK(this.localUserInfoCache.get(block.getUserNumber()).getId().toString()));
            orgRangeParam.setAddedOrgIds(block.getAddedOrgIds());
            orgRangeParam.setOrgRangeType(block.getOrgRangeType());
            orgRangeParam.setImport(true);
            ((IOrgRangeIncludeSubOrg)this.getController(ctx)).saveOrgRange(orgRangeParam);
            if (block.getOrgRangeType() == OrgRangeType.ADMIN_ORG_TYPE) {
                orgRangeParam.setAddedOrgIds(null);
                List<OrgRangeIncludeSubOrgInfo> orgRangeIncludeSubOrgInfos = block.getChangedOrgRangeIncludeSubOrg();
                for (OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo : orgRangeIncludeSubOrgInfos) {
                    orgRangeParam.setChangedOrgRangeIncludeSubOrg(orgRangeIncludeSubOrgInfo);
                    ((IOrgRangeIncludeSubOrg)this.getController(ctx)).saveOrgRange(orgRangeParam);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    protected String[] getMainFields() {
        return new String[]{"FUser_number", "FType"};
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.OrgRangeIncludeSubOrgQuery";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

