/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgRolePermInfoCollection;
import com.kingdee.eas.base.permission.UserOrgRolePermInfoInfo;
import com.kingdee.eas.base.permission.UserOrgRolePermParam;
import com.kingdee.eas.base.permission.UserOrgRolePermResult;
import com.kingdee.eas.base.permission.app.AbstractUserOrgRolePermFacadeControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserOrgRolePermFacadeControllerBean
extends AbstractUserOrgRolePermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserOrgRolePermFacadeControllerBean");

    @Override
    protected List _getUserOrgRoleRelation(Context ctx, List idList, String user, String role, int maxCount) throws BOSException, EASBizException {
        if (idList == null) {
            idList = new ArrayList();
        }
        String sqlSelect = "select top " + maxCount + " b.fid id,b.fnumber userNumber,b.fname_" + ctx.getLocale() + " userName,c.fnumber orgNumber,c.fname_" + ctx.getLocale() + " orgName,c.FDisplayName_" + ctx.getLocale() + " dispName,d.fname_" + ctx.getLocale() + " roleName  from t_pm_userroleorg  a  left join t_pm_user b on b.fid = a.fuserid  left join t_org_baseunit c on c.fid = a.forgid   left join t_pm_role d on d.fid = a.froleid ";
        StringBuffer sqlWhere = new StringBuffer("where");
        if (!StringUtils.isEmpty((String)user)) {
            sqlWhere.append(" b.fnumber='" + user + "'");
        }
        if (idList.size() > 0) {
            if (!"where".equalsIgnoreCase(sqlWhere.toString())) {
                sqlWhere.append(" and ");
            }
            sqlWhere.append(" c.fid in ( " + ToolUtils.aryToStr(idList, true) + ")");
        }
        if (!StringUtils.isEmpty((String)role)) {
            if (!"where".equalsIgnoreCase(sqlWhere.toString())) {
                sqlWhere.append(" and ");
            }
            sqlWhere.append(" d.fnumber= '" + role + "'");
        }
        if ("where".equalsIgnoreCase(sqlWhere.toString())) {
            sqlWhere = new StringBuffer("");
        }
        String sqlOrder = " order by b.fnumber";
        return this.getRolePerm(ctx, sqlSelect + sqlWhere.toString() + sqlOrder);
    }

    private List getRolePerm(Context ctx, String strSql) throws BOSException {
        ArrayList<UserOrgRolePermInfoCollection> result = new ArrayList<UserOrgRolePermInfoCollection>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql);
        UserOrgRolePermInfoCollection coll = null;
        String userNumber = null;
        String userName = null;
        String orgNumber = null;
        String orgDispName = null;
        String urole = null;
        coll = new UserOrgRolePermInfoCollection();
        try {
            while (rs.next()) {
                userNumber = rs.getString("userNumber");
                userName = rs.getString("userName");
                orgNumber = rs.getString("orgNumber");
                orgDispName = rs.getString("dispName");
                urole = rs.getString("roleName");
                UserOrgRolePermInfoInfo info = this.getRolePermInfo(ctx, userNumber, userName, orgNumber, orgDispName, urole);
                coll.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        result.add(coll);
        return result;
    }

    private UserOrgRolePermInfoInfo getRolePermInfo(Context ctx, String userNumber, String userName, String orgNumber, String orgDispName, String urole) throws Exception {
        IUser iu = UserFactory.getLocalInstance(ctx);
        UserInfo userInfo = null;
        userInfo = iu.getUserInfo("select * where number = '" + userNumber + "'");
        FullOrgUnitInfo fInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(userInfo.getDefOrgUnit().getId()));
        return this.getRolePermInfo(userNumber, userName, orgNumber, orgDispName, urole, fInfo.getName());
    }

    private UserOrgRolePermInfoInfo getRolePermInfo(String userNumber, String userName, String orgNumber, String orgDispName, String urole, String defaultOrg) {
        UserOrgRolePermInfoInfo info = new UserOrgRolePermInfoInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setUserNumber(userNumber);
        info.setUserName(userName);
        if (StringUtils.isEmpty((String)defaultOrg)) {
            info.setOrgName("");
        } else {
            info.setOrgName(defaultOrg);
        }
        info.setOrgNumber(orgNumber);
        info.setOrgDisplayName(orgDispName);
        info.setRole(urole);
        return info;
    }

    @Override
    protected List _getUserOrgPermRelation(Context ctx, List idList, String user, String perm, int maxCount) throws BOSException, EASBizException {
        if (idList == null) {
            idList = new ArrayList<String>();
        }
        idList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
        List result = null;
        Object rs = null;
        IUser iu = UserFactory.getLocalInstance(ctx);
        UserInfo userinfo = null;
        if (user != null && user.trim().length() > 0) {
            userinfo = iu.getUser(user);
        }
        if (user != null && user.trim().length() > 0 && userinfo.getType().getValue() == 10) {
            if (!user.equalsIgnoreCase("administrator")) {
                result = this.getAdminPerm(ctx, user);
            }
            if (user.equalsIgnoreCase("administrator")) {
                result = this.getSuperAdminPerm(ctx, user);
            }
        } else {
            String sqlSelect = "select top " + maxCount + " b.fnumber userNumber,b.fname_" + ctx.getLocale() + " userName,d.fid orgFid,d.fnumber orgNumber,d.FDisplayName_" + ctx.getLocale() + " dispName,c.falias_" + ctx.getLocale() + " permName  from t_pm_userorgperm a  left join  t_pm_user b on a.fowner  = b.fid  left join  t_pm_permitem c on a.fpermitemid = c.fid   left join  t_org_baseunit d on a.forgid = d.fid  ";
            StringBuffer sqlWhere = new StringBuffer("where c.fid is not null");
            if (!StringUtils.isEmpty((String)user)) {
                sqlWhere.append(" and  b.fnumber='" + user + "'");
            }
            if (idList.size() > 1) {
                sqlWhere.append(" and d.fid in ( " + ToolUtils.aryToStr(idList, true) + ")");
            }
            if (!StringUtils.isEmpty((String)perm)) {
                sqlWhere.append(" and c.fname= '" + perm + "'");
            }
            if ("where c.fid is not null".equalsIgnoreCase(sqlWhere.toString())) {
                sqlWhere = new StringBuffer("");
            }
            String sqlOrder = " order by b.fnumber";
            result = this.getUserPerm(ctx, sqlSelect + sqlWhere.toString() + sqlOrder);
        }
        return result;
    }

    private List getSuperAdminPerm(Context ctx, String user) throws BOSException {
        ArrayList<UserOrgRolePermInfoCollection> result = new ArrayList<UserOrgRolePermInfoCollection>();
        String sqlUser = "select fnumber userNumber,fname_" + ctx.getLocale() + " userName from t_pm_user where fnumber=? ";
        String sqlSys = "select falias_" + ctx.getLocale() + " permName from t_pm_permitem where ftype in (10)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlUser, (Object[])new String[]{user});
        UserOrgRolePermInfoCollection coll = null;
        String userNumber = null;
        String userName = null;
        String orgNumber = null;
        String orgDispName = null;
        String uPerm = null;
        coll = new UserOrgRolePermInfoCollection();
        try {
            while (rs.next()) {
                userNumber = rs.getString("userNumber");
                userName = rs.getString("userName");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSys);
        try {
            while (rs.next()) {
                uPerm = rs.getString("permName");
                if (StringUtils.isEmpty((String)uPerm)) continue;
                UserOrgRolePermInfoInfo info = this.getRolePermInfo(ctx, userNumber, userName, orgNumber, orgDispName, "");
                info.setPermission(uPerm);
                coll.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        result.add(coll);
        return result;
    }

    private List getAdminPerm(Context ctx, String user) throws BOSException {
        ArrayList<UserOrgRolePermInfoCollection> result = new ArrayList<UserOrgRolePermInfoCollection>();
        String sqlUser = "select fnumber userNumber,fname_" + ctx.getLocale() + " userName from t_pm_user where fnumber=? ";
        String sqlSys = "select falias_" + ctx.getLocale() + " permName from t_pm_permitem where ftype in (10) and fisleaf = 1 and falias_l2 not in ('" + PermissionResUtil.getResource("res_51") + "','License" + PermissionResUtil.getResource("res_52") + "','" + PermissionResUtil.getResource("res_53") + "','" + PermissionResUtil.getResource("res_54") + "License" + PermissionResUtil.getResource("res_55") + "') ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlUser, (Object[])new String[]{user});
        UserOrgRolePermInfoCollection coll = null;
        String userNumber = null;
        String userName = null;
        String orgNumber = null;
        String orgDispName = null;
        String uPerm = null;
        coll = new UserOrgRolePermInfoCollection();
        try {
            while (rs.next()) {
                userNumber = rs.getString("userNumber");
                userName = rs.getString("userName");
            }
        }
        catch (SQLException e2) {
            logger.error((Object)"", (Throwable)e2);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSys);
        try {
            while (rs.next()) {
                uPerm = rs.getString("permName");
                if (StringUtils.isEmpty((String)uPerm)) continue;
                UserOrgRolePermInfoInfo info = this.getRolePermInfo(ctx, userNumber, userName, orgNumber, orgDispName, "");
                info.setPermission(uPerm);
                coll.add(info);
            }
        }
        catch (Exception e2) {
            logger.error((Object)"", (Throwable)e2);
        }
        result.add(coll);
        return result;
    }

    private List getUserPerm(Context ctx, String strSql) throws BOSException {
        ArrayList<UserOrgRolePermInfoCollection> result = new ArrayList<UserOrgRolePermInfoCollection>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql);
        UserOrgRolePermInfoCollection coll = null;
        String userNumber = null;
        String userName = null;
        String orgNumber = null;
        String orgDispName = null;
        String uPerm = null;
        String orgID = null;
        coll = new UserOrgRolePermInfoCollection();
        try {
            while (rs.next()) {
                userNumber = rs.getString("userNumber");
                userName = rs.getString("userName");
                orgNumber = rs.getString("orgNumber");
                orgDispName = rs.getString("dispName");
                uPerm = rs.getString("permName");
                orgID = rs.getString("orgFid");
                if ("11111111-1111-1111-1111-111111111111CCE7AED4".equalsIgnoreCase(orgID)) {
                    orgNumber = "";
                    orgDispName = "";
                }
                if (StringUtils.isEmpty((String)uPerm)) continue;
                UserOrgRolePermInfoInfo info = this.getRolePermInfo(ctx, userNumber, userName, orgNumber, orgDispName, "");
                info.setPermission(uPerm);
                coll.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        result.add(coll);
        return result;
    }

    @Override
    protected RoleCollection _getTopRoleOfUser(Context ctx, String userId, int topNum) throws BOSException, EASBizException {
        RoleCollection roleCol = new RoleCollection();
        String sql = "select top " + topNum + " FName_l2 name,fnumber,fid from t_pm_role where fid in (select froleid from t_pm_userroleorg where fuserid=?)";
        Object[] params = new Object[]{userId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (rs.next()) {
                String name = rs.getString("name");
                String number = rs.getString("fnumber");
                String id = rs.getString("fid");
                RoleInfo role = new RoleInfo();
                role.setName(name);
                role.setNumber(number);
                role.setId(BOSUuid.read((String)id));
                roleCol.add(role);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return roleCol;
    }

    @Override
    protected UserOrgRolePermResult _getUserOrgRolePerm(Context ctx, UserOrgRolePermParam param) throws BOSException, EASBizException {
        Set<String> userIdSet = param.getUserIdSet();
        String sql = "select fowner fuserid,forgid,fpermitemid,fpermtype from t_pm_userorgperm where fowner in (" + ToolUtils.aryToStr(userIdSet) + ") union all select fuserid,forgid,fpermitemid,b.fpermtype from t_pm_userroleorg a join t_pm_roleperm b on a.froleid=b.froleid  where fuserid in (" + ToolUtils.aryToStr(userIdSet) + ")";
        IRowSet rs = null;
        UserOrgRolePermResult result = new UserOrgRolePermResult();
        String userId = null;
        String orgId = null;
        String permId = null;
        HashSet<String> orgIdSet = new HashSet<String>();
        HashSet<String> permIdSet = new HashSet<String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                userId = rs.getString("fuserid");
                orgId = rs.getString("forgid");
                permId = rs.getString("fpermitemid");
                orgIdSet.add(orgId);
                permIdSet.add(permId);
                result.add(userId, orgId, rs.getInt("fpermtype"), permId);
            }
        }
        catch (Exception se) {
            if (se.getCause() instanceof FetchedTooMuchRowsException) {
                String exceptionMsg = "fetched too much rows, cell number exceeding limit";
                String message = se.getCause().getMessage();
                int begin = message.indexOf(exceptionMsg) + exceptionMsg.length();
                int end = message.indexOf(".", begin);
                int maxCells = Integer.valueOf(message.substring(begin, end).trim());
                throw new PermissionException(PermissionException.EXCEEDING_LIMIT_ROWS, new Object[]{maxCells});
            }
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        Map<String, UserInfo> idUserMap = this.getIdUserMap(ctx, userIdSet);
        Map<String, FullOrgUnitInfo> idOrgMap = this.getIdOrgMap(ctx, orgIdSet);
        Map<String, PermItemInfo> idPermItemMap = this.getIdPermItemMap(ctx, permIdSet);
        result.setIdOrgMap(idOrgMap);
        result.setIdPermItemMap(idPermItemMap);
        result.setIdUserMap(idUserMap);
        return result;
    }

    private Map<String, UserInfo> getIdUserMap(Context ctx, Set<String> userIdSet) throws BOSException {
        HashMap<String, UserInfo> ret = new HashMap<String, UserInfo>();
        Locale l = ctx.getLocale();
        String sql = "select fid,fname_" + l.toString() + " name,fnumber from t_pm_user where fid in (" + ToolUtils.aryToStr(userIdSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        UserInfo userInfo = null;
        try {
            while (rs.next()) {
                userInfo = new UserInfo();
                userInfo.setName(rs.getString("name"));
                userInfo.setNumber(rs.getString("fnumber"));
                String id = rs.getString("fid");
                ret.put(id, userInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private Map<String, FullOrgUnitInfo> getIdOrgMap(Context ctx, Set<String> orgIdSet) throws BOSException {
        HashMap<String, FullOrgUnitInfo> ret = new HashMap<String, FullOrgUnitInfo>();
        Locale l = ctx.getLocale();
        String sql = "select ORG.fid fid, CASE WHEN ORG . FISUNION = 1 THEN FName_" + l.toString() + " || '\uff08' || ( select TOP 1 ( case when fstartdate is null then '' else TO_CHAR ( fstartdate , 'yyyy-mm-dd' ) end ) || '~' || ( case when FENDDATE is null then '' else TO_CHAR ( fenddate , 'yyyy-mm-dd' ) end )  from t_org_tree where fid in ( select FTREEID from t_org_structure where Funitid = ORG . FID ) ) || '\uff09' ELSE ORG . FName_" + l.toString() + " END  as name,ORG.fnumber as fnumber from t_org_baseunit ORG where ORG.fid in (" + ToolUtils.aryToStr(orgIdSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        FullOrgUnitInfo orgInfo = null;
        try {
            while (rs.next()) {
                orgInfo = new FullOrgUnitInfo();
                orgInfo.setName(rs.getString("name"));
                orgInfo.setNumber(rs.getString("fnumber"));
                String id = rs.getString("fid");
                ret.put(id, orgInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private Map<String, PermItemInfo> getIdPermItemMap(Context ctx, Set<String> permItemIdSet) throws BOSException {
        HashMap<String, PermItemInfo> ret = new HashMap<String, PermItemInfo>();
        Locale l = ctx.getLocale();
        String sql = "select fid,falias_" + l.toString() + " alias,flongnumber from t_pm_permitem where fid in (" + ToolUtils.aryToStr(permItemIdSet) + ")";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        PermItemInfo permInfo = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                permInfo = new PermItemInfo();
                permInfo.setAlias(rs.getString("alias"));
                permInfo.setLongNumber(rs.getString("flongnumber"));
                String id = rs.getString("fid");
                ret.put(id, permInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return ret;
    }
}

