/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.permrepeat;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.eas.base.permission.app.clear.scan.permrepeat.PermRepeatScanUnit;
import com.kingdee.eas.base.permission.app.clear.strategy.permrank.RankPreCondition;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class PermRepeatScan
extends AbstractScan
implements IPermClearStrategyScan {
    private static Logger logger = Logger.getLogger((String)RankPreCondition.class.getName());
    protected boolean isAll = false;
    protected List<PermRepeatScanUnit> scanUsers = new ArrayList<PermRepeatScanUnit>();

    @Override
    public void unSerialize(String content) {
        PermRepeatScan permRankScan = new PermRepeatScan();
        if (!StringUtils.isEmpty((String)content)) {
            try {
                permRankScan = (PermRepeatScan)new Gson().fromJson(content, PermRepeatScan.class);
                this.isAll = permRankScan.isAll;
                this.scanUsers = permRankScan.scanUsers;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public String serialize() {
        return new Gson().toJson((Object)this);
    }

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        if (this.isAll) {
            // empty if block
        }
        for (PermRepeatScanUnit scanUnit : this.scanUsers) {
            scanUnit.scan(ctx);
        }
        Collections.sort(this.scanUsers, (Comparator)new PermRankScanUnitComparator());
    }

    @Override
    public boolean refreshScan() {
        boolean isExistsSuccess = false;
        for (PermRepeatScanUnit bean : this.scanUsers) {
            bean.refreshScan();
            if (bean.getScanStatus() != ScanStatusEnum.FINISHED) continue;
            isExistsSuccess = true;
        }
        if (this.isScanFinished) {
            this.scanStatus = isExistsSuccess ? ScanStatusEnum.FINISHED : ScanStatusEnum.FAIL;
        }
        return this.isScanFinished;
    }

    public void initScanUsers(Context ctx) throws BOSException {
        this.scanUsers.clear();
        UserCollection userCollection = UserFactory.getLocalInstance(ctx).getUserCollection("select id , number , name");
        for (int i = 0; i < userCollection.size(); ++i) {
            UserInfo userInfo = userCollection.get(i);
            PermRepeatScanUnit scanUnit = new PermRepeatScanUnit();
            scanUnit.setUserId(userInfo.getId().toString());
            scanUnit.setUserNumber(userInfo.getNumber());
            scanUnit.setUserName(userInfo.getName());
            this.scanUsers.add(scanUnit);
        }
    }

    @Override
    public int getCounts() {
        return this.scanUsers.size();
    }

    @Override
    public int getScanCounts() {
        int counts = 0;
        for (PermRepeatScanUnit bean : this.scanUsers) {
            if (bean.getScanStatus() == null || bean.getScanStatus() == ScanStatusEnum.UNSTARTED) continue;
            ++counts;
        }
        return counts;
    }

    @Override
    public int getScanUsersCounts() {
        int counts = 0;
        for (PermRepeatScanUnit user : this.scanUsers) {
            if (ScanStatusEnum.FINISHED != user.getScanStatus()) continue;
            ++counts;
        }
        return counts;
    }

    @Override
    public int getScanPermCounts() {
        int counts = 0;
        for (PermRepeatScanUnit user : this.scanUsers) {
            counts += user.getScanPermCounts();
        }
        return counts;
    }

    @Override
    public int getScanDataCounts() {
        return this.getScanPermCounts();
    }

    @Override
    public int getScanRoleCounts() {
        int counts = 0;
        for (PermRepeatScanUnit user : this.scanUsers) {
            counts += user.getScanRoleCounts();
        }
        return counts;
    }

    @Override
    public int getScanOrgCounts() {
        int counts = 0;
        for (PermRepeatScanUnit user : this.scanUsers) {
            counts += user.getScanOrgCounts();
        }
        return counts;
    }

    public static void main(String[] args) {
        PermRepeatScan permRankScan = new PermRepeatScan();
        System.out.println(permRankScan.serialize());
    }

    @Override
    public ScanStatusEnum getScanStatus() {
        return this.scanStatus;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public void setAll(boolean isAll) {
        this.isAll = isAll;
    }

    public List<PermRepeatScanUnit> getScanUsers() {
        return this.scanUsers;
    }

    public void setScanUsers(List<PermRepeatScanUnit> scanUsers) {
        this.scanUsers = scanUsers;
    }

    public class PermRankScanUnitComparator
    implements Comparator<PermRepeatScanUnit> {
        @Override
        public int compare(PermRepeatScanUnit o1, PermRepeatScanUnit o2) {
            int counts2;
            int counts1 = o1.getScanPermCounts();
            return counts1 < (counts2 = o2.getScanPermCounts()) ? 1 : -1;
        }
    }
}

