/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.discrete;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermException;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermException;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermException;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.discrete.IDiscretePermissionDAO;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscretePermissionDAO
implements IDiscretePermissionDAO {
    private static Logger logger = Logger.getLogger(DiscretePermissionDAO.class);
    private Context context = null;

    public DiscretePermissionDAO(Context context) {
        this.context = context;
    }

    @Override
    public void addDiscretePermission(BOSObjectType objectType, DiscretePermCollection ddps) throws BOSException, EASBizException {
        if (ddps == null || ddps.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(this.getTableName(objectType)).append(" (FUserID, FOrgID, FRoleID, FPermItemID, FBizDataID)").append(" VALUES (?, ?, ?, ?, ?)");
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = EJBFactory.getConnection((Context)this.context);
            ps = cn.prepareStatement(sql.toString());
            int size = ddps.size();
            for (int i = 0; i < size; ++i) {
                DiscretePermInfo info = ddps.get(i);
                if (info.getUser() == null || info.getUser().getId() == null) {
                    ps.setNull(1, 12);
                } else {
                    ps.setString(1, info.getUser().getId().toString());
                }
                if (info.getOrg() == null || info.getOrg().getId() == null) {
                    ps.setNull(2, 12);
                } else {
                    ps.setString(2, info.getOrg().getId().toString());
                }
                if (info.getRole() == null || info.getRole().getId() == null) {
                    ps.setNull(3, 12);
                } else {
                    ps.setString(3, info.getRole().getId().toString());
                }
                if (info.getPermItem() == null || info.getPermItem().getId() == null) {
                    throw new BOSException("permItem is null or paramItem.id is null!");
                }
                ps.setString(4, info.getPermItem().getId().toString());
                if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)info.getBizDataID()))) {
                    throw new BOSException("bizDataID is null !");
                }
                ps.setString(5, info.getBizDataID().toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error:", (Throwable)e);
                throw new DiscretePermException(DiscretePermException.DISCRETE_DATA_PERM_ADD_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    @Override
    public void removeDiscretePermission(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, Set bizDataIDs) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            StringBuffer sql = new StringBuffer();
            if (rolePK == null) {
                sql.append("DELETE FROM ").append(this.getTableName(objectType)).append(" WHERE FUserID = ? ").append(" AND ( FOrgID = ? OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND FBizDataID = ? ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                for (BOSUuid bizDataID : bizDataIDs) {
                    ps.setString(1, userPK.toString());
                    ps.setString(2, orgPK.toString());
                    ps.setString(3, bizDataID.toString());
                    ps.addBatch();
                }
            } else {
                sql.append("DELETE FROM ").append(this.getTableName(objectType)).append(" WHERE FRoleID = ? ").append(" AND FBizDataID = ? ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                for (BOSUuid bizDataID : bizDataIDs) {
                    ps.setString(1, rolePK.toString());
                    ps.setString(2, bizDataID.toString());
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new DiscretePermException(DiscretePermException.DISCRETE_DATA_PERM_DEL_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    @Override
    public Set getBizDatas(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK) throws BOSException, EASBizException {
        HashSet<BOSUuid> result = new HashSet<BOSUuid>();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            if (rolePK == null) {
                sql.append("SELECT DISTINCT FBizDataID FROM ").append(this.getTableName(objectType)).append(" WHERE FUserID = ? ").append(" AND ( FOrgID = ? OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                ps.setString(1, userPK.toString());
                ps.setString(2, orgPK.toString());
            } else {
                sql.append("SELECT DISTINCT FBizDataID FROM ").append(this.getTableName(objectType)).append(" WHERE FRoleID = ? ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                ps.setString(1, rolePK.toString());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(BOSUuid.read((String)rs.getString("FBizDataID")));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return result;
    }

    @Override
    public Set getBizDatas(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        HashSet<BOSUuid> result = new HashSet<BOSUuid>();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            IUserRoleOrgManager userRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance(this.context);
            RoleCollection roleCol = userRoleOrgManager.getRoles(userPK, orgPK);
            List roleIdsList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)roleCol, new IObjectCol2List(){

                @Override
                public String getList(Object obj) {
                    return ((RoleInfo)obj).getId().toString();
                }
            });
            String roleIds = ToolUtils.aryToStr(roleIdsList);
            sql.append("SELECT DISTINCT FBizDataID FROM ").append(this.getTableName(objectType)).append(" WHERE FUserID = ? ").append(" AND ( FOrgID = ? OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
            sql.append(" union select distinct FBizDataID from ").append(this.getTableName(objectType)).append(" where froleid in (").append(roleIds).append(")");
            cn = EJBFactory.getConnection((Context)this.context);
            ps = cn.prepareStatement(sql.toString());
            ps.setString(1, userPK.toString());
            ps.setString(2, orgPK.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(BOSUuid.read((String)rs.getString("FBizDataID")));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return result;
    }

    private String getTableName(BOSObjectType objectType) {
        return (String)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityTables().get(objectType.toString());
    }

    @Override
    public DiscretePermCollection getDiscretePerms(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, IObjectPK bizDataPK) throws BOSException, EASBizException {
        DiscretePermCollection ddps = new DiscretePermCollection();
        StringBuffer sql = new StringBuffer();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (rolePK == null) {
                sql.append("SELECT DiscretePermissionTab.FUserID, DiscretePermissionTab.FOrgID, DiscretePermissionTab.FRoleID, ").append(" DiscretePermissionTab.FBizDataID, DiscretePermissionTab.FPermItemID, ").append(" PermItem.FName, PermItem.FOrgRelation FROM ").append(this.getTableName(objectType)).append(" DiscretePermissionTab ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = DiscretePermissionTab.FPermItemID ").append(" WHERE DiscretePermissionTab.FUserID = ? ").append(" AND ( DiscretePermissionTab.FOrgID = ? OR DiscretePermissionTab.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND DiscretePermissionTab.FBizDataID = ? ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                ps.setString(1, userPK.toString());
                ps.setString(2, orgPK.toString());
                ps.setString(3, bizDataPK.toString());
            } else {
                sql.append("SELECT DiscretePermissionTab.FUserID, DiscretePermissionTab.FOrgID, DiscretePermissionTab.FRoleID, ").append(" DiscretePermissionTab.FBizDataID, DiscretePermissionTab.FPermItemID, ").append(" PermItem.FName, PermItem.FOrgRelation FROM ").append(this.getTableName(objectType)).append(" DiscretePermissionTab ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = DiscretePermissionTab.FPermItemID ").append(" WHERE DiscretePermissionTab.FRoleID = ? ").append(" AND DiscretePermissionTab.FBizDataID = ? ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                ps.setString(1, rolePK.toString());
                ps.setString(2, bizDataPK.toString());
            }
            rs = ps.executeQuery();
            this.getDataFromRowSet(rs, ddps);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return ddps;
    }

    private void getDataFromRowSet(ResultSet rs, DiscretePermCollection ddps) throws SQLException {
        while (rs.next()) {
            String roleID;
            String orgID;
            DiscretePermInfo discretePermInfo = new DiscretePermInfo();
            String userID = rs.getString("FUserID");
            if (!StringUtils.isEmpty((String)userID)) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)userID));
                discretePermInfo.setUser(userInfo);
            }
            if (!StringUtils.isEmpty((String)(orgID = rs.getString("FOrgID")))) {
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)orgID));
                discretePermInfo.setOrg(org);
            }
            if (!StringUtils.isEmpty((String)(roleID = rs.getString("FRoleID")))) {
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)roleID));
                discretePermInfo.setRole(roleInfo);
            }
            BOSUuid bizDataID = BOSUuid.read((String)rs.getString("FBizDataID"));
            discretePermInfo.setBizDataID(bizDataID);
            PermItemInfo permItemInfo = new PermItemInfo();
            permItemInfo.setId(BOSUuid.read((String)rs.getString("FPermItemID")));
            permItemInfo.setName(rs.getString("FName"));
            permItemInfo.setOrgRelation(OrgType.getEnum((int)rs.getInt("FOrgRelation")));
            discretePermInfo.setPermItemInfo(permItemInfo);
            ddps.add(discretePermInfo);
        }
    }

    @Override
    public Set getDiscretePermItems(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK) throws EASBizException, BOSException {
        HashSet<BOSUuid> result = new HashSet<BOSUuid>();
        StringBuffer sql = new StringBuffer();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (rolePK == null) {
                sql.append("SELECT DISTINCT FPermItemID FROM ").append(this.getTableName(objectType)).append(" WHERE FUserID = ? ").append(" AND ( FOrgID = ? OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                ps.setString(1, userPK.toString());
                ps.setString(2, orgPK.toString());
            } else {
                sql.append("SELECT DISTINCT FPermItemID FROM ").append(this.getTableName(objectType)).append(" WHERE FRoleID = ? ");
                cn = EJBFactory.getConnection((Context)this.context);
                ps = cn.prepareStatement(sql.toString());
                ps.setString(1, rolePK.toString());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(BOSUuid.read((String)rs.getString("FPermItemID")));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return result;
    }

    @Override
    public Map getAllUOPs(IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        HashMap<String, UserOrgPermInfo> map = new HashMap<String, UserOrgPermInfo>();
        String sql = "SELECT FPermItemID, FPermType, FRuleStructure FROM T_PM_UserOrgPerm WHERE FOwner = ? AND ( FOrgID = ? OR FOrgID = '11111111-1111-1111-1111-111111111111CCE7AED4' ) ";
        Object[] params = new Object[]{userPK.toString(), orgPK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql, (Object[])params);
        UserOrgPermInfo userOrgPermInfo = null;
        try {
            while (rowSet.next()) {
                userOrgPermInfo = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                userOrgPermInfo.setPermItem(permItemInfo);
                userOrgPermInfo.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                userOrgPermInfo.setRuleStructure(rowSet.getString("FRuleStructure"));
                map.put(PermissionCommonUtil.getKey(userOrgPermInfo), userOrgPermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserOrgPermException(UserOrgPermException.GET_USERORGPERM_FAIL, e);
        }
        return map;
    }

    @Override
    public Map getAllRPs(IObjectPK rolePK) throws BOSException, EASBizException {
        assert (rolePK != null);
        HashMap<String, RolePermInfo> map = new HashMap<String, RolePermInfo>();
        String sql = "SELECT FPermItemID, FPermType, FRuleStructure FROM T_PM_RolePerm WHERE FRoleID = ?";
        Object[] params = new Object[]{rolePK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql, (Object[])params);
        RolePermInfo rolePermInfo = null;
        try {
            while (rowSet.next()) {
                rolePermInfo = new RolePermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                rolePermInfo.setPermItem(permItemInfo);
                rolePermInfo.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                rolePermInfo.setRuleStructure(rowSet.getString("FRuleStructure"));
                map.put(PermissionCommonUtil.getKey(rolePermInfo), rolePermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RolePermException(RolePermException.GET_ROLEPERM_FAIL, e);
        }
        return map;
    }

    @Override
    public String getDiscretePermissionSQL(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK permItemPK) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(100);
        String tableName = this.getTableName(objectType);
        String userID = userPK.toString();
        String orgID = orgPK.toString();
        String permItemID = permItemPK.toString();
        sql.append("SELECT 1 WHERE EXISTS( ").append(" SELECT 1 FROM ").append(tableName).append(" DiscretePerm ").append(" WHERE DiscretePerm.FUserID = ? ").append(" AND ( DiscretePerm.FOrgID = ? OR DiscretePerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND DiscretePerm.FPermItemID = ? ").append(" UNION ALL ").append(" SELECT 1 FROM ").append(tableName).append(" DiscretePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = DiscretePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND UserRoleOrg.FOrgID = ? ").append(" AND DiscretePerm.FPermItemID = ? )");
        Object[] params = new Object[]{userID, orgID, permItemID, userID, orgID, permItemID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                sql = new StringBuffer(100);
                sql.append("SELECT FBizDataID FID FROM ").append(tableName).append(" DiscretePerm ").append(" WHERE DiscretePerm.FUserID = '").append(userID).append("' ").append(" AND ( DiscretePerm.FOrgID = '").append(orgID).append("' OR DiscretePerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND DiscretePerm.FPermItemID = '").append(permItemID).append("' ").append(" UNION ").append(" SELECT FBizDataID FID FROM ").append(tableName).append(" DiscretePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = DiscretePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' ").append(" AND UserRoleOrg.FOrgID = '").append(orgID).append("' ").append(" AND DiscretePerm.FPermItemID = '").append(permItemID).append("' ");
                return sql.toString();
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
        }
    }

    @Override
    public void removeDiscretePermsByBoId(BOSObjectType objectType, List boIdList) throws BOSException, EASBizException {
        String tableName = this.getTableName(objectType);
        if (StringUtils.isEmpty((String)tableName)) {
            logger.error((Object)"table is null");
            return;
        }
        String sql = " delete from " + tableName + " where FBizDataID in (" + ToolUtils.aryToStr(boIdList, true) + ")";
        DbUtil.execute((Context)this.context, (String)sql);
    }

    @Override
    public DiscretePermCollection getDiscretePermsAny(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, IObjectPK permItemId, IObjectPK bizDataPK, String conditionStr) throws BOSException, EASBizException {
        DiscretePermCollection ddps = new DiscretePermCollection();
        StringBuffer sql = new StringBuffer();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sql.append("SELECT ztemp.FUserID, ztemp.FOrgID, ztemp.FRoleID, ").append(" ztemp.FBizDataID, ztemp.FPermItemID, ").append(" PermItem.FName, PermItem.FOrgRelation FROM ").append(this.getTableName(objectType)).append(" ztemp ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = ztemp.FPermItemID ");
            String whereStr = this.getWhereStr(userPK, orgPK, rolePK, permItemId, bizDataPK, conditionStr);
            if (!StringUtils.isEmpty((String)whereStr)) {
                sql.append(" where (").append(whereStr).append(")");
            }
            cn = EJBFactory.getConnection((Context)this.context);
            ps = cn.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            this.getDataFromRowSet(rs, ddps);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                logger.error((Object)sql.toString());
                throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return ddps;
    }

    private String getWhereStr(IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, IObjectPK permItemId, IObjectPK bizDataPK, String conditionStr) {
        String retStr = "";
        if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)userPK)) && StringUtils.isEmpty((String)StringUtils.cnulls((Object)orgPK)) && StringUtils.isEmpty((String)StringUtils.cnulls((Object)rolePK)) && StringUtils.isEmpty((String)StringUtils.cnulls((Object)permItemId)) && StringUtils.isEmpty((String)StringUtils.cnulls((Object)bizDataPK)) && StringUtils.isEmpty((String)conditionStr)) {
            return "";
        }
        retStr = " ";
        String whereStr = "";
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)userPK))) {
            whereStr = " ztemp.fuserid = '" + userPK + "'";
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)orgPK))) {
            whereStr = whereStr + " and ztemp.forgid = '" + orgPK + "'";
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)rolePK))) {
            whereStr = whereStr + " and ztemp.froleid = '" + rolePK + "'";
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)permItemId))) {
            whereStr = whereStr + " and ztemp.fpermitemId = '" + permItemId + "'";
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)bizDataPK))) {
            whereStr = whereStr + " and ztemp.fbizdataId = '" + bizDataPK + "'";
        }
        if (!StringUtils.isEmpty((String)conditionStr)) {
            whereStr = whereStr + " and " + conditionStr;
        }
        if ((whereStr = whereStr.trim()).startsWith("and")) {
            whereStr = whereStr.substring(4, whereStr.length());
        }
        return retStr + whereStr;
    }

    @Override
    public IRowSet getUserDiscretePerms(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, IObjectPK permItemId, IObjectPK bizDataPK, IMetaDataPK queryPK, int startPos, int endPos, String conditionStr, boolean queryUser) throws BOSException {
        IMetaDataLoader iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.context);
        QueryInfo queryInfo = iMetaDataLoader.getQuery(queryPK);
        IQueryDataAccess iQuery = QueryDataAccessFactory.getLocalInstance((Context)this.context);
        EntityViewInfo entityView = new EntityViewInfo();
        String sql = iQuery.getQuerySql(queryPK, entityView);
        String sourceTableName = "";
        if (queryInfo instanceof JoinQueryInfo) {
            JoinQueryInfo joinQueryInfo = (JoinQueryInfo)queryInfo;
            SubObjectInfo subOjb = QueryUtil.getMainObject((JoinQueryInfo)joinQueryInfo);
            sourceTableName = subOjb.getName();
        }
        String retSql = this.formNewSql(objectType, sourceTableName, sql);
        String anotherWhereConditionStr = this.getWhereStr(userPK, orgPK, rolePK, permItemId, bizDataPK, conditionStr);
        retSql = retSql.toLowerCase().indexOf("where") != -1 ? retSql + " and " + anotherWhereConditionStr : retSql + " where " + anotherWhereConditionStr;
        retSql = queryUser ? retSql + " order by fduserid,fdOrgId" : retSql + " order by froleid";
        retSql = retSql + ",ztemp.fbizdataid";
        return DbUtil.executeQuery((Context)this.context, (String)retSql, (int)startPos, (int)endPos);
    }

    private String formNewSql(BOSObjectType objectType, String sourceTable, String sql) {
        try {
            String mutiLanFix = this.context.getLocale().toString();
            SelectParser selectParse = new SelectParser(sql);
            SqlSelect select = (SqlSelect)selectParse.select();
            select.selectList.add(ORMUtils.buildSelectItem((String)"ztemp", (String)"fuserid", (String)"fduserid"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"ztemp", (String)"forgid", (String)"fdOrgId"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"ztemp", (String)"froleid", (String)"fdRoelId"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"t_pm_role", (String)("fname_" + mutiLanFix), (String)"fdRoelName"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"ztemp", (String)"fpermitemid", (String)"fdPermItemId"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"ztemp", (String)"fbizdataid", (String)"fdbizDataId"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"t_pm_user", (String)"fnumber", (String)"fuserNumber"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"t_pm_permItem", (String)("falias_" + mutiLanFix), (String)"fpermItemName"));
            select.selectList.add(ORMUtils.buildSelectItem((String)"t_org_baseunit", (String)("fname_" + mutiLanFix), (String)"forgName"));
            StringBuffer fromStr = new StringBuffer(" select distinct ");
            fromStr.append(ToolUtils.aryToStr(select.selectList, false)).append(" ");
            QuerySQLFormater formater = new QuerySQLFormater(fromStr);
            formater.getFromCause(select);
            String tableName = this.getTableName(objectType);
            fromStr.append(" right join ").append(tableName).append(" as ztemp on ztemp.fbizdataid = \"").append(sourceTable).append("\".").append("fid ");
            fromStr.append(" left join t_pm_user ").append(" as t_pm_user on ztemp.fuserid = t_pm_user.fid ");
            fromStr.append(" left join t_org_baseunit ").append(" as t_org_baseunit on ztemp.forgid = t_org_baseunit.fid ");
            fromStr.append(" left join t_pm_permItem ").append(" as t_pm_permItem on ztemp.fpermitemId = t_pm_permItem.fid ");
            fromStr.append(" left join t_pm_role ").append(" as t_pm_role on ztemp.froleid = t_pm_role.fid ");
            StringBuffer whereSb = new StringBuffer("");
            QuerySQLFormater whereFormater = new QuerySQLFormater(whereSb);
            whereFormater.getConditionCause(select);
            if (whereSb.length() != 0) {
                fromStr.append(" where ");
                fromStr.append(whereSb);
            }
            String retSqlStr = StringUtils.replace((String)fromStr.toString(), (String)"_l1", (String)("_" + mutiLanFix));
            return retSqlStr;
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (FormaterException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }
}

