/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OprtTypeEnum;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgException;
import com.kingdee.eas.base.permission.app.UpdateType;
import com.kingdee.eas.base.permission.app.UserAssignRoleAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserOrgRoleManagerHelper {
    private static Logger logger = Logger.getLogger(UserOrgRoleManagerHelper.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static ThreadLocal<Set<IObjectPK>> THREAD_LOCAL_LOG_PK = new ThreadLocal();

    public static Set<String> getOrgRangeIds(Context ctx, String userId, int type) throws BOSException, EASBizException {
        String sql = " SELECT FORGID From T_PM_ORGRANGE where FUSERID =? and FTYPE =?";
        IRowSet orgIds = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId, type});
        HashSet<String> orgIdsSet = new HashSet<String>();
        try {
            while (orgIds.next()) {
                orgIdsSet.add(orgIds.getString("FORGID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return orgIdsSet;
    }

    public static Set<String> getGrantRoleIds(Context ctx, String fuserId) throws BOSException {
        String sql = " select distinct froleId from T_PM_GrantUserRoleOrg where  fuserid = ? union select fid as froleId from T_PM_ROLE ro where ro.fcreatorid=? ";
        IRowSet roleIds = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fuserId, fuserId});
        HashSet<String> roleIdList = new HashSet<String>();
        try {
            while (roleIds.next()) {
                roleIdList.add(roleIds.getString("froleId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return roleIdList;
    }

    public static void insertUserRolesOrgByCheck(Context ctx, String userId, String orgId, String roleId, String tableName) throws BOSException {
        UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, userId, orgId, new HashSet<String>(Arrays.asList(roleId)), tableName);
    }

    public static void insertUserRolesOrgByCheck(Context ctx, String userId, String orgId, Set<String> roleIds, String tableName) throws BOSException {
        UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, userId, new HashSet<String>(Arrays.asList(orgId)), roleIds, tableName);
    }

    public static void insertUserRolesOrgByCheck(Context ctx, String userId, Set<String> orgIds, Set<String> roleIds, String tableName) throws BOSException {
        UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, new HashSet<String>(Arrays.asList(userId)), orgIds, roleIds, tableName);
    }

    public static void insertUserRolesOrgByCheck(Context ctx, Set<String> userIds, Set<String> orgIds, Set<String> roleIds, String tableName) throws BOSException {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append(" insert into T_PM_UserRoleOrg (FUserID, FRoleID, FOrgID) ");
        insertSql.append(" (select ?, ?, ? ");
        insertSql.append(" where not exists (SELECT 1 FROM " + tableName + " where FUSERID =? and FORGID =? and FROLEID =?) ");
        insertSql.append(" and exists (SELECT 1 FROM T_PM_ORGRANGE where  FUSERID =? and FORGID =? and FTYPE =10))");
        Connection conn = null;
        PreparedStatement state = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            state = conn.prepareStatement(insertSql.toString());
            int num = 0;
            for (String userId : userIds) {
                for (String orgId : orgIds) {
                    for (String roleId : roleIds) {
                        state.setString(1, userId);
                        state.setString(2, roleId);
                        state.setString(3, orgId);
                        state.setString(4, userId);
                        state.setString(5, orgId);
                        state.setString(6, roleId);
                        state.setString(7, userId);
                        state.setString(8, orgId);
                        state.addBatch();
                        if (++num % 1000 != 0) continue;
                        state.executeBatch();
                        state.clearBatch();
                    }
                }
            }
            if (num % 1000 != 0) {
                state.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private static void insertUserRolesOrg(Context ctx, String userId, String orgId, List<String> roleIds, String tableName) throws BOSException {
        String insertSql = "insert into " + tableName + "(fuserid,froleid,forgid) values ( ?,?,?)";
        Connection conn = null;
        PreparedStatement state = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            state = conn.prepareStatement(insertSql);
            int count = 0;
            for (String roleId : roleIds) {
                state.setString(1, userId);
                state.setString(2, roleId);
                state.setString(3, orgId);
                state.addBatch();
                if (++count != 200) continue;
                state.executeBatch();
                state.clearBatch();
                count = 0;
            }
            if (count > 0) {
                state.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private static void deleteUsersRolesOrgs(Context ctx, String userId, String orgId, List<String> roleIds, String tableName) throws BOSException {
        String roleIdStr = ToolUtils.aryToStr(roleIds, true);
        String delSql = "delete from  " + tableName + " where fuserId='" + userId + "' and forgId='" + orgId + "' and froleId in (" + roleIdStr + ")";
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }

    public static Map<UpdateType, List<String>> saveUserRoleOrgsCheck(Context ctx, String userId, String orgId, List<String> roleIds, String tableName) throws BOSException, EASBizException {
        if (!UserOrgRoleManagerHelper.checkCurUserAssinPerm(ctx, userId, orgId)) {
            return new HashMap<UpdateType, List<String>>();
        }
        UserInfo curUser = UserInfoUtils.getCurrentUser(ctx);
        if (curUser.isBizAdmin()) {
            ArrayList<String> canAssignRolesIds = new ArrayList<String>(UserOrgRoleManagerHelper.getGrantRoleIds(ctx, curUser.getId().toString()));
            roleIds.retainAll(canAssignRolesIds);
        }
        return UserOrgRoleManagerHelper.saveUserOrgRoles(ctx, userId, orgId, roleIds, tableName);
    }

    public static Map<UpdateType, List<String>> appendUserOrgRoles(Context ctx, String userId, String orgId, List<String> roleIds, String tableName) throws BOSException, EASBizException {
        return UserOrgRoleManagerHelper.dealUserOrgRoles(ctx, userId, orgId, roleIds, tableName, UpdateType.APPEND);
    }

    public static Map<UpdateType, List<String>> removeUserOrgRoles(Context ctx, String userId, String orgId, List<String> roleIds, String tableName) throws BOSException, EASBizException {
        return UserOrgRoleManagerHelper.dealUserOrgRoles(ctx, userId, orgId, roleIds, tableName, UpdateType.DELETE);
    }

    public static Map<UpdateType, List<String>> saveUserOrgRoles(Context ctx, String userId, String orgId, List<String> roleIds, String tableName) throws BOSException, EASBizException {
        return UserOrgRoleManagerHelper.dealUserOrgRoles(ctx, userId, orgId, roleIds, tableName, UpdateType.OVERWRITE);
    }

    public static Map<UpdateType, List<String>> dealUserOrgRoles(Context ctx, String userId, String orgId, List<String> roleIds, String tableName, UpdateType updateType) throws BOSException, EASBizException {
        boolean isEnablePermAuthen;
        IUser iUser;
        UserInfo userInfo;
        HashMap<UpdateType, List<String>> dealRoleIds = new HashMap<UpdateType, List<String>>();
        dealRoleIds.put(UpdateType.APPEND, new ArrayList());
        dealRoleIds.put(UpdateType.DELETE, new ArrayList());
        boolean isGrantSave = false;
        if ("T_PM_GrantUserRoleOrg".equalsIgnoreCase(tableName)) {
            isGrantSave = true;
            if (!UserOrgRoleManagerHelper.isUserOrgRange(ctx, userId, orgId, OrgRangeType.MANAGE_ORG_TYPE)) {
                return dealRoleIds;
            }
        } else if (!UserOrgRoleManagerHelper.isUserOrgRange(ctx, userId, orgId, OrgRangeType.BIZ_ORG_TYPE)) {
            return dealRoleIds;
        }
        String mainRoleId = (userInfo = (iUser = UserFactory.getLocalInstance(ctx)).getUserInfo("SELECT number,name, mainRole.id, mainRole.name  WHERE id = '" + userId + "' ")).getMainRole() == null ? "" : userInfo.getMainRole().getId().toString();
        Map.Entry<List, List> delAndNewRoles = UserOrgRoleManagerHelper.computeDiffRoleIds(ctx, userId, orgId, roleIds, tableName, updateType);
        List delRoleIds = delAndNewRoles.getKey();
        List<String> newRoleIds = delAndNewRoles.getValue();
        if (delRoleIds.contains(mainRoleId)) {
            Object[] objs = new Object[]{userInfo.getName(), userInfo.getMainRole().getName()};
            throw new UserRoleOrgException(UserRoleOrgException.REMOVE_MAIN_ROLE_FAIL, objs);
        }
        if (newRoleIds != null && !newRoleIds.isEmpty() && (isEnablePermAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen))) {
            List<String> notNeedAuthenRoleIds;
            OprtTypeEnum oprtType = isGrantSave ? OprtTypeEnum.AssignGrantRoleToUser : OprtTypeEnum.AssignRoleToUser;
            UserAssignRoleAuthenRecordAuthen userAssignRoleAuthenRecordAuthen = new UserAssignRoleAuthenRecordAuthen(ctx);
            newRoleIds = notNeedAuthenRoleIds = userAssignRoleAuthenRecordAuthen.createAuthen(ctx, oprtType, userInfo, orgId, UserInfoUtils.getCurrentUser(ctx), newRoleIds);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"USER_SAVE_ROLE"), (BOSObjectType)new RoleInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (String)UserOrgRoleManagerHelper.getRoleDetailLog(ctx, userInfo, orgId, delRoleIds, newRoleIds), (String)"bs_permission_AccreditRole");
        UserOrgRoleManagerHelper.insertUserRolesOrg(ctx, userId, orgId, newRoleIds, tableName);
        if (delRoleIds != null && !delRoleIds.isEmpty()) {
            UserOrgRoleManagerHelper.deleteUsersRolesOrgs(ctx, userId, orgId, delRoleIds, tableName);
        }
        UserOrgRoleManagerHelper.beforeSaveRoleLog(logPK);
        dealRoleIds.put(UpdateType.APPEND, newRoleIds);
        dealRoleIds.put(UpdateType.DELETE, delRoleIds);
        return dealRoleIds;
    }

    private static void beforeSaveRoleLog(IObjectPK logPK) {
        Set<IObjectPK> logPKs = THREAD_LOCAL_LOG_PK.get();
        if (logPKs == null) {
            logPKs = new HashSet<IObjectPK>();
        }
        logPKs.add(logPK);
        THREAD_LOCAL_LOG_PK.set(logPKs);
    }

    public static void afterSaveRoleLog(Context ctx) {
        Set<IObjectPK> logPKs = THREAD_LOCAL_LOG_PK.get();
        if (logPKs == null || logPKs.size() == 0) {
            return;
        }
        for (IObjectPK logPK : logPKs) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        THREAD_LOCAL_LOG_PK.remove();
    }

    private static String getRoleDetailLog(Context ctx, UserInfo userInfo, String orgId, List<String> delRoleIds, List<String> newRoleIds) throws BOSException, EASBizException {
        int i;
        RoleCollection roleCollection;
        FilterInfo filter;
        EntityViewInfo entityViewInfo;
        StringBuffer logDetail = new StringBuffer();
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        logDetail.append(EASResource.getString((String)RESOURCE, (String)"USER_ACCOUNT")).append(userInfo.getName()).append("(").append(userInfo.getNumber()).append(") \n").append(EASResource.getString((String)RESOURCE, (String)"ORG")).append(orgUnitInfo.getName()).append("(").append(orgUnitInfo.getNumber()).append(") \n");
        IRole iRole = RoleFactory.getLocalInstance(ctx);
        if (newRoleIds != null && !newRoleIds.isEmpty()) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"ADDNEW_ROLE"));
            entityViewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(newRoleIds), CompareType.INCLUDE));
            entityViewInfo.setFilter(filter);
            roleCollection = iRole.getRoleCollection(entityViewInfo);
            for (i = 0; i < roleCollection.size(); ++i) {
                logDetail.append(roleCollection.get(i).getName()).append(",");
            }
            logDetail.append("\n");
        }
        if (delRoleIds != null && !delRoleIds.isEmpty()) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"DELETE_ROLE"));
            entityViewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(delRoleIds), CompareType.INCLUDE));
            entityViewInfo.setFilter(filter);
            roleCollection = iRole.getRoleCollection(entityViewInfo);
            for (i = 0; i < roleCollection.size(); ++i) {
                logDetail.append(roleCollection.get(i).getName()).append(",");
            }
            logDetail.append("\n");
        }
        return logDetail.toString();
    }

    private static Map.Entry<List, List> computeDiffRoleIds(Context ctx, String userId, String orgID, List<String> opRoleIds, String tableName, UpdateType updateType) throws BOSException, EASBizException {
        List<Object> deleteRoles = new ArrayList();
        ArrayList<Object> addRoles = new ArrayList();
        List<String> userRoleIds = UserOrgRoleManagerHelper.getUserRoleIds(ctx, tableName, userId, orgID);
        ArrayList<String> retainRoleIds = new ArrayList<String>(opRoleIds);
        retainRoleIds.retainAll(userRoleIds);
        if (updateType.equals((Object)UpdateType.DELETE)) {
            deleteRoles = retainRoleIds;
        } else if (updateType.equals((Object)UpdateType.APPEND)) {
            ArrayList<String> appendRoleIds = new ArrayList<String>(opRoleIds);
            appendRoleIds.removeAll(retainRoleIds);
            addRoles = appendRoleIds;
        } else if (updateType.equals((Object)UpdateType.OVERWRITE)) {
            UserInfo curUser;
            userRoleIds.removeAll(retainRoleIds);
            deleteRoles = userRoleIds;
            ArrayList<String> overRideRoleIds = new ArrayList<String>(opRoleIds);
            overRideRoleIds.removeAll(retainRoleIds);
            addRoles = overRideRoleIds;
            if (!deleteRoles.isEmpty() && (curUser = UserInfoUtils.getCurrentUser(ctx)).isBizAdmin()) {
                ArrayList<String> canAssignRolesIds = new ArrayList<String>(UserOrgRoleManagerHelper.getGrantRoleIds(ctx, curUser.getId().toString()));
                deleteRoles.retainAll(canAssignRolesIds);
            }
        }
        return new AbstractMap.SimpleEntry<List, List>(deleteRoles, addRoles);
    }

    public static List<String> getUserRoleIds(Context ctx, String tableName, String userID, String orgID) throws BOSException {
        ArrayList<String> roleIds = new ArrayList<String>();
        String sql = "select froleid from " + tableName + " where fuserID='" + userID + "' and  forgId ='" + orgID + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                roleIds.add(rowSet.getString("froleid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return roleIds;
    }

    public static boolean isUserOrgRange(Context ctx, String userId, String orgId, OrgRangeType type) throws BOSException, EASBizException {
        if (type == OrgRangeType.MANAGE_ORG_TYPE) {
            IFullOrgUnit iorgunit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            OrgUnitInfo info = iorgunit.getOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            orgId = info.getCU().getId().toString();
        }
        String sql = " SELECT 1 From T_PM_ORGRANGE where FUSERID =? and forgid=?  and  FTYPE =? ";
        IRowSet orgIds = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId, orgId, type.getValue()});
        try {
            if (orgIds != null && orgIds.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean isCuAdminCuRange(Context ctx, String userId, String orgId) throws BOSException, EASBizException {
        IFullOrgUnit iorgunit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        OrgUnitInfo info = iorgunit.getOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        orgId = info.getCU().getId().toString();
        String sql = " SELECT 1 From T_PM_ORGRANGE where FUSERID =? and forgid=?  and  FTYPE =? ";
        IRowSet orgIds = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId, orgId, 10});
        try {
            if (orgIds != null && orgIds.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean checkCurUserAssinPerm(Context ctx, String userId, String orgId) throws EASBizException, BOSException {
        UserInfo curUser = UserInfoUtils.getCurrentUser(ctx);
        ObjectStringPK userPK = new ObjectStringPK(curUser.getId().toString());
        return Administrator.isSuperCUAdmin((IObjectPK)userPK) || !(Administrator.isCUAdmin(ctx, (IObjectPK)userPK) ? !UserOrgRoleManagerHelper.isCuAdminCuRange(ctx, curUser.getId().toString(), orgId) : curUser.isBizAdmin() && !UserOrgRoleManagerHelper.isUserOrgRange(ctx, curUser.getId().toString(), orgId, OrgRangeType.MANAGE_ORG_TYPE));
    }

    public static List<String> getUserRoleIds(Context ctx, String tableName, String roleId) throws BOSException {
        ArrayList<String> userIds = new ArrayList<String>();
        String sql = "select distinct fuserID from " + tableName + " where  froleid ='" + roleId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                userIds.add(rowSet.getString("fuserID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return userIds;
    }
}

