/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAOUtils;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.OtherOwnerCollection;
import com.kingdee.eas.base.permission.OtherOwnerInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.SpecialDataPermEntryInfo;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.SpecialDataPermType;
import com.kingdee.eas.base.permission.SpecialPermLogicTag;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.config.PermissionFilterConfiguration;
import com.kingdee.eas.base.permission.app.service.CoopOrgHelper;
import com.kingdee.eas.base.permission.app.service.DiscretePermissionService;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.base.permission.app.service.IDataPermissionService;
import com.kingdee.eas.base.permission.app.service.SpecialDataPermissionHandler;
import com.kingdee.eas.base.permission.app.util.DebugHelper;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataPermissionService
implements IDataPermissionService {
    private static Logger logger = Logger.getLogger(DataPermissionService.class);
    private Context context = null;

    public DataPermissionService(Context context) {
        this.context = context;
    }

    @Override
    public boolean hasPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, Object bizData) throws BOSException, EASBizException {
        PermItemInfo permItemInfo;
        IObjectPK permissionOrgPK;
        assert (userPK != null && permItemName != null && bizData != null);
        if (bizData instanceof IObjectPK) {
            bizData = new ObjectUuidPK(bizData.toString());
        }
        if ((permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, (permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName)).getOrgRelation(), orgPK, bizData)) == null) {
            return false;
        }
        FunctionPermissionService functionPermissionService = new FunctionPermissionService(this.context);
        if (!functionPermissionService.hasPermission(userPK, permissionOrgPK, permItemName, true)) {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.context);
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(permissionOrgPK);
            UserInfo user = UserFactory.getLocalInstance(this.context).getUserByID(userPK);
            String userName = user != null ? user.getNumber() : "";
            Object[] object = new Object[]{userName, fullOrgUnitInfo.getName(), permItemInfo.getAlias()};
            PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION_2, object);
            logger.error((Object)"pe", (Throwable)((Object)pe));
            throw pe;
        }
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            return true;
        }
        Connection con = null;
        try {
            String rule;
            con = EJBFactory.getConnection((Context)this.context);
            ORMappingDAO dao = new ORMappingDAO(BOSObjectType.create((String)permItemInfo.getObjectType()), this.context, con);
            String commonRule = this.getDataRule(userPK, permissionOrgPK, permItemInfo);
            AbstractObjectValue bizPermData = null;
            String specialRule = this.getSpecialDataPermRule(userPK, permissionOrgPK, permItemInfo);
            String bizPermitemlogic = null;
            if (!StringUtils.isEmpty((String)specialRule)) {
                bizPermitemlogic = this.getItemLogicPriority(orgPK, permItemInfo);
            }
            if (StringUtils.isEmpty((String)(rule = this.mergeCommonAndSpecialRule(commonRule, specialRule, bizPermitemlogic)))) {
                boolean bl = true;
                return bl;
            }
            this.checkBizDataIsMatchRule(permItemInfo, bizData);
            EntityViewInfo entityViewInfo = new EntityViewInfo(rule);
            if (OperationType.READ.equals((Object)permItemInfo.getOperationType())) {
                this.dealEntryWhere(entityViewInfo, EntryFilterType.ENTRYANYWHERE);
            } else {
                this.dealEntryWhere(entityViewInfo, EntryFilterType.ENTRYALLWHERE);
            }
            if (entityViewInfo.getFilter() == null) {
                entityViewInfo.setFilter(new FilterInfo());
            }
            boolean flag = true;
            if (bizData instanceof IObjectPK) {
                bizPermData = dao.getValue((IObjectPK)bizData, this.getSpecialBizDataSelectors(BOSObjectType.create((String)permItemInfo.getObjectType())), true);
            } else if (bizData instanceof IObjectValue) {
                AbstractObjectValue abstractObjectValue;
                bizPermData = abstractObjectValue = (AbstractObjectValue)bizData;
                if (!abstractObjectValue.containsKey("creator") && OperationType.ADDNEW.equals((Object)permItemInfo.getOperationType())) {
                    bizPermData.put("creator", (Object)ContextUtil.getCurrentUserInfo((Context)this.context));
                }
            }
            try {
                flag = dao.accept((IObjectValue)bizPermData, entityViewInfo);
            }
            catch (InvalidDAOMetaDataException ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new PermissionException(PermissionException.DATAPERMISSIONENABLEDFAIL, ex);
            }
            if (!flag) {
                DebugHelper.debugNoDataPermission(this.context, userPK, orgPK, permItemName, bizData, entityViewInfo == null ? null : entityViewInfo.toString());
            }
            boolean bl = flag;
            return bl;
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void dealEntryWhere(EntityViewInfo entityViewInfo, EntryFilterType entryFilterType) {
        if (entityViewInfo != null && entityViewInfo.getEntryFilters() != null) {
            FilterCollection filterCol = entityViewInfo.getEntryFilters();
            for (int i = 0; i < filterCol.size(); ++i) {
                filterCol.get(i).setEntryilterType(entryFilterType);
            }
        }
    }

    private boolean isSpecialEntity(String entityType) {
        return ConfigurationLoader.getInstance().getConfigurationInfo().getSpecialEntityTypes().contains(entityType);
    }

    private boolean isDiscretePermItem(PermItemInfo permItemInfo) {
        Set permItems = (Set)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityPermItems().get(permItemInfo.getObjectType());
        if (permItems == null) {
            return false;
        }
        return permItems.contains(permItemInfo.getName());
    }

    private SelectorItemCollection getSpecialBizDataSelectors(BOSObjectType objectType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.context);
        EntityObjectInfo objectBaseEntity = loader.getEntity(BOSObjectType.create((String)"0B2876F2"));
        EntityObjectInfo entity = loader.getEntity(objectType);
        if (entity.isSubFrom((BusinessObjectInfo)objectBaseEntity)) {
            sic.add(new SelectorItemInfo("creator.id"));
        }
        return sic;
    }

    private void checkBizDataIsMatchRule(PermItemInfo permItemInfo, Object bizObject) throws EASBizException, BOSException {
        if (bizObject instanceof ObjectUuidPK) {
            ObjectUuidPK uuidPK = (ObjectUuidPK)bizObject;
            if (!uuidPK.getObjectType().toString().equals(permItemInfo.getObjectType())) {
                throw new PermissionException(PermissionException.BIZ_OBJECT_NOT_MATCH_RULE);
            }
        } else if (bizObject instanceof IObjectValue) {
            IObjectValue objectValue = (IObjectValue)bizObject;
            if (!objectValue.getBOSType().toString().equals(permItemInfo.getObjectType())) {
                throw new PermissionException(PermissionException.BIZ_OBJECT_NOT_MATCH_RULE);
            }
        } else {
            throw new PermissionException(PermissionException.BIZ_OBJECT_NOT_MATCH_RULE);
        }
    }

    private String getCommonDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        assert (userPK != null && orgPK != null && permItemInfo != null);
        String userID = userPK.toString();
        String orgID = orgPK.toString();
        String permItemID = permItemInfo.getId().toString();
        Object[] params = new Object[]{userID, orgID, permItemID, new Integer(10), userID, orgID, permItemID, new Integer(10)};
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FRuleExpr FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FOrgID = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? AND\u3000UserOrgPerm.FRuleExpr IS NOT NULL").append(" UNION ALL ").append(" SELECT RolePerm.FRuleExpr FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" AND ( 1= 1 OR UserRoleOrg.FOrgID = ? ) ");
        } else {
            sql.append(" AND UserRoleOrg.FOrgID = ? ");
        }
        sql.append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ?  and RolePerm.FRuleExpr IS NOT NULL");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        try {
            HashSet<String> retSet = new HashSet<String>();
            while (rowSet.next()) {
                retSet.add(rowSet.getString("FRuleExpr"));
            }
            String rule = null;
            for (String ruleExpr : retSet) {
                rule = RuleUtil.mergeOQL(rule, ruleExpr, "OR");
            }
            return rule;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
    }

    private String getDiscreteDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (this.isDiscretePermItem(permItemInfo)) {
            DiscretePermissionService service = new DiscretePermissionService(this.context);
            String discretePermissionRule = service.getDiscretePermissionRule(userPK, orgPK, permItemInfo.getName());
            return discretePermissionRule;
        }
        return null;
    }

    private String getDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        String commonDataRule = this.getCommonDataRule(userPK, orgPK, permItemInfo);
        if (CommonFilterUtil.isLikeVarEnumValue((String)commonDataRule)) {
            commonDataRule = CommonQueryUtil.getInnerFilterInfo((Context)this.context, (String)commonDataRule);
        }
        String discreteDataRule = this.getDiscreteDataRule(userPK, orgPK, permItemInfo);
        return RuleUtil.mergeOQL(commonDataRule, discreteDataRule, "OR");
    }

    public SpecialDataPermInfo getSpecialDataPermInfo(String cuID, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SpecialDataPerm.FID ,SpecialDataPerm.FIsEnableCreatorPerm, SpecialDataPerm.FBizObjectType,").append(" SpecialDataPerm.FIsEnableDirectorPerm, SpecialDataPermEntry.FPermType, SpecialDataPermEntry.FLogicTag ").append(" FROM T_PM_SpecialDataPermEntry SpecialDataPermEntry ").append(" INNER JOIN T_PM_SpecialDataPerm SpecialDataPerm ").append(" ON SpecialDataPerm.FID = SpecialDataPermEntry.FSpecialDataPermID ").append(" WHERE SpecialDataPermEntry.FPermItemID = ? AND SpecialDataPerm.FControlUnitID = ? ").append(" AND ( ( SpecialDataPerm.FIsEnableCreatorPerm = 1 AND SpecialDataPermEntry.FPermType <> ").append(0).append(" ) ").append(" OR SpecialDataPerm.FIsEnableDirectorPerm = 1 ) ");
        Object[] params = new Object[]{permItemInfo.getId().toString(), cuID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                SpecialDataPermInfo info = new SpecialDataPermInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setEnableCreatorPerm(rowSet.getInt("FIsEnableCreatorPerm") == 1);
                info.setEnableDirectorPerm(rowSet.getInt("FIsEnableDirectorPerm") == 1);
                String bizObjType = rowSet.getString("FBizObjectType");
                info.setBizObjectType(bizObjType);
                Map extFields = ConfigurationLoader.getInstance().getConfigurationInfo().getSpecialPositionField();
                if (extFields.containsKey(bizObjType)) {
                    info.setExtendedProperty("position-field", (String)extFields.get(bizObjType));
                }
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)cuID));
                info.setCU(cu);
                SpecialDataPermEntryInfo specialDataPermEntryInfo = new SpecialDataPermEntryInfo();
                specialDataPermEntryInfo.setPermType(SpecialDataPermType.getEnum(rowSet.getInt("FPermType")));
                specialDataPermEntryInfo.setLogicTag(SpecialPermLogicTag.getEnum(rowSet.getString("FLogicTag")));
                specialDataPermEntryInfo.setPermItem(permItemInfo);
                info.getEntries().add(specialDataPermEntryInfo);
                this.setOtherOwnerCollection(info);
                return info;
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
    }

    private void setOtherOwnerCollection(SpecialDataPermInfo specialDataPermInfo) throws BOSException, PermissionException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT OtherOwner.FID,OtherOwner.FPropertyName,OtherOwner.FISOTHEROWNER ").append(" FROM T_PM_OtherOwner OtherOwner ").append(" INNER JOIN T_PM_SpecialDataPerm SpecialDataPerm ").append(" ON SpecialDataPerm.FID = OtherOwner.FSpecialDataPermID ").append(" WHERE SpecialDataPerm.FID = ?");
        Object[] params = new Object[]{specialDataPermInfo.getId().toString()};
        OtherOwnerCollection col = specialDataPermInfo.getOtherOwners();
        if (col == null) {
            return;
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                OtherOwnerInfo otherOwnerinfo = new OtherOwnerInfo();
                otherOwnerinfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                otherOwnerinfo.setPropertyName(rowSet.getString("FPropertyName"));
                otherOwnerinfo.setIsOtherOwner(rowSet.getBoolean("FISOTHEROWNER"));
                otherOwnerinfo.setSpecialDataPerm(specialDataPermInfo);
                col.add(otherOwnerinfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
    }

    @Override
    public String getPermissionRule(IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            return " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
        }
        IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, null);
        if (permissionOrgPK == null) {
            DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
            return this.getNoRightRuleInfo(permItemName);
        }
        try {
            String rule = this.getRule(userPK, permissionOrgPK, permItemInfo);
            return rule;
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    private String getNoRightRuleInfo(String strKey) {
        return PermissionFilterConfiguration.getList().getFilterString(strKey);
    }

    @Override
    public String getQueryPermissionSQL(IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String rule = null;
        try {
            FunctionPermissionService funcService = new FunctionPermissionService(this.context);
            if (!funcService.hasPermission(userPK, orgPK, permItemName, true)) {
                rule = "SELECT id " + this.getNoRightRuleInfo(permItemName);
            } else if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
                if (logger.isDebugEnabled()) {
                    endTime = lowTimer.msValue();
                    logger.debug((Object)("getQueryPermissionSQL():  " + (endTime - beginTime)));
                }
                rule = "SELECT id  WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
            } else {
                IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, null);
                if (permissionOrgPK == null) {
                    DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
                    if (logger.isDebugEnabled()) {
                        endTime = lowTimer.msValue();
                        logger.debug((Object)("getQueryPermissionSQL():  " + (endTime - beginTime)));
                    }
                    return "SELECT '' AS \"ID\" WHERE 1 <> 1";
                }
                rule = this.getRule(userPK, permissionOrgPK, permItemInfo);
                if (logger.isDebugEnabled()) {
                    endTime = lowTimer.msValue();
                    logger.debug((Object)("getQueryPermissionSQL():  " + (endTime - beginTime)));
                }
                rule = StringUtils.isEmpty((String)rule) ? "SELECT id  WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )" : "SELECT id " + rule;
            }
            String sql = null;
            if (permItemInfo.getObjectType() == null) {
                logger.error((Object)("permItemInfo :" + permItemInfo.getAlias() + " has not binded entity"));
                throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL);
            }
            sql = ORMappingDAOUtils.getSQLByOQL((BOSObjectType)BOSObjectType.create((String)permItemInfo.getObjectType()), (String)rule, (Context)this.context);
            return sql;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    @Override
    public String getPermissionWhereSQL(IObjectPK userPK, IObjectPK orgPK, String permItemName, String idFieldAlias) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null && !StringUtils.isEmpty((String)idFieldAlias));
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionWhereSQL():  " + (endTime - beginTime)));
            }
            return "1 = 1";
        }
        IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, null);
        if (permissionOrgPK == null) {
            DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getQueryPermissionSQL():  " + (endTime - beginTime)));
            }
            return "1 <> 1";
        }
        try {
            String rule = this.getRule(userPK, permissionOrgPK, permItemInfo);
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionWhereSQL():  " + (endTime - beginTime)));
            }
            if (StringUtils.isEmpty((String)rule)) {
                if (logger.isDebugEnabled()) {
                    endTime = lowTimer.msValue();
                    logger.debug((Object)("getPermissionWhereSQL():  " + (endTime - beginTime)));
                }
                return "1 = 1";
            }
            rule = "SELECT id " + rule;
            String sql = ORMappingDAOUtils.getSQLByOQL((BOSObjectType)BOSObjectType.create((String)permItemInfo.getObjectType()), (String)rule, (Context)this.context);
            StringBuffer result = new StringBuffer(200);
            result.append(" ").append(idFieldAlias).append(" IN ( ").append(sql).append(" ) ");
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionWhereSQL():  " + (endTime - beginTime)));
            }
            return result.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    private String getSpecialDataPermRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        String cuID;
        SpecialDataPermInfo specialDataPermInfo;
        String specialRule = null;
        if (this.isSpecialEntity(permItemInfo.getObjectType()) && (specialDataPermInfo = this.getSpecialDataPermInfo(cuID = PermissionUtil.getControlUnitID(this.context, orgPK), permItemInfo)) != null) {
            SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
            specialRule = specialDataPermissionHandler.getSpecialDataPermissionRule(userPK, orgPK, specialDataPermInfo, permItemInfo);
        }
        return specialRule;
    }

    private String getRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        String rule;
        String commonRule = this.getDataRule(userPK, orgPK, permItemInfo);
        String specialRule = this.getSpecialDataPermRule(userPK, orgPK, permItemInfo);
        String bizPermitemlogic = null;
        if (!StringUtils.isEmpty((String)specialRule)) {
            bizPermitemlogic = this.getItemLogicPriority(orgPK, permItemInfo);
        }
        if ((rule = this.mergeCommonAndSpecialRule(commonRule, specialRule, bizPermitemlogic)) == null) {
            return rule;
        }
        EntityViewInfo oldViewInfo = new EntityViewInfo(rule);
        EntityViewInfo coopFieldViewInfo = new EntityViewInfo();
        coopFieldViewInfo.setFilter(this.getCoopFieldRule(orgPK, permItemInfo));
        EntityViewInfo resViewInfo = RuleUtil.mergeEntityViewInfo(oldViewInfo, coopFieldViewInfo, "OR");
        if (resViewInfo != null) {
            return resViewInfo.toString();
        }
        return null;
    }

    private String mergeCommonAndSpecialRule(String commonRule, String specialRule, String bizPermitemlogic) throws ParserException, BOSException, EASBizException {
        String logic = "OR";
        String globalParamLogic = ParamManager.getParamValue((Context)this.context, null, (String)"LogicOfCommonAndSpecialRule");
        globalParamLogic = StringUtils.isEmpty((String)globalParamLogic) || "1".equals(globalParamLogic) ? "OR" : "AND";
        logic = bizPermitemlogic == null || "DF".equalsIgnoreCase(bizPermitemlogic) ? globalParamLogic : bizPermitemlogic;
        return RuleUtil.mergeOQL(commonRule, specialRule, logic);
    }

    private String getItemLogicPriority(IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        String bizPermitemlogic = null;
        String cuID = PermissionUtil.getControlUnitID(this.context, orgPK);
        SpecialDataPermInfo specialDataPermInfo = this.getSpecialDataPermInfo(cuID, permItemInfo);
        if (specialDataPermInfo != null) {
            SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
            bizPermitemlogic = specialDataPermissionHandler.getSpecialDataPermEntry(specialDataPermInfo, permItemInfo).getLogicTag().getValue();
        }
        return bizPermitemlogic;
    }

    private FilterInfo getCoopFieldRule(IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException {
        String[] orgFieldStr = PermissionUtil.getBizOrgCoopPropertyName(this.context, BOSObjectType.create((String)permItemInfo.getObjectType()));
        String[] coopOrgIdList = CoopOrgHelper.appendPropID(orgFieldStr);
        ArrayList<IObjectPK> orgList = new ArrayList<IObjectPK>();
        orgList.add(orgPK);
        return CoopOrgHelper.getCoopOrgFilterInfo(coopOrgIdList, orgList);
    }

    @Override
    public void checkPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, Object bizData) throws EASBizException, BOSException {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        if (!this.hasPermission(userPK, orgPK, permItemName, bizData)) {
            String userName;
            PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
            UserInfo user = UserFactory.getLocalInstance(this.context).getUserByID(userPK);
            String string = userName = user != null ? user.getNumber() : "";
            if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
                Object[] object = new Object[]{userName, permItemInfo.getAlias()};
                PermissionException pe = new PermissionException(PermissionException.HAS_NOT_DATA_PERMISSION_2, object);
                logger.error((Object)"pe", (Throwable)((Object)pe));
                throw pe;
            }
            IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, bizData);
            if (permissionOrgPK == null) {
                Object[] object = new Object[]{userName, permItemInfo.getAlias()};
                PermissionException pe = new PermissionException(PermissionException.HAS_NOT_DATA_PERMISSION_2, object);
                logger.error((Object)"pe", (Throwable)((Object)pe));
                throw pe;
            }
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.context);
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(permissionOrgPK);
            Object[] object = new Object[]{userName, fullOrgUnitInfo.getName(), permItemInfo.getAlias()};
            PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_DATA_PERMISSION_2, object);
            logger.error((Object)"pe", (Throwable)((Object)pe));
            throw pe;
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("checkPermission():  " + (endTime - beginTime)));
        }
    }
}

