/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.multiorg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.service.multiorg.IMultiOrgCommonDataPermissionService;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgDataPermissionMap;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MultiOrgCommonDataPermissionService
implements IMultiOrgCommonDataPermissionService {
    private static Logger logger = Logger.getLogger(MultiOrgCommonDataPermissionService.class);
    private Context context = null;

    private MultiOrgCommonDataPermissionService(Context context) {
        this.context = context;
    }

    public static IMultiOrgCommonDataPermissionService getService(Context context) {
        return new MultiOrgCommonDataPermissionService(context);
    }

    @Override
    public MultiOrgDataPermissionMap getPermissionRule(IObjectPK userPK, Collection orgCollection, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        MultiOrgDataPermissionMap resultMap = new MultiOrgDataPermissionMap();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionRule():  " + (endTime - beginTime)));
            }
            return resultMap;
        }
        if (orgCollection == null || orgCollection.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)PermissionResUtil.getResource("res_11"));
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionRule():  " + (endTime - beginTime)));
            }
            return resultMap;
        }
        try {
            resultMap = this.handleCommonDataRule(userPK, orgCollection, permItemInfo);
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionRule():  " + (endTime - beginTime)));
            }
            return resultMap;
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    private MultiOrgDataPermissionMap handleCommonDataRule(IObjectPK userPK, Collection orgCollection, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        assert (userPK != null && orgCollection != null && permItemInfo != null);
        String userID = userPK.toString();
        String strOrgCol = ToolUtils.aryToStr(orgCollection);
        String permItemID = permItemInfo.getId().toString();
        MultiOrgDataPermissionMap resultMap = new MultiOrgDataPermissionMap();
        Object[] params = new Object[]{userID, permItemID, new Integer(10), userID, permItemID, new Integer(10)};
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FRuleExpr,UserOrgPerm.FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FOrgID IN (" + strOrgCol + ") ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ").append(" UNION ALL ").append(" SELECT RolePerm.FRuleExpr,UserRoleOrg.FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ");
        if (!OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" AND UserRoleOrg.FOrgID IN (" + strOrgCol + ") ");
        } else {
            sql.append(" AND UserRoleOrg.FOrgID IN ('11111111-1111-1111-1111-111111111111CCE7AED4') ");
        }
        sql.append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        try {
            HashSet<SimpleOrgPerm> retSet = new HashSet<SimpleOrgPerm>();
            while (rowSet.next()) {
                SimpleOrgPerm sop = new SimpleOrgPerm();
                sop.setOrgID(rowSet.getString("FOrgID"));
                sop.setRuleExpr(rowSet.getString("FRuleExpr"));
                retSet.add(sop);
            }
            for (SimpleOrgPerm sop : retSet) {
                String ruleExpr = sop.getRuleExpr();
                String orgID = sop.getOrgID();
                resultMap.addRule(orgID, ruleExpr);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return resultMap;
    }

    class SimpleOrgPerm {
        String ruleExpr = null;
        String orgID = null;

        SimpleOrgPerm() {
        }

        public String getRuleExpr() {
            return this.ruleExpr;
        }

        public void setRuleExpr(String ruleExpr) {
            this.ruleExpr = ruleExpr;
        }

        public String getOrgID() {
            return this.orgID;
        }

        public void setOrgID(String orgID) {
            this.orgID = orgID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SimpleOrgPerm)) {
                return false;
            }
            SimpleOrgPerm temp = (SimpleOrgPerm)obj;
            return StringUtils.cnulls((String)this.getOrgID()).equals(StringUtils.cnulls((String)temp.getOrgID())) && StringUtils.cnulls((String)this.getRuleExpr()).equals(StringUtils.cnulls((String)temp.getRuleExpr()));
        }

        public int hashCode() {
            return (StringUtils.cnulls((String)this.getOrgID()) + StringUtils.cnulls((String)this.getRuleExpr())).hashCode();
        }
    }
}

