/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.start.impl;

import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.IDCRegister;
import com.kingdee.eas.base.permission.app.start.IPermissionServiceStart;
import com.kingdee.eas.base.permission.app.start.PermissionServiceStartManager;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class UpgradeGlobalRomaingNCellStart
implements IPermissionServiceStart {
    private static Logger logger = Logger.getLogger(PermissionServiceStartManager.class);
    private static int MAX_RECORD_COUNT = 1000;
    private Set<String> globalRoamings = null;
    IDCRegister dcRegister;

    public UpgradeGlobalRomaingNCellStart(IDCRegister dcRegister) {
        this.dcRegister = dcRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call() throws Exception {
        ArrayList dcList = this.dcRegister.getDCList();
        if (dcList == null || dcList.size() < 0) {
            logger.error((Object)"\u6ca1\u6709\u8bfb\u53d6\u5230\u8d26\u5957\uff0c\u65e0\u6cd5\u5347\u7ea7\u56fd\u9645\u533a\u53f7\u7528\u6237\u624b\u673a\u53f7\u6570\u636e");
            return;
        }
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            String dataSourceAIS = ((DCInfo)it.next()).getNumber();
            Connection conn = null;
            try {
                conn = DbConnector.getConnection((String)dataSourceAIS);
                this.globalRoamings = this.getAllGloablRoaming(conn);
                this.upgradeAllGloablRoaming(conn);
                this.upgradeUserCellByConn(conn);
                this.upgradePersonCellByConn(conn);
                this.upgradePersonHisCellByConn(conn);
            }
            catch (Exception e) {
                logger.error((Object)("\u8d26\u5957" + dataSourceAIS + "\u56fd\u9645\u533a\u53f7\u624b\u673a\u53f7\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff01"), (Throwable)e);
                continue;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
                continue;
            }
            logger.error((Object)("\u8d26\u5957" + dataSourceAIS + "\u56fd\u9645\u533a\u53f7\u624b\u673a\u53f7\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff01"));
        }
    }

    private void upgradeAllGloablRoaming(Connection conn) throws Exception {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("update T_BD_GlobalRoaming set FAREACODE ='+'||FAREACODE where FAREACODE\u3000not LIKE '+%' ");
            stmt.execute();
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeUserCellByConn(Connection conn) throws Exception {
        PreparedStatement stmt = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT FID ,FCELL,FNCELL,FGLOBALROAMING FROM T_PM_USER");
            rs = stmt.executeQuery();
            preStmt = conn.prepareStatement("update T_PM_USER set FGLObalRoaming=?,FNCELL=? where fid = ?");
            int count = 0;
            while (rs.next()) {
                String id = rs.getString("FID");
                String cell = rs.getString("FCELL");
                String ncell = rs.getString("FNCELL");
                String fGLObalRoaming = rs.getString("FGLOBALROAMING");
                if (StringUtils.isEmpty((String)ncell) && !StringUtils.isEmpty((String)cell)) {
                    String[] globalMap = ToolUtils.getGLObalMapCell(cell);
                    String global = globalMap[0];
                    String newNcell = globalMap[1];
                    if (StringUtils.isEmpty((String)global) || StringUtils.isEmpty((String)newNcell) || !this.globalRoamings.contains(global)) continue;
                    preStmt.setString(1, global);
                    preStmt.setString(2, newNcell);
                    preStmt.setString(3, id);
                    preStmt.addBatch();
                    ++count;
                    continue;
                }
                if (StringUtils.isEmpty((String)ncell)) continue;
                if (StringUtils.isEmpty((String)fGLObalRoaming)) {
                    preStmt.setString(1, "+86");
                    preStmt.setString(2, ncell);
                    preStmt.setString(3, id);
                    preStmt.addBatch();
                    ++count;
                } else if (!fGLObalRoaming.startsWith("+") && this.globalRoamings.contains("+" + fGLObalRoaming)) {
                    preStmt.setString(1, "+" + fGLObalRoaming);
                    preStmt.setString(2, ncell);
                    preStmt.setString(3, id);
                    preStmt.addBatch();
                    ++count;
                }
                if (count <= MAX_RECORD_COUNT) continue;
                preStmt.executeBatch();
                preStmt.clearBatch();
                count = 0;
            }
            if (count > 0) {
                preStmt.executeBatch();
                preStmt.clearBatch();
                count = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            SQLUtils.cleanup(preStmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Statement)preStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePersonCellByConn(Connection conn) throws Exception {
        PreparedStatement stmt = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT FID,FCELL,FNCELL,FGLOBALROAMING  FROM T_BD_PERSON");
            rs = stmt.executeQuery();
            preStmt = conn.prepareStatement("update T_BD_PERSON set FGLObalRoaming=?,FNCELL=? where fid = ?");
            int count = 0;
            while (rs.next()) {
                String id = rs.getString("FID");
                String cell = rs.getString("FCELL");
                String ncell = rs.getString("FNCELL");
                String fGLObalRoaming = rs.getString("FGLOBALROAMING");
                if (StringUtils.isEmpty((String)ncell) && !StringUtils.isEmpty((String)cell)) {
                    String[] globalMap = ToolUtils.getGLObalMapCell(cell);
                    String global = globalMap[0];
                    String newNcell = globalMap[1];
                    if (!StringUtils.isEmpty((String)global) && !StringUtils.isEmpty((String)newNcell) && this.globalRoamings.contains(global)) {
                        preStmt.setString(1, global);
                        preStmt.setString(2, newNcell);
                        preStmt.setString(3, id);
                        preStmt.addBatch();
                        ++count;
                    }
                } else if (!StringUtils.isEmpty((String)ncell)) {
                    if (StringUtils.isEmpty((String)fGLObalRoaming)) {
                        preStmt.setString(1, "+86");
                        preStmt.setString(2, ncell);
                        preStmt.setString(3, id);
                        preStmt.addBatch();
                        ++count;
                    } else if (!fGLObalRoaming.startsWith("+") && this.globalRoamings.contains("+" + fGLObalRoaming)) {
                        preStmt.setString(1, "+" + fGLObalRoaming);
                        preStmt.setString(2, ncell);
                        preStmt.setString(3, id);
                        preStmt.addBatch();
                        ++count;
                    }
                }
                if (count <= MAX_RECORD_COUNT) continue;
                preStmt.executeBatch();
                preStmt.clearBatch();
                count = 0;
            }
            if (count > 0) {
                preStmt.executeBatch();
                preStmt.clearBatch();
                count = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            SQLUtils.cleanup(preStmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Statement)preStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePersonHisCellByConn(Connection conn) throws Exception {
        PreparedStatement stmt = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT FID,FCELL,FNCELL,FGLOBALROAMING  FROM T_BD_PERSONHIS");
            rs = stmt.executeQuery();
            preStmt = conn.prepareStatement("update T_BD_PERSONHIS set FGLObalRoaming=?,FNCELL=? where fid = ?");
            int count = 0;
            while (rs.next()) {
                String id = rs.getString("FID");
                String cell = rs.getString("FCELL");
                String ncell = rs.getString("FNCELL");
                String fGLObalRoaming = rs.getString("FGLOBALROAMING");
                if (StringUtils.isEmpty((String)ncell) && !StringUtils.isEmpty((String)cell)) {
                    String[] globalMap = ToolUtils.getGLObalMapCell(cell);
                    String global = globalMap[0];
                    String newNcell = globalMap[1];
                    if (!StringUtils.isEmpty((String)global) && !StringUtils.isEmpty((String)newNcell) && this.globalRoamings.contains(global)) {
                        preStmt.setString(1, global);
                        preStmt.setString(2, newNcell);
                        preStmt.setString(3, id);
                        preStmt.addBatch();
                        ++count;
                    }
                } else if (!StringUtils.isEmpty((String)ncell)) {
                    if (StringUtils.isEmpty((String)fGLObalRoaming)) {
                        preStmt.setString(1, "+86");
                        preStmt.setString(2, ncell);
                        preStmt.setString(3, id);
                        preStmt.addBatch();
                        ++count;
                    } else if (!fGLObalRoaming.startsWith("+") && this.globalRoamings.contains("+" + fGLObalRoaming)) {
                        preStmt.setString(1, "+" + fGLObalRoaming);
                        preStmt.setString(2, ncell);
                        preStmt.setString(3, id);
                        preStmt.addBatch();
                        ++count;
                    }
                }
                if (count <= MAX_RECORD_COUNT) continue;
                preStmt.executeBatch();
                preStmt.clearBatch();
                count = 0;
            }
            if (count > 0) {
                preStmt.executeBatch();
                preStmt.clearBatch();
                count = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            SQLUtils.cleanup(preStmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Statement)preStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAllGloablRoaming(Connection conn) throws SQLException {
        HashSet<String> gloablRomaings = new HashSet<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT FAREACODE FROM T_BD_GlobalRoaming");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String areacode = rs.getString("FAREACODE");
                if (StringUtils.isEmpty((String)areacode)) continue;
                gloablRomaings.add(areacode);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return gloablRomaings;
    }
}

