/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.app.util.interior.IUserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper4User;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicGroupDiffInfo;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class UserLicenseGroupHelper
implements IUserLicenseGroupHelper {
    private static Logger logger = Logger.getLogger((String)UserLicenseGroupHelper.class.getName());
    Context ctx;
    UserLicenseGroupsInfo userLicenseGroups;
    Map<String, UserLicenseGroupHelper4User> mpUsersLicenseGroupHelp;
    private String ADD_PARAMS = "ADD_PARAMS";
    private String DEL_PARAMS = "DEL_PARAMS";
    private String UPD_PARAMS = "UPD_PARAMS";
    private String DIF_PARAMS = "DIF_PARAMS";

    public UserLicenseGroupHelper(Context ctx) {
        this.ctx = ctx;
        this.init();
    }

    public UserLicenseGroupHelper(Context ctx, UserLicenseGroupsInfo userLicenseGroups) {
        this.ctx = ctx;
        this.userLicenseGroups = userLicenseGroups;
        this.init();
        this.mpUsersLicenseGroupHelp.put(userLicenseGroups.getFuserId(), new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups));
    }

    public UserLicenseGroupHelper(Context ctx, String userId) {
        this.ctx = ctx;
        this.init();
        this.mpUsersLicenseGroupHelp.put(userId, new UserLicenseGroupHelper4User(ctx, userId));
    }

    public UserLicenseGroupHelper(Context ctx, UserLicenseGroupHelper4User ulgh4user) {
        this.ctx = ctx;
        this.init();
        this.mpUsersLicenseGroupHelp.put(ulgh4user.getUserId(), ulgh4user);
    }

    private void init() {
        this.mpUsersLicenseGroupHelp = new ConcurrentHashMap<String, UserLicenseGroupHelper4User>();
    }

    public UserLicenseGroupsInfo getUserLicenseGroups() {
        return this.userLicenseGroups;
    }

    public void setUserLicenseGroups(UserLicenseGroupsInfo userLicenseGroups) {
        this.userLicenseGroups = userLicenseGroups;
    }

    public void addUserLicenseGroupHelper4User(UserLicenseGroupHelper4User ulgh4user) {
        this.mpUsersLicenseGroupHelp.put(ulgh4user.getUserId(), ulgh4user);
    }

    public void addAddUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (userLicGroupInfo == null || userLicGroupInfo.getUser() == null || userLicGroupInfo.getUser().getId() == null) {
            return;
        }
        String userId = userLicGroupInfo.getUser().getId().toString();
        UserLicenseGroupHelper4User userLicGHU = this.mpUsersLicenseGroupHelp.get(userId);
        if (userLicGHU == null) {
            userLicGHU = new UserLicenseGroupHelper4User(this.ctx, userLicGroupInfo.getUser());
            this.mpUsersLicenseGroupHelp.put(userId, userLicGHU);
        }
        userLicGHU.addAddUserLicenseGroupInfo(userLicGroupInfo);
    }

    public void addDelUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (userLicGroupInfo == null || userLicGroupInfo.getUser() == null || userLicGroupInfo.getUser().getId() == null) {
            return;
        }
        String userId = userLicGroupInfo.getUser().getId().toString();
        UserLicenseGroupHelper4User userLicGHU = this.mpUsersLicenseGroupHelp.get(userId);
        if (userLicGHU == null) {
            userLicGHU = new UserLicenseGroupHelper4User(this.ctx, userLicGroupInfo.getUser());
            this.mpUsersLicenseGroupHelp.put(userId, userLicGHU);
        }
        userLicGHU.addDelUserLicenseGroupInfo(userLicGroupInfo);
    }

    public void addUpdUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (userLicGroupInfo == null || userLicGroupInfo.getUser() == null || userLicGroupInfo.getUser().getId() == null) {
            return;
        }
        String userId = userLicGroupInfo.getUser().getId().toString();
        UserLicenseGroupHelper4User userLicGHU = this.mpUsersLicenseGroupHelp.get(userId);
        if (userLicGHU == null) {
            userLicGHU = new UserLicenseGroupHelper4User(this.ctx, userLicGroupInfo.getUser());
            this.mpUsersLicenseGroupHelp.put(userId, userLicGHU);
        }
        userLicGHU.addUpdUserLicenseGroupInfo(userLicGroupInfo);
    }

    @Override
    public boolean exec() throws BOSException, EASBizException {
        Map mpParams = this.getParamsMp();
        try {
            this.delUserLicGroup((List)mpParams.get(this.DEL_PARAMS));
            this.insUserLicGroup((List)mpParams.get(this.ADD_PARAMS));
            this.updUserLicGroup((List)mpParams.get(this.UPD_PARAMS));
            this.updUserLicGroupDif((List)mpParams.get(this.DIF_PARAMS));
        }
        catch (BOSException e) {
            logger.error((Object)("UserLicenseGroupHelper.exec error:" + (Object)((Object)e)));
            throw new BOSException((Throwable)e);
        }
        this.log();
        return true;
    }

    private void log() {
        for (UserLicenseGroupHelper4User userLicGHU : this.mpUsersLicenseGroupHelp.values()) {
            userLicGHU.log();
        }
    }

    private void insUserLicGroup(List<UserLicenseGroupInfoEx> licenseGroupInfos) throws BOSException, EASBizException {
        String sql = "insert into T_PM_UserLicenseGroup(FuserId,FGroupNumber,FSynUser,fid,FIsActive,fname_l1,fname_l2,fname_l3)  values(  ?,     ?,            ?,     ?,    ?       , ?     ,  ?     ,  ?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        HashMap<String, Integer> mpGroupNumberNums = new HashMap<String, Integer>();
        int size = licenseGroupInfos.size();
        for (int i = 0; i < size; ++i) {
            UserLicenseGroupInfoEx ulgiEx = licenseGroupInfos.get(i);
            if (ulgiEx.getInsertParams() == null) continue;
            paramsList.add(ulgiEx.getInsertParams());
            if (!ulgiEx.isIsActive()) continue;
            if (mpGroupNumberNums.get(ulgiEx.getGroupNumber()) == null) {
                mpGroupNumberNums.put(ulgiEx.getGroupNumber(), 1);
                continue;
            }
            int m = (Integer)mpGroupNumberNums.get(ulgiEx.getGroupNumber());
            mpGroupNumberNums.put(ulgiEx.getGroupNumber(), m + 1);
        }
        if (paramsList.size() == 0) {
            return;
        }
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        for (String groupNumber : mpGroupNumberNums.keySet()) {
            int nums = (Integer)mpGroupNumberNums.get(groupNumber);
            if (LicenseUseSrvFactory.getLocalInstance(this.ctx).assignUsersGroup(this.ctx, groupNumber, nums)) continue;
            throw new BOSException();
        }
    }

    private void updUserLicGroup(List<UserLicenseGroupInfoEx> licenseGroupInfos) throws BOSException, EASBizException {
        int num;
        if (licenseGroupInfos == null || 0 == licenseGroupInfos.size()) {
            return;
        }
        String sql = "update T_PM_UserLicenseGroup set FuserId=?,FGroupNumber=?,FSynUser=?,FIsActive=? where fid=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        HashMap<String, Integer> activeGroupNumMap = new HashMap<String, Integer>();
        HashMap<String, Integer> unActiveGroupNumMap = new HashMap<String, Integer>();
        int size = licenseGroupInfos.size();
        for (int i = 0; i < size; ++i) {
            UserLicenseGroupInfoEx ulgiEx = licenseGroupInfos.get(i);
            if (ulgiEx.getUpdateParams() == null) continue;
            if (ulgiEx.isIsActive()) {
                if (activeGroupNumMap.get(ulgiEx.getGroupNumber()) == null) {
                    activeGroupNumMap.put(ulgiEx.getGroupNumber(), 1);
                } else {
                    num = (Integer)activeGroupNumMap.get(ulgiEx.getGroupNumber());
                    activeGroupNumMap.put(ulgiEx.getGroupNumber(), num + 1);
                }
            } else if (!ulgiEx.isIsActive() && !ulgiEx.getUser().isIsForbidden()) {
                if (unActiveGroupNumMap.get(ulgiEx.getGroupNumber()) == null) {
                    unActiveGroupNumMap.put(ulgiEx.getGroupNumber(), 1);
                } else {
                    num = (Integer)unActiveGroupNumMap.get(ulgiEx.getGroupNumber());
                    unActiveGroupNumMap.put(ulgiEx.getGroupNumber(), num + 1);
                }
            }
            paramsList.add(ulgiEx.getUpdateParams());
        }
        if (paramsList.size() == 0) {
            return;
        }
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        for (Map.Entry activeGroupNumEntry : activeGroupNumMap.entrySet()) {
            String groupNum = (String)activeGroupNumEntry.getKey();
            num = (Integer)activeGroupNumEntry.getValue();
            if (LicenseUseSrvFactory.getLocalInstance(this.ctx).assignUsersGroup(this.ctx, groupNum, num)) continue;
            throw new BOSException();
        }
        for (Map.Entry activeGroupNumEntry : unActiveGroupNumMap.entrySet()) {
            String groupNum = (String)activeGroupNumEntry.getKey();
            int num2 = (Integer)activeGroupNumEntry.getValue();
            if (LicenseUseSrvFactory.getLocalInstance(this.ctx).disAssignUsersGroup(this.ctx, groupNum, num2)) continue;
            throw new BOSException();
        }
    }

    private void delUserLicGroup(List<UserLicenseGroupInfoEx> licenseGroupInfos) throws BOSException, EASBizException {
        String sql = "delete from T_PM_UserLicenseGroup where FId=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        HashMap<String, Integer> mpGroupNumberNums = new HashMap<String, Integer>();
        int size = licenseGroupInfos.size();
        for (int i = 0; i < size; ++i) {
            UserLicenseGroupInfoEx ulgiEx = licenseGroupInfos.get(i);
            if (ulgiEx.getDeleteParams() == null) continue;
            paramsList.add(ulgiEx.getDeleteParams());
            if (!ulgiEx.isIsActive() || ulgiEx.getUserLicenseGroupInfo().getUser().isIsForbidden()) continue;
            if (mpGroupNumberNums.get(ulgiEx.getGroupNumber()) == null) {
                mpGroupNumberNums.put(ulgiEx.getGroupNumber(), 1);
                continue;
            }
            int m = (Integer)mpGroupNumberNums.get(ulgiEx.getGroupNumber());
            mpGroupNumberNums.put(ulgiEx.getGroupNumber(), m + 1);
        }
        if (paramsList.size() == 0) {
            return;
        }
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        for (String groupNumber : mpGroupNumberNums.keySet()) {
            int nums = (Integer)mpGroupNumberNums.get(groupNumber);
            if (LicenseUseSrvFactory.getLocalInstance(this.ctx).disAssignUsersGroup(this.ctx, groupNumber, nums)) continue;
            throw new BOSException();
        }
    }

    private void updUserLicGroupDif(List<UserLicGroupDiffInfo> licenseGroupDifInfos) throws BOSException {
    }

    private Map getParamsMp() {
        HashMap mpParams = new HashMap();
        ArrayList<UserLicenseGroupInfoEx> addParamsList = new ArrayList<UserLicenseGroupInfoEx>();
        ArrayList<UserLicenseGroupInfoEx> delParamsList = new ArrayList<UserLicenseGroupInfoEx>();
        ArrayList<UserLicenseGroupInfoEx> updParamsList = new ArrayList<UserLicenseGroupInfoEx>();
        ArrayList<UserLicGroupDiffInfo> difParamsList = new ArrayList<UserLicGroupDiffInfo>();
        for (UserLicenseGroupHelper4User userLicGHU : this.mpUsersLicenseGroupHelp.values()) {
            UserLicGroupDiffInfo userLicGroupDiffInfo;
            UserLicenseGroupsInfo updLicenseGroups;
            UserLicenseGroupsInfo delLicenseGroups;
            UserLicenseGroupsInfo addLicenseGroups = userLicGHU.getAddLicenseGroups();
            if (addLicenseGroups != null && addLicenseGroups.getLsLicGroups() != null) {
                List<UserLicenseGroupInfoEx> licenseGroupInfos = addLicenseGroups.getLsLicGroups();
                addParamsList.addAll(licenseGroupInfos);
            }
            if ((delLicenseGroups = userLicGHU.getDelLicenseGroups()) != null && delLicenseGroups.getLsLicGroups() != null) {
                List<UserLicenseGroupInfoEx> licenseGroupInfos = delLicenseGroups.getLsLicGroups();
                delParamsList.addAll(licenseGroupInfos);
            }
            if ((updLicenseGroups = userLicGHU.getUpdLicenseGroups()) != null && updLicenseGroups.getLsLicGroups() != null) {
                List<UserLicenseGroupInfoEx> licenseGroupInfos = updLicenseGroups.getLsLicGroups();
                updParamsList.addAll(licenseGroupInfos);
            }
            if ((userLicGroupDiffInfo = userLicGHU.getUserLicGroupDiffInfo()) == null) continue;
            difParamsList.add(userLicGroupDiffInfo);
        }
        mpParams.put(this.ADD_PARAMS, addParamsList);
        mpParams.put(this.DEL_PARAMS, delParamsList);
        mpParams.put(this.UPD_PARAMS, updParamsList);
        mpParams.put(this.DIF_PARAMS, difParamsList);
        return mpParams;
    }
}

