/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserLogUtil;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicGroupDiffInfo;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserLicenseGroupHelper4User {
    private static Logger logger = Logger.getLogger((String)UserLicenseGroupHelper4User.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    Context ctx;
    UserInfo user;
    UserLicenseGroupsInfo userLicenseGroups;
    UserLicenseGroupsInfo addLicenseGroups;
    UserLicenseGroupsInfo delLicenseGroups;
    UserLicenseGroupsInfo updLicenseGroups;
    UserLicGroupDiffInfo userLicGroupDiffInfo;
    String userId;

    public UserLicenseGroupHelper4User(Context ctx, String userId) {
        this.ctx = ctx;
        try {
            this.user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.user = new UserInfo(userId);
        }
        this.userLicenseGroups = UserLicenseGroupTool.getUserLicenseGroups(ctx, this.user);
        this.userLicGroupDiffInfo = new UserLicGroupDiffInfo(this.user, this.userLicenseGroups.getLsLicGroups());
        this.userId = userId;
    }

    public UserLicenseGroupHelper4User(Context ctx, UserInfo user) {
        this(ctx, user, UserLicenseGroupTool.getUserLicenseGroups(ctx, user));
    }

    public UserLicenseGroupHelper4User(Context ctx, UserInfo user, UserLicenseGroupsInfo userLicenseGroups) {
        this.ctx = ctx;
        this.user = user;
        this.userId = user.getId().toString();
        this.userLicenseGroups = userLicenseGroups;
        this.userLicGroupDiffInfo = new UserLicGroupDiffInfo(user);
        this.userLicGroupDiffInfo.setLsLicGroups(userLicenseGroups.getLsLicGroups());
    }

    public String getUserId() {
        return this.userId;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public void setUser(UserInfo user) {
        this.user = user;
    }

    public UserLicenseGroupsInfo getUserLicenseGroups() {
        return this.userLicenseGroups;
    }

    public void setUserLicenseGroups(UserLicenseGroupsInfo userLicenseGroups) {
        this.userLicenseGroups = userLicenseGroups;
    }

    public UserLicenseGroupsInfo getAddLicenseGroups() {
        return this.addLicenseGroups;
    }

    public void setAddLicenseGroups(UserLicenseGroupsInfo addLicenseGroups) {
        this.addLicenseGroups = addLicenseGroups;
    }

    public UserLicenseGroupsInfo getDelLicenseGroups() {
        return this.delLicenseGroups;
    }

    public void setDelLicenseGroups(UserLicenseGroupsInfo delLicenseGroups) {
        this.delLicenseGroups = delLicenseGroups;
    }

    public UserLicenseGroupsInfo getUpdLicenseGroups() {
        return this.updLicenseGroups;
    }

    public void setUpdLicenseGroups(UserLicenseGroupsInfo updLicenseGroups) {
        this.updLicenseGroups = updLicenseGroups;
    }

    public UserLicGroupDiffInfo getUserLicGroupDiffInfo() {
        return this.userLicGroupDiffInfo;
    }

    public void setUserLicGroupDiffInfo(UserLicGroupDiffInfo userLicGroupDiffInfo) {
        this.userLicGroupDiffInfo = userLicGroupDiffInfo;
    }

    public void addAddUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (this.addLicenseGroups == null) {
            this.addLicenseGroups = new UserLicenseGroupsInfo(this.user);
        }
        userLicGroupInfo.setSynUser(SynStateEnum.SYN_NO);
        userLicGroupInfo.setUser(this.user);
        this.addLicenseGroups.addLicGroups(userLicGroupInfo);
        this.userLicGroupDiffInfo.addLicGroups(userLicGroupInfo);
    }

    public void addDelUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (this.delLicenseGroups == null) {
            this.delLicenseGroups = new UserLicenseGroupsInfo(this.user);
        }
        userLicGroupInfo.setSynUser(SynStateEnum.SYN_NO);
        userLicGroupInfo.setUser(this.user);
        this.delLicenseGroups.addLicGroups(userLicGroupInfo);
        this.userLicGroupDiffInfo.removeLicGroups(userLicGroupInfo.getGroupNumber());
    }

    public void addUpdUserLicenseGroupInfo(UserLicenseGroupInfoEx userLicGroupInfo) {
        if (this.updLicenseGroups == null) {
            this.updLicenseGroups = new UserLicenseGroupsInfo(this.user);
        }
        userLicGroupInfo.setSynUser(SynStateEnum.SYN_NO);
        userLicGroupInfo.setUser(this.user);
        this.updLicenseGroups.removeLicGroups(userLicGroupInfo.getGroupNumber());
        this.updLicenseGroups.addLicGroups(userLicGroupInfo);
        this.userLicenseGroups.removeLicGroups(userLicGroupInfo.getGroupNumber());
        this.userLicenseGroups.addLicGroups(userLicGroupInfo);
    }

    public void log() {
        this.logAddLicenseGroup();
        this.logDelLicenseGroup();
        this.logUpdLicenseGroup();
    }

    private void logAddLicenseGroup() {
        if (this.addLicenseGroups == null || this.addLicenseGroups.getLsLicGroups() == null) {
            return;
        }
        Map<String, String> validLicGroup = null;
        try {
            validLicGroup = UserLicenseGroupTool.getValidLicenseMapWithoutFunc(this.ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)("UserLicenseGroupHelper4User-logAddLicenseGroup.UserLicenseGroupTool.getValidLicenseMapWithoutFunc" + (Object)((Object)e)));
        }
        List<UserLicenseGroupInfoEx> addgroups = this.addLicenseGroups.getLsLicGroups();
        for (UserLicenseGroupInfoEx groupex : addgroups) {
            if (!validLicGroup.containsKey(groupex.getGroupNumber())) continue;
            if (groupex.isIsActive()) {
                UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l1")) + ": " + groupex.getGroupNumber() + " " + EASResource.getString((String)RESOURCE, (String)"active", (Locale)new Locale("l1")), EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l2")) + ": " + groupex.getGroupNumber() + " " + EASResource.getString((String)RESOURCE, (String)"active", (Locale)new Locale("l2")), EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l3")) + ": " + groupex.getGroupNumber() + " " + EASResource.getString((String)RESOURCE, (String)"active", (Locale)new Locale("l3")));
                continue;
            }
            UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l1")) + ": " + groupex.getGroupNumber() + " " + EASResource.getString((String)RESOURCE, (String)"unActive", (Locale)new Locale("l1")), EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l2")) + ": " + groupex.getGroupNumber() + " " + EASResource.getString((String)RESOURCE, (String)"unActive", (Locale)new Locale("l2")), EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l3")) + ": " + groupex.getGroupNumber() + " " + EASResource.getString((String)RESOURCE, (String)"unActive", (Locale)new Locale("l3")));
        }
    }

    private void logDelLicenseGroup() {
        if (this.delLicenseGroups == null || this.delLicenseGroups.getLsLicGroups() == null) {
            return;
        }
        List<UserLicenseGroupInfoEx> delgroups = this.delLicenseGroups.getLsLicGroups();
        Map<Object, Object> validLicGroupMap = new HashMap();
        try {
            validLicGroupMap = UserLicenseGroupTool.getValidLicenseMapWithoutFunc(this.ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)"UserLicenseGroupHelper4User.logDelLicenseGroup.UserLicenseGroupTool.getValidLicenseMapWithoutFunc exception:", (Throwable)e);
        }
        for (UserLicenseGroupInfoEx groupex : delgroups) {
            if (!validLicGroupMap.containsKey(groupex.getGroupNumber())) continue;
            if (groupex.isIsActive()) {
                UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"deleteActiveGroup", (Locale)new Locale("l1")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"deleteActiveGroup", (Locale)new Locale("l2")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"deleteActiveGroup", (Locale)new Locale("l3")) + ": " + groupex.getGroupNumber());
                continue;
            }
            UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"deleteUnActiveGroup", (Locale)new Locale("l1")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"deleteUnActiveGroup", (Locale)new Locale("l2")) + ": " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"deleteUnActiveGroup", (Locale)new Locale("l3")) + ": " + groupex.getGroupNumber());
        }
    }

    private void logUpdLicenseGroup() {
        if (this.updLicenseGroups == null || this.updLicenseGroups.getLsLicGroups() == null) {
            return;
        }
        List<UserLicenseGroupInfoEx> updgroups = this.updLicenseGroups.getLsLicGroups();
        for (UserLicenseGroupInfoEx groupex : updgroups) {
            if (groupex.isIsActive()) {
                UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l1")) + " " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l2")) + " " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l3")) + " " + groupex.getGroupNumber());
                continue;
            }
            UserLogUtil.log(this.ctx, groupex.getUser().getId().toString(), EASResource.getString((String)RESOURCE, (String)"unActiveGroup", (Locale)new Locale("l1")) + " " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"unActiveGroup", (Locale)new Locale("l2")) + " " + groupex.getGroupNumber(), EASResource.getString((String)RESOURCE, (String)"unActiveGroup", (Locale)new Locale("l3")) + " " + groupex.getGroupNumber());
        }
    }
}

