/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior.permgroup;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.ActiveStateEnum;
import com.kingdee.eas.base.permission.app.util.UserLogUtil;
import com.kingdee.eas.base.permission.app.util.interior.ILicenseUseSrv;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupLogInfo;
import com.kingdee.eas.base.permission.app.util.interior.permgroup.AbstractUserPermChangeListener;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserPermChangeListener
extends AbstractUserPermChangeListener {
    private Map<String, String> moduleAliasMap;
    private static String querySql = "select fgroupnumber,fisactive from t_pm_userlicensegroup where fuserid=?";
    private static String delSql = "delete from T_PM_userlicensegroup where fgroupnumber=? and fuserid=?";
    private static String addSql = "insert into t_pm_userlicensegroup(fuserid,fgroupnumber,fsynuser,fid,fisactive,fname_l2) values(?,?,?,?,?,?)";
    private static String updateSql = "update T_PM_userlicensegroup set fisactive = ? whre fgroupnumber=? and fuserid=?";
    private static String updateSyncStatus = "UPDATE T_PM_USER SET FISSYNTOCLOUD = 0 WHERE FID = ?";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    ILicenseUseSrv licenseUserSrv;

    public UserPermChangeListener(Context ctx, List<String> userIds, String changeOpt) {
        super(ctx, userIds, changeOpt);
        this.moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(this.ctx);
        this.licenseUserSrv = null;
    }

    public UserPermChangeListener(Context ctx, Set<String> userIds, String changeOpt) {
        super(ctx, new ArrayList<String>(userIds), changeOpt);
        this.moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(this.ctx);
        this.licenseUserSrv = null;
    }

    public UserPermChangeListener(Context ctx, String userId, String changeOpt) {
        super(ctx, userId, changeOpt);
        this.moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(this.ctx);
        this.licenseUserSrv = null;
    }

    @Override
    protected void dealGroupsChange() throws BOSException, EASBizException {
        this.licenseUserSrv = LicenseUseSrvFactory.getLocalInstance(this.ctx);
        for (String userId : this.userIds) {
            Set beforeGroups = (Set)this.beforeUserGroups.get(userId);
            Set afterGroups = (Set)this.afterUserGroups.get(userId);
            this.dealChange(userId, beforeGroups, afterGroups);
        }
    }

    public void dealChange(String userId, Set<String> beforeGroups, Set<String> afterGroups) throws BOSException, EASBizException {
        Map<String, ActiveStateEnum> userGroups = this.getUserGroups(userId);
        HashMap<String, ActiveStateEnum> groupsChangeLog = new HashMap<String, ActiveStateEnum>();
        HashSet<String> removeGroups = new HashSet<String>(beforeGroups);
        removeGroups.removeAll(afterGroups);
        for (String groupNumber : removeGroups) {
            ActiveStateEnum isActive = userGroups.get(groupNumber);
            if (isActive == null) continue;
            DbUtil.execute((Context)this.ctx, (String)delSql, (Object[])new Object[]{groupNumber, userId});
            if (isActive != ActiveStateEnum.Active_YES) continue;
            this.licenseUserSrv.disAssignUsersGroup(this.ctx, groupNumber, 1);
            groupsChangeLog.put(groupNumber, ActiveStateEnum.Active_NO);
        }
        HashSet<String> addGroups = new HashSet<String>(afterGroups);
        addGroups.removeAll(beforeGroups);
        for (String groupNumber : addGroups) {
            boolean isAssign;
            String groupName = this.moduleAliasMap.get(groupNumber) != null ? this.moduleAliasMap.get(groupNumber).toString() : "";
            ActiveStateEnum isActive = userGroups.get(groupNumber);
            if (isActive == null) {
                isAssign = false;
                if (this.licenseUserSrv.getGroupRemainNum(this.ctx, groupNumber) > 0) {
                    this.licenseUserSrv.assignUsersGroup(this.ctx, groupNumber, 1);
                    isAssign = true;
                }
                DbUtil.execute((Context)this.ctx, (String)addSql, (Object[])new Object[]{userId, groupNumber, 0, BOSUuid.create((String)"94716EDD").toString(), isAssign, groupName});
                groupsChangeLog.put(groupNumber, ActiveStateEnum.Active_YES);
                continue;
            }
            isAssign = false;
            if (isActive != ActiveStateEnum.Active_NO) continue;
            if (this.licenseUserSrv.getGroupRemainNum(this.ctx, groupNumber) > 0) {
                this.licenseUserSrv.assignUsersGroup(this.ctx, groupNumber, 1);
                isAssign = true;
            }
            DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])new Object[]{userId, groupNumber, 0, BOSUuid.create((String)"94716EDD").toString(), isAssign, groupName});
            groupsChangeLog.put(groupNumber, ActiveStateEnum.Active_YES);
        }
        if (!groupsChangeLog.isEmpty()) {
            this.log(userId, groupsChangeLog);
        }
    }

    private Map<String, ActiveStateEnum> getUserGroups(String userId) throws BOSException {
        HashMap<String, ActiveStateEnum> userGroups = new HashMap<String, ActiveStateEnum>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)querySql, (Object[])new Object[]{userId});
            while (rs.next()) {
                String groupNumber = rs.getString("fgroupnumber");
                ActiveStateEnum isActive = ActiveStateEnum.getEnum(rs.getInt("fisactive"));
                userGroups.put(groupNumber, isActive);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return userGroups;
    }

    private void log(String userId, Map<String, ActiveStateEnum> groupChanges) {
        UserLicenseGroupLogInfo userLicenseGroupLogInfo = new UserLicenseGroupLogInfo();
        userLicenseGroupLogInfo.setCtx(this.ctx);
        userLicenseGroupLogInfo.setFChangeDate(this.getTime());
        userLicenseGroupLogInfo.setFChangeUserId(this.ctx.getCaller().toString());
        userLicenseGroupLogInfo.setFUserId(userId);
        HashSet<String> addGroups = new HashSet<String>();
        HashSet<String> delGroups = new HashSet<String>();
        for (String groupNumber : groupChanges.keySet()) {
            ActiveStateEnum activeStateEnum = groupChanges.get(groupNumber);
            if (activeStateEnum == ActiveStateEnum.Active_YES) {
                addGroups.add(groupNumber);
                continue;
            }
            delGroups.add(groupNumber);
        }
        StringBuilder changeContent = new StringBuilder();
        if (!addGroups.isEmpty()) {
            changeContent.append(EASResource.getString((String)RESOURCE, (String)"ADD_GROUP") + "\uff1a" + ToolUtils.aryToStr(addGroups));
        }
        if (!delGroups.isEmpty()) {
            if (changeContent.length() > 0) {
                changeContent.append(";");
            }
            changeContent.append(EASResource.getString((String)RESOURCE, (String)"CANCEL_GROUP") + "\uff1a" + ToolUtils.aryToStr(delGroups));
        }
        changeContent.append("(" + this.changeOpt + ")");
        userLicenseGroupLogInfo.setFContent_l1(changeContent.toString());
        userLicenseGroupLogInfo.setFContent_l2(changeContent.toString());
        userLicenseGroupLogInfo.setFContent_l3(changeContent.toString());
        UserLogUtil.writeLog(this.ctx, userLicenseGroupLogInfo);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

