/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.card;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.eas.base.permission.DynamicCardStateEnum;
import com.kingdee.eas.base.permission.DynamicCardUserFactory;
import com.kingdee.eas.base.permission.DynamicCardUserInfo;
import com.kingdee.eas.base.permission.IDynamicCardUser;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.card.DynamicCardProxy;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DynamicCardHelper {
    private static Logger logger = Logger.getLogger(DynamicCardHelper.class);

    public static boolean useDynamicCard(UserContextCallback userCtxCallback, String userNumber, String password) throws Exception {
        Context ctx = userCtxCallback.getUserContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return userInfo.getLoginAuthorWay() != null && 2 == userInfo.getLoginAuthorWay().getValue();
    }

    public static boolean verifyPwdInServer(UserContextCallback userCtxCallback, String userNumber, String password) throws Exception {
        IDynamicCardUser iDynamicCardUser = DynamicCardUserFactory.getLocalInstance(userCtxCallback.getUserContext());
        Context ctx = userCtxCallback.getUserContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo == null || userInfo.getId() == null) {
            return false;
        }
        DynamicCardUserInfo cardInfo = iDynamicCardUser.getDynamicCardUserByUserId(userInfo.getId().toString());
        if (cardInfo == null || DynamicCardStateEnum.started != cardInfo.getDynamicState()) {
            throw new UserException(UserException.USER_CARD_SETTING_NOT_RIGHT);
        }
        DynamicCardProxy dynamicProxy = new DynamicCardProxy();
        return dynamicProxy.checkPwd(DynamicCardHelper.getDynCardUserNumber(userCtxCallback, userInfo), password);
    }

    private static String getDynCardUserNumber(UserContextCallback userCtxCallback, UserInfo userInfo) throws BOSException, SQLException {
        String userNumber = userInfo.getId().toString();
        String numberType = null;
        numberType = PermissionCommonUtil.getDynamicCardUserNumberType(userCtxCallback.getUserContext());
        if (StringUtils.isEmpty((String)numberType)) {
            numberType = "1";
        }
        int iType = 1;
        try {
            iType = Integer.parseInt(numberType);
        }
        catch (Exception ex) {
            logger.error((Object)(PermissionResUtil.getResource("res_69") + numberType));
        }
        switch (iType) {
            case 1: {
                userNumber = userInfo.getId().toString();
                break;
            }
            case 2: {
                userNumber = userInfo.getNumber();
                break;
            }
            case 3: {
                userNumber = DynamicCardHelper.getXTOpenID(userCtxCallback.getUserContext(), userInfo);
                break;
            }
            case 4: {
                userNumber = userInfo.getId().toString();
            }
        }
        logger.debug((Object)(PermissionResUtil.getResource("res_70") + userNumber));
        return userNumber;
    }

    private static String getXTOpenID(Context ctx, UserInfo userInfo) throws BOSException, SQLException {
        String sql = "select FXTID from T_PM_EASXTUSERMAP where FUSERID=?";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString()});
        if (result.size() < 1) {
            logger.info((Object)"Fetch OPENID by userid return nothing, Fetch it by personid");
            sql = "select FXTID from T_PM_EASXTUSERMAP where FPERSONID=(select FPERSONID from T_PM_USER where FID=?)";
            result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString()});
            if (result.size() >= 1 && result.next()) {
                return result.getString("FXTID");
            }
        } else if (result.next()) {
            return result.getString("FXTID");
        }
        logger.error((Object)("Get XT openID error, userNumber=" + userInfo.getNumber() + " and FID=" + userInfo.getId().toString()));
        throw new BOSException("Get XT openID error, userNumber=" + userInfo.getNumber() + " and FID=" + userInfo.getId().toString());
    }
}

