/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.card;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.card.DynCardPasswordCheckFactory;
import com.kingdee.eas.base.permission.card.IDynCardPasswordCheck;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class DynamicCardProxy {
    private static IDynCardPasswordCheck iPwdCheck = null;
    private ISecurityAuthParamManager manager = null;
    private static Logger logger = Logger.getLogger((String)DynamicCardProxy.class.getName());

    public DynamicCardProxy() {
        try {
            this.manager = SecurityAuthParamManagerFactory.getLocalInstance(null);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public IDynCardPasswordCheck getIPwdCheck() throws Exception {
        iPwdCheck = DynCardPasswordCheckFactory.getDynCardChecker(this.getDynamicCardSupplierClass());
        iPwdCheck.initCardService(this.manager.getDynamicCardServerConfigFile());
        return iPwdCheck;
    }

    private String getDynamicCardSupplierClass() {
        DynamicCardConfigInfo info;
        String impClass = null;
        if (this.manager != null && (info = this.manager.getDynamicCardConfigInfo(null)) != null) {
            impClass = info.getDynamicCardSupplierClass();
        }
        return impClass;
    }

    public boolean checkPwd(String number, String pwd) throws Exception {
        String sourcePwd = CryptoTean.decrypt((String)number, (String)pwd);
        if (StringUtils.isEmpty((String)sourcePwd)) {
            logger.info((Object)"pwd is null!");
            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
        }
        logger.info((Object)("number is:" + number + " sourcePwd is:" + sourcePwd));
        if (this.getIPwdCheck().checkPwd(number, sourcePwd)) {
            return true;
        }
        throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
    }
}

