/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.ctrlcenterplugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.permission.PermissionUtils;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.helper.SynchUserHelper;
import com.kingdee.eas.base.permission.ctrlcenterplugin.ISqlCallBack;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PermItemDataPlugin {
    private static Logger logger = Logger.getLogger(PermItemDataPlugin.class);
    private static final String ORG_RELATION = "orgRelation";
    private static final String PERM_ITEM_TYPE = "permItemType";
    private static final String ORG_TYPE = "OrgType";
    private static final String ENABLE_DATA_PERMISSION = "enableDataPermission";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public String execute(String metasPath) throws Exception {
        Context virtualContext = this.createVirtualConext(metasPath);
        final StringBuffer script = new StringBuffer(5000);
        script.append(" DELETE FROM T_PM_PermItem ; ").append(SEPARATOR);
        script.append(" DELETE FROM T_PM_PermDependency ; ").append(SEPARATOR);
        this.execute(metasPath, new ISqlCallBack(){

            @Override
            public void processString(String sql) {
                script.append(sql).append(SEPARATOR);
            }

            @Override
            public void finish() {
            }

            @Override
            public void handleException(Exception e) {
            }
        });
        return script.toString();
    }

    public void execute(String metasPath, ISqlCallBack action) throws Exception {
        action.processString(" DELETE FROM T_PM_PermItem ; ");
        action.processString(" DELETE FROM T_PM_PermDependency ; ");
        Context virtualContext = this.createVirtualConext(metasPath);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)virtualContext);
        PermissionInfo permissionInfo = loader.getPermission();
        this.checkPermItems(virtualContext, permissionInfo);
        this.getPermItemScript(virtualContext, permissionInfo, action);
        this.getDependencePermItemScript(virtualContext, permissionInfo, action);
        this.getMenuPermItemScript(virtualContext, permissionInfo, action);
    }

    public Locale[] getLocales(Context ctx) {
        IMetaDataLoader loader = this.getMetaDataLoader(ctx);
        SolutionInfo solutionInfo = loader.getSolution();
        LanguageCollection languages = solutionInfo.getLanguages();
        int size = languages.size();
        Locale[] locales = new Locale[size];
        for (int i = 0; i < size; ++i) {
            locales[i] = languages.get(i).getLocale();
        }
        return locales;
    }

    private String getPermItemScript(Context ctx, PermissionInfo permissionInfo, ISqlCallBack action) throws BOSException {
        StringBuffer retString = new StringBuffer(4000);
        Locale[] locales = this.getLocales(ctx);
        int length = locales.length;
        PermItemCollection collection = this.getAllPermItems(ctx, permissionInfo, locales);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            int j;
            PermItemInfo info = collection.get(i);
            String ID = info.getId().toString();
            String number = info.getNumber();
            String name = info.getName();
            String longNumber = info.getLongNumber();
            String objectType = info.getObjectType();
            PermItemType permItemType = info.getType();
            OrgType orgRelation = info.getOrgRelation();
            String parentID = info.getParent() == null ? null : info.getParent().getId().toString();
            int isLeaf = info.isIsLeaf() ? 1 : 0;
            OperationType operationType = info.getOperationType();
            boolean enableDataPermission = info.isEnableDataPermission();
            StringBuffer buffer = new StringBuffer();
            buffer.append(" INSERT INTO T_PM_PermItem(FID, FNumber, FName, ");
            for (j = 0; j < length; ++j) {
                buffer.append(MultiLangHelper.getFieldName("FAlias", locales[j])).append(", ");
            }
            buffer.append(" FLongNumber, FObjectType, FType, FOrgRelation, FParentID, FIsLeaf, FOperationType, FIsApplyToF7, ");
            for (j = 0; j < length; ++j) {
                if (j == length - 1) {
                    buffer.append(MultiLangHelper.getFieldName("FDescription", locales[j])).append(" ");
                    continue;
                }
                buffer.append(MultiLangHelper.getFieldName("FDescription", locales[j])).append(", ");
            }
            buffer.append(") VALUES ( ");
            buffer.append(" '").append(ID).append("' , ");
            buffer.append(" N'").append(number).append("' , ");
            buffer.append(" N'").append(name).append("' , ");
            for (j = 0; j < length; ++j) {
                buffer.append(info.getAlias(locales[j]) == null ? null : " N'" + info.getAlias(locales[j]) + "' ").append(", ");
            }
            buffer.append(" N'").append(longNumber).append("' , ");
            buffer.append(objectType == null ? null : " N'" + objectType + "' ").append(" , ");
            buffer.append(" ").append(permItemType.getValue()).append(" , ");
            buffer.append(" ").append(orgRelation.getValue()).append(" , ");
            buffer.append(" ").append(parentID == null ? null : " '" + parentID + "' ").append(" , ");
            buffer.append(" ").append(isLeaf).append(" , ");
            buffer.append(" '").append(operationType.getValue()).append("' , ");
            buffer.append(" ").append(enableDataPermission ? 1 : 0).append(" , ");
            for (j = 0; j < length; ++j) {
                if (j == length - 1) {
                    buffer.append(info.getDescription(locales[j]) == null ? null : " N'" + info.getAlias(locales[j]) + "' ").append(" ");
                    continue;
                }
                buffer.append(info.getDescription(locales[j]) == null ? null : " N'" + info.getAlias(locales[j]) + "' ").append(", ");
            }
            buffer.append(" ); ");
            action.processString(buffer.toString());
            retString.append(buffer).append(SEPARATOR);
        }
        return retString.toString();
    }

    private String getMenuPermItemScript(Context ctx, PermissionInfo permissionInfo, ISqlCallBack action) throws BOSException {
        StringBuffer retString = new StringBuffer(4000);
        PermissionItemCollection collection = permissionInfo.getPermissionItems();
        HashMap menuPermItems = new HashMap();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            PermissionItemInfo info = collection.get(i);
            if (!this.isMayBeMenuUIPermItem(info)) continue;
            for (String uiClassName : this.getUIClassNames(info)) {
                Set<PermissionItemInfo> set;
                if (menuPermItems.containsKey(uiClassName)) {
                    set = (Set)menuPermItems.get(uiClassName);
                    set.add(info);
                    continue;
                }
                set = new HashSet();
                set.add(info);
                menuPermItems.put(uiClassName, set);
            }
        }
        Set setUIClass = menuPermItems.keySet();
        for (String uiClassName : setUIClass) {
            Set setPermItem = (Set)menuPermItems.get(uiClassName);
            if (setPermItem.size() != 1) continue;
            StringBuffer buffer = new StringBuffer();
            PermissionItemInfo permissionItemInfo = (PermissionItemInfo)setPermItem.iterator().next();
            buffer.append(" UPDATE T_PM_MainMenuItem SET FFunction = '").append(permissionItemInfo.getInnerID()).append("' WHERE TRIM(FUiClassName) = N'").append(uiClassName).append("' ").append(" AND FFunction IS NULL ; ");
            action.processString(buffer.toString());
            retString.append(buffer).append(SEPARATOR);
        }
        return retString.toString();
    }

    private String[] getUIClassNames(PermissionItemInfo info) {
        HashSet<String> set = new HashSet<String>();
        BizRefCollection bizRefCollection = info.getBizRefs();
        if (info.getBizRefs() != null) {
            int size = bizRefCollection.size();
            for (int i = 0; i < size; ++i) {
                BizRefInfo bizRefInfo = bizRefCollection.get(i);
                MetaDataInfo metaDataInfo = bizRefInfo.getBizMetadataInfo();
                if (metaDataInfo == null) continue;
                String metaDataType = metaDataInfo.getMetaDataType();
                if (!MetaDataTypeList.UIOBJECT.toString().equals(metaDataType)) continue;
                BizPropertyCollection bizPropertyCollection = bizRefInfo.getBizPropertys();
                int size1 = bizRefCollection.size();
                for (int j = 0; j < size1; ++j) {
                    BizPropertyInfo bizPropertyInfo = bizPropertyCollection.get(j);
                    if (bizPropertyInfo == null || !"ActionOnLoad".equals(bizPropertyInfo.getProperty())) continue;
                    set.add(metaDataInfo.getFullName());
                }
            }
        }
        return set.toArray(new String[set.size()]);
    }

    private boolean isMayBeMenuUIPermItem(PermissionItemInfo info) {
        BizRefCollection bizRefCollection = info.getBizRefs();
        if (info.getBizRefs() != null) {
            int size = bizRefCollection.size();
            for (int i = 0; i < size; ++i) {
                BizRefInfo bizRefInfo = bizRefCollection.get(i);
                MetaDataInfo metaDataInfo = bizRefInfo.getBizMetadataInfo();
                if (metaDataInfo == null) continue;
                String metaDataType = metaDataInfo.getMetaDataType();
                if (!MetaDataTypeList.UIOBJECT.toString().equals(metaDataType)) continue;
                BizPropertyCollection bizPropertyCollection = bizRefInfo.getBizPropertys();
                int size1 = bizRefCollection.size();
                for (int j = 0; j < size1; ++j) {
                    BizPropertyInfo bizPropertyInfo = bizPropertyCollection.get(j);
                    if (bizPropertyInfo == null || !"ActionOnLoad".equals(bizPropertyInfo.getProperty())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String getDependencePermItemScript(Context ctx, PermissionInfo permissionInfo, ISqlCallBack action) throws BOSException {
        StringBuffer retString = new StringBuffer(4000);
        PermissionUtils.createDependence((PermissionInfo)permissionInfo);
        DependenceCollection dependencyPermItems = permissionInfo.getDependences();
        HashSet<String> dependencyData = new HashSet<String>();
        int size = dependencyPermItems.size();
        for (int i = 0; i < size; ++i) {
            DependenceInfo dependenceInfo = dependencyPermItems.get(i);
            PermissionItemCollection referingItems = dependenceInfo.getReferingItems();
            int size1 = referingItems.size();
            for (int j = 0; j < size1; ++j) {
                if (StringUtils.isEmpty((String)dependenceInfo.getReferedItem().getInnerID()) || StringUtils.isEmpty((String)referingItems.get(j).getInnerID())) continue;
                String ID = dependenceInfo.getReferedItem().getInnerID();
                String dependencyID = referingItems.get(j).getInnerID();
                String key = ID + dependencyID;
                StringBuffer buffer = new StringBuffer();
                if (dependencyData.contains(key)) continue;
                buffer.append(" INSERT INTO T_PM_PermDependency (FID, FDependencyID) VALUES ( ");
                buffer.append(" '").append(ID).append("' ,");
                buffer.append(" '").append(dependencyID).append("' ); ").append(SEPARATOR);
                dependencyData.add(key);
                action.processString(buffer.toString());
                retString.append(buffer).append(SEPARATOR);
            }
        }
        return retString.toString();
    }

    private Context createVirtualConext(String metasPath) {
        Context context = new Context(null, "eas", null, new Locale("L2"));
        context.put((Object)"METADATAPATH", (Object)metasPath);
        return context;
    }

    private static Context createVirtualContext(String metasPath, String aix) {
        Context context = new Context((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"), "eas", aix, new Locale("L2"));
        context.put((Object)"METADATAPATH", (Object)metasPath);
        return context;
    }

    private IMetaDataLoader getMetaDataLoader(Context ctx) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
    }

    private Set getErrorPermItems(Context ctx, PermissionItemCollection permissionItems) {
        HashSet<PermissionItemInfo> errorPermItems = new HashSet<PermissionItemInfo>();
        IMetaDataLoader loader = this.getMetaDataLoader(ctx);
        int size = permissionItems.size();
        for (int i = 0; i < size; ++i) {
            PermissionItemInfo info = permissionItems.get(i);
            if (!this.isInvaildPermItem(ctx, info, loader)) continue;
            errorPermItems.add(info);
        }
        return errorPermItems;
    }

    private void checkPermItems(Context ctx, PermissionInfo permissionInfo) throws BOSException, PermItemException {
        Set errorPermItems = this.getErrorPermItems(ctx, permissionInfo.getPermissionItems());
        if (errorPermItems.size() > 0) {
            this.logPermItemError(ctx, errorPermItems);
            throw new PermItemException(PermItemException.READ_PERMITEM_FAIL);
        }
    }

    private void logPermItemError(Context ctx, Set errorPermItems) {
        StringBuffer msg = new StringBuffer();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        msg.append(SEPARATOR);
        msg.append("*********************************************************************************************").append(SEPARATOR);
        msg.append(ResourceBase.getString((String)RESOURCE, (String)"errorPermItem", (Locale)ctx.getLocale())).append(SEPARATOR);
        for (PermissionItemInfo info : errorPermItems) {
            String groupName = info.getGroupName();
            String type = info.getType();
            if (StringUtils.isEmpty((String)info.getName())) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s name is null !").append(SEPARATOR);
            }
            if (StringUtils.isEmpty((String)type)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s type is null !").append(SEPARATOR);
            }
            if (this.isInvaildAlias(info)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s alias is null in multi-language !").append(SEPARATOR);
            }
            if (StringUtils.isEmpty((String)groupName)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s groupName is null !").append(SEPARATOR);
            }
            if (this.isUnmatchGroupInfo(info)) {
                int groupNameLength = groupName == null ? 0 : StringUtils.split((String)groupName, (String)".").length;
                Locale[] locales = MultiLangHelper.getSupportedLocales();
                int length = locales.length;
                for (int i = 0; i < length; ++i) {
                    if (!StringUtils.isEmpty((String)info.getGroup(locales[i]))) {
                        int groupLength = StringUtils.split((String)info.getGroup(locales[i]), (String)".").length;
                        if (groupNameLength == groupLength) continue;
                        msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s group:").append(info.getGroup(locales[i])).append(" , groupName : ").append(info.getGroupName()).append("  not match in multi-language !").append(SEPARATOR);
                        continue;
                    }
                    msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s group:").append(info.getGroup(locales[i])).append(" , groupName : ").append(info.getGroupName()).append("  not match in multi-language !").append(SEPARATOR);
                }
            }
            if (this.isInvaildOrgRelation(info, loader)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s orgRelation is isInvaild !").append(SEPARATOR);
            }
            if (!this.isInvaildPermItemType(info)) continue;
            msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s permItemType is isInvaild !").append(SEPARATOR);
        }
        logger.error((Object)msg.toString());
    }

    private PermItemCollection getAllPermItems(Context ctx, PermissionInfo permissionInfo, Locale[] locales) throws BOSException {
        PermItemInfo permItemInfo;
        int i;
        PermItemCollection collection = new PermItemCollection();
        HashMap<String, PermItemInfo> mapPermItem = new HashMap<String, PermItemInfo>(2000);
        PermissionItemCollection permissionItems = permissionInfo.getPermissionItems();
        IMetaDataLoader loader = this.getMetaDataLoader(ctx);
        BOSObjectType bosObjectType = new PermItemInfo().getBOSType();
        int size = permissionItems.size();
        for (i = 0; i < size; ++i) {
            int j;
            PermissionItemInfo info = permissionItems.get(i);
            String groupName = StringUtils.replace((String)info.getGroupName(), (String)".", (String)"!") + "!" + info.getName();
            String ID = info.getInnerID();
            String number = info.getName();
            String name = info.getName();
            String longNumber = groupName;
            String objectType = null;
            EntityObjectRefInfo entityObjectRefInfo = info.getEntityObjectMetadataRef();
            if (entityObjectRefInfo == null) {
                objectType = null;
            } else {
                try {
                    EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK(entityObjectRefInfo.getEntityMetaInfo().getFullName()));
                    objectType = entity != null && entity.getType() != null ? entity.getType().toString() : null;
                }
                catch (RuntimeException e) {
                    logger.error((Object)"", (Throwable)e);
                    objectType = null;
                }
            }
            PermItemType type = PermItemType.BIZ_FUNCTION;
            String strPermItemType = info.getExtendedProperty(PERM_ITEM_TYPE);
            if (!StringUtils.isEmpty((String)strPermItemType)) {
                type = PermItemType.getEnum(Integer.parseInt(strPermItemType));
            }
            OrgType orgRelation = null;
            String strOrgRelation = info.getExtendedProperty(ORG_RELATION);
            if (!StringUtils.isEmpty((String)strOrgRelation)) {
                orgRelation = this.getOrgType(strOrgRelation);
            } else if (StringUtils.isEmpty((String)objectType)) {
                orgRelation = OrgType.NONE;
            } else {
                try {
                    EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)objectType));
                    String strOrgType = entity.getExtendedProperty(ORG_TYPE);
                    orgRelation = !StringUtils.isEmpty((String)strOrgType) ? this.getOrgType(strOrgType) : OrgType.NONE;
                }
                catch (RuntimeException e) {
                    logger.error((Object)"", (Throwable)e);
                    orgRelation = OrgType.NONE;
                }
            }
            String operationType = info.getType();
            boolean enableDataPermission = false;
            String strEnableDataPermission = info.getExtendedProperty(ENABLE_DATA_PERMISSION);
            if (!StringUtils.isEmpty((String)strEnableDataPermission)) {
                enableDataPermission = Boolean.valueOf(strEnableDataPermission);
            }
            PermItemInfo childPermItem = new PermItemInfo();
            childPermItem.setId(BOSUuid.read((String)ID));
            childPermItem.setNumber(number);
            childPermItem.setName(name);
            int length = locales.length;
            for (j = 0; j < length; ++j) {
                childPermItem.setAlias(info.getAlias(locales[j]), locales[j]);
            }
            childPermItem.setLongNumber(longNumber);
            childPermItem.setObjectType(objectType);
            childPermItem.setType(type);
            childPermItem.setOrgRelation(orgRelation);
            childPermItem.setOperationType(OperationType.getEnum(operationType));
            childPermItem.setEnableDataPermission(enableDataPermission);
            childPermItem.setParent(null);
            childPermItem.setIsLeaf(true);
            length = locales.length;
            for (j = 0; j < length; ++j) {
                childPermItem.setDescription(info.getDescription(locales[j]), locales[j]);
            }
            if (!mapPermItem.containsKey(longNumber)) {
                mapPermItem.put(longNumber, childPermItem);
            }
            collection.add(childPermItem);
            StringTokenizer tokenizerGroupName = new StringTokenizer(groupName, "!");
            String parentLongNumber = null;
            int step = 0;
            while (tokenizerGroupName.hasMoreTokens()) {
                ++step;
                String tempGroupName = tokenizerGroupName.nextToken();
                parentLongNumber = parentLongNumber == null ? tempGroupName : parentLongNumber + "!" + tempGroupName;
                PermItemInfo parentItem = (PermItemInfo)childPermItem.clone();
                parentItem.setId(BOSUuid.create((BOSObjectType)bosObjectType));
                parentItem.setNumber(tempGroupName);
                parentItem.setName(tempGroupName);
                int length2 = locales.length;
                for (int j2 = 0; j2 < length2; ++j2) {
                    if (StringUtils.isEmpty((String)info.getGroup(locales[j2]))) continue;
                    String tempGroup = StringUtils.replace((String)info.getGroup(locales[j2]), (String)".", (String)"!") + "!" + info.getName();
                    StringTokenizer tokenizerGroup = new StringTokenizer(tempGroup, "!");
                    String tempAlias = null;
                    for (int k = 0; k < step; ++k) {
                        if (!tokenizerGroup.hasMoreTokens()) continue;
                        tempAlias = tokenizerGroup.nextToken();
                    }
                    parentItem.setAlias(tempAlias, locales[j2]);
                }
                parentItem.setLongNumber(parentLongNumber);
                parentItem.setObjectType(null);
                parentItem.setType(PermItemType.INTEGRATION_FUNCTION);
                parentItem.setOrgRelation(OrgType.NONE);
                parentItem.setIsLeaf(false);
                parentItem.setOperationType(OperationType.OTHER);
                parentItem.setEnableDataPermission(false);
                if (mapPermItem.containsKey(parentLongNumber)) continue;
                mapPermItem.put(parentLongNumber, parentItem);
                collection.add(parentItem);
            }
        }
        mapPermItem = new HashMap(2000);
        size = collection.size();
        for (i = 0; i < size; ++i) {
            permItemInfo = collection.get(i);
            String longNumber = permItemInfo.getLongNumber();
            if (mapPermItem.containsKey(longNumber)) continue;
            mapPermItem.put(longNumber, permItemInfo);
        }
        size = collection.size();
        for (i = 0; i < size; ++i) {
            permItemInfo = collection.get(i);
            String parentLongNumber = permItemInfo.getLongNumber();
            int index = parentLongNumber.lastIndexOf("!");
            if (index == -1 || !mapPermItem.containsKey(parentLongNumber = parentLongNumber.substring(0, index))) continue;
            PermItemInfo parent = (PermItemInfo)mapPermItem.get(parentLongNumber);
            permItemInfo.setParent(parent);
        }
        return collection;
    }

    private boolean isInvaildAlias(PermissionItemInfo info) {
        Locale[] locales = MultiLangHelper.getSupportedLocales();
        int length = locales.length;
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.isEmpty((String)info.getAlias(locales[i]))) continue;
            return true;
        }
        return false;
    }

    private boolean isUnmatchGroupInfo(PermissionItemInfo info) {
        String groupName = info.getGroupName();
        int groupNameLength = groupName == null ? 0 : StringUtils.split((String)groupName, (String)".").length;
        Locale[] locales = MultiLangHelper.getSupportedLocales();
        int length = locales.length;
        for (int i = 0; i < length; ++i) {
            String infoGroup = info.getGroup(locales[i]);
            if (!StringUtils.isEmpty((String)infoGroup)) {
                int groupLength = StringUtils.split((String)infoGroup, (String)".").length;
                if (groupNameLength == groupLength) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isInvaildPermItem(Context ctx, PermissionItemInfo info, IMetaDataLoader loader) {
        if (StringUtils.isEmpty((String)info.getName())) {
            return true;
        }
        if (StringUtils.isEmpty((String)info.getType())) {
            return true;
        }
        if (this.isInvaildAlias(info)) {
            return true;
        }
        if (StringUtils.isEmpty((String)info.getGroupName())) {
            return true;
        }
        if (this.isUnmatchGroupInfo(info)) {
            return true;
        }
        if (this.isInvaildOrgRelation(info, loader)) {
            return true;
        }
        return this.isInvaildPermItemType(info);
    }

    private boolean isInvaildOrgRelation(PermissionItemInfo info, IMetaDataLoader loader) {
        String strOrgRelation = info.getExtendedProperty(ORG_RELATION);
        if (!StringUtils.isEmpty((String)strOrgRelation)) {
            return this.isInvaildOrgType(strOrgRelation);
        }
        if (info.getEntityObjectMetadataRef() == null || info.getEntityObjectMetadataRef().getEntityMetaInfo() == null) {
            return true;
        }
        try {
            EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK(info.getEntityObjectMetadataRef().getEntityMetaInfo().getFullName()));
            String strOrgType = entity.getExtendedProperty(ORG_TYPE);
            if (!StringUtils.isEmpty((String)strOrgType)) {
                return this.isInvaildOrgType(strOrgType);
            }
            return false;
        }
        catch (RuntimeException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }

    private boolean isInvaildOrgType(String str) {
        return this.getOrgType(str) == null;
    }

    private OrgType getOrgType(String str) {
        Iterator iterator = OrgType.iterator();
        while (iterator.hasNext()) {
            OrgType orgType = (OrgType)iterator.next();
            if (!orgType.getName().equalsIgnoreCase(str)) continue;
            return orgType;
        }
        return null;
    }

    private boolean isInvaildPermItemType(PermissionItemInfo info) {
        int i = -1;
        if (info.getExtendedProperty(PERM_ITEM_TYPE) == null) {
            return false;
        }
        i = Integer.parseInt(info.getExtendedProperty(PERM_ITEM_TYPE));
        Iterator iterator = PermItemType.iterator();
        while (iterator.hasNext()) {
            PermItemType permItemType = (PermItemType)((Object)iterator.next());
            if (permItemType.getValue() != i) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synPermItemsIgnoreError(Connection con, String metasPath, String easHome) throws Exception {
        String easDeployPath = this.getEasDeployPath(easHome);
        System.setProperty("eas.deploy", easDeployPath);
        SynchUserHelper helper = null;
        try {
            helper = new SynchUserHelper(con, metasPath);
            helper.setFromConsole(true);
            helper.syncPermItems();
        }
        finally {
            if (helper != null) {
                helper.release();
            }
        }
    }

    public String getEasDeployPath(String easHome) {
        String separator = File.separator;
        return new StringBuffer().append(easHome).append(separator).append("server").append(separator).append("profiles").append(separator).append("server1").append(separator).append("config").toString();
    }

    public void synPermItems(Connection con, String metasPath, String easHome) throws Exception {
        this.checkPermitemError(con, metasPath);
        this.synPermItemsIgnoreError(con, metasPath, easHome);
    }

    private void checkPermitemError(Connection con, String metasPath) throws PermissionException {
        String errorPermitemMsg = null;
        SynchUserHelper helper = null;
        try {
            helper = new SynchUserHelper(con, metasPath);
            helper.setFromConsole(true);
            errorPermitemMsg = helper.getPermItemError();
        }
        catch (Exception e1) {
            throw new PermissionException(PermissionException.PERMITEMERROR, e1);
        }
        finally {
            if (helper != null) {
                helper.release();
            }
        }
        if (!StringUtils.isEmpty((String)errorPermitemMsg)) {
            Exception e = new Exception(errorPermitemMsg);
            throw new PermissionException(PermissionException.PERMITEMERROR, e);
        }
    }
}

