/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.numbersign.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.numbersign.imp.BrowerVirutalSocket;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectData;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectDataInfo;
import com.kingdee.eas.common.EASBizException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GoldGridSignHelper {
    private Context ctx = null;
    private static final Logger logger = CoreUIObject.getLogger(GoldGridSignHelper.class);

    public GoldGridSignHelper(Context ctx) {
        this.ctx = ctx;
    }

    public byte[] sign(IObjectValue iVo, String signInfoId) throws Exception {
        String protectedSignInfo = this.getProtectInfo(iVo);
        return this.sign(protectedSignInfo, signInfoId);
    }

    public boolean verifySign(IObjectValue iVo, String signInfoId) throws Exception {
        String protectedSignInfo = this.getProtectInfo(iVo);
        BrowerVirutalSocket bv = new BrowerVirutalSocket(this.ctx, protectedSignInfo, signInfoId);
        boolean verifyRes = bv.verify();
        logger.info((Object)(" verify res :" + verifyRes));
        return verifyRes;
    }

    public List getFieldList(IObjectValue iVo) throws BOSException, EASBizException {
        SignProtectData signData = new SignProtectData();
        return signData.getFieldList(this.ctx, iVo);
    }

    public String getProtectInfo(IObjectValue iVo) throws BOSException, EASBizException {
        SignProtectData signData = new SignProtectData();
        return signData.getProtectInfo(this.ctx, iVo);
    }

    public Map batchSign(SignProtectDataInfo protectedStr, List signList) throws Exception {
        BrowerVirutalSocket bv = new BrowerVirutalSocket(this.ctx, protectedStr, signList);
        return bv.batchSign();
    }

    private byte[] sign(String protectedStr, String documentId) throws Exception {
        BrowerVirutalSocket bv = new BrowerVirutalSocket(this.ctx, protectedStr, documentId);
        return bv.sign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSignInfo getDefault(IObjectPK userId, NumberSignInfo signInfo) {
        if (signInfo == null) {
            signInfo = new NumberSignInfo();
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId.toString()));
        signInfo.setUserId(userInfo);
        InputStream imageInput = this.getClass().getResourceAsStream("goldgrid.GIF");
        byte[] imageContent = new byte[4048];
        try {
            imageInput.read(imageContent);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (imageInput != null) {
                try {
                    imageInput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        signInfo.setSignInfo(imageContent);
        return signInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDefaultSignErrorImage() {
        InputStream imageInput = null;
        byte[] imageContent = null;
        try {
            imageInput = this.getClass().getResourceAsStream("goldgriderror.gif");
            imageContent = new byte[4048];
            imageInput.read(imageContent);
        }
        catch (IOException e) {
            logger.error((Object)"ioException !", (Throwable)e);
        }
        finally {
            if (imageInput != null) {
                try {
                    imageInput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return imageContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDefaultVerifyErrorImage() {
        InputStream imageInput = null;
        byte[] imageContent = new byte[4048];
        try {
            imageInput = this.getClass().getResourceAsStream("modifyData.GIF");
            imageInput.read(imageContent);
        }
        catch (IOException e) {
            logger.error((Object)"ioException !", (Throwable)e);
        }
        finally {
            if (imageInput != null) {
                try {
                    imageInput.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return imageContent;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getCertStr() throws Exception {
        BrowerVirutalSocket bv = new BrowerVirutalSocket(this.ctx, "", "");
        return bv.getCertStr();
    }
}

