/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.service.IUserLicenseGroupService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UserLicenseGroupService
extends AbstractBOSObject
implements IUserLicenseGroupService {
    private static Logger logger = Logger.getLogger(UserLicenseGroupService.class);
    String filePath = UserLicenseGroupService.getFilePath();
    Context ctx = null;

    public UserLicenseGroupService() {
    }

    public UserLicenseGroupService(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInitTimestamp(long timestamp) {
        Properties p = new Properties();
        FileInputStream in = null;
        FileOutputStream fileOutputStream = null;
        try {
            in = new FileInputStream(this.filePath);
            fileOutputStream = new FileOutputStream(this.filePath);
            p.load(in);
            p.setProperty(ContextUtils.getContextFromSession().getAIS(), Long.toString(timestamp));
            p.store(fileOutputStream, "");
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"UserLicenseGroupService.setInitTimestamp.fileinputStream", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"UserLicenseGroupService.setInitTimestamp.properties.load", (Throwable)e);
        }
        finally {
            p.clear();
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Object)"UserLicenseGroupService.setInitTimestamp.in.IO", (Throwable)e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInitTimestamp(String dbAIS) {
        Properties p = new Properties();
        FileInputStream in = null;
        String initTime = System.currentTimeMillis() + "";
        try {
            in = new FileInputStream(this.filePath);
            p.load(in);
            initTime = p.getProperty(dbAIS);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"UserLicenseGroupService.setInitTimestamp.fileinputStream", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"UserLicenseGroupService.setInitTimestamp.properties.load", (Throwable)e);
        }
        finally {
            p.clear();
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Object)"UserLicenseGroupService.setInitTimestamp.in.IO", (Throwable)e);
                }
            }
        }
        return initTime;
    }

    @Override
    public boolean isInitialed(long currentTime) {
        String initTime = this.getInitTimestamp(ContextUtils.getContextFromSession().getAIS());
        return initTime != null && Long.parseLong(initTime.trim()) <= currentTime;
    }

    private static String getFilePath() {
        String fileSepa = System.getProperty("file.separator");
        String filePath = System.getProperty("EAS_HOME") + fileSepa + "server" + fileSepa + "properties" + fileSepa + "license";
        try {
            File file;
            File LicenseUseInfoDir = new File(filePath);
            if (!LicenseUseInfoDir.exists()) {
                LicenseUseInfoDir.mkdir();
            }
            if (!(file = new File(filePath = filePath + fileSepa + "licenseConfig.properties")).exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filePath;
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public boolean noticLicenseUpdate() {
        if (this.ctx == null) {
            this.ctx = ContextUtils.getContextFromSession();
        }
        try {
            LicenseUseSrvFactory.getLocalInstance(this.ctx).noticLicenseUpdate(this.ctx);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }
}

