/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PermissionOrgTypeUtils {
    public static boolean checkMatchOrg2PermItem(PermItemInfo permItem, OrgUnitInfo orgInfo) {
        if (permItem == null || permItem.getOrgRelation() == null || orgInfo == null) {
            return false;
        }
        OrgType curOrgType = permItem.getOrgRelation();
        if (1 == curOrgType.getValue() && orgInfo.isIsUnion()) {
            ConfigurationLoader loader = ConfigurationLoader.getInstance();
            ConfigurationInfo info = loader.getConfigurationInfo();
            return info.getCslrptPermItemNames().contains(permItem.getNumber());
        }
        if (-1 == curOrgType.getValue()) {
            return "11111111-1111-1111-1111-111111111111CCE7AED4".equals(orgInfo.getId().toString());
        }
        return OrgCommonUtils.isOrgType((OrgUnitInfo)orgInfo, (OrgType)curOrgType);
    }

    public static void addOrgType2Set(FullOrgUnitInfo orgInfo, Set set) {
        if (orgInfo == null) {
            return;
        }
        if (set == null) {
            set = new HashSet<String>();
        }
        Set orgTypeSet = OrgCommonUtils.getOrgTypeCol((FullOrgUnitInfo)orgInfo);
        Iterator orgTypeItr = orgTypeSet.iterator();
        while (orgTypeItr.hasNext()) {
            set.add("" + ((OrgType)orgTypeItr.next()).getValue());
        }
        set.add("-1");
    }

    public static Set getSelectOrgType(FullOrgUnitCollection orgInfoCol) {
        HashSet retSet = new HashSet();
        if (orgInfoCol.isEmpty()) {
            return retSet;
        }
        int size = orgInfoCol.size();
        for (int i = 0; i < size; ++i) {
            PermissionOrgTypeUtils.addOrgType2Set(orgInfoCol.get(i), retSet);
            if (PermissionOrgTypeUtils.haveAllOrg(retSet)) break;
        }
        return retSet;
    }

    public static boolean haveAllOrg(Set retSet) {
        List orgTypeList = OrgType.getEnumList();
        if (retSet == null || retSet.isEmpty()) {
            return false;
        }
        if (orgTypeList == null || orgTypeList.isEmpty()) {
            return true;
        }
        int size = orgTypeList.size();
        for (int i = 0; i < size; ++i) {
            OrgType orgType = (OrgType)orgTypeList.get(i);
            if (retSet.contains("" + orgType.getValue())) continue;
            return false;
        }
        return true;
    }

    public static Set getOrgTypes(Context ctx, IObjectPK orgPK) throws EASBizException, BOSException {
        HashSet<OrgType> result = new HashSet<OrgType>();
        IFullOrgUnit iFullOrgUnit = null;
        iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(orgPK);
        result.add(OrgType.NONE);
        result.addAll(OrgCommonUtils.getOrgTypeCol((FullOrgUnitInfo)fullOrgUnitInfo));
        return result;
    }

    public static boolean isCanBeDefOrg(FullOrgUnitInfo fullOrgUnitInfo) {
        return OrgCommonUtils.isCanBeDefOrg((FullOrgUnitInfo)fullOrgUnitInfo);
    }
}

